/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationMap;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentQuery;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.adapter.ItemNotFoundException;

public abstract class Space {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ContentSet EMPTY_CONTENT_SET = new ContentSet(){

        public Content getContent() throws AdapterException {
            return null;
        }

        public boolean next() throws AdapterException {
            return false;
        }

        public String getURI() {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }
    };
    private static final ContentQuery EMPTY_CONTENT_QUERY = new ContentQuery(){

        public ContentSet execute() throws AdapterException {
            return EMPTY_CONTENT_SET;
        }
    };
    private static final ConfigurationMap EMPTY_CONFIG = new ConfigurationMap();
    private final String name;
    private final Space parent;
    private final Space[] path;
    private final boolean isNode;
    private final boolean isCrawlSpace;

    protected Space(Space parent, String name, boolean hasSubSpaces, boolean isCrawlSpace) {
        Space p;
        if (name == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.name = name;
        this.isNode = hasSubSpaces;
        this.isCrawlSpace = isCrawlSpace;
        int l = 0;
        for (p = this; p != null; p = p.getParent()) {
            ++l;
        }
        this.path = new Space[l];
        p = this;
        int i = l;
        while (i > 0) {
            this.path[--i] = p;
            p = p.getParent();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Space getParent() {
        return this.parent;
    }

    public void open() throws AdapterException {
    }

    public void close() throws AdapterException {
    }

    public ConfigurationMap getConfigurations() {
        return EMPTY_CONFIG;
    }

    public final boolean isNodeSpace() {
        return this.isNode;
    }

    public Space[] getSubSpaces() throws AdapterException {
        return new Space[0];
    }

    public Space getSubSpace(String subspaceName) throws AdapterException {
        return null;
    }

    public final boolean isCrawlSpace() {
        return this.isCrawlSpace;
    }

    public ContentQuery createContentQuery() throws AdapterException {
        return EMPTY_CONTENT_QUERY;
    }

    public FieldDefinition[] getFields() throws AdapterException {
        return new FieldDefinition[0];
    }

    public ConfigurationMap getCrawlSpaceConfigurations() {
        return EMPTY_CONFIG;
    }

    public Content getContent(String uri) throws AdapterException {
        throw new ItemNotFoundException(uri);
    }
}

