/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.Acl;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.Field;
import com.ibm.es.nuvo.crawler.adapter.FieldIterator;
import com.ibm.es.nuvo.crawler.adapter.FieldType;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.util.Checksum;
import com.ibm.es.nuvo.crawler.util.io.ConvertedInputStream;
import com.ibm.es.nuvo.crawler.util.io.ReaderConverter;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class SimpleContent
extends Content {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 65536;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 1024;
    private static final String READER_BODY_ENCODING = "UTF-8";
    private Checksum checksum;
    private final List<Field> fields = new ArrayList<Field>();
    private SubContentsRequestHandler subcontents;
    private long size = 0L;
    private ContentBodyImpl body = null;
    private byte[] buffer = null;
    private char[] charBuf = null;
    private Acl acl;
    private Date docdate;
    private boolean actualContent;

    SimpleContent() {
        this(null);
    }

    SimpleContent(SubContentsRequestHandler subcontents) {
        this(subcontents, true);
    }

    SimpleContent(SubContentsRequestHandler subcontents, boolean isActualContent) {
        this.checksum = new Checksum();
        this.subcontents = subcontents;
        this.acl = null;
        this.actualContent = isActualContent;
    }

    private void ensureByteBuffer(int required) {
        if (this.buffer == null) {
            int len = required < 65536 ? 65536 : required;
            this.buffer = new byte[len];
        } else if (this.buffer.length < required) {
            this.buffer = new byte[this.buffer.length + required];
        }
    }

    private void ensureCharBuffer() {
        if (this.charBuf == null) {
            this.charBuf = new char[1024];
        }
    }

    public void close() {
        this.fields.clear();
        this.subcontents = null;
        this.checksum.reset();
        this.body = null;
    }

    public ContentBody getBody() throws AdapterException {
        return this.body;
    }

    public FieldIterator getFields() throws AdapterException {
        return new FieldIterator(){
            private Iterator<Field> ite;
            {
                this.ite = SimpleContent.this.fields.iterator();
            }

            public boolean hasNext() throws AdapterException {
                return this.ite.hasNext();
            }

            public Field next() throws AdapterException {
                return this.ite.next();
            }
        };
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public ContentSet getSubContents() throws AdapterException {
        return this.subcontents.getSubContents();
    }

    public boolean hasSubContents() {
        return this.subcontents != null;
    }

    public boolean isActualContent() {
        return this.actualContent;
    }

    public long getChecksumValue() {
        return this.checksum.getValue();
    }

    public long getEstimatedSize() {
        return this.size;
    }

    private final void updateChecksum(String str) {
        if (str != null) {
            this.ensureCharBuffer();
            int length = str.length();
            int start = 0;
            int remain = length;
            while (remain > 0) {
                int actual = remain > this.charBuf.length ? this.charBuf.length : remain;
                str.getChars(start, start + actual, this.charBuf, 0);
                this.updateChecksum(this.charBuf, 0, actual);
                remain -= actual;
                start += actual;
            }
        }
    }

    private final void updateChecksum(long v) {
        this.ensureByteBuffer(8);
        for (int i = 0; i < 8; ++i) {
            this.buffer[i] = (byte)(v >>> (7 - i) * 8 & 0xFFL);
        }
        this.checksum.update(this.buffer, 0, 8);
    }

    private final void updateChecksum(double v) {
        this.updateChecksum(Double.doubleToLongBits(v));
    }

    private final void updateChecksum(boolean v) {
        this.checksum.update(v);
    }

    private final void updateChecksum(char[] text, int off, int len) {
        int index = 0;
        this.ensureByteBuffer(len * 2);
        for (int i = off; i < off + len; ++i) {
            char c = text[i];
            this.buffer[index++] = (byte)(c >>> 8 & 0xFF);
            this.buffer[index++] = (byte)(c >>> 0 & 0xFF);
        }
        this.checksum.update(this.buffer, 0, index);
    }

    public final Field addField(String name, String text) {
        if (text != null) {
            this.size += (long)(text.length() * 2);
            this.updateChecksum(text);
        }
        return this.addField(SimpleBuilder.newStringField(name, text));
    }

    public final Field addField(String name, long value) {
        this.size += 8L;
        this.updateChecksum(value);
        return this.addField(SimpleBuilder.newLongField(name, value));
    }

    public final Field addField(String name, long value, String text) {
        String nonNull = text;
        if (null == text) {
            nonNull = "";
        }
        this.size += (long)(8 + nonNull.length() * 2);
        this.updateChecksum(value);
        this.updateChecksum(nonNull);
        return this.addField(SimpleBuilder.newLongField(name, value, text));
    }

    public final Field addField(String name, double value) {
        this.size += 8L;
        this.updateChecksum(value);
        return this.addField(SimpleBuilder.newDoubleField(name, value));
    }

    public final Field addField(String name, double value, String text) {
        String nonNull = text;
        if (null == text) {
            nonNull = "";
        }
        this.size += (long)(8 + nonNull.length() * 2);
        this.updateChecksum(value);
        this.updateChecksum(nonNull);
        return this.addField(SimpleBuilder.newDoubleField(name, value, text));
    }

    public final Field addField(String name, Date date) {
        if (date != null) {
            this.size += 8L;
            this.updateChecksum(date.getTime());
        }
        return this.addField(SimpleBuilder.newDateField(name, date));
    }

    public final Field addField(String name, Date date, String text) {
        String nonNull = text;
        if (null == text) {
            nonNull = "";
        }
        if (date != null) {
            this.size += (long)(8 + nonNull.length() * 2);
            this.updateChecksum(date.getTime());
            this.updateChecksum(nonNull);
        }
        return this.addField(SimpleBuilder.newDateField(name, date, text));
    }

    public final Field addField(String name, boolean value) {
        ++this.size;
        this.updateChecksum(value);
        return this.addField(SimpleBuilder.newBooleanField(name, value));
    }

    public final Field addField(String name, boolean value, String text) {
        String nonNull = text;
        if (null == text) {
            nonNull = "";
        }
        this.size += (long)(1 + nonNull.length() * 2);
        this.updateChecksum(value);
        this.updateChecksum(nonNull);
        return this.addField(SimpleBuilder.newBooleanField(name, value, text));
    }

    public final Field addField(String name, char[] value) {
        if (value != null) {
            this.size += (long)(value.length * 2);
            this.updateChecksum(value, 0, value.length);
            return this.addField(SimpleBuilder.newStringField(name, new String(value)));
        }
        return this.addNullField(name, FieldType.STRING);
    }

    public final Field addField(String name, Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder(4096);
        int len = 0;
        this.ensureCharBuffer();
        while ((len = reader.read(this.charBuf)) > 0) {
            this.updateChecksum(this.charBuf, 0, len);
            builder.append(this.charBuf, 0, len);
        }
        reader.close();
        return this.addField(SimpleBuilder.newStringField(name, builder.toString()));
    }

    public final Field addNullField(String name, FieldType type) {
        return this.addField(SimpleBuilder.newNullField(name, type));
    }

    private final Field addField(Field field) {
        String name = field.getName();
        this.size += name != null ? (long)(name.length() * 2) : 0L;
        this.updateChecksum(name);
        this.fields.add(field);
        return field;
    }

    public final ContentBody createBody(File file) throws IOException {
        return this.createBody(new FileInputStream(file), file.getName(), null, false, null, false);
    }

    public final ContentBody createBody(InputStream input, String filename) throws IOException {
        return this.createBody(input, filename, null, false, null, false);
    }

    public final ContentBody createBody(Reader reader) throws IOException {
        return this.createBody(new ConvertedInputStream(new ReaderConverter(reader, new ReaderConverter.Plugin(){

            public Writer createWriter(OutputStream out) throws IOException {
                return new OutputStreamWriter(out, SimpleContent.READER_BODY_ENCODING);
            }
        })), null, null, false, READER_BODY_ENCODING, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContentBody createBody(InputStream input, String filename, String mimetype, boolean isKnownMimetype, String encoding, boolean isKnownEnconding) throws IOException {
        if (input != null) {
            this.body = new ContentBodyImpl(filename, mimetype, isKnownMimetype, encoding, isKnownEnconding);
            try {
                int read = 0;
                this.ensureByteBuffer(65536);
                while ((read = input.read(this.buffer)) > 0) {
                    this.size += (long)read;
                    this.body.write(this.buffer, 0, read);
                }
            }
            catch (IOException e) {
                try {
                    this.body.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.body = null;
            }
            finally {
                try {
                    input.close();
                }
                catch (Throwable ignore) {}
                if (this.body != null) {
                    this.body.close();
                }
            }
        }
        return this.body;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public Date getDate() {
        return this.docdate;
    }

    public void setDate(Date date) {
        this.docdate = date;
    }

    public final class ContentBodyImpl
    extends ContentBody {
        private String encoding;
        private String filename;
        private String mimetype;
        private boolean isKnownEncoding;
        private boolean isKnownMimetype;
        private long length;
        private final DataBufferOutputStream dataBuffer = new DataBufferOutputStream();

        private ContentBodyImpl(String filename, String mimetype, boolean isKnownMimetype, String encoding, boolean isKnownEncoding) {
            this.filename = filename;
            this.mimetype = mimetype;
            this.isKnownMimetype = isKnownMimetype;
            this.encoding = encoding;
            this.isKnownEncoding = isKnownEncoding;
            this.length = 0L;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean isKnownEncoding() {
            return this.isKnownEncoding;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getLength() {
            return this.length;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public boolean isKnownMimetype() {
            return this.isKnownMimetype;
        }

        public InputStream getStream() throws AdapterException, IOException {
            try {
                return this.dataBuffer.getInputStream();
            }
            catch (DataBufferException e) {
                throw new AdapterException(e);
            }
        }

        private void write(byte[] b, int off, int len) throws IOException {
            this.length += (long)len;
            SimpleContent.this.checksum.update(b, off, len);
            this.dataBuffer.write(b, off, len);
        }

        private void close() throws IOException {
            this.dataBuffer.close();
        }

        public DataBufferOutputStream getDataBuffer() {
            return this.dataBuffer;
        }
    }

    public static interface SubContentsRequestHandler {
        public ContentSet getSubContents() throws AdapterException;
    }
}

