/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Field;
import com.ibm.es.nuvo.crawler.adapter.FieldType;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SimpleBuilder {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    private SimpleBuilder() {
    }

    public static final SimpleContent newContent() {
        return new SimpleContent();
    }

    public static final SimpleContent newContent(SimpleContent.SubContentsRequestHandler handler) {
        return new SimpleContent(handler);
    }

    public static final SimpleContent newContent(SimpleContent.SubContentsRequestHandler handler, boolean isActualContent) {
        return new SimpleContent(handler, isActualContent);
    }

    public static final Field newNullField(String name, FieldType type) {
        return new NullField(name, type);
    }

    public static final Field newStringField(String name, String text) {
        return new StringField(name, text);
    }

    public static final Field newLongField(String name, long value) {
        return new LongField(name, value);
    }

    public static final Field newLongField(String name, long value, String textValue) {
        return new LongField(name, value, textValue);
    }

    public static final Field newDoubleField(String name, double value) {
        return new DoubleField(name, value);
    }

    public static final Field newDoubleField(String name, double value, String textValue) {
        return new DoubleField(name, value, textValue);
    }

    public static final Field newDateField(String name, Date date) {
        return new DateField(name, date, null);
    }

    public static final Field newDateField(String name, Date date, String textValue) {
        return new DateField(name, date, textValue);
    }

    public static final Field newBooleanField(String name, boolean value) {
        return new BooleanField(name, value);
    }

    public static final Field newBooleanField(String name, boolean value, String textValue) {
        return new BooleanField(name, value, textValue);
    }

    public static final Field newReaderField(String name, char[] value) {
        return SimpleBuilder.newReaderField(name, value != null ? new CharArrayReaderLocator(value) : null);
    }

    public static final Field newReaderField(String name, File file, String enc) {
        return SimpleBuilder.newReaderField(name, file != null ? new FileReaderLocator(file, enc) : null);
    }

    public static final Field newReaderField(String name, ReaderFieldLocator locator) {
        return new ReaderField(name, locator);
    }

    private static final class CharArrayReaderLocator
    implements ReaderFieldLocator {
        private final char[] value;

        CharArrayReaderLocator(char[] value) {
            this.value = value;
        }

        public Reader getReader() {
            return new CharArrayReader(this.value);
        }
    }

    private static final class FileReaderLocator
    implements ReaderFieldLocator {
        private final File file;
        private final String enc;

        FileReaderLocator(File file, String enc) {
            this.file = file;
            this.enc = enc;
        }

        public Reader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.enc));
        }
    }

    private static class ReaderField
    extends Field {
        private final ReaderFieldLocator locator;

        ReaderField(String name, ReaderFieldLocator locator) {
            super(name, FieldType.READER);
            this.locator = locator;
        }

        public boolean isNull() {
            return this.locator == null;
        }

        public Reader getReader() throws IOException {
            return this.locator.getReader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder builder = new StringBuilder();
            char[] buf = new char[4096];
            Reader reader = null;
            try {
                reader = this.getReader();
                if (reader == null) {
                    String string = "<null>";
                    return string;
                }
                int len = 0;
                while ((len = reader.read(buf)) > 0) {
                    builder.append(buf, 0, len);
                }
            }
            catch (IOException e) {
                builder.append("cannot read the value of this reader field " + this.getName());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return builder.toString();
        }
    }

    private static class DoubleField
    extends Field {
        private final double value;
        private final String textValue;

        DoubleField(String name, double value) {
            this(name, value, null);
        }

        DoubleField(String name, double value, String text) {
            super(name, FieldType.DOUBLE);
            this.value = value;
            this.textValue = text;
        }

        public boolean isNull() {
            return false;
        }

        public double getDouble() {
            return this.value;
        }

        public String getString() {
            return this.textValue;
        }

        public String toString() {
            return Double.toString(this.value);
        }
    }

    private static class LongField
    extends Field {
        private final long value;
        private final String textValue;

        LongField(String name, long value) {
            this(name, value, null);
        }

        LongField(String name, long value, String text) {
            super(name, FieldType.LONG);
            this.value = value;
            this.textValue = text;
        }

        public boolean isNull() {
            return false;
        }

        public long getLong() {
            return this.value;
        }

        public String getString() {
            return this.textValue;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    private static class BooleanField
    extends Field {
        private final boolean value;
        private final String textValue;

        BooleanField(String name, boolean value) {
            this(name, value, null);
        }

        BooleanField(String name, boolean value, String text) {
            super(name, FieldType.BOOLEAN);
            this.value = value;
            this.textValue = text;
        }

        public boolean isNull() {
            return false;
        }

        public boolean getBoolean() {
            return this.value;
        }

        public String getString() {
            return this.textValue;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }
    }

    private static class DateField
    extends Field {
        private static final String DATE_STRING = "yyyy.MM.dd G  HH:mm:ss z";
        private final Date date;
        private final String textValue;

        DateField(String name, Date date, String textValue) {
            super(name, FieldType.DATE);
            this.date = date;
            this.textValue = textValue;
        }

        DateField(String name, long time) {
            super(name, FieldType.DATE);
            this.date = new Date(time);
            this.textValue = null;
        }

        public boolean isNull() {
            return this.date == null;
        }

        public Date getDate() {
            return this.date;
        }

        public String getString() throws AdapterException {
            return this.textValue;
        }

        public String toString() {
            return new SimpleDateFormat(DATE_STRING).format(this.getDate());
        }
    }

    private static class StringField
    extends Field {
        private final String value;

        StringField(String name, String value) {
            super(name, FieldType.STRING);
            this.value = value;
        }

        public boolean isNull() {
            return this.value == null;
        }

        public String getString() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class NullField
    extends Field {
        NullField(String name, FieldType type) {
            super(name, type);
        }

        public boolean isNull() {
            return true;
        }
    }

    public static interface ReaderFieldLocator {
        public Reader getReader() throws IOException;
    }
}

