/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.ConfigurationMap;
import com.ibm.es.nuvo.crawler.adapter.FieldType;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldDefinition {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final String name;
    private final String typeName;
    private final FieldType type;
    private final String value;
    private final ConfigurationMap configs;
    private final EnumSet<FieldProperty> props;

    public FieldDefinition(String name, String typeName, FieldType type, boolean isSystem, String value) {
        this.name = name;
        this.typeName = typeName;
        this.type = type;
        this.props = EnumSet.noneOf(FieldProperty.class);
        if (isSystem) {
            this.props.add(FieldProperty.SYSTEM);
        }
        this.value = value;
        this.configs = new ConfigurationMap();
    }

    public FieldDefinition(String name, String typeName, FieldType type, boolean isSystem) {
        this(name, typeName, type, isSystem, null);
    }

    public FieldDefinition(String name, String typeName, FieldType type) {
        this(name, typeName, type, false);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isSystemField() {
        return this.props.contains((Object)FieldProperty.SYSTEM);
    }

    public FieldType getType() {
        return this.type;
    }

    public ConfigurationMap getConfigurations() {
        return this.configs;
    }

    public EnumSet<FieldProperty> getFieldProperties() {
        return this.props;
    }

    public String getValue() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FieldProperty {
        SYSTEM;

    }
}

