/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.Acl;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.FieldIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public abstract class Content {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ContentSet EMPTY_CONTENT_SET = new ContentSet(){

        public Content getContent() throws AdapterException {
            return null;
        }

        public boolean next() throws AdapterException {
            return false;
        }

        public String getURI() {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }
    };
    private static final ContentBody EMPTY_BODY = new ContentBody(){

        public long getLength() {
            return 0L;
        }

        public InputStream getStream() throws AdapterException, IOException {
            return EMPTY_STREAM;
        }
    };
    private static final InputStream EMPTY_STREAM = new InputStream(){

        public int read() throws IOException {
            return -1;
        }
    };
    private int code = 200;
    public static final int RETURNCODE_OK = 200;
    public static final int RETURNCODE_PARTIAL_CONTENT = 206;
    public static final int RETURNCODE_FORBIDDEN = 403;

    public Acl getAcl() {
        return null;
    }

    public Date getDate() {
        return null;
    }

    public boolean hasBody() {
        return false;
    }

    public ContentBody getBody() throws AdapterException {
        return EMPTY_BODY;
    }

    public boolean hasSubContents() {
        return false;
    }

    public ContentSet getSubContents() throws AdapterException {
        return EMPTY_CONTENT_SET;
    }

    public boolean isActualContent() {
        return true;
    }

    public abstract FieldIterator getFields() throws AdapterException;

    public void close() throws AdapterException {
    }

    public void setReturnCode(int code) {
        this.code = code;
    }

    public int getReturnCode() {
        return this.code;
    }
}

