/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationMap {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final Map<String, ConfigurationElement> configs = new HashMap<String, ConfigurationElement>();

    public ConfigurationElement get(String name) {
        return this.configs.get(name);
    }

    public Iterator<ConfigurationElement> getElements() {
        return this.configs.values().iterator();
    }

    public int size() {
        return this.configs.size();
    }

    public ConfigurationElement add(String name, String defaultValue, boolean isMandatory) {
        return this.add(name, defaultValue, ConfigurationMap.createAttributes(isMandatory));
    }

    public ConfigurationElement add(String name, String defaultValue, EnumSet<ConfigurationElement.Attribute> attributes) {
        return this.add(new StringConfiguration(name, defaultValue, attributes));
    }

    public ConfigurationElement add(String name, long defaultValue, boolean isMandatory) {
        return this.add(name, defaultValue, ConfigurationMap.createAttributes(isMandatory));
    }

    public ConfigurationElement add(String name, long defaultValue, EnumSet<ConfigurationElement.Attribute> attributes) {
        return this.add(new LongConfiguration(name, defaultValue, attributes));
    }

    public ConfigurationElement add(String name, boolean defaultValue, boolean isMandatory) {
        return this.add(name, defaultValue, ConfigurationMap.createAttributes(isMandatory));
    }

    public ConfigurationElement add(String name, boolean defaultValue, EnumSet<ConfigurationElement.Attribute> attributes) {
        return this.add(new BooleanConfiguration(name, defaultValue, attributes));
    }

    public ConfigurationElement add(String name, boolean isMandatory, ListConfiguration.Style style) {
        return this.add(name, ConfigurationMap.createAttributes(isMandatory), style);
    }

    public ConfigurationElement add(String name, EnumSet<ConfigurationElement.Attribute> attributes, ListConfiguration.Style style) {
        return this.add(new SimpleListConfiguration(name, style, attributes));
    }

    private ConfigurationElement add(ConfigurationElement config) {
        this.configs.put(config.getName(), config);
        return config;
    }

    private static final EnumSet<ConfigurationElement.Attribute> createAttributes(boolean mandatory) {
        EnumSet<ConfigurationElement.Attribute> attrs = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        if (mandatory) {
            attrs.add(ConfigurationElement.Attribute.MANDATORY);
        }
        return attrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleListConfiguration
    extends AbstractConfigurationElement
    implements ListConfiguration {
        private final Map<String, SimpleItem> items = new HashMap<String, SimpleItem>();
        protected final ListConfiguration.Style style;

        protected SimpleListConfiguration(String name, ListConfiguration.Style style, EnumSet<ConfigurationElement.Attribute> attributes) {
            super(name, ConfigurationElement.Type.LIST, attributes);
            this.style = style;
        }

        protected void deselectAll() {
            for (SimpleItem item : this.items.values()) {
                item.selected = false;
            }
        }

        @Override
        public ListConfiguration.Item add(String key) {
            SimpleItem item = this.items.get(key);
            if (item == null) {
                item = new SimpleItem(key);
                this.items.put(key, item);
            }
            return item;
        }

        @Override
        public ListConfiguration.Item[] getItems() {
            return this.items.values().toArray(new ListConfiguration.Item[0]);
        }

        @Override
        public void remove(ListConfiguration.Item item) {
            this.items.remove(item.getValue());
        }

        @Override
        public ListConfiguration.Style getStyle() {
            return this.style;
        }

        @Override
        public ListConfiguration getList() throws AdapterException {
            return this;
        }

        @Override
        public ListConfiguration.Item get(String param) {
            return this.items.get(param);
        }

        @Override
        public void clear() {
            this.items.clear();
        }

        private final class SimpleItem
        implements ListConfiguration.Item {
            private final String value;
            protected boolean selected;

            protected SimpleItem(String value) {
                this.value = value;
                this.selected = false;
            }

            public String getValue() {
                return this.value;
            }

            public void setSelected(boolean selected) {
                if (SimpleListConfiguration.this.style == ListConfiguration.Style.SINGLE && selected) {
                    SimpleListConfiguration.this.deselectAll();
                }
                this.selected = selected;
            }

            public boolean isSelected() {
                return this.selected;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongConfiguration
    extends AbstractConfigurationElement {
        private long value;

        protected LongConfiguration(String name, long defaultValue, EnumSet<ConfigurationElement.Attribute> attributes) {
            super(name, ConfigurationElement.Type.LONG, attributes);
            this.value = defaultValue;
        }

        @Override
        public long getLong() {
            return this.value;
        }

        @Override
        public void setLong(long value) {
            this.value = value;
        }

        @Override
        public String getString() {
            return Long.toString(this.value);
        }

        @Override
        public void setString(String value) {
            if (value != null) {
                try {
                    long l;
                    this.value = l = Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanConfiguration
    extends AbstractConfigurationElement {
        private boolean value;

        protected BooleanConfiguration(String name, boolean defaultValue, EnumSet<ConfigurationElement.Attribute> attributes) {
            super(name, ConfigurationElement.Type.BOOLEAN, attributes);
            this.value = defaultValue;
        }

        @Override
        public boolean getBoolean() {
            return this.value;
        }

        @Override
        public void setBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public String getString() {
            return Boolean.toString(this.value);
        }

        @Override
        public void setString(String value) {
            if (value != null) {
                boolean b;
                this.value = b = Boolean.parseBoolean(value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringConfiguration
    extends AbstractConfigurationElement {
        private String value;

        protected StringConfiguration(String name, String defaultValue, EnumSet<ConfigurationElement.Attribute> attributes) {
            super(name, ConfigurationElement.Type.STRING, attributes);
            this.value = defaultValue;
        }

        @Override
        public String getString() {
            return this.value;
        }

        @Override
        public void setString(String value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractConfigurationElement
    implements ConfigurationElement {
        private final String name;
        private final ConfigurationElement.Type type;
        private final EnumSet<ConfigurationElement.Attribute> attrs;

        protected AbstractConfigurationElement(String name, ConfigurationElement.Type type, EnumSet<ConfigurationElement.Attribute> attributes) {
            this.name = name;
            this.type = type;
            this.attrs = attributes.clone();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ConfigurationElement.Type getType() {
            return this.type;
        }

        @Override
        public EnumSet<ConfigurationElement.Attribute> getAttributes() {
            return this.attrs;
        }

        @Override
        public boolean isMandatory() {
            return this.attrs.contains((Object)ConfigurationElement.Attribute.MANDATORY);
        }

        @Override
        public boolean getBoolean() throws AdapterException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong() throws AdapterException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString() throws AdapterException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setBoolean(boolean value) throws AdapterException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLong(long value) throws AdapterException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setString(String value) throws AdapterException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListConfiguration getList() throws AdapterException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.name).append('[').append((Object)this.type).append(']').append('[').append(this.isMandatory()).append(']');
            return builder.toString();
        }
    }
}

