/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Credentials;
import com.ibm.es.nuvo.crawler.adapter.ItemFinder;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.adapter.URINormalizer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class Adapter {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final URINormalizer DEFAULT_NORMALIZER = new URINormalizer(){
        private static final String CHAR_SET = "UTF-8";
        private static final String ARCHIVE_TAG = "?ArchiveEntry=";

        public String normalize(String orgUri) {
            String uri = orgUri;
            if (uri == null || 0 == uri.length()) {
                return "";
            }
            boolean isWildcardStart = uri.startsWith("*") || uri.startsWith("?");
            StringBuilder str = new StringBuilder(uri.length());
            String startPrefix = "";
            int prefixCount = 0;
            int pi = -1;
            String tmp = uri;
            while ((pi = tmp.indexOf("://")) != -1) {
                tmp = tmp.substring(pi + 3, tmp.length());
                ++prefixCount;
            }
            boolean skipEncodePrefix = false;
            if (prefixCount != 0) {
                if (prefixCount == 1) {
                    if (!isWildcardStart) {
                        skipEncodePrefix = true;
                    }
                } else {
                    skipEncodePrefix = true;
                }
            }
            if (skipEncodePrefix) {
                int prefixIndex = uri.indexOf("://") + 3;
                startPrefix = uri.substring(0, prefixIndex);
                uri = uri.substring(prefixIndex, uri.length());
            }
            if (uri.contains(ARCHIVE_TAG)) {
                StringBuilder strbld = new StringBuilder(uri.length() + 2);
                String beforeTag = uri.substring(0, uri.indexOf(ARCHIVE_TAG));
                String afterTag = uri.substring(uri.indexOf(ARCHIVE_TAG) + ARCHIVE_TAG.length(), uri.length());
                strbld.append(beforeTag).append('/').append(ARCHIVE_TAG).append('/').append(afterTag);
                uri = strbld.toString();
            }
            String[] tokens = uri.split("/");
            boolean isUriSlash = false;
            for (int i = 0; i < tokens.length; ++i) {
                String token;
                if (i != 0 && i != tokens.length && !str.toString().endsWith(ARCHIVE_TAG) && !isUriSlash) {
                    str.append("/");
                }
                if ((token = tokens[i]).equals("")) {
                    str.delete(str.length() - 1, str.length());
                    token = "//";
                    isUriSlash = true;
                } else {
                    isUriSlash = false;
                }
                if (token.equals(ARCHIVE_TAG)) {
                    str.delete(str.length() - 1, str.length());
                    str.append(ARCHIVE_TAG);
                    continue;
                }
                for (int j = 0; j < token.length(); ++j) {
                    char c = token.charAt(j);
                    if (c == '*' || c == '?') {
                        str.append(c);
                        continue;
                    }
                    try {
                        str.append(URLEncoder.encode(String.valueOf(c), CHAR_SET));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        str.append(c);
                    }
                }
            }
            return startPrefix + str.toString();
        }
    };

    public abstract Space getRootSpace() throws AdapterException;

    public void close() throws AdapterException {
    }

    public ItemFinder createItemFinder(Credentials credentails) throws AdapterException {
        return null;
    }

    public URINormalizer createURINormalizer() {
        return DEFAULT_NORMALIZER;
    }
}

