/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter;

import com.ibm.es.nuvo.crawler.adapter.AclDomain;
import com.ibm.es.nuvo.crawler.adapter.AclEntry;
import com.ibm.es.nuvo.crawler.adapter.acl.AclNormalizer;
import com.ibm.es.nuvo.crawler.adapter.acl.AclNormalizerException;
import com.ibm.es.nuvo.crawler.util.Checksum;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Acl {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + Acl.class.getName());
    private static final int DEFAULT_CHAR_BUFSIZE = 128;
    private final Map<Integer, List<AclEntry>> entries;
    private int maxLevel;
    private final AclDomain domain;
    private AclNormalizer normalizer;

    public Acl(AclDomain domain) {
        if (domain == null) {
            throw new NullPointerException();
        }
        this.entries = new HashMap<Integer, List<AclEntry>>();
        this.maxLevel = 0;
        this.domain = domain;
        this.normalizer = new AclNormalizer();
    }

    public AclEntry addEntry(String principal, int level) {
        String normalizedPrincipal;
        List<AclEntry> list;
        block6: {
            Integer lv;
            if (level <= 0) {
                throw new IllegalArgumentException();
            }
            if (principal == null) {
                throw new NullPointerException();
            }
            if (this.maxLevel < level) {
                this.maxLevel = level;
            }
            if ((list = this.entries.get(lv = Integer.valueOf(level))) == null) {
                list = new ArrayList<AclEntry>();
                this.entries.put(lv, list);
            }
            normalizedPrincipal = principal;
            try {
                normalizedPrincipal = this.normalizer.normalize(principal);
            }
            catch (AclNormalizerException ane) {
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, ane);
            }
        }
        AclEntry entry = new AclEntry(principal, normalizedPrincipal, level, false, false);
        list.add(entry);
        return entry;
    }

    public Iterator<AclEntry> getEntries(int level) {
        if (level <= 0) {
            throw new IllegalArgumentException();
        }
        Integer lv = level;
        List<AclEntry> list = this.entries.get(lv);
        if (list == null) {
            return null;
        }
        Collections.sort(list);
        return new ArrayList<AclEntry>(list).iterator();
    }

    public Iterator<AclEntry> getEntries() {
        ArrayList<AclEntry> work = new ArrayList<AclEntry>();
        for (List<AclEntry> list : this.entries.values()) {
            if (list == null) continue;
            work.addAll(list);
        }
        Collections.sort(work);
        return new ArrayList(work).iterator();
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public long getAclHash(boolean isACLNormalized) {
        ArrayList<AclEntry> work = new ArrayList<AclEntry>();
        for (List<AclEntry> list : this.entries.values()) {
            if (list == null) continue;
            work.addAll(list);
        }
        Collections.sort(work);
        Checksum checksum = new Checksum();
        char[] charBuf = new char[128];
        byte[] byteBuf = new byte[256];
        for (AclEntry entry : work) {
            String principal = entry.getPrincipal();
            if (isACLNormalized) {
                principal = entry.getNormalizedPrincipal();
            }
            int length = principal.length();
            int start = 0;
            int remain = length;
            while (remain > 0) {
                int actual = remain > charBuf.length ? charBuf.length : remain;
                principal.getChars(start, start + actual, charBuf, 0);
                int index = 0;
                for (int i = 0; i < actual; ++i) {
                    byteBuf[index++] = (byte)(charBuf[i] >>> 8 & 0xFF);
                    byteBuf[index++] = (byte)(charBuf[i] >>> 0 & 0xFF);
                }
                checksum.update(byteBuf, 0, index);
                remain -= actual;
                start += actual;
            }
            int level = entry.getLevel();
            for (int i = 0; i < 4; ++i) {
                byteBuf[i] = (byte)(level >>> (3 - i) * 8 & 0xFF);
            }
            checksum.update(byteBuf, 0, 4);
            checksum.update(entry.isNegative());
        }
        return checksum.getValue();
    }

    public String getDomianID() {
        if (this.domain == null) {
            throw new NullPointerException();
        }
        String result = this.domain.getDomainId();
        return result;
    }

    public void setNormalizer(AclNormalizer lNormalizer) {
        if (lNormalizer != null) {
            this.normalizer = lNormalizer;
        }
    }

    public Acl clone() {
        Acl another = new Acl(this.domain);
        another.setNormalizer(this.normalizer);
        Iterator<AclEntry> iter = this.getEntries();
        while (iter.hasNext()) {
            AclEntry entry = iter.next();
            another.addEntry(entry.getPrincipal(), entry.getLevel());
        }
        return another;
    }
}

