/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler;

import com.ibm.es.nuvo.crawler.util.hash.Hash32;

public class ParsedPath {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    String element;
    String attribute;
    private int hash;

    public ParsedPath(String path) {
        if (path == null) {
            return;
        }
        this.hash = new Hash32(path).intValue();
        int i = path.lastIndexOf(64);
        if (i < 0 && i + 1 < path.length()) {
            this.element = path;
            this.attribute = null;
        } else {
            this.element = path.substring(0, i - 1);
            this.attribute = path.substring(i + 1);
        }
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getElement() {
        return this.element;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.element);
        if (this.attribute != null) {
            builder.append("@");
            builder.append(this.attribute);
        }
        return builder.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParsedPath)) {
            return false;
        }
        ParsedPath path = (ParsedPath)o;
        return this.hash == path.hash;
    }
}

