/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.crawler.config.listener.CollectionCrawlerConfigCache;
import com.ibm.es.nuvo.crawler.runtime.AdapterService;
import com.ibm.es.nuvo.crawler.runtime.BaseAdapterService;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import com.ibm.es.nuvo.crawler.security.DSSecurityManager;
import com.ibm.es.nuvo.crawler.security.internal.DSSecurityManagerImpl;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcess;
import com.ibm.es.nuvo.crawler.view.DSViewFetchManager;
import com.ibm.es.nuvo.crawler.view.internal.DSViewFetchManagerImpl;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.config.GlobalConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class GlobalCrawlerManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = GlobalCrawlerManager.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private final Map<String, BaseCrawlerManager> crawlerManagers = new HashMap<String, BaseCrawlerManager>();
    private final AdapterService adapterService;
    private final DSSecurityManagerImpl securityManager;
    private final DSViewFetchManager viewFetchManager;
    private final WinSecurityProcess winSecurityProcess;
    private final CollectionCrawlerConfigCache crawlerConfigCache;
    private static Boolean isGlobalACLSupport = null;
    private static final String RELINFO_SYSTEM = "System";
    private static final String RELINFO_SECURITY = "SecuritySupported";

    public GlobalCrawlerManager() throws ExtendedException {
        String adaptersDir = GlobalConfiguration.getConfiguration().getInstallPath() + File.separator + "plugins" + File.separator + "crawlers";
        this.adapterService = new BaseAdapterService(new File(adaptersDir));
        this.securityManager = new DSSecurityManagerImpl(true);
        this.viewFetchManager = new DSViewFetchManagerImpl();
        if (GlobalCrawlerManager.isGlobalACLSupport()) {
            if (GlobalConfiguration.getConfiguration().isWindows()) {
                Properties props = new Properties();
                this.winSecurityProcess = new WinSecurityProcess();
                this.winSecurityProcess.init(props);
                this.winSecurityProcess.startProcess();
            } else {
                this.winSecurityProcess = null;
            }
        } else {
            this.winSecurityProcess = null;
        }
        this.crawlerConfigCache = new CollectionCrawlerConfigCache();
    }

    private BaseCrawlerManager createCrawlerManager(CollectionConfiguration config) throws ExtendedException {
        String id = config.getId();
        String crawlerConfig = CollectionConfiguration.buildCollectionPath(id);
        String crawlerData = config.getIndexPath(IndexDescriptor.IndexType.Crawl);
        boolean isACLNormalized = config.isNormalizeDocumentACLs();
        BaseCrawlerManager mgr = new BaseCrawlerManager(id, isACLNormalized, this.adapterService, crawlerConfig, crawlerData);
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws ExtendedException {
        String methodName = "terminate";
        tracer.entering(className, "terminate");
        Map<String, BaseCrawlerManager> map = this.crawlerManagers;
        synchronized (map) {
            Set<String> keys = this.crawlerManagers.keySet();
            for (String key : keys) {
                this.crawlerConfigCache.removeCacheFor(key);
                BaseCrawlerManager manager = this.crawlerManagers.get(key);
                if (logger.isLoggable(Level.FINE)) {
                    // empty if block
                }
                manager.shutdown();
                if (!logger.isLoggable(Level.INFO)) continue;
            }
        }
        if (GlobalConfiguration.getConfiguration().isWindows() && this.winSecurityProcess != null) {
            this.winSecurityProcess.term();
        }
        tracer.exiting(className, "terminate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawlerManager getCrawlerManager(String colId) {
        CrawlerManager result = null;
        Map<String, BaseCrawlerManager> map = this.crawlerManagers;
        synchronized (map) {
            if (this.crawlerManagers.containsKey(colId)) {
                result = this.crawlerManagers.get(colId);
            } else {
                GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
                ConfigurationManager configMgr = globalSystem.getConfigurationManager();
                Vector<String> collectionIds = configMgr.getCollectionIds();
                if (collectionIds.contains(colId)) {
                    try {
                        BaseCrawlerManager manager = this.createCrawlerManager(configMgr.getCollection(colId));
                        this.crawlerManagers.put(colId, manager);
                        this.securityManager.registerCrawlerManager(colId, manager);
                        result = manager;
                    }
                    catch (ExtendedException ee) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCollection(String colId, boolean closeAllResource) {
        if (closeAllResource) {
            Map<String, BaseCrawlerManager> map = this.crawlerManagers;
            synchronized (map) {
                if (this.crawlerManagers.containsKey(colId)) {
                    this.securityManager.unregisterCrawlerManager(colId);
                    this.crawlerConfigCache.removeCacheFor(colId);
                    this.crawlerManagers.get(colId).shutdown();
                    this.crawlerManagers.remove(colId);
                }
            }
        }
    }

    public DSSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public WinSecurityProcess getFencedWinSecurityProcess() {
        return this.winSecurityProcess;
    }

    public DSViewFetchManager getViewFetchManager() {
        return this.viewFetchManager;
    }

    public CollectionCrawlerConfigCache getCrawlerConfigCache() {
        return this.crawlerConfigCache;
    }

    public static synchronized boolean isGlobalACLSupport() throws ExtendedException {
        if (isGlobalACLSupport == null) {
            boolean b;
            ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
            if (releaseInfo != null) {
                b = releaseInfo.getValueAsBoolean(RELINFO_SYSTEM, RELINFO_SECURITY, false);
                if (b) {
                    GlobalConfig globalConfig = ConfigurationLoader.getGlobalConfig();
                    b = globalConfig.getAuthenticationModule().isLocalOSLoginRequired();
                }
            } else {
                b = false;
            }
            isGlobalACLSupport = b;
        }
        return isGlobalACLSupport;
    }
}

