/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler;

import com.ibm.es.nuvo.crawler.FileSystemCrawlerFilter;
import com.ibm.es.nuvo.crawler.FinishedCrawling;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueue;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import com.ibm.es.nuvo.util.threadpool.Task;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileSystemCrawler
extends Task {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String collectionId;
    private String path;
    private DocumentQueue documentQueue;
    private FileSystemCrawlerFilter filter;
    private volatile boolean stopCrawl = false;
    private static final String fileProtocol = "file";
    private static final String hostname = "localhost";

    public FileSystemCrawler(String collectionId, String path, DocumentQueue documentQueue) {
        this.collectionId = collectionId;
        this.path = path;
        this.documentQueue = documentQueue;
        this.filter = null;
    }

    public void setFilter(FileSystemCrawlerFilter filter) {
        this.filter = filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendDocumentsFromDirectory(String directory) {
        if (this.stopCrawl) {
            return;
        }
        File file = new File(directory);
        if (file.isDirectory()) {
            String[] filesAndDirectories = file.list();
            for (int i = 0; i < filesAndDirectories.length; ++i) {
                this.sendDocumentsFromDirectory(directory + File.separator + filesAndDirectories[i]);
            }
            return;
        } else {
            try {
                if (this.filter != null && this.filter.accept(directory)) {
                    String filePath = this.filter.getURI(directory);
                    filePath = filePath.replace('\\', '/');
                    filePath = filePath.replace(" ", "%20");
                    String uriString = "file://localhost/" + filePath;
                    this.documentQueue.addDocumentStream(this.collectionId, this.createDataBufferStreamDocument(uriString, directory));
                    return;
                }
                if (this.filter != null) return;
                String filePath = directory;
                filePath = filePath.replace('\\', '/');
                this.documentQueue.addDocumentStream(this.collectionId, this.createDataBufferStreamDocument(directory, directory));
                return;
            }
            catch (FileNotFoundException e) {
                if (this.stopCrawl) return;
                e.printStackTrace();
                return;
            }
            catch (DocumentQueueInsertException e) {
                if (this.stopCrawl) return;
                e.printStackTrace();
                return;
            }
            catch (DocumentStreamCreateException e) {
                e.printStackTrace();
            }
        }
    }

    public void executeTask() {
        this.sendDocumentsFromDirectory(this.path);
    }

    public Object getEvent() {
        return new FinishedCrawling(this.path);
    }

    public void setStopCrawl(boolean stop) {
        this.stopCrawl = stop;
    }

    private DataBufferStreamDocument createDataBufferStreamDocument(String uri, String pathIn) throws FileNotFoundException, DocumentStreamCreateException {
        FileInputStream fs = new FileInputStream(pathIn);
        DataBufferOutputStream ds = new DataBufferOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = fs.read(buffer)) != -1) {
                ds.write(buffer, 0, len);
            }
            fs.close();
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new DataBufferStreamDocument(uri, ds);
    }
}

