/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.tracking;

import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.configuration.tracking.UpdateId;
import com.ibm.es.nuvo.configuration.tracking.UpdateTrackingData;
import com.ibm.es.nuvo.httplistener.HttpListenerManager;
import com.ibm.es.nuvo.httplistener.HttpListenerServer;
import com.ibm.es.nuvo.util.Constants;

public class UpdateTrackingManager {
    private static final String KeySeparator = "/";
    private static UpdateTrackingManager instance = null;
    private String localMachineName = null;

    private UpdateTrackingManager() {
    }

    public static UpdateTrackingManager getInstance() {
        if (instance == null) {
            instance = new UpdateTrackingManager();
        }
        return instance;
    }

    public void incrementChangeFor(Constants.ConfigurationObjectType objectType, String objectId) throws ConfigurationManagerException {
        SettingsConfigurationManager mgr = SettingsConfigurationManager.getConfigurationManager();
        UpdateTrackingData data = (UpdateTrackingData)mgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.UpdateTrackingData);
        String key = this.buildKey(objectType, objectId);
        UpdateId myUpdateId = data.getUpdateMap().get(key);
        String machineName = this.getLocalMachineName();
        if (myUpdateId != null) {
            myUpdateId.incrementChange(machineName);
        } else {
            myUpdateId = new UpdateId();
            myUpdateId.setMachineName(machineName);
            data.getUpdateMap().put(key, myUpdateId);
        }
        mgr.updateStateObject(SettingsConfigurationManager.SettingsType.UpdateTrackingData, data);
    }

    public void setChangeTo(Constants.ConfigurationObjectType objectType, String objectId, UpdateId newId) throws ConfigurationManagerException {
        SettingsConfigurationManager mgr = SettingsConfigurationManager.getConfigurationManager();
        UpdateTrackingData data = (UpdateTrackingData)mgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.UpdateTrackingData);
        String key = this.buildKey(objectType, objectId);
        data.getUpdateMap().put(key, newId);
        mgr.updateStateObject(SettingsConfigurationManager.SettingsType.UpdateTrackingData, data);
    }

    public boolean isNewIdGreater(Constants.ConfigurationObjectType objectType, String objectId, UpdateId newId) {
        UpdateTrackingData data = this.getConfigData();
        String key = this.buildKey(objectType, objectId);
        UpdateId myUpdateId = data.getUpdateMap().get(key);
        boolean newIdGreater = true;
        if (myUpdateId != null) {
            newIdGreater = myUpdateId.compareTo(newId) < 0;
        }
        return newIdGreater;
    }

    private String buildKey(Constants.ConfigurationObjectType objectType, String objectId) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(KeySeparator);
        sb.append(objectType.toString());
        if (objectId != null) {
            sb.append(KeySeparator);
            sb.append(objectId);
        }
        return sb.toString();
    }

    private UpdateTrackingData getConfigData() {
        SettingsConfigurationManager mgr = SettingsConfigurationManager.getConfigurationManager();
        UpdateTrackingData data = (UpdateTrackingData)mgr.getSettings(SettingsConfigurationManager.SettingsType.UpdateTrackingData);
        return data;
    }

    private String getLocalMachineName() {
        if (this.localMachineName == null) {
            HttpListenerServer server = HttpListenerManager.getSingleInstanceListenerServer();
            String hostname = server.getHostName();
            StringBuilder sb = new StringBuilder(200);
            sb.append(hostname);
            sb.append(":");
            int port = server.getAdminHttpPort();
            if (port == 0) {
                port = server.getAdminHttpsPort();
            }
            sb.append(port);
            this.localMachineName = sb.toString();
        }
        return this.localMachineName;
    }
}

