/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.tracking;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.SettingsObject;
import com.ibm.es.nuvo.configuration.tracking.UpdateId;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTrackingData
implements SettingsObject {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String VersionAttribute = "version";
    private static final String DataFileName = "updateData.xml";
    private static final String EntryElement = "entry";
    private static final String NameElement = "name";
    private static final String UpdateTrackingDataElement = "update_tracking_data";
    private String tempRestoredName = null;
    private HashMap<String, UpdateId> updateMap = new HashMap();

    public HashMap<String, UpdateId> getUpdateMap() {
        return this.updateMap;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException, ExtendedException {
        XMLTagger xmlTagger = new XMLTagger(true, true);
        xmlTagger.openStartElement(UpdateTrackingDataElement);
        xmlTagger.writeAttr(VersionAttribute, "1.0");
        xmlTagger.closeTag();
        for (Map.Entry<String, UpdateId> curEntry : this.updateMap.entrySet()) {
            xmlTagger.startElement(EntryElement);
            xmlTagger.startElement(NameElement);
            xmlTagger.writeText(curEntry.getKey());
            xmlTagger.endElement(NameElement);
            UpdateId updateId = curEntry.getValue();
            updateId.writeTo(xmlTagger);
            xmlTagger.endElement(EntryElement);
        }
        xmlTagger.endElement(UpdateTrackingDataElement);
        String xml = xmlTagger.getXML();
        try {
            os.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    @Override
    public void loadFrom(InputStream is) throws ExtendedException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String basePath = "/update_tracking_data/entry/";
        tree.addPath(basePath + NameElement, "restoreEntryName");
        tree.addSetSubcomponent(basePath + "change_id", "buildUpdateId");
        UpdateId.prepareParseTree(basePath, tree);
        parser.parse(is, tree, this);
    }

    @Override
    public String getPersistantFileName() {
        StringBuffer sb = new StringBuffer(200);
        GlobalConfiguration gc = GlobalConfiguration.getConfiguration();
        sb.append(gc.getConfigPath());
        sb.append(File.separator);
        sb.append(DataFileName);
        return sb.toString();
    }

    public void restoreEntryName(String restoredName) {
        this.tempRestoredName = restoredName;
    }

    public UpdateId buildUpdateId() {
        UpdateId updateId = new UpdateId();
        if (this.tempRestoredName != null) {
            this.updateMap.put(this.tempRestoredName, updateId);
            this.tempRestoredName = null;
        }
        return updateId;
    }
}

