/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.tool;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.configuration.tool.ConfigurationTool;
import com.ibm.es.nuvo.configuration.tool.ServerStatus;
import com.ibm.es.nuvo.inyo.client.api.Collection;
import com.ibm.es.nuvo.inyo.client.api.CollectionNotFoundException;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.logging.DynamicFileHandlerException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.LoggerWrapper;
import com.ibm.es.nuvo.util.CommandLineArguments;
import com.ibm.es.nuvo.util.Encryption;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Locale;

public class SynonymTool {
    private static final String OKResponse = "HTTP/1.1 200 OK";
    private static String ImportSynonymCmd = "importSynonym";
    private static String RemoveSynonymCmd = "removeSynonym";
    private static String HelpCmd = "help";
    private static String SynonymFileArg = "synonymFile";
    private static String CollectionNameArg = "collectionName";
    private static final String LocaleCmd = "locale";
    private static String ReplaceArg = "replace";
    private static String ConfigPath = "configPath";
    private static String ConfigFileName = "config.xml";
    private static final String AuthenticationFileName = "authentication.xml";
    private static final String KeyFileName = "key.txt";
    private static final String SYNONYM_TOOL_LOGGER = "SynonymToolLogger";
    private static final String SynonymLoggerPrefix = "SynonymTool";
    private static final String USAGE = " Usage:\n synonymTool synonym_command -configPath value [-locale value] -command_specific_arguments\n\n Where:\n synonym_command:\n     importSynonym: Update synonyms for the specified collection\n     removeSynonym: Delete all the synonyms for the specified collection\n     help:          Print this help message\n\n -configPath value\n     The fully qualified path to the configuration directory such as /opt/ibm/search/config\n -locale value\n     The 5-character locale code, such as en_US, de_DE, or zh_TW. If omitted, the server locale is used (optional).\n\n command_specific_arguments:\n\n synonymTool importSynonym\n     -synonymFile value\n         The fully qualified path to the synonym file that contains the updated synonyms.\n     -replace value\n         true:  Replace the existing synonyms with the updated synonyms.\n         false: Append the updated synonyms to the existing synonyms.\n     -collectionName value\n         The name of the collection for which synonyms are to be updated.\n\n synonymTool removeSynonym\n     -collectionName value\n         The name of the collection for which synonyms are to be removed\n\n Example to append updated synonyms in the Default collection:\n synonymTool importSynonym -configPath /opt/ibm/search/config -synonymFile synonym.xml -collectionName Default -replace false\n\n Example to remove all synonyms from the Default collection:\n synonymTool removeSynonym -configPath /opt/ibm/search/config -collectionName Default";
    private String mode;
    private CommandLineArguments cmdArgs = null;
    private String configPath;
    private File configFile;
    public static final ExtendedLogger synonymLogger = ExtendedLogger.getLogger("SynonymToolLogger");
    private LoggerWrapper wrappedSynonymLogger;
    private boolean useInyoServer = true;
    private Locale locale = Locale.getDefault();

    public SynonymTool() {
    }

    public SynonymTool(String[] args) {
        this.processRequest(args);
    }

    public boolean processRequest(String[] args) {
        Message msg;
        String localeString;
        String[] arguments;
        if (args.length < 1) {
            this.printUsage();
            System.exit(0);
        }
        this.mode = args[0];
        if (this.mode.equalsIgnoreCase(HelpCmd) || this.mode.equalsIgnoreCase("-help") || this.mode.equalsIgnoreCase("--help") || this.mode.equals("-h") || this.mode.equals("?")) {
            if (args.length >= 3) {
                arguments = new String[args.length - 1];
                System.arraycopy(args, 1, arguments, 0, args.length - 1);
                this.cmdArgs = new CommandLineArguments(arguments);
                if (this.cmdArgs.doesParamExist(LocaleCmd)) {
                    localeString = this.cmdArgs.getParam(LocaleCmd);
                    this.locale = ConfigurationTool.getLocale(localeString);
                }
            }
            this.printUsage();
            System.exit(0);
        }
        arguments = new String[args.length - 1];
        System.arraycopy(args, 1, arguments, 0, args.length - 1);
        this.cmdArgs = new CommandLineArguments(arguments);
        if (this.cmdArgs.doesParamExist(LocaleCmd)) {
            localeString = this.cmdArgs.getParam(LocaleCmd);
            this.locale = ConfigurationTool.getLocale(localeString);
        }
        if (this.cmdArgs.doesParamExist(ConfigPath)) {
            this.configPath = this.cmdArgs.getParam(ConfigPath);
            this.configFile = new File(this.configPath + File.separator + ConfigFileName);
        } else {
            msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
            msg.addArgument(ConfigPath);
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(1);
        }
        this.init();
        this.initLogger();
        if (!this.isServerUp()) {
            msg = new Message("D0055E.SERVER_SHUTDOWN_REQUIRE_RUNNING");
            synonymLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
        return this.processRequest(args, this.getToken());
    }

    public static Locale getLocale(String localeString) {
        if (localeString.length() != 5) {
            Message msg = new Message("G0177E.INVALID_LOCALE_STRING");
            msg.addArgument(localeString);
            System.err.println(msg.getFormattedTextWithDisplayKey());
            System.exit(7);
        }
        String lang = localeString.substring(0, 1);
        String country = localeString.substring(3, 4);
        return new Locale(lang, country);
    }

    private boolean isServerUp() {
        String hostName = this.getHostName();
        int port = this.getAdminHTTPPort();
        try {
            return ServerStatus.isServerRunning(this.getToken(), hostName, port, this.useInyoServer);
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
            msg.addArgument(e.getLocalizedMessage());
            synonymLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
    }

    public boolean processRequest(String[] args, String token) {
        if (this.mode.equals(ImportSynonymCmd)) {
            Message msg;
            if (!this.cmdArgs.doesParamExist(SynonymFileArg)) {
                msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(SynonymFileArg);
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(1);
            }
            if (!this.cmdArgs.doesParamExist(ReplaceArg)) {
                msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(ReplaceArg);
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(1);
            }
            if (!this.cmdArgs.doesParamExist(CollectionNameArg)) {
                msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(CollectionNameArg);
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(1);
            }
            return this.importSynonyms(token, this.useInyoServer);
        }
        if (this.mode.equals(RemoveSynonymCmd)) {
            if (!this.cmdArgs.doesParamExist(CollectionNameArg)) {
                Message msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(CollectionNameArg);
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(1);
            }
            return this.removeSynonyms(token, this.useInyoServer);
        }
        Message msg = new Message("D0029E.COMMAND_ARG_MISSING");
        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
        System.exit(1);
        return false;
    }

    private void init() {
        try {
            GlobalConfiguration.initialize(this.configFile.getAbsolutePath());
        }
        catch (Exception e) {
            Message msg = new Message("G0026E.CONFIG_FILE_ERROR");
            msg.addArgument(this.configFile.getAbsolutePath());
            System.err.println(msg.getFormattedText(this.locale));
            System.exit(2);
        }
        try {
            ReleaseInfo.initialize(null);
            this.useInyoServer = ReleaseInfo.getReleaseInfo().getValueAsBoolean("System", "UseCustomServer", true);
        }
        catch (ExtendedException e) {
            File releaseFile = new File(this.configPath + File.separator + "releaseinfo", "release.properties");
            Message msg = new Message("G0042E.CONFIG_DIRECTORY_MISSING_FILES");
            msg.addArgument(releaseFile.getAbsolutePath());
            msg.addArgument(releaseFile.getName());
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(3);
        }
    }

    private void initLogger() {
        try {
            this.wrappedSynonymLogger = new LoggerWrapper(synonymLogger, GlobalConfiguration.getConfiguration() == null ? null : GlobalConfiguration.getConfiguration().getLogPath(), SynonymLoggerPrefix);
            this.wrappedSynonymLogger.initialize(0x800000, 1);
        }
        catch (DynamicFileHandlerException e) {
            Message msg = new Message("G0027W.LOGGER_INIT_ERROR");
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(4);
        }
    }

    private int getAdminHTTPPort() {
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
            return jettyConfig.getAdminHttpPort();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String getHostName() {
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
            return jettyConfig.getHostName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean importSynonyms(String token, boolean inyoServer) {
        String index = null;
        String fileName = null;
        String replace = null;
        if (!(this.cmdArgs.doesParamExist(CollectionNameArg) && this.cmdArgs.doesParamExist(SynonymFileArg) && this.cmdArgs.doesParamExist(ReplaceArg))) {
            Message msg = new Message("D0029E.COMMAND_ARG_MISSING");
            synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(1);
            return false;
        }
        index = this.cmdArgs.getParam(CollectionNameArg);
        fileName = this.cmdArgs.getParam(SynonymFileArg);
        replace = this.cmdArgs.getParam(ReplaceArg);
        if (!replace.equals("true") && !replace.equals("false")) {
            Message msg = new Message("D0048E.INVALID_ARGUMENT_VALUE");
            msg.addArgument(replace);
            synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(1);
            return false;
        }
        File synonymXML = new File(fileName);
        if (!synonymXML.exists()) {
            Message msg = new Message("D0048E.INVALID_ARGUMENT_VALUE");
            msg.addArgument(fileName);
            synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
        File coll = new File(GlobalConfiguration.getConfiguration().getCollectionPath() + File.separator + index);
        if (!coll.isDirectory()) {
            Message msg = new Message("D0006E.NONEXISTANT_COLLECTION");
            msg.addArgument(index);
            synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
        if (inyoServer) {
            Collection collection = new Collection(this.getHostName(), this.getAdminHTTPPort(), token);
            try {
                collection.updateSynonym(index, fileName, replace.equals("true"));
                return true;
            }
            catch (CollectionNotFoundException e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
            catch (InyoException e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
        }
        try {
            String requestHeader = this.httpRequestHeader(index, fileName, replace, token);
            return this.sendRequest(requestHeader);
        }
        catch (IOException e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION" + e);
            synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
    }

    private boolean removeSynonyms(String token, boolean inyoServer) {
        String index = this.cmdArgs.getParam(CollectionNameArg);
        File coll = new File(GlobalConfiguration.getConfiguration().getCollectionPath() + File.separator + index);
        if (!coll.isDirectory()) {
            Message msg = new Message("D0006E.NONEXISTANT_COLLECTION");
            msg.addArgument(index);
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
        if (inyoServer) {
            Collection collection = new Collection(this.getHostName(), this.getAdminHTTPPort(), token);
            try {
                collection.removeSynonym(index);
                return true;
            }
            catch (CollectionNotFoundException e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
            catch (InyoException e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
        }
        try {
            String requestHeader = this.httpRequestHeader(index, token);
            return this.sendRequest(requestHeader);
        }
        catch (IOException e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION" + e);
            synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRequest(String requestHeader) throws IOException {
        Socket socket;
        block20: {
            OutputStreamWriter osw;
            block17: {
                boolean bl;
                block18: {
                    socket = null;
                    osw = null;
                    try {
                        int ncr;
                        socket = new Socket(this.getHostName(), this.getAdminHTTPPort());
                        osw = new OutputStreamWriter(socket.getOutputStream());
                        osw.write(requestHeader);
                        osw.flush();
                        socket.getOutputStream().flush();
                        InputStream is = socket.getInputStream();
                        byte[] ba = new byte[256];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while ((ncr = is.read(ba)) > 0) {
                            baos.write(ba, 0, ncr);
                        }
                        String response = null;
                        if (baos.size() > 0) {
                            response = baos.toString();
                        }
                        if (response == null || response.startsWith(OKResponse)) break block17;
                        Message msg = new Message("D0049E.NO_OK_SERVER_RESPONSE");
                        msg.addArgument(response);
                        synonymLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
                        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                        bl = false;
                        Object var11_11 = null;
                        if (osw == null) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (osw != null) {
                            try {
                                osw.close();
                            }
                            catch (Exception e) {
                                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                                return false;
                            }
                        }
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Exception e) {
                                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                                return false;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        osw.close();
                    }
                    catch (Exception e) {
                        Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                        synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                        return false;
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                        synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                        return false;
                    }
                }
                return bl;
            }
            Object var11_12 = null;
            if (osw == null) break block20;
            try {
                osw.close();
            }
            catch (Exception e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
                synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
        }
        return true;
    }

    private String httpRequestHeader(String index, String fileName, String replace, String token) {
        StringBuffer sb = new StringBuffer();
        sb.append("POST /api/admin HTTP/1.1").append("\r\n");
        sb.append("Host: " + this.getHostName() + ":" + this.getAdminHTTPPort()).append("\r\n");
        sb.append("action: importSynonym").append("\r\n");
        sb.append("index: " + index).append("\r\n");
        sb.append("replace: " + replace).append("\r\n");
        sb.append("fileName: " + fileName).append("\r\n");
        sb.append("Authorization: Basic ").append(token).append("\r\n");
        sb.append("Connection: close\r\n");
        sb.append("\r\n");
        return sb.toString();
    }

    private String httpRequestHeader(String index, String token) {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE /api/admin HTTP/1.1").append("\r\n");
        sb.append("Host: " + this.getHostName() + ":" + this.getAdminHTTPPort()).append("\r\n");
        sb.append("action: removeSynonym").append("\r\n");
        sb.append("index: " + index).append("\r\n");
        sb.append("Authorization: Basic ").append(token).append("\r\n");
        sb.append("Connection: close\r\n");
        sb.append("\r\n");
        return sb.toString();
    }

    private String getToken() {
        try {
            Message msg;
            String keyFileName = this.configPath + File.separator + KeyFileName;
            String authFileName = this.configPath + File.separator + AuthenticationFileName;
            File keyFile = new File(keyFileName);
            File authFile = new File(authFileName);
            if (!authFile.exists()) {
                msg = new Message("D0061E.AUTHENTICATION_FILE_NOT_EXIST");
                msg.addArgument(authFile.getAbsolutePath());
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(5);
            }
            if (!keyFile.exists()) {
                msg = new Message("D0060E.KEY_FILE_NOT_EXIST");
                msg.addArgument(keyFile.getAbsolutePath());
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(6);
            }
            Encryption.loadDefaultKey(keyFileName);
            AuthenticationData authData = new AuthenticationData();
            authData.loadFrom(new FileInputStream(new File(authFileName)));
            return authData.getApiPassword();
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
            synonymLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            return null;
        }
    }

    private void printUsage() {
        Message msg = new Message("D0059I.SYNONYM_TOOL_USAGE");
        System.err.println();
        if (null == msg.getText(this.locale)) {
            System.err.println(USAGE);
        } else {
            System.err.println(msg.getFormattedText(this.locale));
        }
    }

    public static void main(String[] args) {
        SynonymTool synTool = new SynonymTool();
        if (args.length > 0 && args[0].equals("test")) {
            String importRequest = "importSynonym -collectionName Default -replace true -configPath  C:\\Projects\\whitneyr3\\package\\config\\ -synonymFile C:\\Projects\\whitneyr3\\qa\\package\\resource\\unittest\\api\\synonym1.xml";
            synTool.processRequest(importRequest.split("\\s+", 9));
        } else {
            synTool.processRequest(args);
        }
    }
}

