/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.tool;

import com.ibm.es.nuvo.inyo.client.api.InyoSystem;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.inyo.client.infra.Response;
import com.ibm.es.nuvo.util.Base64;
import java.net.HttpURLConnection;
import java.net.URL;

public class ServerStatus {
    private static String MonitorURL = "/whitney/inyo/monitor";

    public static boolean isServerRunning(String authToken, String hostName, int port, boolean useInyoServer) throws Exception {
        try {
            if (useInyoServer) {
                InyoSystem sys = new InyoSystem(hostName, port, authToken);
                return sys.getStatus() == Response.Status.Done;
            }
            String auth = ":" + authToken;
            byte[] data = auth.getBytes("UTF-8");
            String base64Auth = Base64.encode(data);
            URL url = new URL("http", hostName, port, MonitorURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.addRequestProperty("action", "getStatus");
            connection.addRequestProperty("scope", "system");
            connection.addRequestProperty("Authorization", "Basic " + base64Auth);
            int code = connection.getResponseCode();
            if (code == 200) {
                return true;
            }
            if (code == 500 || code == 401 || code == 404) {
                return true;
            }
        }
        catch (InyoException ie) {
            return !ie.getMessage().equals("D0050E.CONNECT_ERROR");
        }
        return false;
    }
}

