/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.tool;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.configuration.SystemSettings;
import com.ibm.es.nuvo.configuration.tool.ServerStatus;
import com.ibm.es.nuvo.httplistener.KeystoreManager;
import com.ibm.es.nuvo.logging.DynamicFileHandlerException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.LoggerWrapper;
import com.ibm.es.nuvo.util.AuthUtils;
import com.ibm.es.nuvo.util.CommandLineArguments;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.FileUtils;
import com.ibm.es.nuvo.util.XMLDOMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationTool {
    private static final String ConfigFileName = "config.xml";
    private static final String AuthenticationFileName = "authentication.xml";
    private static final String KeyFileName = "key.txt";
    private static final String KeyStoreFileName = "keystore";
    private static final String StartupFileName = "startup.sh";
    private static final String LoggerName = "com.ibm.es.nuvo";
    private static final String CONFIG_TOOL_LOGGER = "ConfigToolLogger";
    private static final String ConfigLoggerPrefix = "ConfigTool";
    private static String USAGE = "Usage:\n configTool configuration_command -configPath value [-locale value] -command_specific_arguments\n\n Where:\n configuration_command:\n    configureHTTPListener: Configure the server ports and host name\n    configureParams:       Configure collection-level parameters\n    generateToken:         Generate a token  for communicating with the server\n    printAdminHTTPPort:    Print the administration console port\n    printAll:              Print the values for all the collection-level parameters\n    printToken:            Print the current token\n    help:                  Print this help message\n\n -configPath value\n     The fully qualified path to the configuration directory, such as /opt/ibm/search/config\n\n -locale value\n     The 5-character locale code, such as en_US, de_DE, or zh_TW. If omitted, en_US locale is used (optional).\n\n command_specific_arguments\n\n configTool configureHTTPListener\n -adminHTTPPort value\n     The HTTP port number for the administration console.\n -searchHTTPPort value\n     The HTTP port number for the search application (optional).\n\n configTool configureParams\n -adminHTTPPort value\n     The HTTP port number for the administration console (optional).\n -searchHTTPPort value\n     The HTTP port number for the search application (optional).\n -logPath value\n     The fully qualified path to the directory to use for log files(optional).\n -tempDirPath <value>\n     The fully qualified path to a directory to use for temporary space (optional).\n -defaultDataPath value\n     The fully qualified path to the search engine data directory (optional).\n -installPath value\n     The fully qualified path to the search engine installation directory (optional).\n -logLevel value\n     The types of messages to be logged. Valid values are FINE, FINER, FINEST, INFO, OFF, SEVERE and WARNING (optional).\n\n configTool generateToken\n -seed value\n     The random seed for generating an encrypted token for communicating with the server\n\n Example to change the directory used to store log files, using the French locale:\n configTool configureParams -configPath /opt/ibm/search/config -locale fr_FR -logPath /opt/ibm/search/mylog\n\n Example to initialize and configure the administration port of the server:\n configTool configureHTTPListener -configPath c:\\IBM\\OmniFind\\config -adminHTTPPort 8888\n\n Example to generate a new token, using abcd as seed value and using the Spanish locale:\n configTool generateToken -configPath c:\\IBM\\Search\\config -locale es_ES -seed abcd";
    private static final String[] JettyFiles = new String[]{"jetty.xml", "jetty_search.xml"};
    private String configPath = null;
    private File configFile;
    private CommandLineArguments cmdArgs;
    private String mode;
    public static final ExtendedLogger configLogger = ExtendedLogger.getLogger("ConfigToolLogger");
    private LoggerWrapper wrappedConfigLogger;
    private Vector<ElementToOverwrite> elements = new Vector();
    private static ServerSocket socket = null;
    private boolean useInyoServer = true;
    private Locale locale = Locale.getDefault();

    public ConfigurationTool(String[] args) {
        this.process(args);
    }

    public ConfigurationTool() {
    }

    public void reinit() {
        this.initGlobalConfig();
    }

    private void initLogger() {
        try {
            this.wrappedConfigLogger = new LoggerWrapper(configLogger, GlobalConfiguration.getConfiguration() == null ? null : GlobalConfiguration.getConfiguration().getLogPath(), ConfigLoggerPrefix);
            this.wrappedConfigLogger.initialize(0x800000, 1);
        }
        catch (DynamicFileHandlerException e) {
            Message msg = new Message("G0027W.LOGGER_INIT_ERROR");
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(6);
        }
    }

    public static Locale getLocale(String localeString) {
        if (localeString.length() != 5) {
            Message msg = new Message("G0177E.INVALID_LOCALE_STRING");
            msg.addArgument(localeString);
            System.err.println(msg.getFormattedTextWithDisplayKey());
            System.exit(24);
        }
        String lang = localeString.substring(0, 2);
        String country = localeString.substring(3, 5);
        return new Locale(lang, country);
    }

    public void process(String[] args) {
        Message msg;
        String localeString;
        String[] arguments;
        if (args.length < 1) {
            this.printUsage(System.err);
            System.exit(0);
        }
        if (args[0].equalsIgnoreCase(Mode.help.toString()) || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help") || args[0].equals("-h") || args[0].equals("?")) {
            if (args.length >= 3) {
                arguments = new String[args.length - 1];
                System.arraycopy(args, 1, arguments, 0, args.length - 1);
                this.cmdArgs = new CommandLineArguments(arguments);
                if (this.cmdArgs.doesParamExist(Params.locale.toString())) {
                    localeString = this.cmdArgs.getParam(Params.locale.toString());
                    this.locale = ConfigurationTool.getLocale(localeString);
                }
            }
            this.printUsage(System.err);
            System.exit(0);
        }
        this.mode = args[0];
        arguments = new String[args.length - 1];
        System.arraycopy(args, 1, arguments, 0, args.length - 1);
        this.cmdArgs = new CommandLineArguments(arguments);
        if (this.cmdArgs.doesParamExist(Params.locale.toString())) {
            localeString = this.cmdArgs.getParam(Params.locale.toString());
            this.locale = ConfigurationTool.getLocale(localeString);
        }
        if (!this.checkMode()) {
            msg = new Message("D0029E.COMMAND_ARG_MISSING");
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(12);
        }
        if (args.length < 3) {
            msg = new Message("D0031E.MANDATORY_ARG_MISSING");
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(14);
        }
        if (this.cmdArgs.doesParamExist(Params.configPath.toString())) {
            this.configPath = this.cmdArgs.getParam(Params.configPath.toString());
            this.configFile = new File(this.configPath + File.separator + ConfigFileName);
        } else {
            msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
            msg.addArgument(Params.configPath.toString());
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(14);
        }
        this.initGlobalConfig();
        this.initLogger();
        if (!this.checkServerStatus()) {
            msg = new Message("D0036E.SERVER_RUNNING_REQUIRE_SHUTDOWN");
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(17);
        }
    }

    private boolean checkMode() {
        return this.mode.equals(Mode.configureHTTPListener.toString()) || this.mode.equals(Mode.createInstance.toString()) || this.mode.equals(Mode.configureParams.toString()) || this.mode.equals(Mode.generateToken.toString()) || this.mode.equals(Mode.printAll.toString()) || this.mode.equals(Mode.printAdminHTTPPort.toString()) || this.mode.equals(Mode.printToken.toString());
    }

    private boolean checkServerStatus() {
        return !this.mode.equals(Mode.configureParams.toString()) && !this.mode.equals(Mode.configureHTTPListener.toString()) && !this.mode.equals(Mode.createInstance.toString()) && !this.mode.equals(Mode.generateToken.toString()) || !this.isServerUp();
    }

    private void initGlobalConfig() {
        Message msg;
        try {
            GlobalConfiguration.initialize(this.configFile.getAbsolutePath());
            if (!(this.mode.equals(Mode.generateToken.toString()) || this.mode.equals(Mode.printAll.toString()) || this.mode.equals(Mode.printAdminHTTPPort.toString()) || this.mode.equals(Mode.printToken.toString()))) {
                GlobalConfiguration.getConfiguration().setConfigPath(this.configFile.getParentFile().getCanonicalPath());
            }
        }
        catch (Exception e) {
            msg = new Message("G0026E.CONFIG_FILE_ERROR");
            msg.addArgument(this.configFile.getAbsolutePath());
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(5);
        }
        try {
            if (!(this.mode.equals(Mode.generateToken.toString()) || this.mode.equals(Mode.printAll.toString()) || this.mode.equals(Mode.printAdminHTTPPort.toString()) || this.mode.equals(Mode.printToken.toString()))) {
                ReleaseInfo.initialize(this.configPath + File.separator + "releaseinfo" + File.separator + "release.properties");
                this.useInyoServer = ReleaseInfo.getReleaseInfo().getValueAsBoolean("System", "UseCustomServer", true);
            }
        }
        catch (ExtendedException e) {
            msg = new Message("G0042E.CONFIG_DIRECTORY_MISSING_FILES");
            msg.addArgument(this.configPath + File.separator + "releaseinfo");
            msg.addArgument("release.properties");
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(8);
        }
    }

    public void configure() {
        if (this.mode.equals(Mode.configureHTTPListener.toString())) {
            try {
                this.configureHTTPListener();
            }
            catch (NumberFormatException e) {
                Message msg = new Message("D0039W.INVALID_PORT_NO", e.getMessage());
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(18);
            }
        } else if (this.mode.equals(Mode.createInstance.toString())) {
            this.createInstance();
        } else if (this.mode.equals(Mode.configureParams.toString())) {
            try {
                this.configureParams();
            }
            catch (NumberFormatException e) {
                Message msg = new Message("D0039W.INVALID_PORT_NO", e.getMessage());
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(18);
            }
        } else if (this.mode.equals(Mode.printToken.toString())) {
            String keyFileName = this.configPath + File.separator + KeyFileName;
            String authFileName = this.configPath + File.separator + AuthenticationFileName;
            File keyFile = new File(keyFileName);
            File authFile = new File(authFileName);
            if (!keyFile.exists() || !authFile.exists()) {
                Message msg = new Message("D0062E.NO_TOKEN_FOUND");
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(20);
            }
            this.printToken(keyFileName, authFileName);
        } else if (this.mode.equals(Mode.printAll.toString())) {
            this.printAll();
        } else if (this.mode.equals(Mode.printAdminHTTPPort.toString())) {
            this.printPort();
        } else if (this.mode.equals(Mode.generateToken.toString())) {
            this.generateAuthenticationToken();
        } else {
            Message msg = new Message("D0029E.COMMAND_ARG_MISSING");
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(12);
        }
    }

    private static void copyFiles(String from, String to) throws IOException {
        File src = new File(from);
        File dest = new File(to);
        if (src.isDirectory()) {
            dest.mkdirs();
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                String src1 = src.getAbsolutePath() + File.separator + list[i];
                String dest1 = dest.getAbsolutePath() + File.separator + list[i];
                ConfigurationTool.copyFiles(src1, dest1);
            }
        } else {
            int c;
            FileInputStream fin = new FileInputStream(src);
            FileOutputStream fout = new FileOutputStream(dest);
            while ((c = fin.read()) >= 0) {
                fout.write(c);
            }
            fin.close();
            fout.close();
        }
    }

    private void createInstance() {
        block6: {
            if (this.cmdArgs.doesParamExist(Params.installPath.toString()) && this.cmdArgs.doesParamExist(Params.instancePath.toString())) {
                String installHomePath = this.cmdArgs.getParam(Params.installPath.toString());
                String instanceHomePath = this.cmdArgs.getParam(Params.instancePath.toString());
                try {
                    File source;
                    Message msg;
                    boolean created;
                    File destination = new File(instanceHomePath + File.separator + "config");
                    if (!destination.exists() && !(created = destination.mkdirs())) {
                        msg = new Message("D0041E.UNABLE_TO_CREATE_DIRECTORY");
                        msg.addArgument(destination.getAbsolutePath());
                        configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                    }
                    if ((source = new File(installHomePath + File.separator + "config")).isDirectory()) {
                        ConfigurationTool.copyFiles(source.getAbsolutePath(), destination.getAbsolutePath());
                        break block6;
                    }
                    msg = new Message("D0038E.INSTALL_SOURCE_NOT_DIRECTORY");
                    msg.addArgument(source.getAbsolutePath());
                    configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(21);
                }
                catch (IOException e) {
                    Message msg = new Message("D0045E.CREATE_INSTANCE_FAILED");
                    configLogger.severe(msg.getFormattedText(this.locale));
                    System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(22);
                }
            } else {
                Message msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(Params.installPath.toString() + " or " + Params.instancePath.toString());
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(13);
            }
        }
    }

    private void printToken(String keyFileName, String authFileName) {
        String apiPass = AuthUtils.getCurrentAuth(keyFileName, authFileName);
        String key = AuthUtils.getKey(keyFileName);
        Message msg = new Message("D0024I.GEN_AUTHTOKEN");
        System.out.println(msg.getFormattedText(this.locale));
        System.out.println(apiPass);
        msg = new Message("D0025I.GEN_ENCKEY");
        System.out.println(msg.getFormattedText(this.locale));
        System.out.println(key);
    }

    public String getHostName() {
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
            return jettyConfig.getHostName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int getAdminHTTPPort() {
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
            return jettyConfig.getAdminHttpPort();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getSearchHTTPPort() {
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
            return jettyConfig.getSearchHttpPort();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getSearchHTTPSPort() {
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
            return jettyConfig.getSearchHttpsPort();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getAdminHTTPSPort() {
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
            return jettyConfig.getAdminHttpsPort();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private void printPort() {
        int port = this.getAdminHTTPPort();
        if (port > 0) {
            System.out.println(port);
        } else {
            Message msg = new Message("D0039W.INVALID_PORT_NO");
            msg.addArgument(port);
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(18);
        }
    }

    private static String[] getJettyFilesForPorts_2(int adminHttp, int searchHttp) {
        String[] retFiles = null;
        if (adminHttp == searchHttp) {
            retFiles = new String[]{"jetty.xml"};
            return retFiles;
        }
        retFiles = new String[]{"jetty_admin.xml", "jetty_search.xml"};
        return retFiles;
    }

    private static String[] getJettyFilesForPorts(int adminHttp, int adminHttps, int searchHttp, int searchHttps) {
        String[] retFiles = null;
        if (adminHttp == searchHttps || adminHttp == adminHttps || searchHttp == searchHttps || searchHttp == adminHttps) {
            return null;
        }
        if (0 == searchHttps && 0 == adminHttps) {
            if (adminHttp == searchHttp) {
                retFiles = new String[]{"jetty.xml"};
                return retFiles;
            }
            retFiles = new String[]{"jetty_admin.xml", "jetty_search.xml"};
            return retFiles;
        }
        if (0 == searchHttp && 0 == adminHttp) {
            if (adminHttp == searchHttp) {
                retFiles = new String[]{"jetty.ssl.xml"};
                return retFiles;
            }
            retFiles = new String[]{"jetty_admin.ssl.xml", "jetty_search.ssl.xml"};
            return retFiles;
        }
        if (0 != searchHttp && 0 != adminHttp && 0 != searchHttps && 0 != adminHttps) {
            if (adminHttps == searchHttps && adminHttp == searchHttp) {
                retFiles = new String[]{"jetty.both.xml"};
                return retFiles;
            }
            if (adminHttps != searchHttps && adminHttp != searchHttp) {
                retFiles = new String[]{"jetty_admin.both.xml", "jetty_search.both.xml"};
                return retFiles;
            }
        }
        return retFiles;
    }

    private String generateKeyStore(String hostname) {
        String keyFile = this.configPath + File.separator + KeyFileName;
        try {
            Encryption.loadDefaultKey(keyFile);
        }
        catch (Exception e2) {
            Message msg = new Message("G0107E.ENCRYPTION_KEY_LOAD_FAILED", keyFile);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e2);
            configLogger.severe(ee.getFormattedText(this.locale, true));
            System.exit(10);
        }
        File keystoreFile = new File(this.configPath, KeyStoreFileName);
        String httpsKeyPassword = null;
        try {
            boolean generated;
            String httpsKeystorePassword = httpsKeyPassword = Encryption.readKeyAsStringFromFile(keyFile);
            if (keystoreFile.isFile()) {
                keystoreFile.delete();
            }
            if (!(generated = KeystoreManager.generateKeystoreFile(keystoreFile, hostname, httpsKeyPassword, httpsKeystorePassword))) {
                Message msg = new Message("G0013E.KEYSTORE_GENERATION_FAILED", keyFile);
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(3);
            }
        }
        catch (IOException e) {
            Message msg = new Message("G0013E.KEYSTORE_GENERATION_FAILED", keyFile);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            configLogger.severe(ee.getFormattedText(this.locale, true));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(3);
        }
        return httpsKeyPassword;
    }

    private void backupExisting() {
        File backupJetty = new File(this.configPath, JettyFiles[0] + ".bk");
        File backupJettySearch = new File(this.configPath, JettyFiles[1] + ".bk");
        if (backupJettySearch.isFile()) {
            backupJettySearch.delete();
        }
        if (backupJetty.isFile()) {
            backupJetty.delete();
        }
        File originalJetty = new File(this.configPath, JettyFiles[0]);
        File originalJettySearch = new File(this.configPath, JettyFiles[1]);
        if (originalJetty.isFile()) {
            originalJetty.renameTo(backupJetty);
        }
        if (originalJettySearch.isFile()) {
            originalJettySearch.renameTo(backupJettySearch);
        }
    }

    private void restoreBackup() {
        File backupJetty = new File(this.configPath, JettyFiles[0] + ".bk");
        File backupJettySearch = new File(this.configPath, JettyFiles[1] + ".bk");
        File jetty = new File(this.configPath, JettyFiles[0]);
        File jettySearch = new File(this.configPath, JettyFiles[1]);
        if (backupJetty.isFile()) {
            backupJetty.renameTo(jetty);
        }
        if (backupJettySearch.isFile()) {
            backupJettySearch.renameTo(jettySearch);
        }
    }

    private void removeBackedUp() {
        File backupJetty = new File(this.configPath, JettyFiles[0] + ".bk");
        File backupJettySearch = new File(this.configPath, JettyFiles[1] + ".bk");
        if (backupJettySearch.isFile()) {
            backupJettySearch.delete();
        }
        if (backupJetty.isFile()) {
            backupJetty.delete();
        }
    }

    private void CopyJettyXMLFilesIntoConfig(String[] jettyBaseNames) {
        this.backupExisting();
        int i = 0;
        for (String jettyBaseName : jettyBaseNames) {
            String jettyTargetFileName = JettyFiles[i];
            String templateFilePath = GlobalConfiguration.getConfiguration().getConfigFileName("defaults" + File.separator + "jetty_templates", jettyBaseName);
            File templateFile = new File(templateFilePath);
            File jettyXmlFile = new File(this.configPath, jettyTargetFileName);
            if (jettyXmlFile.isFile()) {
                jettyXmlFile.delete();
            }
            try {
                FileUtils.copyFile(templateFile, jettyXmlFile);
            }
            catch (ExtendedException e) {
                this.restoreBackup();
                Message msg = new Message("G0033E.FILE_COPY_ERROR", templateFile, jettyXmlFile);
                ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                configLogger.severe(ee.getFormattedText(this.locale, false));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(23);
            }
            ++i;
        }
        this.removeBackedUp();
    }

    private void updatePort(File file, int httpPort) {
        if (!file.isFile()) {
            if (file.getName().equals(JettyFiles[0])) {
                Message msg = new Message("G0042E.CONFIG_DIRECTORY_MISSING_FILES");
                msg.addArgument(file.getPath());
                msg.addArgument(file.getName());
                configLogger.warning(msg.getFormattedText(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(8);
            }
            return;
        }
        File replacedFile = new File(file.getAbsolutePath() + ".replaced.xml");
        String elementToOverwrite = null;
        try {
            Document doc = XMLDOMUtils.readAsNonValidatingDOM(file);
            if (httpPort != 0) {
                elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=Port";
                this.overwrite(doc, elementToOverwrite, String.valueOf(httpPort));
            }
            XMLDOMUtils.writeDOM(doc, replacedFile);
            file.delete();
            replacedFile.renameTo(file);
        }
        catch (Exception e) {
            Message msg = new Message("D0033E.CONFIG_FILE_RENAME_FAILED");
            msg.addArgument(file.getAbsolutePath());
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(2);
        }
    }

    private void overwrite(Document doc, String elementToOverwrite, String elementTextContentValue) {
        if (null == elementTextContentValue) {
            return;
        }
        Element matchedElement = XMLDOMUtils.getElement(elementToOverwrite, doc);
        if (null != matchedElement) {
            matchedElement.setTextContent(elementTextContentValue);
        }
    }

    private void overwrite(Document doc, Vector<ElementToOverwrite> elem) {
        Iterator<ElementToOverwrite> iter = elem.iterator();
        ElementToOverwrite element = null;
        Element matchedElement = null;
        while (iter.hasNext()) {
            element = iter.next();
            if (element.key == null || null == (matchedElement = XMLDOMUtils.getElement(element.key, doc))) continue;
            matchedElement.setTextContent(element.value);
        }
    }

    private boolean generateAuthenticationToken() {
        String seed = null;
        if (this.cmdArgs.doesParamExist(Params.seed.toString())) {
            seed = this.cmdArgs.getParam(Params.seed.toString());
        } else {
            Message msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
            msg.addArgument(Params.seed.toString());
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(13);
        }
        String authFileName = this.configPath + File.separator + AuthenticationFileName;
        try {
            String keyFileName = this.configPath + File.separator + KeyFileName;
            AuthUtils.generateKeyFile(seed, keyFileName);
            AuthUtils.generateAuth(seed, keyFileName, authFileName);
            return true;
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
            msg.addArgument(e.getLocalizedMessage());
            configLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
    }

    private boolean isServerUp() {
        String hostName = this.getHostName();
        int port = this.getAdminHTTPPort();
        try {
            return ServerStatus.isServerRunning("pbIhUEI=", hostName, port, this.useInyoServer);
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
            msg.addArgument(e.getLocalizedMessage());
            configLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
    }

    private void configureHTTPListener() throws NumberFormatException {
        Message msg;
        Integer adminHttpPort = null;
        Integer searchHttpPort = null;
        if (this.cmdArgs.doesParamExist(Params.adminHTTPPort.toString())) {
            adminHttpPort = new Integer(this.cmdArgs.getParam(Params.adminHTTPPort.toString()));
            if (adminHttpPort < 0) {
                msg = new Message("D0039W.INVALID_PORT_NO");
                msg.addArgument(adminHttpPort);
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(18);
            }
            if (this.isPortInUse(adminHttpPort)) {
                msg = new Message("D0034E.PORT_IN_USE");
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(16);
            }
        } else {
            msg = new Message("G0008E.MISSING_ARGUMENT", Params.adminHTTPPort.toString());
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(1);
        }
        if (this.cmdArgs.doesParamExist(Params.searchHTTPPort.toString())) {
            searchHttpPort = new Integer(this.cmdArgs.getParam(Params.searchHTTPPort.toString()));
            if (searchHttpPort < 0) {
                msg = new Message("D0039W.INVALID_PORT_NO");
                msg.addArgument(searchHttpPort);
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(18);
            }
            if (this.isPortInUse(searchHttpPort)) {
                msg = new Message("D0034E.PORT_IN_USE");
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(16);
            }
        } else {
            searchHttpPort = adminHttpPort;
        }
        String[] jettyFiles = ConfigurationTool.getJettyFilesForPorts_2(adminHttpPort, searchHttpPort);
        this.CopyJettyXMLFilesIntoConfig(jettyFiles);
        this.updatePort(new File(this.configPath, JettyFiles[0]), adminHttpPort);
        if (searchHttpPort.intValue() != adminHttpPort.intValue()) {
            this.updatePort(new File(this.configPath, JettyFiles[1]), searchHttpPort);
        }
    }

    public int getMaxDocumentSize() {
        String parserConfigFileName = GlobalConfiguration.getConfiguration().getConfigFileName("defaults", "parser_config.xml");
        try {
            FileInputStream fis = new FileInputStream(parserConfigFileName);
            int numBytes = fis.available();
            byte[] bytes = new byte[numBytes];
            fis.read(bytes);
            fis.close();
            String content = new String(bytes);
            Pattern p = Pattern.compile("maxTextUnicodeChars\">\\d+");
            Matcher m = p.matcher(content);
            if (m.find()) {
                return new Integer(m.group().substring(21));
            }
            Message msg = new Message("D0041W.MAX_DOCUMENT_SIZE_PARAM_NOT_EXIST");
            msg.addArgument(parserConfigFileName);
            configLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return -1;
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
            msg.addArgument(e.getMessage());
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            return -1;
        }
    }

    private boolean isPortInUse(int port) {
        try {
            socket = new ServerSocket(port);
            socket.close();
            socket = null;
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private static Message isValidDirectoryName(String name) {
        StringTokenizer st = new StringTokenizer(name, File.separator);
        Message errorMsg = null;
        boolean first = true;
        while (st.hasMoreTokens()) {
            if (first && GlobalConfiguration.getConfiguration().isWindows()) {
                first = false;
                if (st.nextToken().contains(":")) continue;
                errorMsg = new Message("G0104E.BAD_DIRECTORY_NAME", name);
                return errorMsg;
            }
            errorMsg = FileUtils.isValidDirectoryName(st.nextToken(), false);
            if (errorMsg == null) continue;
            return errorMsg;
        }
        return errorMsg;
    }

    private void configureParams() throws NumberFormatException {
        Message msg;
        if (this.cmdArgs.doesParamExist(Params.logLevel.toString())) {
            this.setLogLevel();
        }
        if (this.cmdArgs.doesParamExist(Params.adminHTTPPort.toString())) {
            Integer adminHttpPort = new Integer(this.cmdArgs.getParam(Params.adminHTTPPort.toString()));
            if (adminHttpPort < 0) {
                msg = new Message("D0039W.INVALID_PORT_NO");
                msg.addArgument(adminHttpPort);
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(18);
            }
            if (this.isPortInUse(adminHttpPort)) {
                msg = new Message("D0034E.PORT_IN_USE");
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(16);
            }
            this.updatePort(new File(this.configPath, JettyFiles[0]), adminHttpPort);
        }
        if (this.cmdArgs.doesParamExist(Params.searchHTTPPort.toString())) {
            Integer searchHttpPort = new Integer(this.cmdArgs.getParam(Params.searchHTTPPort.toString()));
            if (searchHttpPort < 0) {
                msg = new Message("D0039W.INVALID_PORT_NO");
                msg.addArgument(searchHttpPort);
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(18);
            }
            if (this.isPortInUse(searchHttpPort)) {
                msg = new Message("D0034E.PORT_IN_USE");
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(16);
            }
            this.updatePort(new File(this.configPath, JettyFiles[1]), searchHttpPort);
        }
        String elementToOverwrite = null;
        String value = null;
        this.elements.clear();
        try {
            Message errorMsg;
            if (this.cmdArgs.doesParamExist(Params.configPath.toString())) {
                value = this.cmdArgs.getParam(Params.configPath.toString());
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((errorMsg = ConfigurationTool.isValidDirectoryName(value)) != null) {
                    configLogger.warning(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(9);
                }
                elementToOverwrite = "/config/configPath";
                this.elements.add(new ElementToOverwrite(elementToOverwrite, value));
            }
            if (this.cmdArgs.doesParamExist(Params.logPath.toString())) {
                value = this.cmdArgs.getParam(Params.logPath.toString());
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((errorMsg = ConfigurationTool.isValidDirectoryName(value)) != null) {
                    configLogger.warning(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(9);
                }
                elementToOverwrite = "/config/logPath";
                this.elements.add(new ElementToOverwrite(elementToOverwrite, value));
            }
            if (this.cmdArgs.doesParamExist(Params.defaultDataPath.toString())) {
                value = this.cmdArgs.getParam(Params.defaultDataPath.toString());
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((errorMsg = ConfigurationTool.isValidDirectoryName(value)) != null) {
                    configLogger.warning(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(9);
                }
                elementToOverwrite = "/config/defaultDataDirectory";
                this.elements.add(new ElementToOverwrite(elementToOverwrite, value));
            }
            if (this.cmdArgs.doesParamExist(Params.tempDirPath.toString())) {
                value = this.cmdArgs.getParam(Params.tempDirPath.toString());
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((errorMsg = ConfigurationTool.isValidDirectoryName(value)) != null) {
                    configLogger.warning(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(9);
                }
                elementToOverwrite = "/config/tempDirectory";
                this.elements.add(new ElementToOverwrite(elementToOverwrite, value));
            }
            if (this.cmdArgs.doesParamExist(Params.installPath.toString())) {
                value = this.cmdArgs.getParam(Params.installPath.toString());
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((errorMsg = ConfigurationTool.isValidDirectoryName(value)) != null) {
                    configLogger.warning(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(errorMsg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(9);
                }
                elementToOverwrite = "/config/installPath";
                this.elements.add(new ElementToOverwrite(elementToOverwrite, value));
            }
            if (this.elements.size() > 0) {
                FileInputStream fileInputStream = new FileInputStream(this.configFile);
                Document doc = XMLDOMUtils.readAsNonValidatingDOM(fileInputStream);
                fileInputStream.close();
                this.overwrite(doc, this.elements);
                File replacedFile = new File(this.configFile.getAbsolutePath() + ".replaced.xml");
                XMLDOMUtils.writeDOM(doc, replacedFile);
                this.configFile.delete();
                boolean renamed = replacedFile.renameTo(this.configFile);
                if (!renamed) {
                    Message msg2 = new Message("D0033E.CONFIG_FILE_RENAME_FAILED");
                    msg2.addArgument(this.configFile.getAbsolutePath());
                    configLogger.severe(msg2.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(msg2.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(15);
                }
            }
        }
        catch (Exception e) {
            Message msg3 = new Message("D0033E.CONFIG_FILE_RENAME_FAILED");
            msg3.addArgument(this.configFile.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg3, (Throwable)e);
            configLogger.severe(ee.getFormattedText(this.locale, false));
            System.exit(15);
        }
    }

    public String getMaxHeapSize() {
        String binPath = GlobalConfiguration.getConfiguration().getBinPath();
        File startupFile = new File(binPath, StartupFileName);
        try {
            FileInputStream fis = new FileInputStream(startupFile);
            int numBytes = fis.available();
            byte[] bytes = new byte[numBytes];
            fis.read(bytes);
            fis.close();
            String content = new String(bytes);
            Pattern p = Pattern.compile("-Xmx\\d+[\\.]?[\\d*]?[MG]");
            Matcher m = p.matcher(content);
            if (m.find()) {
                return m.group().substring(4);
            }
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
            msg.addArgument(e.getMessage());
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
        }
        return null;
    }

    private void setMaxHeapSize() {
        String binPath = GlobalConfiguration.getConfiguration().getBinPath();
        File startupFile = new File(binPath, StartupFileName);
        String heapSize = this.cmdArgs.getParam(Params.maxHeapSize.toString());
        if (!((heapSize = heapSize.trim()).endsWith("G") || heapSize.endsWith("M") || heapSize.endsWith("g") || heapSize.endsWith("m"))) {
            Message msg = new Message("D0037E.HEAP_SIZE_NOT_VALID_JVM_PARAMETER");
            msg.addArgument(heapSize);
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(24);
        }
        try {
            FileInputStream fis = new FileInputStream(startupFile);
            int numBytes = fis.available();
            byte[] bytes = new byte[numBytes];
            fis.read(bytes);
            fis.close();
            String content = new String(bytes);
            String replaced = content.replaceAll("-Xmx\\d+[\\.]?[\\d*]?[MG]", "-Xmx" + heapSize);
            File replacedStartup = new File(startupFile.getAbsolutePath() + ".replaced");
            FileOutputStream fos = new FileOutputStream(replacedStartup);
            fos.write(replaced.getBytes());
            fos.close();
            startupFile.delete();
            boolean renamed = replacedStartup.renameTo(startupFile);
            if (!renamed) {
                Message msg = new Message("D0033E.CONFIG_FILE_RENAME_FAILED");
                msg.addArgument(startupFile.getAbsolutePath());
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(15);
            }
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
            msg.addArgument(e.getMessage());
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(19);
        }
    }

    public String getLogLevel() {
        SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
        SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.SystemSettings);
        return systemSettings.getLoggerLevel(LoggerName).getName();
    }

    private void setLogLevel() {
        String newLogLevel = this.cmdArgs.getParam(Params.logLevel.toString());
        if (newLogLevel.equals("FINE") || newLogLevel.equals("FINER") || newLogLevel.equals("FINEST") || newLogLevel.equals("INFO") || newLogLevel.equals("OFF") || newLogLevel.equals("SEVERE") || newLogLevel.equals("WARNING")) {
            SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
            SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.SystemSettings);
            systemSettings.setLoggerLevel(LoggerName, Level.parse(newLogLevel));
            try {
                settingsConfigMgr.updateStateObject(SettingsConfigurationManager.SettingsType.SystemSettings, systemSettings);
            }
            catch (ConfigurationManagerException e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
                msg.addArgument(e.getFormattedText(this.locale));
                configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(19);
            }
        } else {
            Message msg = new Message("D0057E.INVALID_LOG_LEVEL_PARAMETER_VALUE");
            msg.addArgument(newLogLevel);
            configLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
        }
    }

    public String getConfigPath() {
        return GlobalConfiguration.getConfiguration().getConfigPath();
    }

    public String getDefaultDataDirectory() {
        return GlobalConfiguration.getConfiguration().getDefaultDataDirectory();
    }

    public String getInstallPath() {
        return GlobalConfiguration.getConfiguration().getInstallPath();
    }

    public String getLogPath() {
        return GlobalConfiguration.getConfiguration().getLogPath();
    }

    public int getNumberOfIndexers() {
        return GlobalConfiguration.getConfiguration().getNumberOfIndexers();
    }

    public int getNumberOfTokenizers() {
        return GlobalConfiguration.getConfiguration().getNumberOfTokenizers();
    }

    private boolean isValidNumeric(String val, boolean isPostive) {
        try {
            long longVal = Long.parseLong(val);
            if (isPostive) {
                return longVal > 0L;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getTempDirectory() {
        return GlobalConfiguration.getConfiguration().getTempDirectory();
    }

    private void printAll() {
        System.out.println("adminHTTPPort " + this.getAdminHTTPPort() + "\n");
        System.out.println("searchHTTPPort " + this.getSearchHTTPPort() + "\n");
        System.out.println("token ");
        String keyFileName = this.configPath + File.separator + KeyFileName;
        String authFileName = this.configPath + File.separator + AuthenticationFileName;
        File keyFile = new File(keyFileName);
        File authFile = new File(authFileName);
        if (keyFile.exists() && authFile.exists()) {
            this.printToken(keyFileName, authFileName);
        }
        System.out.println();
        System.out.println("configPath " + this.getConfigPath() + "\n");
        System.out.println("defaultDataPath " + this.getDefaultDataDirectory() + "\n");
        System.out.println("installPath " + this.getInstallPath() + "\n");
        System.out.println("logPath " + this.getLogPath() + "\n");
        System.out.println("tempDirPath " + this.getTempDirectory() + "\n");
        System.out.println("logLevel " + this.getLogLevel() + "\n");
    }

    private void printUsageWithMessage(PrintStream printStream, Message msg) {
        if (msg != null) {
            printStream.println(msg.getFormattedTextWithDisplayKey(this.locale));
        }
        Message mesg = new Message("G0174I.CONFIG_TOOL_USAGE");
        System.err.println();
        if (null == mesg.getText(this.locale)) {
            System.err.println(USAGE);
        } else {
            System.err.println(mesg.getFormattedText(this.locale));
        }
    }

    private void printUsage(PrintStream printStream) {
        this.printUsageWithMessage(printStream, null);
    }

    public static void main(String[] args) {
        ConfigurationTool configTool = new ConfigurationTool(args);
        configTool.configure();
    }

    private static class ElementToOverwrite {
        String key;
        String value;

        public ElementToOverwrite(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Params {
        configPath,
        debug,
        adminHTTPPort,
        adminHTTPSPort,
        searchHTTPPort,
        searchHTTPSPort,
        hostName,
        logPath,
        defaultDataPath,
        installPath,
        instancePath,
        numberOfIndexers,
        numberOfTokenizers,
        logLevel,
        maxDocumentSize,
        maxHeapSize,
        locale,
        seed,
        tempDirPath;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        configureHTTPListener,
        createInstance,
        configureParams,
        printToken,
        printAll,
        printAdminHTTPPort,
        generateToken,
        help;

    }
}

