/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.tool;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.configuration.tool.ConfigurationTool;
import com.ibm.es.nuvo.configuration.tool.ServerStatus;
import com.ibm.es.nuvo.inyo.client.api.Collection;
import com.ibm.es.nuvo.inyo.client.api.CollectionNotFoundException;
import com.ibm.es.nuvo.inyo.client.api.InyoSystem;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.logging.DynamicFileHandlerException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.LoggerWrapper;
import com.ibm.es.nuvo.util.BuildProperties;
import com.ibm.es.nuvo.util.CommandLineArguments;
import com.ibm.es.nuvo.util.Encryption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;

public class AdministrationTool {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String ConfigFileName = "config.xml";
    private static final String CollectionStatusCmd = "status";
    private static final String DeleteCmd = "delete";
    private static final String VersionArg = "version";
    private static final String HelpCmd = "help";
    private static final String ConfigureTraceCmd = "configureTrace";
    private static final String PrintTraceCmd = "printTrace";
    private static final String CollectionName = "collectionName";
    private static final String GetStackTraceCmd = "getStackTrace";
    private static final String ConfigPath = "configPath";
    private static final String LocaleArg = "locale";
    private static final String TraceArg = "trace";
    private static final String ADMIN_TOOL_LOGGER = "AdminToolLogger";
    private static final String AdminLoggerPrefix = "AdminTool";
    private static final String AuthenticationFileName = "authentication.xml";
    private static final String KeyFileName = "key.txt";
    private static final String USAGE = " Usage: \n adminTool admin_command -configPath value [-locale value] [-collectionName value] [-trace value]\n\n Where:\n admin_command:\n     delete:         Delete the specified collection\n     status:         Print status of all collections\n     version:        Print the version number of the search server\n     configureTrace: Turns on or off the search server trace\n     printTrace:     Print the current search server trace setting\n     help:           Print this help message\n\n -configPath value\n     The fully qualified path to the configuration directory such as /opt/ibm/search/config\n -locale value\n     The 5-character locale code, such as en_US, de_DE, or zh_TW. If omitted, the server locale is used (optional).\n -collectionName value\n     The name of collection that you want to delete or obtain status information about.\n -trace value\n     The supported trace value is either on or off\n\n Example to delete the Default collection:\n adminTool delete -configPath /opt/ibm/search/config -collectionName Default\n\n Example to print the status of all collections:\n adminTool status -configPath /opt/ibm/search/config\n\n Example to turn on the trace for the search server:\n adminTool configureTrace -configPath /opt/ibm/search/config -trace on";
    private CommandLineArguments cmdArgs = null;
    private File configFile;
    private String mode;
    private String configPath;
    private ConfigurationManager cfgMgr;
    private JettyConfiguration jettyConfig = null;
    public static final ExtendedLogger adminLogger = ExtendedLogger.getLogger("AdminToolLogger");
    private LoggerWrapper wrappedAdminLogger;
    private boolean useInyoServer = true;
    private String collectionPath = null;
    private Locale locale = Locale.getDefault();

    public AdministrationTool(String[] args) {
        this.processRequest(args);
    }

    public AdministrationTool() {
    }

    public boolean processRequest(String[] args) {
        Message msg;
        String localeString;
        String[] arguments;
        if (args.length == 0) {
            this.printUsage();
            System.exit(0);
        }
        this.mode = args[0];
        if (this.mode.equalsIgnoreCase(HelpCmd) || this.mode.equalsIgnoreCase("-help") || this.mode.equalsIgnoreCase("--help") || this.mode.equals("-h") || this.mode.equals("?")) {
            if (args.length >= 3) {
                arguments = new String[args.length - 1];
                System.arraycopy(args, 1, arguments, 0, args.length - 1);
                this.cmdArgs = new CommandLineArguments(arguments);
                if (this.cmdArgs.doesParamExist(LocaleArg)) {
                    localeString = this.cmdArgs.getParam(LocaleArg);
                    this.locale = ConfigurationTool.getLocale(localeString);
                }
            }
            this.printUsage();
            System.exit(0);
        }
        arguments = new String[args.length - 1];
        System.arraycopy(args, 1, arguments, 0, args.length - 1);
        this.cmdArgs = new CommandLineArguments(arguments);
        if (this.cmdArgs.doesParamExist(LocaleArg)) {
            localeString = this.cmdArgs.getParam(LocaleArg);
            this.locale = AdministrationTool.getLocale(localeString);
        }
        if (this.cmdArgs.doesParamExist(ConfigPath)) {
            this.configPath = this.cmdArgs.getParam(ConfigPath);
            this.configFile = new File(this.configPath + File.separator + ConfigFileName);
        } else {
            msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
            msg.addArgument(ConfigPath);
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(9);
        }
        this.init();
        if (!this.isServerUp() && !this.mode.equals(VersionArg)) {
            msg = new Message("D0055E.SERVER_SHUTDOWN_REQUIRE_RUNNING");
            adminLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(11);
        }
        if (this.mode.equals(DeleteCmd)) {
            if (!this.cmdArgs.doesParamExist(CollectionName)) {
                msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(CollectionName);
                adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(3);
            }
            return this.deleteCollection(this.getToken());
        }
        if (this.mode.equals(VersionArg)) {
            return this.reportVersion();
        }
        if (this.mode.equals(CollectionStatusCmd)) {
            return this.collectionStatus(this.getToken());
        }
        if (this.mode.equals(ConfigureTraceCmd)) {
            if (!this.cmdArgs.doesParamExist(TraceArg)) {
                msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(TraceArg);
                adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(3);
            }
            return this.configureTrace();
        }
        if (this.mode.equals(PrintTraceCmd)) {
            return this.printTrace();
        }
        if (this.mode.equals(GetStackTraceCmd)) {
            this.handleStackTraceRequest(this.getToken());
            return true;
        }
        msg = new Message("D0029E.COMMAND_ARG_MISSING");
        adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
        System.exit(3);
        return false;
    }

    private String getToken() {
        try {
            Message msg;
            String keyFileName = this.configPath + File.separator + KeyFileName;
            String authFileName = this.configPath + File.separator + AuthenticationFileName;
            File keyFile = new File(keyFileName);
            File authFile = new File(authFileName);
            if (!authFile.exists()) {
                msg = new Message("D0061E.AUTHENTICATION_FILE_NOT_EXIST");
                msg.addArgument(authFile.getAbsolutePath());
                adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(4);
            }
            if (!keyFile.exists()) {
                msg = new Message("D0060E.KEY_FILE_NOT_EXIST");
                msg.addArgument(keyFile.getAbsolutePath());
                adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(5);
            }
            Encryption.loadDefaultKey(keyFileName);
            AuthenticationData authData = new AuthenticationData();
            authData.loadFrom(new FileInputStream(new File(authFileName)));
            return authData.getApiPassword();
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION", e);
            adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(14);
            return null;
        }
    }

    public static Locale getLocale(String localeString) {
        if (localeString.length() != 5) {
            Message msg = new Message("G0177E.INVALID_LOCALE_STRING");
            msg.addArgument(localeString);
            System.err.println(msg.getFormattedTextWithDisplayKey());
            System.exit(15);
        }
        String lang = localeString.substring(0, 2);
        String country = localeString.substring(3, 5);
        return new Locale(lang, country);
    }

    private boolean isServerUp() {
        String hostName = this.getHostName();
        int port = this.getAdminHTTPPort();
        try {
            return ServerStatus.isServerRunning(this.getToken(), hostName, port, this.useInyoServer);
        }
        catch (Exception e) {
            Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
            msg.addArgument(e.getLocalizedMessage());
            adminLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(5);
            return false;
        }
    }

    private int getAdminHTTPPort() {
        return this.jettyConfig.getAdminHttpPort();
    }

    private String getHostName() {
        return this.jettyConfig.getHostName();
    }

    private boolean printTrace() {
        if (this.useInyoServer) {
            Collection collection = new Collection(this.getHostName(), this.getAdminHTTPPort(), this.getToken());
            try {
                if (collection.printTrace()) {
                    System.out.println(new Message("R0038I.TRACE_ON").getText(this.locale));
                } else {
                    System.out.println(new Message("R0039I.TRACE_OFF").getText(this.locale));
                }
            }
            catch (InyoException e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
                msg.addArgument(e.getLocalizedMessage());
                adminLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            }
            return true;
        }
        return false;
    }

    private boolean configureTrace() {
        if (this.useInyoServer) {
            Message msg;
            boolean on = false;
            if (this.cmdArgs.doesParamExist(TraceArg)) {
                if (!this.cmdArgs.getParam(TraceArg).equalsIgnoreCase("on") && !this.cmdArgs.getParam(TraceArg).equalsIgnoreCase("off")) {
                    msg = new Message("G0007E.INVALID_ARGUMENT");
                    msg.addArgument(this.cmdArgs.getParam(TraceArg));
                    adminLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
                    System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                    System.exit(9);
                }
                on = this.cmdArgs.getParam(TraceArg).equalsIgnoreCase("on");
            } else {
                msg = new Message("D0030E.COMMAND_SPECIFIC_ARG_MISSING");
                msg.addArgument(TraceArg);
                adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                System.exit(9);
            }
            Collection collection = new Collection(this.getHostName(), this.getAdminHTTPPort(), this.getToken());
            try {
                collection.configureTrace(on);
                if (on) {
                    Message msg2 = new Message("R0036I.TRACE_TURNED_ON");
                    msg2.addArgument(GlobalConfiguration.getConfiguration().getLogPath());
                    System.out.println(msg2.getFormattedText(this.locale));
                } else {
                    System.out.println(new Message("R0037I.TRACE_TURNED_OFF").getText(this.locale));
                }
            }
            catch (InyoException e) {
                Message msg3 = new Message("D0047E.RUNTIME_EXCEPTION");
                msg3.addArgument(e.getLocalizedMessage());
                adminLogger.warning(msg3.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg3.getFormattedTextWithDisplayKey(this.locale));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStackTraceRequest(String token) {
        InyoSystem sys = new InyoSystem(this.getHostName(), this.getAdminHTTPPort(), token);
        OutputStreamWriter fout = null;
        try {
            System.out.println("Printing Server Stack Trace to stacks.xml in current working directory... ");
            fout = new FileWriter("stacks.xml");
            String s = sys.getServerStack();
            fout.write(s, 0, s.length());
            System.out.println("Done");
        }
        catch (InyoException ex) {
            ex.printStackTrace();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            try {
                fout.close();
            }
            catch (Exception ex) {}
        }
    }

    private boolean collectionStatus(String token) {
        if (this.useInyoServer) {
            Collection collection = new Collection(this.getHostName(), this.getAdminHTTPPort(), token);
            try {
                System.out.println(collection.status());
            }
            catch (InyoException e) {
                Message msg = new Message("D0047E.RUNTIME_EXCEPTION");
                msg.addArgument(e.getLocalizedMessage());
                adminLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            }
            return true;
        }
        if (this.cfgMgr != null) {
            Vector<String> collIds = this.cfgMgr.getCollectionIds();
            Iterator<String> iter = collIds.iterator();
            String collectionId = null;
            File collection = null;
            if (collIds.size() > 0) {
                System.out.println("CollectionId\tNumDocs\t\tIndexState");
            }
            while (iter.hasNext()) {
                collectionId = iter.next();
                collection = new File(this.collectionPath + File.separator + collectionId + File.separator + "data" + File.separator + "text");
                try {
                    System.out.println(collectionId + "\t\t" + IndexReader.open((File)collection).numDocs() + "\t\t" + IndexReader.indexExists((File)collection));
                }
                catch (CorruptIndexException e) {
                    System.out.println(collectionId + "\t\t" + 0 + "\t\t" + "CorruptedIndex");
                }
                catch (IOException e) {
                    System.out.println(collectionId + "\t\t" + 0 + "\t\t" + "false");
                }
            }
            return true;
        }
        Message msg = new Message("D0027E.UNSUPORTED_ACTION");
        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
        System.exit(2);
        return false;
    }

    private boolean reportVersion() {
        try {
            System.out.println(BuildProperties.loadProperties().getProperty("build.version"));
        }
        catch (IOException e) {
            System.out.println("?");
        }
        return true;
    }

    private boolean deleteCollection(String token) {
        String collectionId = this.cmdArgs.getParam(CollectionName);
        File colFile = new File(this.collectionPath + File.separator + collectionId);
        if (!colFile.isDirectory()) {
            Message msg = new Message("D0006E.NONEXISTANT_COLLECTION");
            msg.addArgument(collectionId);
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            return false;
        }
        if (this.useInyoServer) {
            Collection collection = new Collection(this.getHostName(), this.getAdminHTTPPort(), token);
            try {
                collection.delete(collectionId);
                Message msg = new Message("R0036E.DELETE_COLLECTION_SUCCESS");
                msg.addArgument(collectionId);
                adminLogger.info(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return true;
            }
            catch (CollectionNotFoundException e) {
                Message msg = new Message("D0006E.NONEXISTANT_COLLECTION");
                msg.addArgument(collectionId);
                adminLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
            catch (InyoException e) {
                Message msg = new Message("R0008E.DELETE_COLLECTION_ERROR");
                adminLogger.warning(msg.getFormattedTextWithDisplayKey(this.locale));
                System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
                return false;
            }
        }
        Message msg = new Message("D0027E.UNSUPORTED_ACTION");
        System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
        System.exit(2);
        return false;
    }

    private void init() {
        Message msg;
        try {
            GlobalConfiguration.initialize(this.configFile.getAbsolutePath());
            GlobalConfiguration.getConfiguration().setConfigPath(this.configPath);
            this.collectionPath = GlobalConfiguration.getConfiguration().getCollectionPath();
            this.cfgMgr = ConfigurationManager.getConfigurationManager();
            this.jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
        }
        catch (Exception e) {
            msg = new Message("G0026E.CONFIG_FILE_ERROR");
            msg.addArgument(this.configFile.getAbsolutePath());
            adminLogger.severe(msg.getFormattedTextWithDisplayKey(this.locale));
            System.err.println(msg.getFormattedText(this.locale));
            System.exit(6);
        }
        try {
            ReleaseInfo.initialize(null);
            this.useInyoServer = ReleaseInfo.getReleaseInfo().getValueAsBoolean("System", "UseCustomServer", true);
        }
        catch (ExtendedException e) {
            File releaseFile = new File(this.configPath + File.separator + "releaseinfo", "release.properties");
            Message msg2 = new Message("G0042E.CONFIG_DIRECTORY_MISSING_FILES");
            msg2.addArgument(releaseFile.getAbsolutePath());
            msg2.addArgument(releaseFile.getName());
            System.err.println(msg2.getFormattedTextWithDisplayKey(this.locale));
            System.exit(7);
        }
        try {
            this.wrappedAdminLogger = new LoggerWrapper(adminLogger, GlobalConfiguration.getConfiguration() == null ? null : GlobalConfiguration.getConfiguration().getLogPath(), AdminLoggerPrefix);
            this.wrappedAdminLogger.initialize(0x800000, 1);
        }
        catch (DynamicFileHandlerException e) {
            msg = new Message("G0027W.LOGGER_INIT_ERROR");
            System.err.println(msg.getFormattedTextWithDisplayKey(this.locale));
            System.exit(8);
        }
    }

    private void printUsage() {
        Message msg = new Message("D0058I.ADMIN_TOOL_USAGE");
        System.out.println();
        if (null == msg.getText(this.locale)) {
            System.out.println(USAGE);
        } else {
            System.out.println(msg.getFormattedText(this.locale));
        }
        System.out.println();
    }

    public static void main(String[] args) {
        AdministrationTool adminTool = new AdministrationTool();
        if (args.length > 0 && args[0].equals("test")) {
            String statusRequest = "delete -collectionName Default -configPath  C:\\Projects\\whitneyr3\\package\\config\\";
            adminTool.processRequest(statusRequest.split("\\s+", 5));
        } else {
            adminTool.processRequest(args);
        }
    }
}

