/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.remote;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.remote.ConfigurationAccessException;
import com.ibm.es.nuvo.configuration.remote.RemoteConfigurationNotificationInterface;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.p2p.P2PDispatcher;
import com.ibm.es.nuvo.network.p2p.P2PServiceInterface;
import com.ibm.es.nuvo.util.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteConfigurationNotificationService {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String CollectionType = "collection";
    public static final int RC_Ok = 200;
    public static final int RC_Exception = 201;
    private static RemoteConfigurationNotificationService service = null;
    private static String ServiceName = "ConfigNotification";
    private RemoteConfigurationNotificationInterface notifier = null;
    private P2PServiceInterface msgReceiver = null;
    private long numNotificationRequestReceived = 0L;

    public static RemoteConfigurationNotificationService getInstance() {
        if (service == null) {
            service = new RemoteConfigurationNotificationService();
        }
        return service;
    }

    public static void notify(Node toNode, Constants.ConfigurationObjectType notificationComponent, String notification, String objectId, byte[] data) throws ConfigurationAccessException {
        int responseCode = 0;
        String context = notificationComponent.toString();
        if (notification != null && notification.length() > 0) {
            context = context + "/" + notification;
        }
        if (objectId != null && objectId.length() > 0) {
            context = context + "/" + objectId;
        }
        ByteArrayInputStream is = null;
        if (data != null) {
            is = new ByteArrayInputStream(data);
        }
        try {
            P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
            responseCode = p2pDispatcher.sendMsg(toNode, ServiceName, context, null, is, null);
        }
        catch (Exception e) {
            Message msg = new Message("G0???E.ERROR_SENDING_NOTIFICATION_TO_REMOTE_NODE", context, toNode.getName(), toNode.getHttpPort(), -1);
            ConfigurationAccessException ce = new ConfigurationAccessException(msg, (Throwable)e);
            throw ce;
        }
        if (responseCode != 200) {
            Message msg = new Message("G0???E.ERROR_SENDING_NOTIFICATION_TO_REMOTE_NODE", context, toNode.getName(), toNode.getHttpPort(), responseCode);
            ConfigurationAccessException ce = new ConfigurationAccessException(msg);
            throw ce;
        }
    }

    private RemoteConfigurationNotificationService() {
    }

    public void intialize() {
        P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
        this.msgReceiver = new MsgReciever();
        p2pDispatcher.addService(ServiceName, this.msgReceiver);
    }

    public long getNumNotificationRequestsReceived() {
        return this.numNotificationRequestReceived;
    }

    public RemoteConfigurationNotificationInterface getNotifier() {
        return this.notifier;
    }

    public void setNotifier(RemoteConfigurationNotificationInterface notifier) {
        this.notifier = notifier;
    }

    public void shutdown() {
        P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
        p2pDispatcher.removeService(ServiceName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MsgReciever
    implements P2PServiceInterface {
        @Override
        public int msgRecieved(Hashtable<String, String> params, Node sender, HttpServletRequest request, HttpServletResponse response) {
            RemoteConfigurationNotificationService.this.numNotificationRequestReceived++;
            Constants.ConfigurationObjectType configObjType = null;
            String notificationType = null;
            String objectId = null;
            byte[] requestData = null;
            int rc = 200;
            StringTokenizer st = new StringTokenizer(request.getPathInfo(), "/");
            if (st.hasMoreTokens()) {
                st.nextToken();
                if (st.hasMoreTokens()) {
                    configObjType = Constants.ConfigurationObjectType.getTypeFromString(st.nextToken());
                    if (st.hasMoreTokens()) {
                        notificationType = st.nextToken();
                        if (st.hasMoreTokens()) {
                            objectId = st.nextToken();
                        }
                    }
                }
            }
            requestData = this.getDataFromRequest(request);
            try {
                if (RemoteConfigurationNotificationService.this.notifier != null) {
                    RemoteConfigurationNotificationService.this.notifier.remoteConfigChange(configObjType, notificationType, objectId, requestData);
                }
            }
            catch (ExtendedException e) {
                rc = 201;
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, e);
                }
                e.printStackTrace();
            }
            catch (Exception e) {
                rc = 201;
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, new ExtendedException(e));
                }
                e.printStackTrace();
            }
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getDataFromRequest(HttpServletRequest request) {
            byte[] requestData = null;
            ServletInputStream is = null;
            try {
                is = request.getInputStream();
                if (is != null) {
                    int br;
                    byte[] buffer = new byte[2048];
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    while ((br = is.read(buffer)) >= 0) {
                        os.write(buffer, 0, br);
                    }
                    requestData = os.toByteArray();
                }
            }
            catch (IOException e) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            return requestData;
        }
    }
}

