/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.remote;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.remote.CombinedCollectionConfiguration;
import com.ibm.es.nuvo.configuration.remote.ConfigurationAccessException;
import com.ibm.es.nuvo.util.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationAccessRouter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getConfigurationObject(Constants.ConfigurationObjectType type, String objectId, Hashtable<String, String> params) throws ExtendedException, IOException {
        String xmlDoc = "";
        if (type.equals((Object)Constants.ConfigurationObjectType.Collection)) {
            if (objectId == null) throw new RuntimeException("objectId must be specified when objectType is " + type.toString());
            CombinedCollectionConfiguration combinedConfig = CombinedCollectionConfiguration.getCombinedInfoFor(objectId);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            combinedConfig.writeTo(bos);
            return new String(bos.toByteArray(), "UTF-8");
        }
        if (type.equals((Object)Constants.ConfigurationObjectType.EncryptionKey)) return xmlDoc;
        ConfigurationAccessException ae = new ConfigurationAccessException(new Message("R0026E.INVALID_OBJECT_TYPE", type.toString()));
        throw ae;
    }

    public static void refreshConfigurationObject(Constants.ConfigurationObjectType type, String objectId, boolean synchronous, Hashtable<String, String> params) throws ExtendedException, InterruptedException {
        if (type.equals((Object)Constants.ConfigurationObjectType.Collection)) {
            if (objectId == null) {
                throw new RuntimeException("objectId must be specified when objectType is " + type.toString());
            }
        } else {
            ConfigurationAccessException ae = new ConfigurationAccessException(new Message("R0026E.INVALID_OBJECT_TYPE", type.toString()));
            throw ae;
        }
        ConfigurationManager cMgr = ConfigurationManager.getConfigurationManager();
        cMgr.refreshCacheForCollection(objectId);
        cMgr.refreshCollectionUsers(objectId, synchronous, true);
    }
}

