/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.remote;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.util.CombinedXMLData;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Vector;

public class CombinedCollectionConfiguration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CombinedDataElement = "combined_collection_data";
    private static final String CollectionDataElement = "collection_data";
    private static final String ParserDataElement = "parser_data";
    private static final String CrawlspaceDataElement = "crawlspace_data";
    private CollectionConfiguration collection = null;
    private CollectionCrawlspace crawlspace = null;

    public static CombinedCollectionConfiguration getCombinedInfoFor(String collectionId) throws ConfigurationManagerException {
        CombinedCollectionConfiguration combinedConfig;
        block2: {
            combinedConfig = new CombinedCollectionConfiguration();
            try {
                CollectionConfiguration collection = ConfigurationManager.getConfigurationManager().getCollection(collectionId, (CollectionConfiguration.State)null);
                combinedConfig.setCollection(collection);
                CollectionCrawlspace crawlspace = CollectionCrawlspaceConfigurationManager.getConfigurationManager().getCrawlspace(collectionId);
                combinedConfig.setCrawlspace(crawlspace);
            }
            catch (ConfigurationManagerException e) {
                if (e.isACause(FileNotFoundException.class) || e.isACause(ConfigurationObjectNotExistsException.class)) break block2;
                throw e;
            }
        }
        return combinedConfig;
    }

    public CombinedCollectionConfiguration(CollectionConfiguration collection, CollectionCrawlspace crawlspace) {
        this.collection = collection;
        this.crawlspace = crawlspace;
    }

    public CombinedCollectionConfiguration() {
    }

    public CollectionConfiguration getCollection() {
        return this.collection;
    }

    public void setCollection(CollectionConfiguration collection) {
        this.collection = collection;
    }

    public CollectionCrawlspace getCrawlspace() {
        return this.crawlspace;
    }

    public void setCrawlspace(CollectionCrawlspace crawlspace) {
        this.crawlspace = crawlspace;
    }

    public void writeTo(OutputStream os) throws ExtendedException, IOException {
        XMLTagger tagger = new XMLTagger(true);
        tagger.startPI("xml");
        tagger.writeAttr("version", "1.0");
        tagger.writeAttr("encoding", "UTF-8");
        tagger.endPI();
        tagger.openStartElement(CombinedDataElement);
        tagger.writeAttr("version", "1.0");
        tagger.closeTag();
        if (this.collection != null) {
            this.collection.writeTo(tagger, CollectionDataElement, ParserDataElement);
        }
        if (this.crawlspace != null) {
            tagger.startElement(CrawlspaceDataElement);
            this.crawlspace.writeTo(tagger);
            tagger.endElement(CrawlspaceDataElement);
        }
        tagger.endElement(CombinedDataElement);
        String xml = tagger.getXML();
        os.write(xml.getBytes("UTF-8"));
    }

    public static CombinedCollectionConfiguration loadFrom(InputStream is) throws IOException, ExtendedException, InterruptedException {
        CombinedCollectionConfiguration config = new CombinedCollectionConfiguration();
        Vector<String> elementNames = new Vector<String>();
        elementNames.add(CollectionDataElement);
        elementNames.add(ParserDataElement);
        elementNames.add(CrawlspaceDataElement);
        HashMap<String, String> xmlDocsMap = CombinedXMLData.loadDocumentsFrom(is, elementNames);
        String collectionDoc = xmlDocsMap.get(CollectionDataElement);
        String parserDoc = xmlDocsMap.get(ParserDataElement);
        String crawlspaceDoc = xmlDocsMap.get(CrawlspaceDataElement);
        if (collectionDoc != null) {
            ByteArrayInputStream collectionStream = new ByteArrayInputStream(collectionDoc.getBytes("UTF-8"));
            ByteArrayInputStream parserStream = null;
            if (parserDoc != null) {
                parserStream = new ByteArrayInputStream(parserDoc.getBytes("UTF-8"));
            }
            config.setCollection(CollectionConfiguration.loadFrom(collectionStream, parserStream));
        }
        if (crawlspaceDoc != null) {
            ByteArrayInputStream crawlspaceStream = new ByteArrayInputStream(crawlspaceDoc.getBytes("UTF-8"));
            config.setCrawlspace(CollectionCrawlspace.loadFrom(crawlspaceStream));
        }
        return config;
    }
}

