/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.remote;

import com.ibm.es.nuvo.configuration.remote.CombinedCollectionConfiguration;
import com.ibm.es.nuvo.configuration.remote.ConfigurationAccessException;
import com.ibm.es.nuvo.configuration.remote.RemoteConfigurationNotificationService;
import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.NodeManager;
import com.ibm.es.nuvo.util.Constants;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class CollectionChangeBroadcaster
implements PropertyChangeListener {
    private volatile boolean broadcastUpdates = true;

    public synchronized boolean isBroadcastUpdates() {
        return this.broadcastUpdates;
    }

    public synchronized void setBroadcastUpdates(boolean broadcastUpdates) {
        this.broadcastUpdates = broadcastUpdates;
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Vector<Node> nodes;
        if (this.broadcastUpdates && (nodes = NodeManager.getInstance().getNodeList(true)).size() > 0) {
            String eventName = evt.getPropertyName();
            String collectionId = evt.getNewValue().toString();
            byte[] data = null;
            try {
                if ("ConfigurationObjectCreated".equals(eventName) || "ConfigurationObjectUpdated".equals(eventName)) {
                    CombinedCollectionConfiguration combinedConfig = CombinedCollectionConfiguration.getCombinedInfoFor(collectionId);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    combinedConfig.writeTo(bos);
                    bos.close();
                    data = bos.toByteArray();
                }
                for (int i = 0; i < nodes.size(); ++i) {
                    Node toNode = nodes.get(i);
                    try {
                        System.out.println("Sending " + eventName + " to node " + toNode.getName());
                        RemoteConfigurationNotificationService.notify(toNode, Constants.ConfigurationObjectType.Collection, eventName, collectionId, data);
                        continue;
                    }
                    catch (ConfigurationAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

