/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.crawler;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.crawler.CrawlerConfigurationInterface;
import com.ibm.es.nuvo.crawler.CrawlerConfigPublisher;
import com.ibm.es.nuvo.crawler.CrawlerConfigPulblisherFactory;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.configuration.loader.WebCrawlSpaceConfigLoader;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.ReliableFileInputStream;
import com.ibm.es.nuvo.util.ReliableFileOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class WebCrawlerConfiguration
implements CrawlerConfigurationInterface {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String BaseFileName = "web_crawlspace.xml";
    private static WebCrawlerConfiguration instance = null;

    public static CrawlerConfigurationInterface getInstance() {
        if (instance == null) {
            instance = new WebCrawlerConfiguration();
        }
        return instance;
    }

    public void writeCrawlspace(String directory, Object aCrawlspace) throws ExtendedException {
        CrawlSpaceConfig crawlSpace = (CrawlSpaceConfig)aCrawlspace;
        String fileName = this.buildDataFileName(directory);
        ReliableFileOutputStream os = null;
        try {
            os = new ReliableFileOutputStream(fileName);
            CrawlerConfigPublisher publisher = CrawlerConfigPulblisherFactory.getPublisher(CrawlSpaceConfig.class, crawlSpace);
            publisher.publish(os);
        }
        catch (FileNotFoundException e) {
            ExtendedException ee = new ExtendedException(e);
            throw ee;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Object readCrawlspace(String directory, String collectionId) throws ConfigurationManagerException {
        String fileName = this.buildDataFileName(directory);
        ReliableFileInputStream configFileStream = null;
        CrawlSpaceConfig cs = null;
        try {
            configFileStream = new ReliableFileInputStream(fileName);
            cs = (CrawlSpaceConfig)WebCrawlSpaceConfigLoader.instance().load(collectionId, configFileStream);
        }
        catch (Exception e) {
            Message msg = new Message("G0059E.CRAWLSPACE_LOAD_ERROR", fileName);
            throw new ConfigurationManagerException(msg, (Throwable)e);
        }
        finally {
            try {
                if (configFileStream != null) {
                    configFileStream.close();
                }
            }
            catch (IOException e2) {}
        }
        return cs;
    }

    public Object createDefaultCrawlspace(String collectionId) throws ConfigurationManagerException {
        String defaultCrawlerConfigFileName = GlobalConfiguration.getConfiguration().getConfigFileName("defaults", BaseFileName);
        File f = new File(defaultCrawlerConfigFileName);
        String directory = f.getParent();
        CrawlSpaceConfig cs = (CrawlSpaceConfig)this.readCrawlspace(directory, collectionId);
        cs.setCollectionId(collectionId);
        return cs;
    }

    public void deleteCrawlspace(String directory) {
        boolean deleted;
        String fileName = this.buildDataFileName(directory);
        File f = new File(fileName);
        if (!f.exists() || !(deleted = f.delete())) {
            // empty if block
        }
    }

    public boolean crawlspaceExists(String directory) {
        String fileName = this.buildDataFileName(directory);
        File f = new File(fileName);
        return f.exists();
    }

    public void notifyCrawlerCrawlspaceUpdated(Object newCrawlspace, String crawlspaceId) {
        CrawlSpaceConfig crawlSpaceConfig = (CrawlSpaceConfig)newCrawlspace;
        GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
        WebCrawler webCrawler = globalSystem.getWebCrawler();
        Properties crawlerProperties = new Properties();
        crawlerProperties.put("crawler.configured.object", crawlSpaceConfig);
        webCrawler.applyConfig(crawlspaceId, crawlerProperties);
    }

    public void notifyCrawlerCrawlspaceDeleted(String crawlspaceId) throws ExtendedException {
        GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
        WebCrawler webCrawler = globalSystem.getWebCrawler();
        String collectionId = CollectionConfiguration.crawlspaceIdToCollectionId(crawlspaceId);
        if (webCrawler != null) {
            Properties crawlerProperties = new Properties();
            String crawlerDBPath = CollectionConfiguration.getCrawlerDataDirectory(Constants.CrawlerType.Web, collectionId);
            crawlerProperties.put("crawler.metadata.db.path", crawlerDBPath);
            webCrawler.drop(crawlspaceId, crawlerProperties);
        }
    }

    private String buildDataFileName(String directory) {
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        String fileName = directory + BaseFileName;
        return fileName;
    }
}

