/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.crawler;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.api.CrawlService;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CrawlServiceFactory;
import com.ibm.es.nuvo.configuration.crawler.CSStatus;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceStatus;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlerStateSnapshot {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String CrawlersStateElement = "crawlers_state";
    private static final String CollectionElement = "collection";
    private static final String CollectionIdElement = "id";
    private static final String CrawlerElement = "crawler";
    private static final String CrawlerIdElement = "id";
    private static final String CrawlSpaceIdElement = "id";
    private static final String CrawlSpaceElement = "crawlSpace";
    private HashMap<String, HashMap<String, Object>> crawlerStatesByCollection = new HashMap();
    private HashMap<String, Object> tempCrawlerInfo = null;
    private String tempCrawlSpaceId;
    private HashMap<String, CSStatus> tempCrawlSpaceInfo;

    public static CrawlerStateSnapshot getSnapshotFor(String collectionId) throws ExtendedException {
        Vector<String> vIds = new Vector<String>();
        vIds.add(collectionId);
        return CrawlerStateSnapshot.getSnapshotFor(vIds);
    }

    public static CrawlerStateSnapshot getSnapshotFor(Vector<String> collectionIds) throws ExtendedException {
        CrawlerStateSnapshot activeCrawlers = new CrawlerStateSnapshot();
        GlobalCrawlerManager crawlerMgr = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlService webCrawlService = CrawlServiceFactory.getInstance().getServiceFor(Constants.CrawlerType.Web);
        for (int i = 0; i < collectionIds.size(); ++i) {
            CrawlerManager crwMgr;
            String crawlSpaceId;
            boolean crawling;
            String cId = collectionIds.get(i);
            HashMap<String, Object> crawlerInfo = new HashMap<String, Object>();
            activeCrawlers.crawlerStatesByCollection.put(cId, crawlerInfo);
            if (webCrawlService != null && (crawling = webCrawlService.isCrawling(crawlSpaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, cId)))) {
                crawlerInfo.put(Constants.CrawlerType.Web.toString(), Constants.CrawlerType.Web.toString());
            }
            if (crawlerMgr == null || (crwMgr = crawlerMgr.getCrawlerManager(cId)) == null) continue;
            CrawlerControl[] crwCtrls = crwMgr.getAvailableCrawlerControls();
            for (int j = 0; j < crwCtrls.length; ++j) {
                String crawlerId = crwCtrls[j].getID();
                CrawlSpaceControl[] crwSpaceCtrls = crwMgr.getAvailableCrawlSpaceControls(crawlerId);
                HashMap<String, CSStatus> crawlSpaceToStatus = new HashMap<String, CSStatus>();
                for (int k = 0; k < crwSpaceCtrls.length; ++k) {
                    String crwSpcCtrlId = crwSpaceCtrls[k].getID();
                    CrawlSpaceStatus crwSpcStatus = crwSpaceCtrls[k].getCrawlSpaceStatus();
                    CrawlSpaceStatus.Status crawlspaceStatus = crwSpcStatus.getStatus();
                    CSStatus csStatus = new CSStatus(crwSpcStatus.getMode(), crawlspaceStatus);
                    crawlSpaceToStatus.put(crwSpcCtrlId, csStatus);
                }
                crawlerInfo.put(crawlerId, crawlSpaceToStatus);
            }
        }
        return activeCrawlers;
    }

    public void renameCollection(String oldId, String newId) {
        HashMap<String, Object> collectionInfo = this.crawlerStatesByCollection.remove(oldId);
        if (collectionInfo != null) {
            this.crawlerStatesByCollection.put(newId, collectionInfo);
        }
    }

    public void restartCrawlers() throws ExtendedException {
        GlobalCrawlerManager crawlerMgr = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlService webCrawlService = CrawlServiceFactory.getInstance().getServiceFor(Constants.CrawlerType.Web);
        for (Map.Entry<String, HashMap<String, Object>> curEntry : this.crawlerStatesByCollection.entrySet()) {
            String cId = curEntry.getKey();
            HashMap<String, Object> crawlerToCrawlspace = curEntry.getValue();
            for (Map.Entry<String, Object> crawlerEntry : crawlerToCrawlspace.entrySet()) {
                CrawlerManager crwMgr;
                String crawlerId = crawlerEntry.getKey();
                Object crawlerEntryValue = crawlerEntry.getValue();
                if (Constants.CrawlerType.Web.toString().equals(crawlerId)) {
                    String crawlSpaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, cId);
                    webCrawlService.startCrawl(crawlSpaceId, false);
                    continue;
                }
                if (!(crawlerEntryValue instanceof HashMap) || (crwMgr = crawlerMgr.getCrawlerManager(cId)) == null) continue;
                HashMap crawlSpaceToStatus = (HashMap)crawlerEntryValue;
                for (Map.Entry crawlspaceStatusEntry : crawlSpaceToStatus.entrySet()) {
                    CrawlSpaceStatus crwSpcStatus;
                    CrawlSpaceStatus.Status currentStatus;
                    String crawlspaceId = (String)crawlspaceStatusEntry.getKey();
                    CrawlSpaceControl crwSpcCtrl = this.findCrawlSpaceControlFor(crwMgr, crawlerId, crawlspaceId);
                    if (crwSpcCtrl == null) continue;
                    CSStatus crawlspaceStatus = (CSStatus)crawlspaceStatusEntry.getValue();
                    CrawlMode crawlMode = crawlspaceStatus.getMode();
                    CrawlSpaceStatus.Status savedStatus = crawlspaceStatus.getStatus();
                    if (crawlMode == null || crwSpcCtrl == null || !CrawlSpaceStatus.Status.CRAWLING.equals((Object)savedStatus) && !CrawlSpaceStatus.Status.INIT.equals((Object)savedStatus) || CrawlSpaceStatus.Status.CRAWLING.equals((Object)(currentStatus = (crwSpcStatus = crwSpcCtrl.getCrawlSpaceStatus()).getStatus())) && CrawlSpaceStatus.Status.INIT.equals((Object)currentStatus)) continue;
                    crwSpcCtrl.startCrawl(crawlMode);
                }
            }
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        XMLTagger xmlTagger = new XMLTagger(true);
        xmlTagger.startPI("xml");
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.writeAttr("encoding", "UTF-8");
        xmlTagger.endPI();
        this.writeTo(xmlTagger);
        String xmlDoc = xmlTagger.getXML();
        os.write(xmlDoc.getBytes("UTF-8"));
    }

    public void writeTo(XMLTagger tagger) {
        tagger.startElement(CrawlersStateElement);
        Iterator<Map.Entry<String, HashMap<String, Object>>> iterator = this.crawlerStatesByCollection.entrySet().iterator();
        while (iterator.hasNext()) {
            tagger.startElement(CollectionElement);
            Map.Entry<String, HashMap<String, Object>> curEntry = iterator.next();
            String cId = curEntry.getKey();
            tagger.startElement("id");
            tagger.writeText(cId);
            tagger.endElement("id");
            HashMap<String, Object> crawlerToCrawlspace = curEntry.getValue();
            Iterator<Map.Entry<String, Object>> crawlerIterator = crawlerToCrawlspace.entrySet().iterator();
            while (crawlerIterator.hasNext()) {
                tagger.startElement(CrawlerElement);
                Map.Entry<String, Object> crawlerEntry = crawlerIterator.next();
                String crawlerId = crawlerEntry.getKey();
                Object crawlerEntryValue = crawlerEntry.getValue();
                tagger.startElement("id");
                tagger.writeText(crawlerId);
                tagger.endElement("id");
                if (crawlerEntryValue instanceof HashMap) {
                    HashMap crawlSpaceToStatus = (HashMap)crawlerEntryValue;
                    Iterator crawlspaceIterator = crawlSpaceToStatus.entrySet().iterator();
                    while (crawlspaceIterator.hasNext()) {
                        tagger.startElement(CrawlSpaceElement);
                        Map.Entry crawlspaceStatusEntry = crawlspaceIterator.next();
                        String crawlspaceId = (String)crawlspaceStatusEntry.getKey();
                        CSStatus crawlspaceStatus = (CSStatus)crawlspaceStatusEntry.getValue();
                        tagger.startElement("id");
                        tagger.writeText(crawlspaceId);
                        tagger.endElement("id");
                        crawlspaceStatus.writeTo(tagger);
                        tagger.endElement(CrawlSpaceElement);
                    }
                }
                tagger.endElement(CrawlerElement);
            }
            tagger.endElement(CollectionElement);
        }
        tagger.endElement(CrawlersStateElement);
    }

    public static CrawlerStateSnapshot loadFrom(InputStream is) throws ParseException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String key = "/";
        CrawlerStateSnapshot.prepareParseTree(key, tree);
        CrawlerStateSnapshot activeCrawlers = new CrawlerStateSnapshot();
        parser.parse(is, tree, activeCrawlers);
        activeCrawlers.tempCrawlerInfo = null;
        activeCrawlers.tempCrawlSpaceId = null;
        activeCrawlers.tempCrawlSpaceInfo = null;
        return activeCrawlers;
    }

    public static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + CrawlersStateElement + "/" + CollectionElement + "/";
        tree.addCallMethod(parentPath + "id", "restoreCollectionId");
        tree.addCallMethod(parentPath + CrawlerElement + "/" + "id", "restoreCrawlerId");
        tree.addCallMethod(parentPath + CrawlerElement + "/" + CrawlSpaceElement + "/" + "id", "restoreCrawlSpaceId");
        String pathForCSStatus = parentPath + CrawlerElement + "/" + CrawlSpaceElement + "/";
        tree.addSetSubcomponent(pathForCSStatus + "cs_status", "buildCSStatus");
        CSStatus.prepareParseTree(pathForCSStatus, tree);
    }

    public void restoreCollectionId(String id) {
        this.tempCrawlerInfo = new HashMap();
        this.crawlerStatesByCollection.put(id, this.tempCrawlerInfo);
    }

    public void restoreCrawlerId(String id) {
        if (Constants.CrawlerType.Web.toString().equals(id)) {
            this.tempCrawlerInfo.put(id, id);
        } else {
            this.tempCrawlSpaceInfo = new HashMap();
            this.tempCrawlerInfo.put(id, this.tempCrawlSpaceInfo);
        }
    }

    public void restoreCrawlSpaceId(String id) {
        this.tempCrawlSpaceId = id;
    }

    public CSStatus buildCSStatus() {
        CSStatus status = new CSStatus();
        this.tempCrawlSpaceInfo.put(this.tempCrawlSpaceId, status);
        return status;
    }

    public HashMap<String, HashMap<String, Object>> getCrawlerStatesByCollection() {
        return this.crawlerStatesByCollection;
    }

    private CrawlSpaceControl findCrawlSpaceControlFor(CrawlerManager crwMgr, String crawlerId, String crawlspaceId) throws CrawlerControlException {
        CrawlSpaceControl[] crwSpaceCtrls = crwMgr.getAvailableCrawlSpaceControls(crawlerId);
        CrawlSpaceControl foundCrawSpaceControl = null;
        if (crwSpaceCtrls != null) {
            for (int i = 0; i < crwSpaceCtrls.length && foundCrawSpaceControl == null; ++i) {
                if (!crwSpaceCtrls[i].getID().equals(crawlspaceId)) continue;
                foundCrawSpaceControl = crwSpaceCtrls[i];
            }
        }
        return foundCrawSpaceControl;
    }
}

