/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration.crawler;

import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceStatus;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;

public class CSStatus {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String CrawlSpaceStatusElement = "cs_status";
    private static final String StartModeElement = "start_mode";
    private static final String StatusElement = "status";
    private CrawlMode mode = null;
    private CrawlSpaceStatus.Status status = null;

    public CSStatus(CrawlMode mode, CrawlSpaceStatus.Status status) {
        this.mode = mode;
        this.status = status;
    }

    public CSStatus() {
    }

    public static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        String path = parentPath + CrawlSpaceStatusElement + "/";
        tree.addCallMethod(path + StartModeElement, "setModeStr");
        tree.addCallMethod(path + StatusElement, "setStatusStr");
    }

    public void writeTo(XMLTagger tagger) {
        tagger.startElement(CrawlSpaceStatusElement);
        if (this.mode != null) {
            tagger.startElement(StartModeElement);
            tagger.writeText(this.mode.toString());
            tagger.endElement(StartModeElement);
        }
        if (this.status != null) {
            tagger.startElement(StatusElement);
            tagger.writeText(this.status.toString());
            tagger.endElement(StatusElement);
        }
        tagger.endElement(CrawlSpaceStatusElement);
    }

    public CrawlMode getMode() {
        return this.mode;
    }

    public void setMode(CrawlMode mode) {
        this.mode = mode;
    }

    public CrawlSpaceStatus.Status getStatus() {
        return this.status;
    }

    public void setStatus(CrawlSpaceStatus.Status status) {
        this.status = status;
    }

    public void setModeStr(String strMode) {
        this.mode = CrawlMode.valueOf(strMode);
    }

    public void setStatusStr(String strStatus) {
        this.status = CrawlSpaceStatus.Status.valueOf(strStatus);
    }
}

