/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.SettingsObject;
import com.ibm.es.nuvo.configuration.crawler.CrawlerStateSnapshot;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class SystemSettings
implements SettingsObject {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String LoggerLevelPrefix = "LoggerLevel ";
    private static final String LastQueryLogDicBuildTimeStamp = "LastQueryLogDicBuildTimeStamp";
    private static final String ElementSettings = "settings";
    private static final String ElementProperty = "property";
    private static final String[] ElementPropertyAttributes = new String[]{"name", "value"};
    private static final String[] ElementPropertyAttributesDefaults = new String[]{"", ""};
    private static final String ClickThroughTracking = "ClickThroughTracking";
    private static final String DefaultCollectionId = "DefaultIndex";
    private static final String SystemSettingsFileName = "systemSettings.xml";
    public static final String MetadataPluginDirectory = "MetadataPluginDirectory";
    private CrawlerStateSnapshot crawlersState = null;
    private TreeMap<String, String> properties = new TreeMap();

    public CrawlerStateSnapshot getCrawlersState() {
        return this.crawlersState;
    }

    public void setCrawlersState(CrawlerStateSnapshot crawlersState) {
        this.crawlersState = crawlersState;
    }

    public Level getLoggerLevel(String loggerName) {
        String levelStr = this.properties.get(LoggerLevelPrefix + loggerName);
        Level retLevel = Level.INFO;
        if (null != levelStr) {
            try {
                retLevel = Level.parse(levelStr);
            }
            catch (Exception e) {
                retLevel = Level.INFO;
            }
        }
        return retLevel;
    }

    public void setLoggerLevel(String loggerName, Level newLevel) {
        this.properties.put(LoggerLevelPrefix + loggerName, newLevel.toString());
    }

    public boolean getClickThroughTracking() {
        String mode = this.properties.get(ClickThroughTracking);
        if (null == mode || mode.length() == 0) {
            return false;
        }
        return mode.equals("1");
    }

    public void setClickThroughTracking(boolean mode) {
        if (mode) {
            this.properties.put(ClickThroughTracking, "1");
        } else {
            this.properties.put(ClickThroughTracking, "0");
        }
    }

    public String getDefaultCollectionId() {
        return this.properties.get(DefaultCollectionId);
    }

    public void setDefaultCollectionId(String newId) {
        if (newId != null) {
            this.properties.put(DefaultCollectionId, newId);
        } else {
            this.properties.remove(DefaultCollectionId);
        }
    }

    public Long getLastQueryLogDictionaryBuildTimeStamp() {
        String timestampStr = this.properties.get(LastQueryLogDicBuildTimeStamp);
        if (null != timestampStr) {
            try {
                return new Long(timestampStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setLastQueryLogDictionaryBuildTimeStamp(long timeStamp) {
        this.properties.put(LastQueryLogDicBuildTimeStamp, Long.toString(timeStamp));
    }

    public void writeTo(OutputStream os) throws IOException {
        XMLTagger xmlTagger = new XMLTagger(true, true);
        xmlTagger.openStartElement(ElementSettings);
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.closeTag();
        for (Map.Entry<String, String> curEntry : this.properties.entrySet()) {
            xmlTagger.openStartElement(ElementProperty);
            xmlTagger.writeAttr("name", curEntry.getKey());
            xmlTagger.writeAttr("value", curEntry.getValue());
            xmlTagger.closeEndElementTag();
        }
        if (this.crawlersState != null) {
            this.crawlersState.writeTo(xmlTagger);
        }
        xmlTagger.endElement(ElementSettings);
        String xml = xmlTagger.getXML();
        try {
            os.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void loadFrom(InputStream is) throws ParseException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String path = "/settings/";
        String propertyPath = path + ElementProperty;
        tree.addCallMethod(propertyPath, "setProperty", ElementPropertyAttributes, ElementPropertyAttributesDefaults);
        tree.addSetSubcomponent(path + "crawlers_state", "buildCrawlersState");
        CrawlerStateSnapshot.prepareParseTree(path, tree);
        parser.parse(is, tree, this);
    }

    public CrawlerStateSnapshot buildCrawlersState() {
        this.crawlersState = new CrawlerStateSnapshot();
        return this.crawlersState;
    }

    public String getPersistantFileName() {
        StringBuffer sb = new StringBuffer(200);
        GlobalConfiguration gc = GlobalConfiguration.getConfiguration();
        sb.append(gc.getConfigPath());
        sb.append(File.separator);
        sb.append(SystemSettingsFileName);
        return sb.toString();
    }

    public String getMetadataPluginDirectory() {
        String metadataPluginDirectory = this.properties.get(MetadataPluginDirectory);
        return metadataPluginDirectory;
    }

    public void setMetadataPluginDirectory(String metadataPluginDirectory) {
        this.properties.put(MetadataPluginDirectory, metadataPluginDirectory);
    }
}

