/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.BaseConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationLock;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsObject;
import com.ibm.es.nuvo.configuration.SystemSettings;
import com.ibm.es.nuvo.configuration.tracking.UpdateTrackingData;
import com.ibm.es.nuvo.eventmonitor.EventManagerData;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.network.NodeConfigurationData;
import com.ibm.es.nuvo.util.ReliableFileInputStream;
import com.ibm.es.nuvo.util.ReliableFileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;

public class SettingsConfigurationManager
extends BaseConfigurationManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static SettingsConfigurationManager configManager = null;
    private Object fileIOLock = new Object();

    public static SettingsConfigurationManager getConfigurationManager() {
        if (configManager == null) {
            configManager = new SettingsConfigurationManager();
        }
        return configManager;
    }

    private SettingsConfigurationManager() {
    }

    public SettingsObject getSettings(SettingsType settingsType) {
        SettingsObject settingsObject = null;
        try {
            settingsObject = (SettingsObject)this.configurationCache.get(settingsType);
            return settingsObject;
        }
        catch (CacheException e) {
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, e);
            }
            settingsObject = this.loadDefaultStateObject(settingsType);
            return settingsObject;
        }
    }

    public SettingsObject getSettingsForUpdate(SettingsType settingsType) {
        SettingsObject stateObject = null;
        stateObject = (SettingsObject)this.load((Object)settingsType);
        this.markAsUpdateable(stateObject);
        return stateObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateObject(SettingsType settingsType, SettingsObject stateObject) throws ConfigurationManagerException {
        if (!this.isUpdateable(stateObject)) {
            String msg = "Error!!  Tried to update non updatable stateObject.  You need to get the crawlspace by getStateObjectForUpdate()!!!";
            throw new RuntimeException(msg);
        }
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            try {
                this.writeConfiguration(stateObject);
                this.removeFromUpdateableList(stateObject);
                this.configurationCache.replace(settingsType, stateObject, false);
                this.firePropertyChangeEvent("ConfigurationObjectUpdated", null, (Object)settingsType);
            }
            catch (Exception e) {
                Message msg = new Message("G0068E.SETTINGS_UPDATE_ERROR", stateObject.getPersistantFileName());
                throw new ConfigurationManagerException(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Object name) {
        SettingsType settingsType = (SettingsType)((Object)name);
        SettingsObject stateObject = this.createNewStateObject(settingsType);
        String fileName = stateObject.getPersistantFileName();
        Object object = this.fileIOLock;
        synchronized (object) {
            block17: {
                try {
                    ReliableFileInputStream configFileStream = null;
                    try {
                        configFileStream = new ReliableFileInputStream(fileName);
                        stateObject.loadFrom(configFileStream);
                    }
                    catch (FileNotFoundException e) {
                        stateObject = this.loadDefaultStateObject(settingsType);
                    }
                    finally {
                        try {
                            if (configFileStream != null) {
                                configFileStream.close();
                            }
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (ExtendedException e) {
                    if (!Loggers.logger.isLoggable(Level.WARNING)) break block17;
                    Message msg = new Message("G0067W.SETTINGS_LOAD_WARNING", fileName);
                    Loggers.logger.log(Level.WARNING, msg.getKey());
                    Loggers.logger.log(Level.WARNING, e);
                }
            }
        }
        return stateObject;
    }

    private SettingsObject createNewStateObject(SettingsType settingsType) {
        SettingsObject stateObject = null;
        if (settingsType == SettingsType.SystemSettings) {
            stateObject = new SystemSettings();
        } else if (settingsType == SettingsType.EventManagerSettings) {
            stateObject = new EventManagerData();
        } else if (settingsType == SettingsType.AuthenticationData) {
            stateObject = new AuthenticationData();
        } else if (settingsType == SettingsType.NodeConfigurationData) {
            stateObject = new NodeConfigurationData();
        } else if (settingsType == SettingsType.UpdateTrackingData) {
            stateObject = new UpdateTrackingData();
        }
        return stateObject;
    }

    private SettingsObject loadDefaultStateObject(SettingsType settingsType) {
        return this.createNewStateObject(settingsType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfiguration(SettingsObject settingsObject) throws IOException, ExtendedException {
        Object object = this.fileIOLock;
        synchronized (object) {
            String fileName = settingsObject.getPersistantFileName();
            ReliableFileOutputStream os = null;
            try {
                os = new ReliableFileOutputStream(fileName);
                settingsObject.writeTo(os);
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettingsType {
        SystemSettings,
        EventManagerSettings,
        AuthenticationData,
        NodeConfigurationData,
        UpdateTrackingData;

    }
}

