/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;

public class ScoringWeights {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final String ScoringElement = "scoring";
    static final String TextWeightElement = "text_weight";
    static final String AgeWeightElement = "age_weight";
    static final String DepthWeightElement = "depth_weight";
    static final String LinkCountWeightElement = "link_weight";
    static final String ProximityElement = "proximity";
    static final String ProximityWeightElement = "weight";
    static final String ProximityWindowSizeElement = "window_size";
    static final String ProximityGaussDeviationElement = "gauss_deviation";
    static final String ProximityMinNumberOfPositionsToProcessElement = "min_number_of_positions_to_process";
    static final String ProximityFractionOfPositionsToProcessElement = "fraction_of_positions_to_process";
    private double textWeight = 3.0;
    private double linkCountWeight = 1.0;
    private double ageWeight = 1.0;
    private double depthWeight = 1.0;
    private double proximityWeight = 2.0;
    private int proximityWindowSize = 5;
    private double proximityGaussDeviation = 3.5;
    private int proximityMinNumberOfPositionsToProcess = 20;
    private double proximityFractionOfPositionsToProcess = 0.2;

    public double getAgeWeight() {
        return this.ageWeight;
    }

    public double getDepthWeight() {
        return this.depthWeight;
    }

    public double getLinkCountWeight() {
        return this.linkCountWeight;
    }

    public double getTextWeight() {
        return this.textWeight;
    }

    public double getProximityWeight() {
        return this.proximityWeight;
    }

    public int getProximityWindowSize() {
        return this.proximityWindowSize;
    }

    public double getProximityGaussDeviation() {
        return this.proximityGaussDeviation;
    }

    public int getProximityMinNumberOfPositionsToProcess() {
        return this.proximityMinNumberOfPositionsToProcess;
    }

    public double getProximityFractionOfPositionsToProcess() {
        return this.proximityFractionOfPositionsToProcess;
    }

    public void setAgeWeight(double ageWeight) {
        this.ageWeight = ageWeight;
    }

    public void setDepthWeight(double depthWeight) {
        this.depthWeight = depthWeight;
    }

    public void setLinkCountWeight(double linkCountWeight) {
        this.linkCountWeight = linkCountWeight;
    }

    public void setTextWeight(double textWeight) {
        this.textWeight = textWeight;
    }

    public void setProximityWeight(double proximityWeight) {
        this.proximityWeight = proximityWeight;
    }

    public void setProximityWindowSize(int proximityWindowSize) {
        this.proximityWindowSize = proximityWindowSize;
    }

    public void setProximityGaussDeviation(double proximityGaussDeviation) {
        this.proximityGaussDeviation = proximityGaussDeviation;
    }

    public void setProximityMinNumberOfPositionsToProcess(int proximityMinNumberOfPositionsToProcess) {
        this.proximityMinNumberOfPositionsToProcess = proximityMinNumberOfPositionsToProcess;
    }

    public void setProximityFractionOfPositionsToProcess(double proximityFractionOfPositionsToProcess) {
        this.proximityFractionOfPositionsToProcess = proximityFractionOfPositionsToProcess;
    }

    public static ScoringWeights createDefault() throws ExtendedException {
        CollectionConfiguration collection = CollectionConfiguration.createDefault();
        return collection.getScoringWeights();
    }

    public void writeTo(XMLTagger tagger) {
        tagger.startElement(ScoringElement);
        tagger.startElement(TextWeightElement);
        tagger.writeText(Double.toString(this.textWeight));
        tagger.endElement(TextWeightElement);
        tagger.startElement(LinkCountWeightElement);
        tagger.writeText(Double.toString(this.linkCountWeight));
        tagger.endElement(LinkCountWeightElement);
        tagger.startElement(AgeWeightElement);
        tagger.writeText(Double.toString(this.ageWeight));
        tagger.endElement(AgeWeightElement);
        tagger.startElement(DepthWeightElement);
        tagger.writeText(Double.toString(this.depthWeight));
        tagger.endElement(DepthWeightElement);
        tagger.startElement(ProximityElement);
        tagger.startElement(ProximityWeightElement);
        tagger.writeText(Double.toString(this.proximityWeight));
        tagger.endElement(ProximityWeightElement);
        tagger.startElement(ProximityWindowSizeElement);
        tagger.writeText(Integer.toString(this.proximityWindowSize));
        tagger.endElement(ProximityWindowSizeElement);
        tagger.startElement(ProximityGaussDeviationElement);
        tagger.writeText(Double.toString(this.proximityGaussDeviation));
        tagger.endElement(ProximityGaussDeviationElement);
        tagger.startElement(ProximityMinNumberOfPositionsToProcessElement);
        tagger.writeText(Integer.toString(this.proximityMinNumberOfPositionsToProcess));
        tagger.endElement(ProximityMinNumberOfPositionsToProcessElement);
        tagger.startElement(ProximityFractionOfPositionsToProcessElement);
        tagger.writeText(Double.toString(this.proximityFractionOfPositionsToProcess));
        tagger.endElement(ProximityFractionOfPositionsToProcessElement);
        tagger.endElement(ProximityElement);
        tagger.endElement(ScoringElement);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + ScoringElement + "/";
        tree.addCallMethod(parentPath + TextWeightElement, "setTextWeightStr");
        tree.addCallMethod(parentPath + AgeWeightElement, "setAgeWeightStr");
        tree.addCallMethod(parentPath + DepthWeightElement, "setDepthWeightStr");
        tree.addCallMethod(parentPath + LinkCountWeightElement, "setLinkCountWeightStr");
        tree.addCallMethod(parentPath + ProximityElement + "/" + ProximityWeightElement, "setProximityWeightStr");
        tree.addCallMethod(parentPath + ProximityElement + "/" + ProximityWindowSizeElement, "setProximityWindowSizeStr");
        tree.addCallMethod(parentPath + ProximityElement + "/" + ProximityGaussDeviationElement, "setProximityGaussDeviationStr");
        tree.addCallMethod(parentPath + ProximityElement + "/" + ProximityMinNumberOfPositionsToProcessElement, "setProximityMinNumberOfPositionsToProcessStr");
        tree.addCallMethod(parentPath + ProximityElement + "/" + ProximityFractionOfPositionsToProcessElement, "setProximityFractionOfPositionsToProcessStr");
    }

    public void setTextWeightStr(String strDouble) {
        double value = Double.parseDouble(strDouble);
        this.setTextWeight(value);
    }

    public void setAgeWeightStr(String strDouble) {
        double value = Double.parseDouble(strDouble);
        this.setAgeWeight(value);
    }

    public void setDepthWeightStr(String strDouble) {
        double value = Double.parseDouble(strDouble);
        this.setDepthWeight(value);
    }

    public void setLinkCountWeightStr(String strDouble) {
        double value = Double.parseDouble(strDouble);
        this.setLinkCountWeight(value);
    }

    public void setProximityWeightStr(String strDouble) {
        double value = Double.parseDouble(strDouble);
        this.setProximityWeight(value);
    }

    public void setProximityWindowSizeStr(String strInt) {
        int value = Integer.parseInt(strInt);
        this.setProximityWindowSize(value);
    }

    public void setProximityGaussDeviationStr(String strDouble) {
        double value = Double.parseDouble(strDouble);
        this.setProximityGaussDeviation(value);
    }

    public void setProximityMinNumberOfPositionsToProcessStr(String strInt) {
        int value = Integer.parseInt(strInt);
        this.setProximityMinNumberOfPositionsToProcess(value);
    }

    public void setProximityFractionOfPositionsToProcessStr(String strDouble) {
        double value = Double.parseDouble(strDouble);
        this.setProximityFractionOfPositionsToProcess(value);
    }
}

