/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.FileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class LanguageConfiguration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String PropertiesSuffix = ".properties";
    private Locale locale;
    private static final String queryLangsFile = "ql.properties";
    private static final String filterLangsFile = "fl.properties";

    public LanguageConfiguration(Locale locale) {
        this.locale = locale;
    }

    public String[] getQueryLanguages() throws ExtendedException {
        String[] qLangs = null;
        if (!this.isEnglishOnlyInstall()) {
            try {
                qLangs = this.getLanguages(queryLangsFile);
            }
            catch (Exception e) {
                ExtendedException ee = new ExtendedException(e);
                throw ee;
            }
        }
        return qLangs;
    }

    public String[] getFilterLanguages() throws ExtendedException {
        String[] filterLangs = null;
        try {
            filterLangs = this.getLanguages(filterLangsFile);
        }
        catch (Exception e) {
            ExtendedException ee = new ExtendedException(e);
            throw ee;
        }
        return filterLangs;
    }

    public Locale[] getInstalledResourceBundleLocales() {
        Locale[] locales = null;
        Message msg = new Message();
        String resBundName = msg.getResourceBundleName();
        String resourceNameReplaced = resBundName.replace('.', '/');
        String resourceName = resourceNameReplaced + PropertiesSuffix;
        URL resourceURL = this.getClass().getClassLoader().getResource(resourceName);
        if (null != resourceURL) {
            String resourceFilePath = resourceURL.getFile();
            try {
                resourceFilePath = URLDecoder.decode(resourceFilePath, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            File resourceFile = new File(resourceFilePath);
            int indexOfLast = resBundName.lastIndexOf(46);
            String resBundNamePrefix = resBundName.substring(indexOfLast + 1);
            File[] resourceFiles = null;
            if (resourceURL.getProtocol() == "jar") {
                URI jarPathURI;
                String jarPath;
                block15: {
                    String jarPathResourcePath = resourceURL.getFile();
                    jarPath = jarPathResourcePath.substring(0, jarPathResourcePath.lastIndexOf(resourceName) - 2);
                    jarPathURI = null;
                    try {
                        jarPathURI = new URI(jarPath);
                    }
                    catch (URISyntaxException e1) {
                        InvalidArgumentException ee = new InvalidArgumentException("jarPath", jarPath, e1);
                        if (!Loggers.logger.isLoggable(Level.WARNING)) break block15;
                        Loggers.logger.log(Level.WARNING, ee);
                    }
                }
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(new File(jarPathURI));
                }
                catch (IOException e) {
                    InvalidArgumentException ee = new InvalidArgumentException("jarPath", jarPath, e);
                    if (Loggers.logger.isLoggable(Level.WARNING)) {
                        Loggers.logger.log(Level.WARNING, ee);
                    }
                    return null;
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                ArrayList<File> bundleEntries = new ArrayList<File>();
                String regExpr = resourceNameReplaced + ".*\\" + PropertiesSuffix;
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.matches(regExpr)) continue;
                    bundleEntries.add(new File(entryName));
                }
                if (bundleEntries.size() > 0) {
                    resourceFiles = new File[bundleEntries.size()];
                    resourceFiles = bundleEntries.toArray(resourceFiles);
                }
            } else if (resourceURL.getProtocol() == "file") {
                FileFilter fileFilter = new FileFilter(resBundNamePrefix, PropertiesSuffix);
                File parentFile = resourceFile.getParentFile();
                if (null != parentFile) {
                    resourceFiles = parentFile.listFiles(fileFilter);
                }
            }
            if (null != resourceFiles) {
                locales = this.getLocaleFromResourceBundles(resourceFiles, resBundNamePrefix);
            }
        }
        return this.getSortedLocales(locales);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isEnglishOnlyInstall() {
        FileFilter dicFilter;
        String uimaDataPath = GlobalConfiguration.getConfiguration().getUimaDataPath();
        File uimaDataFiles = new File(uimaDataPath + File.separator);
        String[] dictionaryList = uimaDataFiles.list(dicFilter = new FileFilter(null, "dic"));
        boolean englishOnly = dictionaryList == null || dictionaryList.length <= 3;
        return englishOnly;
    }

    private String[] getLanguages(String languagePropsFile) throws IOException {
        String qlPropsPath = GlobalConfiguration.getConfiguration().getConfigPath();
        Properties qlProps = new Properties();
        FileInputStream is = new FileInputStream(qlPropsPath + File.separator + languagePropsFile);
        qlProps.load(is);
        is.close();
        String[] queryLocales = new String[qlProps.size()];
        Enumeration<Object> langEnum = qlProps.keys();
        int i = 0;
        while (langEnum.hasMoreElements()) {
            String lang = langEnum.nextElement().toString();
            queryLocales[i++] = lang;
        }
        return queryLocales;
    }

    private Locale[] getLocaleFromResourceBundles(File[] bundles, String bundleName) {
        if (null != bundles && bundles.length > 0) {
            ArrayList<Locale> localesList = new ArrayList<Locale>(bundles.length);
            for (int i = 0; i < bundles.length; ++i) {
                String curFileName = bundles[i].getName();
                curFileName = curFileName.replaceFirst(bundleName, "");
                int localeStrLen = (curFileName = curFileName.replaceFirst(PropertiesSuffix, "")).length();
                if (localeStrLen >= 3) {
                    String lang = curFileName.substring(1, 3);
                    Locale localeIn = null;
                    if (localeStrLen >= 6) {
                        String country = curFileName.substring(4, 6);
                        localeIn = new Locale(lang, country);
                    } else {
                        localeIn = new Locale(lang);
                    }
                    localesList.add(localeIn);
                    continue;
                }
                if (0 != localeStrLen) continue;
                localesList.add(Locale.US);
            }
            Locale[] retLocales = null;
            if (localesList.size() > 0) {
                retLocales = new Locale[localesList.size()];
                localesList.toArray(retLocales);
            } else {
                retLocales = new Locale[]{Locale.US};
            }
            return retLocales;
        }
        return null;
    }

    private Locale[] getSortedLocales(Locale[] locales) {
        if (locales != null) {
            LocaleComparator localeComparator = new LocaleComparator(this.locale);
            Arrays.sort(locales, localeComparator);
        }
        return locales;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleComparator
    implements Comparator<Locale> {
        private Collator collator;
        private Locale compareLocale;

        public LocaleComparator(Locale compareLocale) {
            this.compareLocale = compareLocale;
            this.collator = Collator.getInstance(this.compareLocale);
        }

        @Override
        public int compare(Locale l1, Locale l2) {
            return this.collator.compare(l1.getDisplayLanguage(this.compareLocale), l2.getDisplayLanguage(this.compareLocale));
        }

        public boolean equals(Locale l1, Locale l2) {
            return this.collator.equals(l1.getDisplayLanguage(this.compareLocale), l2.getDisplayLanguage(this.compareLocale));
        }
    }
}

