/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.util.XMLDOMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JettyConfiguration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String WAR_FILE_API = "whitney_api.war";
    private static final String WAR_FILE_ADMIN = "whitney_admin.war";
    private static final String WAR_FILE_SEARCH = "whitney_search.war";
    int adminHttpPort = 0;
    int adminHttpsPort = 0;
    int adminHttpMaxIdleTimeMs = 120000;
    int adminHttpAcceptorThreads = 1;
    int searchHttpPort = 0;
    int searchHttpsPort = 0;
    private String hostName = null;
    private String apiContext = null;
    private String adminContext = null;
    private String searchContext = null;

    public JettyConfiguration(GlobalConfiguration globalConfig) throws IOException, ParserConfigurationException, SAXException {
        String adminJettyFileName = globalConfig.getJettyConfigFilePath();
        String searchJettyFileName = globalConfig.getJettySearchConfigFilePath();
        File adminJettyFile = new File(adminJettyFileName);
        File searchJettyFile = new File(searchJettyFileName);
        if (!searchJettyFile.exists()) {
            searchJettyFile = null;
        }
        this.configure(adminJettyFile, searchJettyFile);
    }

    public JettyConfiguration(InputStream adminJettyStream, InputStream searchJettyStream) throws IOException, ParserConfigurationException, SAXException {
        this.configure(adminJettyStream, searchJettyStream);
    }

    public JettyConfiguration(File adminJettyFile, File searchJettyFile) throws IOException, ParserConfigurationException, SAXException {
        this.configure(adminJettyFile, searchJettyFile);
    }

    public JettyConfiguration(File adminJettyFile) throws IOException, ParserConfigurationException, SAXException {
        this(adminJettyFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(File adminJettyFile, File searchJettyFile) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(adminJettyFile);
        FileInputStream searchfileInputStream = null;
        try {
            if (null != searchJettyFile) {
                searchfileInputStream = new FileInputStream(searchJettyFile);
            }
            this.configure(fileInputStream, searchfileInputStream);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {}
            if (null != searchfileInputStream) {
                try {
                    searchfileInputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void configure(InputStream adminJettyInputStream, InputStream searchJettyInputStream) throws ParserConfigurationException, SAXException, IOException {
        Element[] warAppElements;
        Document doc = XMLDOMUtils.readAsNonValidatingDOM(adminJettyInputStream);
        String element = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=Port";
        this.adminHttpPort = this.getValueForElement(doc, element, this.adminHttpPort);
        element = "/Configure/Call/Arg/New@class=org.mortbay.http.ibmjsse.IbmJsseListener/Set@name=Port";
        this.adminHttpsPort = this.getValueForElement(doc, element, this.adminHttpsPort);
        element = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=AcceptorThreads";
        this.adminHttpAcceptorThreads = this.getValueForElement(doc, element, this.adminHttpAcceptorThreads);
        element = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=MaxIdleTimeMs";
        this.adminHttpMaxIdleTimeMs = this.getValueForElement(doc, element, this.adminHttpMaxIdleTimeMs);
        element = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=Host";
        this.hostName = this.getStringValueForElement(doc, element, null);
        if (this.hostName == null || this.hostName.length() == 0) {
            element = "/Configure/Call/Arg/New@class=org.mortbay.http.ibmjsse.IbmJsseListener/Set@name=Host";
            this.hostName = this.getStringValueForElement(doc, element, null);
        }
        if (this.hostName == null || this.hostName.length() == 0 || "0.0.0.0".equals(this.hostName)) {
            this.hostName = "localhost";
        }
        if (null != (warAppElements = this.getElements(doc, "/Configure/Call@name=addWebApplication"))) {
            this.apiContext = this.getContextPathForWarFile(warAppElements, WAR_FILE_API);
            this.adminContext = this.getContextPathForWarFile(warAppElements, WAR_FILE_ADMIN);
            this.searchContext = this.getContextPathForWarFile(warAppElements, WAR_FILE_SEARCH);
        }
        if (null == searchJettyInputStream) {
            this.searchHttpPort = this.adminHttpPort;
            this.searchHttpsPort = this.adminHttpsPort;
        } else {
            Document searchDoc = XMLDOMUtils.readAsNonValidatingDOM(searchJettyInputStream);
            element = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=Port";
            this.searchHttpPort = this.getValueForElement(searchDoc, element, this.searchHttpPort);
            element = "/Configure/Call/Arg/New@class=org.mortbay.http.ibmjsse.IbmJsseListener/Set@name=Port";
            this.searchHttpsPort = this.getValueForElement(searchDoc, element, this.searchHttpsPort);
            warAppElements = this.getElements(doc, "/Configure/Call@name=addWebApplication");
            this.searchContext = this.getContextPathForWarFile(warAppElements, WAR_FILE_SEARCH);
        }
    }

    private String getContextPathForWarFile(Element[] warAppElements, String warFileNameToFind) {
        if (null == warAppElements) {
            return null;
        }
        for (Element element : warAppElements) {
            Element warFileNode;
            String warFileName;
            Element[] argElement;
            NodeList children = element.getChildNodes();
            if (children.getLength() < 2 || null == (argElement = this.getElements(children, "Arg")) || argElement.length < 2 || null == (warFileName = (warFileNode = argElement[1]).getTextContent()) || !(warFileName = warFileName.trim()).endsWith(warFileNameToFind)) continue;
            return argElement[0].getTextContent().trim();
        }
        return null;
    }

    private Element[] getElements(NodeList elementList, String name) {
        ArrayList<Element> specifiedElements = new ArrayList<Element>(2);
        for (int i = 0; i < elementList.getLength(); ++i) {
            Node curNode = elementList.item(i);
            if (!(curNode instanceof Element) || !curNode.getNodeName().equals(name)) continue;
            specifiedElements.add((Element)curNode);
        }
        if (specifiedElements.size() > 0) {
            Element[] retElements = new Element[specifiedElements.size()];
            return specifiedElements.toArray(retElements);
        }
        return null;
    }

    private Element[] getElements(Document doc, String path) {
        if (null == path) {
            return null;
        }
        return XMLDOMUtils.getElements(path, doc, -1);
    }

    private int getValueForElement(Document doc, String element, int defaultValue) {
        Element matchedElement = XMLDOMUtils.getElement(element, doc);
        int retValue = defaultValue;
        if (null != matchedElement) {
            String value = matchedElement.getTextContent();
            retValue = Integer.valueOf(value);
        }
        return retValue;
    }

    private String getStringValueForElement(Document doc, String element, String defaultValue) {
        Element matchedElement = XMLDOMUtils.getElement(element, doc);
        String retValue = defaultValue;
        if (null != matchedElement) {
            retValue = matchedElement.getTextContent();
        }
        return retValue;
    }

    public int getAdminHttpPort() {
        return this.adminHttpPort;
    }

    public int getAdminHttpsPort() {
        return this.adminHttpsPort;
    }

    public int getAdminHttpAcceptorThreads() {
        return this.adminHttpAcceptorThreads;
    }

    public int getAdminHttpMaxIdleTimeMs() {
        return this.adminHttpMaxIdleTimeMs;
    }

    public int getSearchHttpPort() {
        return this.searchHttpPort;
    }

    public int getSearchHttpsPort() {
        return this.searchHttpsPort;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getAdminAppURL() {
        StringBuilder builder = new StringBuilder();
        builder.append("http");
        int port = this.adminHttpPort;
        if (port == 0) {
            port = this.adminHttpsPort;
            builder.append('s');
        }
        builder.append("://");
        builder.append(this.hostName);
        builder.append(':');
        builder.append(port);
        return builder.toString();
    }

    public String getApiContext() {
        return this.apiContext;
    }

    public String getAdminContext() {
        return this.adminContext;
    }

    public String getSearchContext() {
        return this.searchContext;
    }
}

