/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptorProperties;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.io.File;

public class IndexDescriptor {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String ElementIndex = "index";
    private static final String ElementType = "type";
    private static final String ElementPath = "path";
    private static final String ElementEnabled = "enabled";
    private static final String ElementProperty = "property";
    private static final String[] ElementPropertyAttributes = new String[]{"name", "value"};
    private static final String[] ElementPropertyAttributesDefaults = new String[]{"", ""};
    private String path = null;
    private IndexDescriptorProperties properties = null;
    private IndexType type = null;
    private CollectionConfiguration collection = null;
    private boolean enabled = true;

    public static IndexDescriptor buildDescriptorFor(CollectionConfiguration collection, IndexType type) throws ExtendedException {
        IndexDescriptor iDesc = new IndexDescriptor(type, collection);
        iDesc.properties = IndexDescriptor.getDefaultProperties(type);
        return iDesc;
    }

    protected IndexDescriptor() {
    }

    private IndexDescriptor(IndexType type, CollectionConfiguration collection) {
        this.type = type;
        this.collection = collection;
        this.path = collection.getDefaultDataDirectory() + File.separator + IndexDescriptor.getDefaultDirectoryName(type);
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        String absolutePath = this.path;
        File fTemp = new File(this.path);
        if (!fTemp.isAbsolute()) {
            String pathToConfigDirectory = this.collection.getCollectionDirectory();
            File f2 = new File(pathToConfigDirectory, this.path);
            absolutePath = f2.getAbsolutePath();
        }
        return absolutePath;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IndexType getType() {
        return this.type;
    }

    public void setType(IndexType type) {
        this.type = type;
    }

    public void setCollection(CollectionConfiguration collection) {
        this.collection = collection;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IndexDescriptorProperties getProperties() {
        return this.properties;
    }

    public void setProperties(IndexDescriptorProperties properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new IndexDescriptorProperties();
        }
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        String value = null;
        if (this.properties != null) {
            value = (String)this.properties.get(name);
        }
        return value;
    }

    protected void writeTo(XMLTagger xmlTagger) {
        xmlTagger.startElement(ElementIndex);
        xmlTagger.startElement(ElementType);
        xmlTagger.writeText(this.getType().toString());
        xmlTagger.endElement(ElementType);
        xmlTagger.startElement(ElementPath);
        xmlTagger.writeText(this.getPath());
        xmlTagger.endElement(ElementPath);
        xmlTagger.startElement(ElementEnabled);
        xmlTagger.writeText(Boolean.toString(this.enabled));
        xmlTagger.endElement(ElementEnabled);
        if (this.properties != null && this.properties.size() > 0) {
            this.properties.writeTo(xmlTagger);
        }
        xmlTagger.endElement(ElementIndex);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + ElementIndex + "/";
        tree.addCallMethod(parentPath + ElementPath, "setPath");
        tree.addCallMethod(parentPath + ElementType, "setTypeStr");
        tree.addCallMethod(parentPath + ElementEnabled, "setEnabledStr");
        tree.addCallMethod(parentPath + ElementProperty, "setProperty", ElementPropertyAttributes, ElementPropertyAttributesDefaults);
    }

    public void setEnabledStr(String enabled) {
        this.setEnabled(enabled.equalsIgnoreCase("true"));
    }

    public void setTypeStr(String strIndexType) {
        for (IndexType types : IndexType.values()) {
            if (!types.toString().equals(strIndexType)) continue;
            this.setType(types);
            break;
        }
    }

    protected static String getDefaultDirectoryName(IndexType indexType) {
        String name = null;
        switch (indexType) {
            case Text: {
                name = "text";
                break;
            }
            case QuickLink: {
                name = "ql";
                break;
            }
            case Synonym: {
                name = "synonym";
                break;
            }
            case Anchor: {
                name = "at";
                break;
            }
            case Cache: {
                name = "cache";
                break;
            }
            case Facet: {
                name = "facets";
                break;
            }
            case Crawl: {
                name = "crawl";
            }
        }
        return name;
    }

    private static IndexDescriptorProperties getDefaultProperties(IndexType indexType) throws ExtendedException {
        IndexDescriptorProperties properties = null;
        CollectionConfiguration collection = CollectionConfiguration.createDefault();
        IndexDescriptor indexDescriptor = collection.getIndexDescriptorFor(indexType);
        if (indexDescriptor != null) {
            properties = indexDescriptor.getProperties();
        }
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        Text,
        QuickLink,
        Synonym,
        Cache,
        Anchor,
        Facet,
        Crawl;

    }
}

