/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.api.DocumentPipelineExtension;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfigurationException;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.util.FileUtils;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalConfiguration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String JettyConfigFileName = "jetty.xml";
    private static final String JettySearchConfigFileName = "jetty_search.xml";
    public static final String DefaultsSubdirectory = "defaults";
    private static final String CollectionSubdirectory = "collections";
    private static final String StellentSubdirectory = "stellent";
    private static final String BinSubdirectory = "bin";
    private static final String SpellSubdirectory = "spell";
    private static final String ResourceSubdirectory = "resource";
    protected static final String DefaultDocQueueSubdirectory = "doc_queue";
    private static final String StyleSheetSubdirectory = "stylesheets";
    private static final String OverridesSubdirectory = "overrides";
    private static final String ShutdownFileName = "shutdown.txt";
    private static final String OSName = System.getProperty("os.name").toLowerCase();
    private static final String JavaHomeDirectory = System.getProperty("java.home");
    private static final String JavaClassPath = System.getProperty("java.class.path");
    private static final String TempSubDirectoryName = "IQQ";
    private static final String LockDirectoryName = "locks";
    private static GlobalConfiguration configuration = null;
    private String installPath = null;
    private String logPath = null;
    private String configPath = null;
    private String tempDirectory = null;
    private String defaultDataDirectory = null;
    private String docQueueDirectory = null;
    private String stellentDirectoryOverride = null;
    private int asyncAnchorTextProcessingIntervals = 20;
    private int documentQueueSize;
    private int documentBatchSize = -1;
    private int numberOfIndexers = Math.max(2, Runtime.getRuntime().availableProcessors());
    private int numberOfTokenizers = Math.max(2, Runtime.getRuntime().availableProcessors());
    private boolean useMultipleThreadPerCollection = true;
    private int numberOfSearchables = 10;
    private String documentPipelineExtensionClassName = null;
    private Class<DocumentPipelineExtension> documentPipelineExtensionClass = null;

    public static void initialize(String fullPath) throws ParseException, FileNotFoundException {
        FileInputStream is = new FileInputStream(fullPath);
        configuration = GlobalConfiguration.loadFrom(is, fullPath);
    }

    public static GlobalConfiguration loadFrom(InputStream is, String configFileName) throws ParseException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        tree.addPath("/config/installPath/", "setInstallPath");
        tree.addPath("/config/configPath/", "setConfigPath");
        tree.addPath("/config/logPath/", "setLogPath");
        tree.addPath("/config/defaultDataDirectory/", "setDefaultDataDirectory");
        tree.addPath("/config/documentQueueSize/", "setDocumentQueueSize", Integer.TYPE);
        tree.addPath("/config/numberOfIndexers", "setNumberOfIndexers", Integer.TYPE);
        tree.addPath("/config/numberOfTokenizers", "setNumberOfTokenizers", Integer.TYPE);
        tree.addPath("/config/numberOfSearchables", "setNumberOfSearchables", Integer.TYPE);
        tree.addPath("/config/stellent/path", "setStellentPath");
        tree.addPath("/config/tempDirectory", "setTempDirectory");
        tree.addPath("/config/docQueueDirectory", "setDocQueueDirectory");
        tree.addPath("/config/asyncAnchorTextProcessingIntervals", "setAsyncAnchorTextProcessingIntervals", Integer.TYPE);
        tree.addPath("/config/documentBatchSize", "setDocumentBatchSize", Integer.TYPE);
        tree.addPath("/config/useMultipleThreadPerCollection", "setMultipleThreadPerCollection", Boolean.TYPE);
        tree.addPath("/config/documentPipelineExtension/className", "setDocumentPipelineExtensionClassName");
        GlobalConfiguration config = new GlobalConfiguration();
        parser.parse(is, tree, config);
        config.prepareDirectories(configFileName);
        return config;
    }

    public static GlobalConfiguration getConfiguration() {
        return configuration;
    }

    public void setInstallPath(String path) {
        this.installPath = path;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public int getDocumentBatchSize() {
        return this.documentBatchSize;
    }

    public void setDocumentBatchSize(int documentBatchSize) {
        this.documentBatchSize = documentBatchSize;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setDocumentQueueSize(int queueSize) {
        this.documentQueueSize = queueSize;
    }

    public int getDocumentQueueSize() {
        return this.documentQueueSize;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getCollectionPath() {
        return this.configPath + File.separator + CollectionSubdirectory;
    }

    public String getStyleSheetPath() {
        return this.configPath + File.separator + StyleSheetSubdirectory;
    }

    public String getResourcePath() {
        return this.installPath + File.separator + ResourceSubdirectory;
    }

    public String getBinPath() {
        return this.installPath + File.separator + BinSubdirectory;
    }

    public String getSpellDirectory() {
        return this.getConfigPath() + File.separator + SpellSubdirectory;
    }

    public String getUimaDataPath() {
        return this.getResourcePath() + File.separator + "uima";
    }

    public String getJettyConfigFilePath() {
        return this.getConfigPath() + File.separator + JettyConfigFileName;
    }

    public String getJettySearchConfigFilePath() {
        return this.getConfigPath() + File.separator + JettySearchConfigFileName;
    }

    public String getDefaultsDirectory() {
        return this.getConfigPath() + File.separator + DefaultsSubdirectory;
    }

    public String getDocQueueDirectory() {
        return this.docQueueDirectory;
    }

    public String getDocQueueFileName() {
        return this.docQueueDirectory + File.separator + "doc_queue.xml";
    }

    public void setDocQueueDirectory(String docQueueDirectory) {
        this.docQueueDirectory = docQueueDirectory;
    }

    public String getDefaultDataDirectory() {
        return this.defaultDataDirectory;
    }

    public void setDefaultDataDirectory(String defaultDataDirectory) {
        this.defaultDataDirectory = defaultDataDirectory;
    }

    public Class<DocumentPipelineExtension> getDocumentPipelineExtensionClass() {
        return this.documentPipelineExtensionClass;
    }

    public void setDocumentPipelineExtensionClassName(String documentPipelineExtensionClassName) {
        this.documentPipelineExtensionClassName = documentPipelineExtensionClassName;
    }

    public String getStellentPath() {
        if (this.stellentDirectoryOverride != null) {
            return this.stellentDirectoryOverride;
        }
        if (this.isWindows()) {
            return this.getInstallPath() + File.separator + StellentSubdirectory + ".windows";
        }
        if (this.isLinux()) {
            return this.getInstallPath() + File.separator + StellentSubdirectory + ".linux32";
        }
        if (this.isAIX()) {
            return this.getInstallPath() + File.separator + StellentSubdirectory + ".aix32";
        }
        return null;
    }

    public String getBuildPropertiesFileName() {
        return this.configPath + File.separator + "build_info.properties";
    }

    public void setStellentPath(String path) {
        this.stellentDirectoryOverride = path;
    }

    public String getKeyPath() {
        return this.configPath + File.separator + "key.txt";
    }

    public final boolean isWindows() {
        return OSName.contains("windows");
    }

    public final boolean isAIX() {
        return OSName.contains("aix");
    }

    public final boolean isLinux() {
        return OSName.contains("linux");
    }

    public int getNumberOfIndexers() {
        return this.numberOfIndexers;
    }

    public int getAsyncAnchorTextProcessingIntervals() {
        return this.asyncAnchorTextProcessingIntervals;
    }

    public int getNumberOfTokenizers() {
        return this.numberOfTokenizers;
    }

    public int getNumberOfSearchables() {
        return this.numberOfSearchables;
    }

    public void setAsyncAnchorTextProcessingIntervals(int asyncAnchorTextProcessingIntervals) {
        this.asyncAnchorTextProcessingIntervals = asyncAnchorTextProcessingIntervals;
    }

    public void setNumberOfIndexers(int numberOfIndexers) {
        this.numberOfIndexers = numberOfIndexers;
    }

    public void setNumberOfTokenizers(int numberOfTokenizers) {
        this.numberOfTokenizers = numberOfTokenizers;
    }

    public void setNumberOfSearchables(int numberOfSearchables) {
        this.numberOfSearchables = numberOfSearchables;
    }

    public final String getJavaHome() {
        return JavaHomeDirectory;
    }

    public final String getJavaClassPath() {
        return JavaClassPath;
    }

    public String getStellentDirectoryOverride() {
        return this.stellentDirectoryOverride;
    }

    public void setStellentDirectoryOverride(String stellentDirectoryOverride) {
        this.stellentDirectoryOverride = stellentDirectoryOverride;
    }

    public void setMultipleThreadPerCollection(boolean concurrent) {
        this.useMultipleThreadPerCollection = concurrent;
    }

    public boolean getMultipleThreadPerCollection() {
        return this.useMultipleThreadPerCollection;
    }

    public String getLockDirectory() {
        return this.getConfigPath() + File.separator + LockDirectoryName;
    }

    public void validate() throws GlobalConfigurationException {
        boolean createOk;
        File docQueueDir;
        String fullTempDirectory;
        File fullTempDir;
        String baseTempDirectory;
        Message msg;
        boolean createOk2;
        File tempDir;
        boolean createOk3;
        File installDirectory = new File(this.installPath);
        if (!installDirectory.exists()) {
            Message msg2 = new Message("G0039E.INSTALL_DIRECTORY_DOES_NOT_EXIST", this.installPath);
            throw new GlobalConfigurationException(msg2);
        }
        File configDirectory = new File(this.configPath);
        if (!configDirectory.exists()) {
            Message msg3 = new Message("G0040E.CONFIG_DIRECTORY_DOES_NOT_EXIST", this.configPath);
            throw new GlobalConfigurationException(msg3);
        }
        String[] installItemsNames = new String[]{"lib", ResourceSubdirectory};
        Vector<String> installMissingItems = FileUtils.validateDirectoryContains(this.installPath, installItemsNames);
        String[] configItemsNames = new String[]{DefaultsSubdirectory, "mimetypes.xml"};
        Vector<String> configMissingItems = FileUtils.validateDirectoryContains(this.configPath, configItemsNames);
        if (installMissingItems != null && installMissingItems.size() > 0 || configMissingItems != null && configMissingItems.size() > 0) {
            int i;
            StringBuffer sb;
            Message installMsg = null;
            Message configMsg = null;
            if (installMissingItems != null && installMissingItems.size() > 0) {
                sb = new StringBuffer(200);
                for (i = 0; i < installMissingItems.size(); ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(installMissingItems.elementAt(i).toString());
                }
                installMsg = new Message("G0041E.INSTALL_DIRECTORY_MISSING_FILES", this.installPath, sb.toString());
            }
            if (configMissingItems != null && configMissingItems.size() > 0) {
                sb = new StringBuffer(200);
                for (i = 0; i < configMissingItems.size(); ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(configMissingItems.elementAt(i).toString());
                }
                configMsg = new Message("G0042E.CONFIG_DIRECTORY_MISSING_FILES", this.configPath, sb.toString());
            }
            GlobalConfigurationException exception = null;
            if (installMsg != null && configMsg != null) {
                exception = new GlobalConfigurationException(installMsg, (Throwable)new GlobalConfigurationException(configMsg));
            } else if (installMsg != null) {
                exception = new GlobalConfigurationException(installMsg);
            } else if (configMsg != null) {
                exception = new GlobalConfigurationException(configMsg);
            }
            throw exception;
        }
        File logDirectory = new File(this.logPath);
        if (!logDirectory.exists() && !(createOk3 = logDirectory.mkdirs())) {
            Message msg4 = new Message("G0149E.COULD_NOT_CREATE_DIRECTORY", logDirectory.getAbsolutePath());
            throw new GlobalConfigurationException(msg4);
        }
        if (this.tempDirectory != null && this.tempDirectory.length() > 0 && !(tempDir = new File(this.tempDirectory)).exists() && !(createOk2 = tempDir.mkdirs())) {
            String oldTemp = this.tempDirectory;
            this.tempDirectory = null;
            String systemDirectory = this.getTempDirectory();
            msg = new Message("G0054W.COULD_NOT_CREATE_TEMP_DIRECTORY", oldTemp, systemDirectory);
            System.err.println(msg.getFormattedTextWithDisplayKey());
        }
        if (!(baseTempDirectory = this.getTempDirectory()).endsWith(File.separator)) {
            baseTempDirectory = baseTempDirectory + File.separator;
        }
        if (!(fullTempDir = new File(fullTempDirectory = baseTempDirectory + TempSubDirectoryName + "_" + this.getTempDirNumber() + File.separator)).exists()) {
            boolean createOk4 = fullTempDir.mkdirs();
            if (!createOk4) {
                msg = new Message("G0102E.COULD_NOT_CREATE_IQQ_TEMP_DIRECTORY", fullTempDirectory);
                throw new GlobalConfigurationException(msg);
            }
        } else {
            File tempFile = new File(fullTempDir, "dummy.txt");
            boolean createOk5 = false;
            try {
                createOk5 = tempFile.createNewFile();
                tempFile.delete();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!createOk5) {
                Message msg5 = new Message("G0139E.COULD_NOT_CREATE_FILE_IN_TEMP_DIR", fullTempDirectory);
                throw new GlobalConfigurationException(msg5);
            }
        }
        if (!(docQueueDir = new File(this.docQueueDirectory)).exists() && !(createOk = docQueueDir.mkdirs())) {
            Message msg6 = new Message("G0149E.COULD_NOT_CREATE_DIRECTORY", docQueueDir.getAbsolutePath());
            throw new GlobalConfigurationException(msg6);
        }
        this.setTempDirectory(fullTempDirectory);
        if (this.documentPipelineExtensionClassName != null && this.documentPipelineExtensionClassName.length() > 0) {
            try {
                this.documentPipelineExtensionClass = Class.forName(this.documentPipelineExtensionClassName);
                this.documentPipelineExtensionClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new GlobalConfigurationException(e);
            }
            catch (IllegalAccessException e) {
                throw new GlobalConfigurationException(e);
            }
            catch (InstantiationException e) {
                throw new GlobalConfigurationException(e);
            }
            catch (ClassCastException e) {
                throw new GlobalConfigurationException(e);
            }
        }
    }

    private void prepareDirectories(String globalConfigFileName) {
        if (this.installPath == null || this.installPath.length() == 0) {
            String globalConfigFileParentDir;
            File configFile = new File(globalConfigFileName);
            File globalConfigDirectoryObj = new File(configFile.getParent());
            this.installPath = globalConfigFileParentDir = globalConfigDirectoryObj.getParent();
        }
        if (this.configPath == null || this.configPath.length() == 0) {
            this.configPath = this.installPath + File.separator + "config";
        }
        if (this.logPath == null || this.logPath.length() == 0) {
            this.logPath = this.installPath + File.separator + "log";
        }
        if (this.tempDirectory != null) {
            if (this.tempDirectory.length() > 0) {
                if (!this.tempDirectory.endsWith(File.separator)) {
                    this.tempDirectory = this.tempDirectory + File.separator;
                }
            } else {
                this.tempDirectory = null;
            }
        }
        if (this.docQueueDirectory == null || this.docQueueDirectory.length() == 0) {
            this.docQueueDirectory = this.getConfigPath() + File.separator + DefaultDocQueueSubdirectory;
        } else if (this.docQueueDirectory.endsWith(File.separator)) {
            this.docQueueDirectory = this.docQueueDirectory.substring(0, this.docQueueDirectory.length() - File.separator.length());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("installPath:   " + this.getInstallPath() + "\n");
        buffer.append("logPath:    " + this.getLogPath() + "\n");
        buffer.append("configPath: " + this.getConfigPath() + "\n");
        buffer.append("number of indexers: " + this.getNumberOfIndexers() + "\n");
        buffer.append("java home directory:" + this.getJavaHome() + "\n");
        return buffer.toString();
    }

    public String getTempDirectory() {
        String directory = this.tempDirectory;
        if (directory == null) {
            directory = System.getProperty("java.io.tmpdir");
        }
        return directory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public String getShutdownFileName() {
        String fileName = this.getConfigPath() + File.separator + ShutdownFileName;
        return fileName;
    }

    public String getConfigFileName(String configSubDirName, String baseFileName) {
        String fileName = null;
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        String overrideDirectory = releaseInfo.getValue("System", "ConfigDirectoryOverride");
        if (overrideDirectory != null && overrideDirectory.length() > 0) {
            File f;
            fileName = this.getConfigPath() + File.separator + OverridesSubdirectory + File.separator + overrideDirectory + File.separator;
            if (configSubDirName != null) {
                fileName = fileName + configSubDirName + File.separator;
            }
            if (!(f = new File(fileName = fileName + baseFileName)).exists()) {
                fileName = null;
            }
        }
        if (fileName == null) {
            fileName = this.getConfigPath() + File.separator;
            if (configSubDirName != null) {
                fileName = fileName + configSubDirName + File.separator;
            }
            fileName = fileName + baseFileName;
        }
        return fileName;
    }

    private String getTempDirNumber() {
        File jettyFile;
        long tempDirNumber = 0L;
        if (this.configPath != null && (jettyFile = new File(this.getJettyConfigFilePath())).exists()) {
            try {
                JettyConfiguration jettyConfig = new JettyConfiguration(jettyFile);
                tempDirNumber = jettyConfig.getAdminHttpPort();
                if (tempDirNumber <= 0L) {
                    tempDirNumber = jettyConfig.getAdminHttpsPort();
                }
                if (tempDirNumber <= 0L) {
                    tempDirNumber = jettyConfig.getSearchHttpPort();
                }
                if (tempDirNumber <= 0L) {
                    tempDirNumber = jettyConfig.getSearchHttpsPort();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tempDirNumber <= 0L) {
            tempDirNumber = System.currentTimeMillis();
        }
        return String.valueOf(tempDirNumber);
    }
}

