/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.common.MetadataPart;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationChangeNotification;
import com.ibm.es.nuvo.configuration.FieldMapper;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.util.CrawlerAdminUtil;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMappingManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<String, MapperImpl> mappers = new TreeMap<String, MapperImpl>();
    private CollectionConfiguration collectionConfig;
    protected static final String ELEM_MAPPINGS = "mappings";
    private static final String ELEM_CRAWLSPACE = "crawlspace";
    private static final String ATTR_ID = "id";
    private static final String ELEM_FIELD_MAPPINGS = "fieldmappings";
    private static final String ELEM_MAPPING_RULES = "rules";
    private static final String ATTR_TYPE = "type";
    private static final String TYPE_FIELDS = "fields";
    private static final String TYPE_IMPLICIT = "implicit";
    private static final String ELEM_FIELD_MAPPING = "mapping";
    private static final String ATTR_NATIVE = "native";
    private static final String ATTR_FIELD = "field";

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + ELEM_MAPPINGS;
        tree.addSetSubcomponent(parentPath, "createHandler");
        ParseTreeHandler.prepareParseTree(parentPath, tree);
    }

    public void writeTo(XMLTagger tagger) {
        tagger.startElement(ELEM_MAPPINGS);
        for (MapperImpl mapper : this.mappers.values()) {
            mapper.writeTo(tagger);
        }
        tagger.endElement(ELEM_MAPPINGS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        for (MapperImpl mapper : this.mappers.values()) {
            sb.append(mapper.toString());
        }
        return sb.toString();
    }

    public ParseTreeHandler createHandler() {
        return new ParseTreeHandler(this);
    }

    FieldMapper getMapper(String crawlspaceId) {
        return crawlspaceId != null ? this.mappers.get(crawlspaceId) : null;
    }

    public Metadata map(Metadata metadata) {
        FieldMapper mapper = this.getMapper(metadata.get("CrawlSpaceID"));
        return mapper != null ? mapper.map(metadata) : metadata;
    }

    public List<FieldSource> getFieldSources(String name) {
        ArrayList<FieldSource> ret = new ArrayList<FieldSource>();
        for (MapperImpl mapper : this.mappers.values()) {
            mapper.dumpFieldSources(ret, name);
        }
        return ret;
    }

    public List<FieldMapping> getFieldMappings(String crawlspaceId) {
        MapperImpl mapper = this.mappers.get(crawlspaceId);
        if (mapper != null) {
            ArrayList<FieldMapping> ret = new ArrayList<FieldMapping>();
            mapper.dumpMappingRules(ret);
            return ret;
        }
        return null;
    }

    public Map<String, FieldMapping> getFieldMappingMap(String crawlspaceId) {
        List<FieldMapping> list = this.getFieldMappings(crawlspaceId);
        if (list == null) {
            return null;
        }
        TreeMap<String, FieldMapping> ret = new TreeMap<String, FieldMapping>();
        for (FieldMapping mapping : list) {
            ret.put(mapping.getNativeName(), mapping);
        }
        return ret;
    }

    public void addMapping(String crawlspaceId, String nativeName, String fieldName, boolean isImplicit) throws CrawlerControlException {
        MapperImpl mapper = this.mappers.get(crawlspaceId);
        if (mapper == null) {
            mapper = new MapperImpl(crawlspaceId);
            this.mappers.put(crawlspaceId, mapper);
        }
        if (mapper.addMapping(nativeName, fieldName, isImplicit)) {
            this.fireRebuildNeededNotification(crawlspaceId);
        }
    }

    public void removeMapping(String crawlspaceId, String nativeName, boolean isImplicit) throws CrawlerControlException {
        MapperImpl mapper = this.mappers.get(crawlspaceId);
        if (mapper != null && mapper.removeMapping(nativeName, isImplicit)) {
            this.fireRebuildNeededNotification(crawlspaceId);
        }
    }

    public void removeCrawlspace(String crawlspaceId) {
        this.mappers.remove(crawlspaceId);
    }

    public Metadata getCrawlspaceMetadata(String crawlspaceId) {
        MapperImpl mapper = this.mappers.get(crawlspaceId);
        return mapper != null ? mapper.getMetadata() : null;
    }

    public void setCrawlspaceMetadata(String crawlspaceId, Metadata metadata) throws CrawlerControlException {
        MapperImpl mapper = this.mappers.get(crawlspaceId);
        if (mapper == null) {
            mapper = new MapperImpl(crawlspaceId);
            this.mappers.put(crawlspaceId, mapper);
        }
        if (mapper.setMetadata(metadata)) {
            this.fireRebuildNeededNotification(crawlspaceId);
        }
    }

    void setCollectionConfiguration(CollectionConfiguration config) {
        this.collectionConfig = config;
    }

    private void fireRebuildNeededNotification(String crawlspaceId) throws CrawlerControlException {
        String colId;
        if (this.collectionConfig != null && CrawlerAdminUtil.hasInitialCrawlingStarted(colId = this.collectionConfig.getId(), crawlspaceId)) {
            ConfigurationChangeNotification.notifyCollectionRebuildNeeded(this.collectionConfig.getId());
        }
    }

    public static class ParseTreeHandler {
        private FieldMappingManager manager;
        private MapperImpl currentMapper;
        private boolean isCurrentImplicit;

        protected static void prepareParseTree(String parentPath, ParseTree tree) {
            parentPath = parentPath + "/crawlspace";
            tree.addSetSubcomponent(parentPath + "/" + "metadata", "createMetadata");
            Metadata.prepareParseTree(parentPath, tree);
            tree.addCallMethod(parentPath, "parseCrawlSpace", new String[]{FieldMappingManager.ATTR_ID}, new String[]{null});
            parentPath = parentPath + "/fieldmappings/rules";
            tree.addCallMethod(parentPath, "parseRules", new String[]{FieldMappingManager.ATTR_TYPE}, new String[]{null});
            parentPath = parentPath + "/mapping";
            tree.addCallMethod(parentPath, "parseMapping", new String[]{FieldMappingManager.ATTR_NATIVE, FieldMappingManager.ATTR_FIELD}, new String[]{null, null});
        }

        public ParseTreeHandler(FieldMappingManager manager) {
            this.manager = manager;
        }

        public void parseCrawlSpace(String id) {
            this.currentMapper = new MapperImpl(id);
            this.manager.mappers.put(id, this.currentMapper);
        }

        public void parseRules(String type) {
            this.isCurrentImplicit = FieldMappingManager.TYPE_IMPLICIT.equals(type);
        }

        public void parseMapping(String nativeName, String fieldName) {
            this.currentMapper.addMapping(nativeName, fieldName, this.isCurrentImplicit);
        }

        public Metadata createMetadata() {
            Metadata metadata = new Metadata();
            this.currentMapper.setMetadata(metadata);
            return metadata;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapperImpl
    implements FieldMapper {
        private String crawlspaceId;
        private Map<String, MapRule> fieldMappings;
        private Map<String, MapRule> implicitFieldMappings;
        private Metadata crawlspaceMetadata;
        private Metadata mappedCrawlspaceMetadata;

        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            String newline = System.getProperty("line.separator");
            sb.append("----- Mapping Rules for ").append(this.crawlspaceId).append(" -----").append(newline).append("FieldMappingRules : ").append(this.fieldMappings.values()).append(newline).append("ImplicitFieldMappingRules : ").append(this.implicitFieldMappings.values()).append(newline).append("##### CrawlspaceMetadata #####").append(newline).append(this.crawlspaceMetadata).append(newline).append("##############################").append(newline);
            return sb.toString();
        }

        MapperImpl(String crawlspaceId) {
            this.crawlspaceId = crawlspaceId;
            this.fieldMappings = new TreeMap<String, MapRule>();
            this.implicitFieldMappings = new TreeMap<String, MapRule>();
        }

        @Override
        public Metadata map(Metadata metadata) {
            Metadata ret = new Metadata();
            ret.setACL(metadata.getACL());
            if (this.crawlspaceMetadata != null) {
                if (this.mappedCrawlspaceMetadata == null) {
                    this.mappedCrawlspaceMetadata = new Metadata();
                    this.map(this.crawlspaceMetadata, this.mappedCrawlspaceMetadata);
                }
                ret.getMetadataPart(Metadata.Type.CrawlerMetadata).setAll(this.mappedCrawlspaceMetadata.getMetadataPart(Metadata.Type.CrawlerMetadata));
                ret.getMetadataPart(Metadata.Type.CrawlerImplicit).putAll(this.mappedCrawlspaceMetadata.getMetadataPart(Metadata.Type.CrawlerImplicit));
            }
            this.map(metadata, ret);
            return ret;
        }

        void writeTo(XMLTagger tagger) {
            tagger.openStartElement(FieldMappingManager.ELEM_CRAWLSPACE);
            tagger.writeAttr(FieldMappingManager.ATTR_ID, this.crawlspaceId);
            tagger.closeTag();
            tagger.startElement(FieldMappingManager.ELEM_FIELD_MAPPINGS);
            if (this.fieldMappings.size() > 0) {
                tagger.openStartElement(FieldMappingManager.ELEM_MAPPING_RULES);
                tagger.writeAttr(FieldMappingManager.ATTR_TYPE, FieldMappingManager.TYPE_FIELDS);
                tagger.closeTag();
                for (MapRule rule : this.fieldMappings.values()) {
                    rule.writeTo(tagger);
                }
                tagger.endElement(FieldMappingManager.ELEM_MAPPING_RULES);
            }
            if (this.implicitFieldMappings.size() > 0) {
                tagger.openStartElement(FieldMappingManager.ELEM_MAPPING_RULES);
                tagger.writeAttr(FieldMappingManager.ATTR_TYPE, FieldMappingManager.TYPE_IMPLICIT);
                tagger.closeTag();
                for (MapRule rule : this.implicitFieldMappings.values()) {
                    rule.writeTo(tagger);
                }
                tagger.endElement(FieldMappingManager.ELEM_MAPPING_RULES);
            }
            tagger.endElement(FieldMappingManager.ELEM_FIELD_MAPPINGS);
            if (this.crawlspaceMetadata != null) {
                this.crawlspaceMetadata.writeTo(tagger);
            }
            tagger.endElement(FieldMappingManager.ELEM_CRAWLSPACE);
        }

        boolean addMapping(String nativeName, String fieldName, boolean isImplicit) {
            this.mappedCrawlspaceMetadata = null;
            Map<String, MapRule> map = isImplicit ? this.implicitFieldMappings : this.fieldMappings;
            MapRule prev = map.put(nativeName, new MapRule(nativeName, fieldName, isImplicit));
            return prev == null || !prev.fieldName.equals(fieldName);
        }

        boolean removeMapping(String nativeName, boolean isImplicit) {
            this.mappedCrawlspaceMetadata = null;
            return (isImplicit ? this.implicitFieldMappings : this.fieldMappings).remove(nativeName) != null;
        }

        Metadata getMetadata() {
            return this.crawlspaceMetadata != null ? new Metadata(this.crawlspaceMetadata) : null;
        }

        boolean setMetadata(Metadata metadata) {
            boolean ret = metadata != null ? metadata.equals(this.crawlspaceMetadata) : this.crawlspaceMetadata == null;
            this.crawlspaceMetadata = metadata;
            this.mappedCrawlspaceMetadata = null;
            return !ret;
        }

        void dumpFieldSources(Collection<FieldSource> list, String fieldName) {
            for (MapRule rule : this.implicitFieldMappings.values()) {
                if (!fieldName.equals(rule.getFieldName())) continue;
                list.add(rule);
            }
            for (MapRule rule : this.fieldMappings.values()) {
                if (!fieldName.equals(rule.getFieldName())) continue;
                list.add(rule);
            }
        }

        void dumpMappingRules(Collection<FieldMapping> list) {
            list.addAll(this.implicitFieldMappings.values());
            list.addAll(this.fieldMappings.values());
        }

        private void map(Metadata src, Metadata dest) {
            dest.getMetadataPart(Metadata.Type.CrawlerMetadata).setAll(src.getMetadataPart(Metadata.Type.CrawlerMetadata));
            this.map(src.getMetadataPart(Metadata.Type.CrawlerImplicit), dest.getMetadataPart(Metadata.Type.CrawlerImplicit), this.implicitFieldMappings);
            this.map(src.getMetadataPart(Metadata.Type.CrawlerFields), dest.getMetadataPart(Metadata.Type.CrawlerFields), this.fieldMappings);
            dest.getMetadataPart(Metadata.Type.ParserMetadata).setAll(src.getMetadataPart(Metadata.Type.ParserMetadata));
        }

        private void map(MetadataPart src, MetadataPart dest, Map<String, MapRule> rules) {
            for (Map.Entry<String, MetadataPart.Value> entry : src.keyValues()) {
                String key = entry.getKey();
                MapRule rule = rules.get(key);
                if (rule != null) {
                    dest.add(rule.getFieldName(), entry.getValue());
                    continue;
                }
                dest.add(key, entry.getValue());
            }
        }

        private class MapRule
        implements FieldMapping {
            private String nativeName;
            private String fieldName;
            private boolean isImplicit;

            MapRule(String nativeName, String fieldName, boolean isImplicit) {
                this.nativeName = nativeName;
                this.fieldName = fieldName;
                this.isImplicit = isImplicit;
            }

            public String getId() {
                return MapperImpl.this.crawlspaceId;
            }

            public String getNativeName() {
                return this.nativeName;
            }

            public SourceType getType() {
                return SourceType.Crawler;
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public boolean isImplicit() {
                return this.isImplicit;
            }

            void writeTo(XMLTagger tagger) {
                tagger.openStartElement(FieldMappingManager.ELEM_FIELD_MAPPING);
                tagger.writeAttr(FieldMappingManager.ATTR_NATIVE, this.nativeName);
                tagger.writeAttr(FieldMappingManager.ATTR_FIELD, this.fieldName);
                tagger.closeEndElementTag();
            }

            public String toString() {
                return "[" + this.nativeName + "->" + this.fieldName + "]";
            }
        }
    }

    public static interface FieldMapping
    extends FieldSource {
        public String getFieldName();
    }

    public static interface FieldSource {
        public SourceType getType();

        public String getId();

        public String getNativeName();

        public boolean isImplicit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        Crawler,
        Parser,
        Other;

    }
}

