/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationChangeNotification;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDefinitions {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final String ELEM_FIELDS = "fields";
    static final String ELEM_FIELD = "field";
    static final String ATTR_NAME = "name";
    static final String ATTR_CATEGORY = "category";
    static final String ATTR_ENABLED = "enabled";
    static final String ELEM_FULL_TEXT_SEARCHABLE = "fulltextsearchable";
    static final String ELEM_FIELD_SEARCHABLE = "fieldsearchable";
    static final String ATTR_TOKENIZED = "tokenized";
    static final String ATTR_CASE_SENSITIVE = "casesensitive";
    static final String ATTR_SORTABLE = "sortable";
    static final String ATTR_LEMMATIZED = "lemmatized";
    static final String ELEM_PARAMETRIC_SEARCHABLE = "parametricsearchable";
    static final String ATTR_TYPE = "type";
    static final String ATTR_PRECISION = "precision";
    static final String ELEM_RETURNABLE = "returnable";
    static final String ELEM_DEFAULT_VALUE = "default";
    static final String TYPE_PREDEFINED = "predefined";
    private Map<String, FieldDefinition> userFields = new TreeMap<String, FieldDefinition>();
    private Map<String, FieldDefinition> predefinedFields = new TreeMap<String, FieldDefinition>();
    private Map<EnumSet<FieldType>, Map<String, FieldDefinition>> mapCache = new HashMap<EnumSet<FieldType>, Map<String, FieldDefinition>>();
    private static Map<String, FieldDefinition> builtInFields;
    private static Map<String, FieldDefinition> hiddenFields;
    private FieldDefinition current;
    private FieldDefinition defaultDefinition;
    private CollectionConfiguration collectionConfig;
    public static final EnumSet<FieldType> ALL;

    public static final FieldDefinitions createDefault() throws ExtendedException {
        CollectionConfiguration collection = CollectionConfiguration.createDefault();
        return collection.getFieldDefinitions();
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + ELEM_FIELDS;
        tree.addCallMethod(parentPath, "parseFields");
        String defaultPath = parentPath + "/" + ELEM_DEFAULT_VALUE;
        parentPath = parentPath + "/field";
        tree.addCallMethod(parentPath, "parseField", new String[]{ATTR_NAME, ATTR_CATEGORY, ATTR_TYPE}, null);
        parentPath = parentPath + "/";
        tree.addCallMethod(parentPath + ELEM_FULL_TEXT_SEARCHABLE, "parseFullTextSeachable", new String[]{ATTR_ENABLED}, null);
        tree.addCallMethod(parentPath + ELEM_FIELD_SEARCHABLE, "parseFieldSeachable", new String[]{ATTR_ENABLED, ATTR_TOKENIZED, ATTR_CASE_SENSITIVE, ATTR_SORTABLE, ATTR_LEMMATIZED}, null);
        tree.addCallMethod(parentPath + ELEM_PARAMETRIC_SEARCHABLE, "parseParametricSeachable", new String[]{ATTR_ENABLED, ATTR_TYPE, ATTR_PRECISION}, null);
        tree.addCallMethod(parentPath + ELEM_RETURNABLE, "parseReturnable", new String[]{ATTR_ENABLED}, null);
        tree.addCallMethod(parentPath + ELEM_DEFAULT_VALUE, "parseDefaultValue");
        tree.addCallMethod(defaultPath, "parseDefault", new String[]{ATTR_CATEGORY}, null);
        defaultPath = defaultPath + "/";
        tree.addCallMethod(defaultPath + ELEM_FULL_TEXT_SEARCHABLE, "parseFullTextSeachable", new String[]{ATTR_ENABLED}, null);
        tree.addCallMethod(defaultPath + ELEM_FIELD_SEARCHABLE, "parseFieldSeachable", new String[]{ATTR_ENABLED, ATTR_TOKENIZED, ATTR_CASE_SENSITIVE, ATTR_SORTABLE, ATTR_LEMMATIZED}, null);
        tree.addCallMethod(defaultPath + ELEM_PARAMETRIC_SEARCHABLE, "parseParametricSeachable", new String[]{ATTR_ENABLED, ATTR_TYPE, ATTR_PRECISION}, null);
        tree.addCallMethod(defaultPath + ELEM_RETURNABLE, "parseReturnable", new String[]{ATTR_ENABLED}, null);
        tree.addCallMethod(defaultPath + ELEM_DEFAULT_VALUE, "parseDefaultValue");
    }

    public void writeTo(XMLTagger tagger) {
        tagger.startElement(ELEM_FIELDS);
        for (FieldDefinition field : this.predefinedFields.values()) {
            field.writeTo(tagger, FieldType.Predefined);
        }
        for (FieldDefinition field : this.userFields.values()) {
            field.writeTo(tagger, null);
        }
        if (this.defaultDefinition != null) {
            this.defaultDefinition.writeTo(tagger, FieldType.Default);
        }
        tagger.endElement(ELEM_FIELDS);
    }

    public void parseFields() {
        this.userFields = new TreeMap<String, FieldDefinition>();
        this.predefinedFields = new TreeMap<String, FieldDefinition>();
        this.mapCache.clear();
    }

    public void parseField(String name, String category, String type) {
        if (name != null) {
            name = name.toLowerCase();
            Map<String, FieldDefinition> map = this.userFields;
            if (TYPE_PREDEFINED.equalsIgnoreCase(type)) {
                map = this.predefinedFields;
            }
            if (!this.userFields.containsKey(name) && !this.predefinedFields.containsKey(name)) {
                this.current = new FieldDefinition(name);
                if (category != null) {
                    this.current.setCategory(Boolean.parseBoolean(category));
                }
                map.put(name, this.current);
            }
        }
    }

    public void parseDefault(String category) {
        if (this.defaultDefinition == null) {
            this.current = new FieldDefinition(null);
            if (category != null) {
                this.current.setCategory(Boolean.parseBoolean(category));
            }
            this.defaultDefinition = this.current;
        }
    }

    public void parseFullTextSeachable(String enabled) {
        if (this.current != null && enabled != null) {
            this.current.setFullTextSearchable(Boolean.parseBoolean(enabled));
        }
    }

    public void parseFieldSeachable(String enabled, String tokenized, String caseSensitive, String sortable, String lemmatized) {
        if (this.current != null) {
            if (enabled != null) {
                this.current.setFieldSearchable(Boolean.parseBoolean(enabled));
            }
            FieldDefinition.FieldSearchAttributes attr = new FieldDefinition.FieldSearchAttributes();
            if (tokenized != null) {
                attr.setTokenized(Boolean.parseBoolean(tokenized));
            }
            if (caseSensitive != null) {
                attr.setCaseSensitive(Boolean.parseBoolean(caseSensitive));
            }
            if (sortable != null) {
                attr.setSortable(Boolean.parseBoolean(sortable));
            }
            if (lemmatized != null) {
                attr.setLemmatized(Boolean.parseBoolean(lemmatized));
            }
            this.current.setFieldSearchAttr(attr);
        }
    }

    public void parseParametricSeachable(String enabled, String type, String precision) {
        if (this.current != null) {
            if (enabled != null) {
                this.current.setParametricSearchable(Boolean.parseBoolean(enabled));
            }
            FieldDefinition.ParametricSearchAttributes attr = new FieldDefinition.ParametricSearchAttributes();
            if (type != null) {
                for (FieldDefinition.ParametricType t : FieldDefinition.ParametricType.values()) {
                    if (!t.name().equalsIgnoreCase(type)) continue;
                    attr.setType(t);
                    break;
                }
            }
            if (precision != null) {
                try {
                    attr.setPrecision(Integer.parseInt(precision));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            this.current.setParametricSearchAttr(attr);
        }
    }

    public void parseReturnable(String enabled) {
        if (this.current != null && enabled != null) {
            this.current.setReturnable(Boolean.parseBoolean(enabled));
        }
    }

    public void parseDefaultValue(String value) {
        if (this.current != null) {
            this.current.setDefaultValue(value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("UserFields : ").append(this.userFields.toString());
        sb.append(", PredefinedFields : ").append(this.predefinedFields.toString());
        if (this.defaultDefinition != null) {
            sb.append(", DefaultField : " + this.defaultDefinition);
        }
        return sb.toString();
    }

    public Map<String, FieldDefinition> getFieldDefinitions(EnumSet<FieldType> requiredTypes) {
        Map<String, FieldDefinition> ret = this.mapCache.get(requiredTypes);
        if (ret == null) {
            MapWithDefault<String, FieldDefinition> map = new MapWithDefault<String, FieldDefinition>();
            if (requiredTypes.contains((Object)FieldType.User)) {
                FieldDefinitions.addFieldDefinitions(this.userFields, map);
            }
            if (requiredTypes.contains((Object)FieldType.Predefined)) {
                FieldDefinitions.addFieldDefinitions(this.predefinedFields, map);
            }
            if (requiredTypes.contains((Object)FieldType.BuiltIn)) {
                FieldDefinitions.addFieldDefinitions(builtInFields, map);
            }
            if (requiredTypes.contains((Object)FieldType.Hidden)) {
                FieldDefinitions.addFieldDefinitions(hiddenFields, map);
            }
            if (requiredTypes.contains((Object)FieldType.Default) && this.defaultDefinition != null) {
                try {
                    map.setDefault((FieldDefinition)this.defaultDefinition.clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            this.mapCache.put(requiredTypes, map);
            ret = map;
        }
        return ret;
    }

    public FieldDefinition getDefaultDefinition() {
        return this.defaultDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertFieldDefinition(FieldDefinition definition, FieldType type) {
        Map<Object, Object> map;
        String name = definition.getName();
        boolean needRebuild = false;
        switch (type) {
            case User: {
                if (hiddenFields.containsKey(name) || builtInFields.containsKey(name) || this.predefinedFields.containsKey(name)) {
                    throw new IllegalArgumentException("The name " + name + " is reserved for internal use.");
                }
                map = this.userFields;
                synchronized (map) {
                    FieldDefinition prev = this.userFields.put(name, definition);
                    needRebuild = prev != null ? !prev.equals(definition) : false;
                    break;
                }
            }
            case Predefined: {
                if (hiddenFields.containsKey(name) || builtInFields.containsKey(name)) {
                    throw new IllegalArgumentException("The name " + name + " is reserved for internal use.");
                }
                map = this.predefinedFields;
                synchronized (map) {
                    if (this.predefinedFields.containsKey(name)) {
                    } else {
                        throw new IllegalArgumentException("Adding new predefined fields is not allowed.");
                    }
                    FieldDefinition prev = this.predefinedFields.put(name, definition);
                    needRebuild = prev != null ? !prev.equals(definition) : false;
                    break;
                }
            }
            case Default: {
                if (name != null) {
                    throw new IllegalArgumentException("Set null as field name for default.");
                }
                needRebuild = this.defaultDefinition != null ? !this.defaultDefinition.equals(definition) : true;
                this.defaultDefinition = definition;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + (Object)((Object)type) + " cannot be modified.");
            }
        }
        map = this.mapCache;
        synchronized (map) {
            this.mapCache.clear();
        }
        if (needRebuild) {
            this.fireRebuildNeededNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFieldDefinition(String name, FieldType type) {
        Map<Object, Object> map;
        switch (type) {
            case User: {
                map = this.userFields;
                synchronized (map) {
                    this.userFields.remove(name);
                    this.fireRebuildNeededNotification();
                    break;
                }
            }
            case Default: {
                if (name != null) {
                    throw new IllegalArgumentException("Do not specify name for default.");
                }
                this.defaultDefinition = null;
                this.fireRebuildNeededNotification();
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + (Object)((Object)type) + " cannot be removed.");
            }
        }
        map = this.mapCache;
        synchronized (map) {
            this.mapCache.clear();
        }
    }

    void setCollectionConfiguration(CollectionConfiguration config) {
        this.collectionConfig = config;
    }

    private void fireRebuildNeededNotification() {
        if (this.collectionConfig != null) {
            boolean haveQueueWithNoDocsProcessed;
            String collectionId = this.collectionConfig.getId();
            GlobalSystem gs = GlobalSystem.getSingleInstance();
            DocumentQueueInterface dq = gs.getDocumentQueue();
            IndexerMonitor im = gs.getIndexerMonitor();
            boolean indexEmpty = im != null && im.getNumberOfDocuments(collectionId) == 0L;
            boolean bl = haveQueueWithNoDocsProcessed = dq != null && dq.getCounter() == 0;
            if (!indexEmpty || !haveQueueWithNoDocsProcessed) {
                ConfigurationChangeNotification.notifyCollectionRebuildNeeded(this.collectionConfig.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addFieldDefinitions(Map<String, FieldDefinition> src, Map<String, FieldDefinition> dest) {
        Map<String, FieldDefinition> map = src;
        synchronized (map) {
            for (FieldDefinition def : src.values()) {
                try {
                    dest.put(def.getName(), (FieldDefinition)def.clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        ALL = EnumSet.of(FieldType.User, FieldType.Predefined, FieldType.BuiltIn, FieldType.Hidden, FieldType.Default);
        TreeMap<String, FieldDefinition> tmp = new TreeMap<String, FieldDefinition>();
        FieldDefinition def = new FieldDefinition("charset");
        def.setFieldSearchable(true);
        FieldDefinition.FieldSearchAttributes attr = new FieldDefinition.FieldSearchAttributes(false);
        attr.setSortable(true);
        def.setFieldSearchAttr(attr);
        def.setReturnable(true);
        tmp.put(def.getName(), def);
        def = new FieldDefinition("title");
        def.setFullTextSearchable(true);
        def.setFieldSearchable(true);
        def.setReturnable(true);
        tmp.put(def.getName(), def);
        def = new FieldDefinition("language");
        def.setFieldSearchable(true);
        def.setFieldSearchAttr(new FieldDefinition.FieldSearchAttributes(false));
        def.setReturnable(true);
        tmp.put(def.getName(), def);
        builtInFields = Collections.unmodifiableMap(tmp);
        tmp = new TreeMap();
        def = new FieldDefinition("_stype");
        def.setFieldSearchable(true);
        def.setFieldSearchAttr(new FieldDefinition.FieldSearchAttributes(false));
        def.setReturnable(true);
        tmp.put(def.getName(), def);
        def = new FieldDefinition("_xmlvals");
        def.setFullTextSearchable(true);
        tmp.put(def.getName(), def);
        def = new FieldDefinition("_plain");
        def.setFullTextSearchable(true);
        def.setFieldSearchable(false);
        def.setParametricSearchable(false);
        def.setReturnable(false);
        tmp.put(def.getName(), def);
        def = new FieldDefinition("_code");
        def.setParametricSearchable(true);
        def.setParametricSearchAttr(new FieldDefinition.ParametricSearchAttributes(FieldDefinition.ParametricType.Decimal));
        def.setReturnable(true);
        def.setFieldSearchable(true);
        def.setFieldSearchAttr(new FieldDefinition.FieldSearchAttributes(false));
        tmp.put(def.getName(), def);
        def = new FieldDefinition("uri");
        def.setReturnable(true);
        def.setFieldSearchable(true);
        attr = new FieldDefinition.FieldSearchAttributes(false);
        attr.setCaseSensitive(true);
        def.setFieldSearchAttr(attr);
        tmp.put(def.getName(), def);
        hiddenFields = Collections.unmodifiableMap(tmp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapWithDefault<K, V>
    extends TreeMap<K, V> {
        private static final long serialVersionUID = 4808723514239023220L;
        private V defaultValue;

        private MapWithDefault() {
        }

        @Override
        public boolean containsKey(Object key) {
            boolean ret = super.containsKey(key);
            return ret ? true : this.defaultValue != null;
        }

        @Override
        public V get(Object key) {
            Object ret = super.get(key);
            return ret == null ? this.defaultValue : ret;
        }

        public void setDefault(V value) {
            this.defaultValue = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FieldType {
        User,
        Predefined,
        BuiltIn,
        Hidden,
        Default;

    }
}

