/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.util.XMLTagger;

public class FieldDefinition
implements Cloneable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String name;
    private Boolean isCategory;
    private Boolean isFullTextSearchable;
    private Boolean isParametricSearchable;
    private Boolean isFieldSearchable;
    private Boolean isReturnable;
    private FieldSearchAttributes fieldSearchAttr = new FieldSearchAttributes();
    private ParametricSearchAttributes parametricSearchAttr = new ParametricSearchAttributes();
    private String defaultValue;

    protected Object clone() throws CloneNotSupportedException {
        FieldDefinition ret = new FieldDefinition(this.name);
        ret.isCategory = this.isCategory;
        ret.isFullTextSearchable = this.isFullTextSearchable;
        ret.isParametricSearchable = this.isParametricSearchable;
        ret.isFieldSearchable = this.isFieldSearchable;
        ret.isReturnable = this.isReturnable;
        if (this.fieldSearchAttr != null) {
            ret.fieldSearchAttr = (FieldSearchAttributes)this.fieldSearchAttr.clone();
        }
        if (this.parametricSearchAttr != null) {
            ret.parametricSearchAttr = (ParametricSearchAttributes)this.parametricSearchAttr.clone();
        }
        ret.defaultValue = this.defaultValue;
        return ret;
    }

    public boolean equals(Object o) {
        if (o instanceof FieldDefinition) {
            boolean ret;
            FieldDefinition other = (FieldDefinition)o;
            boolean bl = ret = this.isCategory() == other.isCategory() && this.isFieldSearchable() == other.isFieldSearchable() && this.isFullTextSearchable() == other.isFullTextSearchable() && this.isParametricSearchable() == other.isParametricSearchable() && this.isReturnable() == other.isReturnable();
            if (ret) {
                ret = this.getFieldSearchAttr().equals(other.getFieldSearchAttr());
            }
            if (ret) {
                ret = this.getParametricSearchAttr().equals(other.getParametricSearchAttr());
            }
            if (ret) {
                ret = this.getName() == null ? other.getName() == null : this.getName().equals(other.getName());
            }
            if (ret) {
                ret = this.getDefaultValue() == null ? other.getDefaultValue() == null : this.getDefaultValue().equals(other.getDefaultValue());
            }
            return ret;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public FieldDefinition(String name) {
        if (name != null) {
            this.name = name.toLowerCase();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isCategory() {
        return this.isCategory != null ? this.isCategory : false;
    }

    public boolean isFieldSearchable() {
        return this.isFieldSearchable != null ? this.isFieldSearchable : false;
    }

    public boolean isFullTextSearchable() {
        return this.isFullTextSearchable != null ? this.isFullTextSearchable : false;
    }

    public boolean isParametricSearchable() {
        return this.isParametricSearchable != null ? this.isParametricSearchable : false;
    }

    public FieldSearchAttributes getFieldSearchAttr() {
        return this.fieldSearchAttr != null ? this.fieldSearchAttr : new FieldSearchAttributes();
    }

    public ParametricSearchAttributes getParametricSearchAttr() {
        return this.parametricSearchAttr != null ? this.parametricSearchAttr : new ParametricSearchAttributes();
    }

    public boolean isReturnable() {
        return this.isReturnable != null ? this.isReturnable : true;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setCategory(boolean isCategory) {
        this.isCategory = isCategory;
    }

    public void setFieldSearchable(boolean isFieldSearchable) {
        this.isFieldSearchable = isFieldSearchable;
    }

    public void setFullTextSearchable(boolean isFullTextSearchable) {
        this.isFullTextSearchable = isFullTextSearchable;
    }

    public void setParametricSearchable(boolean isParametricSearchable) {
        this.isParametricSearchable = isParametricSearchable;
    }

    public void setFieldSearchAttr(FieldSearchAttributes fieldSearchAttr) {
        try {
            this.fieldSearchAttr = (FieldSearchAttributes)fieldSearchAttr.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void setParametricSearchAttr(ParametricSearchAttributes parametricSearchAttr) {
        try {
            this.parametricSearchAttr = (ParametricSearchAttributes)parametricSearchAttr.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void setReturnable(boolean isReturnable) {
        this.isReturnable = isReturnable;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void writeTo(XMLTagger tagger, FieldDefinitions.FieldType type) {
        if (FieldDefinitions.FieldType.Default.equals((Object)type)) {
            tagger.openStartElement("default");
        } else {
            tagger.openStartElement("field");
            tagger.writeAttr("name", this.name);
        }
        if (this.isCategory != null) {
            tagger.writeAttr("category", this.isCategory.toString());
        }
        if (FieldDefinitions.FieldType.Predefined.equals((Object)type)) {
            tagger.writeAttr("type", "predefined");
        }
        tagger.closeTag();
        if (this.isFullTextSearchable != null) {
            tagger.openStartElement("fulltextsearchable");
            tagger.writeAttr("enabled", this.isFullTextSearchable.toString());
            tagger.closeEndElementTag();
        }
        if (this.isFieldSearchable != null) {
            tagger.openStartElement("fieldsearchable");
            tagger.writeAttr("enabled", this.isFieldSearchable.toString());
            if (this.fieldSearchAttr != null) {
                this.fieldSearchAttr.writeTo(tagger);
            }
            tagger.closeEndElementTag();
        }
        if (this.isParametricSearchable != null) {
            tagger.openStartElement("parametricsearchable");
            tagger.writeAttr("enabled", this.isParametricSearchable.toString());
            if (this.parametricSearchAttr != null) {
                this.parametricSearchAttr.writeTo(tagger);
            }
            tagger.closeEndElementTag();
        }
        if (this.isReturnable != null) {
            tagger.openStartElement("returnable");
            tagger.writeAttr("enabled", this.isReturnable.toString());
            tagger.closeEndElementTag();
        }
        if (this.defaultValue != null) {
            tagger.startElement("default");
            tagger.writeText(this.defaultValue);
            tagger.endElement("default");
        }
        if (FieldDefinitions.FieldType.Default.equals((Object)type)) {
            tagger.endElement("default");
        } else {
            tagger.endElement("field");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.name).append(" <");
        if (this.isCategory()) {
            sb.append("Category,");
        }
        if (this.isFullTextSearchable()) {
            sb.append("FullText,");
        }
        if (this.isFieldSearchable()) {
            sb.append("Field(").append(this.getFieldSearchAttr().toString()).append("),");
        }
        if (this.isParametricSearchable()) {
            sb.append("Parametric(").append(this.getParametricSearchAttr().toString()).append("),");
        }
        if (this.isReturnable()) {
            sb.append("Return,");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue=").append(this.getDefaultValue());
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(">");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParametricType {
        Decimal,
        Date;

    }

    public static class ParametricSearchAttributes
    implements Cloneable {
        private ParametricType type;
        private Integer precision;
        private static final ParametricType defaultType = ParametricType.Decimal;
        private static final int defaultPrecision = 3;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean equals(Object o) {
            if (o instanceof ParametricSearchAttributes) {
                ParametricSearchAttributes other = (ParametricSearchAttributes)o;
                boolean ret = this.getType().equals((Object)other.getType());
                if (ret) {
                    ret = this.getPrecision() == other.getPrecision();
                }
                return ret;
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public ParametricSearchAttributes() {
        }

        public ParametricSearchAttributes(ParametricType type) {
            this();
            this.type = type;
        }

        public ParametricType getType() {
            return this.type != null ? this.type : defaultType;
        }

        public void setType(ParametricType type) {
            this.type = type;
        }

        public int getPrecision() {
            return this.precision != null ? this.precision : 3;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        void writeTo(XMLTagger tagger) {
            if (this.type != null) {
                tagger.writeAttr("type", this.type.toString().toLowerCase());
            }
            if (this.precision != null) {
                tagger.writeAttr("precision", this.precision.toString());
            }
        }

        public String toString() {
            return "Type=" + this.getType().toString() + ", Precision=" + this.precision;
        }
    }

    public static class FieldSearchAttributes
    implements Cloneable {
        private Boolean isTokenized;
        private Boolean isCaseSensitive;
        private Boolean isSortable;
        private Boolean isLemmatized;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean equals(Object o) {
            if (o instanceof FieldSearchAttributes) {
                FieldSearchAttributes other = (FieldSearchAttributes)o;
                return this.isCaseSensitive() == other.isCaseSensitive() && this.isLemmatized() == other.isLemmatized() && this.isSortable() == other.isSortable() && this.isTokenized() == other.isTokenized();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public FieldSearchAttributes() {
        }

        public FieldSearchAttributes(boolean isTokenized) {
            this();
            this.isTokenized = isTokenized;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive != null ? this.isCaseSensitive : !this.isTokenized();
        }

        public boolean isSortable() {
            return this.isSortable != null ? this.isSortable : false;
        }

        public boolean isTokenized() {
            return this.isTokenized != null ? this.isTokenized : true;
        }

        public boolean isLemmatized() {
            return this.isLemmatized != null ? this.isLemmatized : true;
        }

        public void setCaseSensitive(boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
        }

        public void setSortable(boolean isSortable) {
            this.isSortable = isSortable;
        }

        public void setTokenized(boolean isTokenized) {
            this.isTokenized = isTokenized;
        }

        public void setLemmatized(boolean isLemmatized) {
            this.isLemmatized = isLemmatized;
        }

        void writeTo(XMLTagger tagger) {
            if (this.isTokenized != null) {
                tagger.writeAttr("tokenized", this.isTokenized.toString());
            }
            if (this.isCaseSensitive != null) {
                tagger.writeAttr("casesensitive", this.isCaseSensitive.toString());
            }
            if (this.isSortable != null) {
                tagger.writeAttr("sortable", this.isSortable.toString());
            }
            if (this.isLemmatized != null) {
                tagger.writeAttr("lemmatized", this.isLemmatized.toString());
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(16);
            sb.append(this.isTokenized() ? "t" : "-").append(this.isCaseSensitive() ? "c" : "-").append(this.isSortable() ? "s" : "-").append(this.isLemmatized() ? "l" : "-");
            return sb.toString();
        }
    }
}

