/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.api.DocumentPipelineExtension;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;

public class DocumentPipelineExtensionManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static DocumentPipelineExtensionManager instance = null;
    private HashMap<String, DocumentPipelineExtension> openExtensions = new HashMap();

    public static DocumentPipelineExtensionManager getInstance() {
        if (instance == null) {
            instance = new DocumentPipelineExtensionManager();
        }
        return instance;
    }

    private DocumentPipelineExtensionManager() {
    }

    public synchronized DocumentPipelineExtension getExtension(String collectionId) {
        DocumentPipelineExtension extension = this.accessOpenExtension(collectionId, true);
        return extension;
    }

    public synchronized void notifyCollectionCreated(String collectionId) {
        DocumentPipelineExtension extension = this.createExtension(collectionId);
        if (extension != null) {
            try {
                String configDir = GlobalConfiguration.getConfiguration().getConfigPath();
                String collectionDir = CollectionConfiguration.buildCollectionPath(collectionId);
                extension.create(collectionId, configDir, collectionDir);
            }
            catch (Exception e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Message msg = new Message("G0171E.ERROR_PROCESSING_DOCUMENT_PIPELINE_EXTENSION", collectionId);
                    ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, ee);
                }
                e.printStackTrace();
            }
        }
    }

    public synchronized void notifyCollectionDeleted(String collectionId) {
        DocumentPipelineExtension extension = this.accessOpenExtension(collectionId, true);
        if (extension != null) {
            try {
                extension.delete();
            }
            catch (Exception e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Message msg = new Message("G0171E.ERROR_PROCESSING_DOCUMENT_PIPELINE_EXTENSION", collectionId);
                    ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, ee);
                }
                e.printStackTrace();
            }
            this.closeExtension(collectionId);
        }
    }

    public synchronized DocumentPipelineExtension closeExtension(String collectionId) {
        DocumentPipelineExtension extension = this.openExtensions.remove(collectionId);
        if (extension != null) {
            this.closeExtensionFor(collectionId, extension);
        }
        return extension;
    }

    public synchronized void closeAllExtensions() {
        Set<String> extensionKeys = this.openExtensions.keySet();
        for (String collectionId : extensionKeys) {
            this.closeExtensionFor(collectionId, this.openExtensions.get(collectionId));
        }
        this.openExtensions.clear();
    }

    private DocumentPipelineExtension accessOpenExtension(String collectionId, boolean createIfNecessary) {
        DocumentPipelineExtension extension = null;
        Class<DocumentPipelineExtension> extensionClass = GlobalConfiguration.getConfiguration().getDocumentPipelineExtensionClass();
        if (extensionClass != null && (extension = this.openExtensions.get(collectionId)) == null && createIfNecessary && (extension = this.createExtension(collectionId)) != null) {
            try {
                String configDir = GlobalConfiguration.getConfiguration().getConfigPath();
                String collectionDir = CollectionConfiguration.buildCollectionPath(collectionId);
                extension.open(collectionId, configDir, collectionDir);
                this.openExtensions.put(collectionId, extension);
            }
            catch (Exception e) {
                extension = null;
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Message msg = new Message("G0171E.ERROR_PROCESSING_DOCUMENT_PIPELINE_EXTENSION", collectionId);
                    ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, ee);
                }
                e.printStackTrace();
            }
        }
        return extension;
    }

    private DocumentPipelineExtension createExtension(String collectionId) {
        DocumentPipelineExtension extension = null;
        Class<DocumentPipelineExtension> extensionClass = GlobalConfiguration.getConfiguration().getDocumentPipelineExtensionClass();
        if (extensionClass != null) {
            try {
                extension = extensionClass.newInstance();
            }
            catch (Exception e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Message msg = new Message("G0171E.ERROR_PROCESSING_DOCUMENT_PIPELINE_EXTENSION", collectionId);
                    ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, ee);
                }
                e.printStackTrace();
            }
        }
        return extension;
    }

    private void closeExtensionFor(String collectionId, DocumentPipelineExtension extension) {
        try {
            extension.close();
        }
        catch (Exception e) {
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Message msg = new Message("G0171E.ERROR_PROCESSING_DOCUMENT_PIPELINE_EXTENSION", collectionId);
                ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                Loggers.logger.log(Level.SEVERE, ee);
            }
            e.printStackTrace();
        }
    }
}

