/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.BaseConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryBasedConfigurationManager
extends BaseConfigurationManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    protected abstract String getBaseDirectory();

    protected abstract boolean isDirectoryValid(File var1);

    protected String buildIdDirectoryName(String id) {
        String pathName = this.getBaseDirectory();
        if (!pathName.endsWith(File.separator)) {
            pathName = pathName + File.separator;
        }
        pathName = pathName + id;
        return pathName;
    }

    protected Vector<String> getIds() {
        Vector objIdList = this.configurationCache.getAllNames();
        Vector<String> idList = new Vector<String>();
        for (int i = 0; i < objIdList.size(); ++i) {
            idList.add(objIdList.get(i).toString());
        }
        String pathName = this.getBaseDirectory();
        File file = new File(pathName);
        File[] files = file.listFiles();
        if (files != null && files.length > idList.size()) {
            for (int i = 0; i < files.length; ++i) {
                String dirId;
                if (!this.isDirectoryValid(files[i]) || idList.contains(dirId = this.generateIdFromFile(files[i]))) continue;
                idList.add(dirId);
            }
        }
        return idList;
    }

    protected boolean idExists(String id) {
        boolean found = false;
        try {
            Object obj = this.configurationCache.get(id);
            found = obj != null;
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        return found;
    }

    protected Vector<String> removeIdDirectory(String id) {
        Vector<String> filesCouldNotDelete;
        block2: {
            String pathName = this.buildIdDirectoryName(id);
            File configurationDirectory = new File(pathName);
            filesCouldNotDelete = FileUtils.removeDirectory(configurationDirectory);
            try {
                this.configurationCache.destroy(id);
            }
            catch (CacheException e) {
                if (!Loggers.tracer.isLoggable(Level.FINE)) break block2;
                Message msg = new Message("G0002I.TRACE_MESSAGE", "Error removing object from cache for id " + id + "  Error " + e);
                Loggers.tracer.log(Level.FINE, msg);
            }
        }
        this.firePropertyChangeEvent("ConfigurationObjectRemoved", null, id);
        return filesCouldNotDelete;
    }

    protected void createConfigDirctory(String id) throws ConfigurationManagerException {
        Message msg = FileUtils.isValidDirectoryName(id, false);
        if (msg == null) {
            boolean createOk;
            String pathName = this.buildIdDirectoryName(id);
            File configDirectory = new File(pathName);
            if (!configDirectory.exists() && !(createOk = configDirectory.mkdirs())) {
                Message errorMsg = new Message("G0105E.DIRECTORY_CREATE_FAILED", pathName);
                throw new ConfigurationManagerException(errorMsg);
            }
        } else {
            throw new ConfigurationManagerException(msg);
        }
    }

    protected void removeObjectIdFromCache(String objectId) {
        block2: {
            try {
                this.configurationCache.destroy(objectId);
            }
            catch (CacheException e) {
                if (!Loggers.tracer.isLoggable(Level.FINE)) break block2;
                Message msg = new Message("G0002I.TRACE_MESSAGE", "Error removing object from cache for id " + objectId + "  Error " + e);
                Loggers.tracer.log(Level.FINE, msg);
            }
        }
    }

    protected void notifyDirectoryDeleted(String subDirectoryName) {
        this.removeObjectIdFromCache(subDirectoryName);
    }

    protected String generateIdFromFile(File file) {
        return file.getName();
    }
}

