/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationLock;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectCreateException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.configuration.DirectoryBasedConfigurationManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.util.FileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CrawlspaceConfigurationManager
extends DirectoryBasedConfigurationManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String crawlspaceFileName = null;
    protected Object fileIOLock = new Object();
    private String crawlspaceFileType = null;

    protected abstract void updateCrawlerForNewConfig(String var1, Object var2) throws ConfigurationManagerException;

    protected abstract void doRemoveCrawler(String var1) throws ConfigurationManagerException;

    protected abstract Object loadConfiguration(InputStream var1, String var2) throws ExtendedException;

    protected abstract void writeConfiguration(Object var1, String var2) throws IOException, ExtendedException;

    protected CrawlspaceConfigurationManager(String crawlspaceFileName, String crawlspaceFileType) {
        this.crawlspaceFileName = crawlspaceFileName;
        this.crawlspaceFileType = crawlspaceFileType;
    }

    protected Object getCrawlspace(String collectionId) throws ConfigurationManagerException {
        try {
            return this.configurationCache.get(collectionId);
        }
        catch (CacheException e) {
            throw new ConfigurationManagerException(e);
        }
    }

    protected Object getCrawlspaceForUpdate(String collectionId) throws ConfigurationManagerException {
        Object crawlSpaceConfig = null;
        try {
            crawlSpaceConfig = this.load(collectionId);
            this.markAsUpdateable(crawlSpaceConfig);
        }
        catch (CacheException e) {
            throw new ConfigurationManagerException(e);
        }
        return crawlSpaceConfig;
    }

    public Vector<String> getCollectionIds() {
        return this.getIds();
    }

    public boolean crawlspaceExists(String collectionId) {
        return this.idExists(collectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCrawlspace(Object config, String collectionId) throws ConfigurationObjectCreateException {
        ConfigurationManager cfgMgr = ConfigurationManager.getConfigurationManager();
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            if (this.crawlspaceExists(collectionId)) {
                Message msg = new Message("G0060E.CRAWLSPACE_ALREADY_EXISTS", collectionId);
                throw new ConfigurationObjectCreateException(msg);
            }
            if (!cfgMgr.collectionExists(collectionId)) {
                Message msg = new Message("G0065E.COLLECTION_DOES_NOT_EXIST_ERROR", collectionId);
                throw new ConfigurationObjectCreateException(msg);
            }
            try {
                this.writeConfiguration(config, collectionId);
                this.removeFromUpdateableList(config);
                this.firePropertyChangeEvent("ConfigurationObjectCreated", null, collectionId);
            }
            catch (Exception e) {
                Message msg = new Message("G0061E.CRAWLSPACE_CREATE_ERROR", collectionId);
                throw new ConfigurationObjectCreateException(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCrawlspace(String collectionId, Object crawlSpaceConfig) throws ConfigurationManagerException, ConfigurationObjectNotExistsException {
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            if (!this.isUpdateable(crawlSpaceConfig)) {
                String msg = "Error!!  Tried to update non updatable crawlSpaceConfig.  You need to get the crawlspace by getCrawlspaceForUpdate()!!!";
                throw new RuntimeException(msg);
            }
            if (!this.crawlspaceExists(collectionId)) {
                Message msg = new Message("G0064E.CRAWLSPACE_DOES_NOT_EXIST_ERROR", collectionId);
                throw new ConfigurationObjectNotExistsException(msg);
            }
            try {
                this.writeConfiguration(crawlSpaceConfig, collectionId);
                this.removeFromUpdateableList(crawlSpaceConfig);
                this.configurationCache.replace(collectionId, crawlSpaceConfig, false);
                this.updateCrawlerForNewConfig(collectionId, crawlSpaceConfig);
                this.firePropertyChangeEvent("ConfigurationObjectUpdated", null, collectionId);
            }
            catch (Exception e) {
                Message msg = new Message("G0062E.CRAWLSPACE_UPDATE_ERROR", collectionId);
                throw new ConfigurationManagerException(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCrawlspace(String collectionId) throws ConfigurationObjectNotExistsException, ConfigurationManagerException {
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            if (!this.crawlspaceExists(collectionId)) {
                Message msg = new Message("G0057W.REMOVE_CRAWLSPACE_NOT_EXISTS", collectionId);
                throw new ConfigurationObjectNotExistsException(msg);
            }
            try {
                this.doRemoveCrawler(collectionId);
            }
            catch (ExtendedException e1) {
                throw new ConfigurationManagerException(e1);
            }
            this.removeObjectIdFromCache(collectionId);
            String crawlspaceFile = this.buildFullyQualifiedFileName(collectionId);
            File f = new File(crawlspaceFile);
            boolean deleteOk = false;
            Object object2 = this.fileIOLock;
            synchronized (object2) {
                deleteOk = f.delete();
            }
            if (!deleteOk) {
                Message msg = new Message("G0058E.CRAWLSPACE_FILE_DELETE_ERROR", crawlspaceFile, collectionId);
                ConfigurationManagerException ce = new ConfigurationManagerException(msg);
                throw ce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(Object name) throws CacheException {
        String collectionId = (String)name;
        Object crawlspaceConfig = null;
        Object object = this.fileIOLock;
        synchronized (object) {
            String crawlspaceFileNameBuilt = this.buildFullyQualifiedFileName(collectionId);
            try {
                File crawlerConfigFile = new File(crawlspaceFileNameBuilt);
                FileInputStream configFileStream = null;
                try {
                    configFileStream = new FileInputStream(crawlerConfigFile);
                    crawlspaceConfig = this.loadConfiguration(configFileStream, collectionId);
                }
                catch (FileNotFoundException e) {
                    Message msg = new Message("G0064E.CRAWLSPACE_DOES_NOT_EXIST_ERROR", collectionId);
                    throw new ConfigurationObjectNotExistsException(msg, (Throwable)e);
                }
                finally {
                    try {
                        if (configFileStream != null) {
                            configFileStream.close();
                        }
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Exception e) {
                Message msg = new Message("G0059E.CRAWLSPACE_LOAD_ERROR", crawlspaceFileNameBuilt);
                throw new CacheException(msg, (Throwable)e);
            }
        }
        return crawlspaceConfig;
    }

    @Override
    protected boolean isDirectoryValid(File crawlspaceDirectory) {
        boolean isValid = false;
        if (crawlspaceDirectory.isDirectory()) {
            FileFilter xmlFilter = new FileFilter(this.crawlspaceFileName, this.crawlspaceFileType);
            String[] crawlspaceDirectoryList = crawlspaceDirectory.list(xmlFilter);
            isValid = crawlspaceDirectoryList != null && crawlspaceDirectoryList.length > 0;
        }
        return isValid;
    }

    @Override
    protected String getBaseDirectory() {
        String pathName = GlobalConfiguration.getConfiguration().getCollectionPath();
        return pathName;
    }

    protected String buildFullyQualifiedFileName(String collectionId) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.buildIdDirectoryName(collectionId));
        sb.append(File.separator);
        sb.append(this.crawlspaceFileName);
        sb.append('.');
        sb.append(this.crawlspaceFileType);
        return sb.toString();
    }
}

