/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.api.CrawlService;
import com.ibm.es.nuvo.configuration.WebCrawlServiceImpl;
import com.ibm.es.nuvo.configuration.crawler.CrawlerConfigurationInterface;
import com.ibm.es.nuvo.configuration.crawler.WebCrawlerConfiguration;
import com.ibm.es.nuvo.util.Constants;

public class CrawlServiceFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static CrawlServiceFactory singleInstance = null;

    public static CrawlServiceFactory getInstance() {
        if (singleInstance == null) {
            singleInstance = new CrawlServiceFactory();
        }
        return singleInstance;
    }

    private CrawlServiceFactory() {
    }

    public CrawlService getServiceFor(Constants.CrawlerType type) {
        CrawlService service = null;
        if (Constants.CrawlerType.Web.equals((Object)type)) {
            service = WebCrawlServiceImpl.getCrawlService();
        }
        return service;
    }

    public CrawlService[] getAllServices() {
        Constants.CrawlerType[] types = Constants.CrawlerType.values();
        CrawlService[] services = new CrawlService[types.length];
        for (int i = 0; i < types.length; ++i) {
            services[i] = this.getServiceFor(types[i]);
        }
        return services;
    }

    public CrawlerConfigurationInterface getConfigInterfaceFor(Constants.CrawlerType type) {
        CrawlerConfigurationInterface mgr = null;
        if (Constants.CrawlerType.Web.equals((Object)type)) {
            mgr = WebCrawlerConfiguration.getInstance();
        }
        return mgr;
    }

    public CrawlerConfigurationInterface[] getAllConfigInterfaces() {
        Constants.CrawlerType[] types = Constants.CrawlerType.values();
        CrawlerConfigurationInterface[] mgrs = new CrawlerConfigurationInterface[types.length];
        for (int i = 0; i < types.length; ++i) {
            mgrs[i] = this.getConfigInterfaceFor(types[i]);
        }
        return mgrs;
    }
}

