/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.api.CrawlService;
import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionBadStateException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationLock;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectCreateException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.configuration.ConfigurationRequest;
import com.ibm.es.nuvo.configuration.CrawlServiceFactory;
import com.ibm.es.nuvo.configuration.DirectoryBasedConfigurationManager;
import com.ibm.es.nuvo.configuration.DocumentPipelineExtensionManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.configuration.RemoveCacheIndex;
import com.ibm.es.nuvo.configuration.RestartData;
import com.ibm.es.nuvo.configuration.crawler.CrawlerStateSnapshot;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.QueuedDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.indexer.Indexer;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.manager.IndexManager;
import com.ibm.es.nuvo.search.SearchServiceImpl;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.CountingSemaphore;
import com.ibm.es.nuvo.util.FileFilter;
import com.ibm.es.nuvo.util.FileUtils;
import com.ibm.es.nuvo.util.StringUtils;
import com.ibm.es.nuvo.util.threadpool.TaskPool;
import com.ibm.supa.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager
extends DirectoryBasedConfigurationManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int MaxRenameAttempts = 10;
    public static CollectionConfiguration.State[] DefaultAccessableStates = new CollectionConfiguration.State[]{CollectionConfiguration.State.Normal, CollectionConfiguration.State.IndexComponentDeletePending};

    public static ConfigurationManager getConfigurationManager() {
        return GlobalSystem.getSingleInstance().getConfigurationManager();
    }

    public static String getDefaultCollectionName() {
        return "Default";
    }

    public Vector<String> getCollectionIds() {
        return this.getCollectionIds(DefaultAccessableStates);
    }

    public Vector<String> getCollectionIds(CollectionConfiguration.State state) {
        CollectionConfiguration.State[] states = null;
        if (state != null) {
            states = new CollectionConfiguration.State[]{state};
        }
        return this.getCollectionIds(states);
    }

    private Vector<String> getCollectionIds(CollectionConfiguration.State[] validStates) {
        Vector<String> idList = this.getIds();
        if (idList != null && validStates != null && validStates.length > 0) {
            for (int i = idList.size() - 1; i >= 0; --i) {
                String collectionId = idList.get(i);
                CollectionConfiguration collection = null;
                try {
                    collection = this.getCollection(collectionId, (CollectionConfiguration.State[])null);
                    if (collection != null && !collection.isInState(validStates)) {
                        collection = null;
                    }
                }
                catch (Exception e) {
                    collection = null;
                }
                if (collection != null) continue;
                idList.remove(i);
            }
        }
        return idList;
    }

    public CollectionConfiguration getCollection(String collectionId) throws ConfigurationManagerException {
        return this.getCollection(collectionId, DefaultAccessableStates);
    }

    public CollectionConfiguration getCollection(String collectionId, CollectionConfiguration.State state) throws ConfigurationManagerException, CollectionBadStateException {
        CollectionConfiguration.State[] states = null;
        if (state != null) {
            states = new CollectionConfiguration.State[]{state};
        }
        return this.getCollection(collectionId, states);
    }

    private CollectionConfiguration getCollection(String collectionId, CollectionConfiguration.State[] validStates) throws ConfigurationManagerException, CollectionBadStateException {
        CollectionConfiguration collection = null;
        try {
            collection = (CollectionConfiguration)this.configurationCache.get(collectionId);
            if (!collection.isInState(validStates)) {
                Message msg = new Message("G0156E.COLLECTION_NOT_AVAILABLE_BECAUSE_OF_STATE", collectionId, collection.getState().getText());
                CollectionBadStateException e = new CollectionBadStateException(msg, collection.getState());
                throw e;
            }
        }
        catch (CacheException e) {
            throw new ConfigurationManagerException(e);
        }
        return collection;
    }

    public CollectionConfiguration getCollectionForUpdate(String collectionId) throws ConfigurationManagerException {
        return this.getCollectionForUpdate(collectionId, DefaultAccessableStates);
    }

    public CollectionConfiguration getCollectionForUpdate(String collectionId, CollectionConfiguration.State state) throws ConfigurationManagerException {
        CollectionConfiguration.State[] states = null;
        if (state != null) {
            states = new CollectionConfiguration.State[]{state};
        }
        return this.getCollectionForUpdate(collectionId, states);
    }

    private CollectionConfiguration getCollectionForUpdate(String collectionId, CollectionConfiguration.State[] validStates) throws ConfigurationManagerException, CollectionBadStateException {
        CollectionConfiguration collection = null;
        try {
            collection = (CollectionConfiguration)this.load(collectionId);
            if (!collection.isInState(validStates)) {
                Message msg = new Message("G0156E.COLLECTION_NOT_AVAILABLE_BECAUSE_OF_STATE", collectionId, collection.getState().getText());
                CollectionBadStateException e = new CollectionBadStateException(msg, collection.getState());
                throw e;
            }
            this.markAsUpdateable(collection);
        }
        catch (CacheException e) {
            throw new ConfigurationManagerException(e);
        }
        return collection;
    }

    public boolean collectionExists(String collectionId) {
        return this.idExists(collectionId);
    }

    public void createCollection(CollectionConfiguration config) throws ConfigurationObjectCreateException {
        this.createCollection(config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCollection(CollectionConfiguration config, boolean initializeCrawlerMetadata) throws ConfigurationObjectCreateException {
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            String collectionId = config.getId();
            if (this.collectionExists(collectionId)) {
                Message msg = new Message("G0038E.COLLECTION_ALREADY_EXISTS", collectionId);
                throw new ConfigurationObjectCreateException(msg);
            }
            try {
                this.writeCollectionConfiguration(config);
                Vector<IndexDescriptor> indexDescriptors = config.getIndexDescriptors();
                for (int i = 0; i < indexDescriptors.size(); ++i) {
                    boolean createOk;
                    IndexDescriptor indexDescriptor = indexDescriptors.get(i);
                    File indexDirectory = new File(indexDescriptor.getAbsolutePath());
                    if (indexDirectory.exists() || (createOk = indexDirectory.mkdirs())) continue;
                    Message msg = new Message("G0149E.COULD_NOT_CREATE_DIRECTORY", indexDirectory.getAbsolutePath());
                    throw new ConfigurationObjectCreateException(msg);
                }
                this.createIndexFiles(config, initializeCrawlerMetadata);
                ConfigurationLoader.createDefaultAnalysisScopeConfig(config.getId());
                DocumentPipelineExtensionManager.getInstance().notifyCollectionCreated(collectionId);
                this.firePropertyChangeEvent("ConfigurationObjectCreated", null, collectionId);
            }
            catch (ConfigurationObjectCreateException e) {
                this.removeIdDirectory(collectionId);
                throw e;
            }
            catch (Exception e) {
                this.removeIdDirectory(collectionId);
                Message msg = new Message("G0036E.COLLECTION_CREATE_ERROR", collectionId);
                throw new ConfigurationObjectCreateException(msg, (Throwable)e);
            }
        }
    }

    public void updateCollection(CollectionConfiguration collection) throws ConfigurationManagerException, ConfigurationObjectNotExistsException {
        UpdateCollectionRequest updateRequest = new UpdateCollectionRequest(collection);
        this.updateCollection(collection.getId(), updateRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCollection(String collectionId, ConfigurationRequest request) throws ConfigurationManagerException, ConfigurationObjectNotExistsException {
        boolean checkForCollectionExist = true;
        try {
            while (request != null) {
                Object object = ConfigurationLock.getLockObj();
                synchronized (object) {
                    if (checkForCollectionExist) {
                        if (!this.collectionExists(collectionId)) {
                            Message msg = new Message("G0065E.COLLECTION_DOES_NOT_EXIST_ERROR", collectionId);
                            throw new ConfigurationObjectNotExistsException(msg);
                        }
                        checkForCollectionExist = false;
                    }
                    request = request.process(collectionId);
                }
                this.refreshCollectionUsers(collectionId, request != null, false);
            }
        }
        catch (ConfigurationObjectNotExistsException e) {
            throw e;
        }
        catch (ConfigurationManagerException e) {
            throw e;
        }
        catch (Exception e) {
            Message msg = new Message("G0063E.COLLECTION_UPDATE_ERROR", collectionId);
            throw new ConfigurationManagerException(msg, (Throwable)e);
        }
        this.firePropertyChangeEvent("ConfigurationObjectUpdated", null, collectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection(String collectionId) throws ConfigurationManagerException, InterruptedException, ConfigurationObjectNotExistsException {
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            String collectionPath;
            File fCollectionPath;
            if (!this.collectionExists(collectionId) && !(fCollectionPath = new File(collectionPath = CollectionConfiguration.buildCollectionPath(collectionId))).exists()) {
                Message msg = new Message("G0037W.REMOVE_COLLECTION_NOT_EXISTS", collectionId);
                throw new ConfigurationObjectNotExistsException(msg);
            }
            try {
                CollectionCrawlspaceConfigurationManager csConfigMgr = CollectionCrawlspaceConfigurationManager.getConfigurationManager();
                if (csConfigMgr.crawlspaceExists(collectionId)) {
                    csConfigMgr.removeCrawlspace(collectionId);
                }
            }
            catch (ExtendedException e1) {
                throw new ConfigurationManagerException(e1);
            }
            CollectionConfiguration collection = null;
            try {
                collection = this.getCollectionForUpdate(collectionId, (CollectionConfiguration.State[])null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (collection != null) {
                if (collection.getState().equals((Object)CollectionConfiguration.State.DeletePending)) {
                    Message msg = new Message("G0156E.COLLECTION_NOT_AVAILABLE_BECAUSE_OF_STATE", collectionId, collection.getState().getText());
                    CollectionBadStateException e = new CollectionBadStateException(msg, collection.getState());
                    throw e;
                }
                collection.setState(CollectionConfiguration.State.DeletePending);
                try {
                    this.persistCollection(collection);
                }
                catch (Exception e) {
                    ConfigurationManagerException exc = new ConfigurationManagerException(e);
                    throw exc;
                }
                this.removeFromUpdateableList(collection);
            }
            DocumentPipelineExtensionManager.getInstance().notifyCollectionDeleted(collectionId);
        }
        this.refreshCollectionUsers(collectionId, true, true);
        object = ConfigurationLock.getLockObj();
        synchronized (object) {
            this.removeCollectionImpl(collectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCollection(String collectionId) throws InterruptedException, ExtendedException, IOException {
        CrawlerStateSnapshot crawlerSnapshot = null;
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            if (!this.collectionExists(collectionId)) {
                Message msg = new Message("G0065E.COLLECTION_DOES_NOT_EXIST_ERROR", collectionId);
                throw new ConfigurationObjectNotExistsException(msg);
            }
            CollectionConfiguration collection = null;
            collection = this.getCollectionForUpdate(collectionId);
            if (!collection.getState().equals((Object)CollectionConfiguration.State.Normal)) {
                Message msg = new Message("G0156E.COLLECTION_NOT_AVAILABLE_BECAUSE_OF_STATE", collectionId, collection.getState().getText());
                CollectionBadStateException e = new CollectionBadStateException(msg, collection.getState());
                throw e;
            }
            crawlerSnapshot = CrawlerStateSnapshot.getSnapshotFor(collectionId);
            IndexManager indexManager = GlobalSystem.getSingleInstance().getIndexManager();
            indexManager.deactivateCollection(collectionId);
            collection.setState(CollectionConfiguration.State.ClearPending);
            try {
                this.persistCollection(collection);
            }
            catch (ConfigurationManagerException e) {
                indexManager.activateCollection(collectionId);
                throw e;
            }
            catch (IOException e) {
                indexManager.activateCollection(collectionId);
                ConfigurationManagerException exc = new ConfigurationManagerException(e);
                throw exc;
            }
            this.removeFromUpdateableList(collection);
        }
        this.refreshCollectionUsers(collectionId, true, true);
        object = ConfigurationLock.getLockObj();
        synchronized (object) {
            this.clearCollectionImpl(collectionId);
            crawlerSnapshot.restartCrawlers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameCollection(String existingCollectionId, String newCollectionId) throws InterruptedException, ExtendedException {
        CrawlerStateSnapshot crawlerSnapshot = null;
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            if (!this.collectionExists(existingCollectionId)) {
                Message msg = new Message("G0065E.COLLECTION_DOES_NOT_EXIST_ERROR", existingCollectionId);
                throw new ConfigurationObjectNotExistsException(msg);
            }
            String newCollectionPath = CollectionConfiguration.buildCollectionPath(newCollectionId);
            File newCollectionDirectory = new File(newCollectionPath);
            if (newCollectionDirectory.exists() || this.collectionExists(newCollectionId)) {
                Message msg = new Message("G0038E.COLLECTION_ALREADY_EXISTS", newCollectionId);
                throw new ConfigurationManagerException(msg);
            }
            Message msg2 = FileUtils.isValidDirectoryName(newCollectionId, true);
            if (msg2 != null) {
                throw new ConfigurationManagerException(msg2);
            }
            CollectionConfiguration collection = null;
            collection = this.getCollectionForUpdate(existingCollectionId, (CollectionConfiguration.State[])null);
            if (!collection.getState().equals((Object)CollectionConfiguration.State.Normal)) {
                Message msg = new Message("G0156E.COLLECTION_NOT_AVAILABLE_BECAUSE_OF_STATE", existingCollectionId, collection.getState().getText());
                CollectionBadStateException e = new CollectionBadStateException(msg, collection.getState());
                throw e;
            }
            crawlerSnapshot = CrawlerStateSnapshot.getSnapshotFor(existingCollectionId);
            IndexManager indexManager = GlobalSystem.getSingleInstance().getIndexManager();
            indexManager.deactivateCollection(existingCollectionId);
            collection.setState(CollectionConfiguration.State.RenamePending);
            RestartData restartData = new RestartData();
            restartData.setNewName(newCollectionId);
            collection.setRestartData(restartData);
            try {
                this.persistCollection(collection);
            }
            catch (ConfigurationManagerException e) {
                indexManager.activateCollection(existingCollectionId);
                throw e;
            }
            catch (Exception e) {
                indexManager.activateCollection(existingCollectionId);
                ConfigurationManagerException exc = new ConfigurationManagerException(e);
                throw exc;
            }
            this.removeFromUpdateableList(collection);
        }
        this.refreshCollectionUsers(existingCollectionId, true, true);
        object = ConfigurationLock.getLockObj();
        synchronized (object) {
            try {
                this.renameCollectionImpl(existingCollectionId);
            }
            catch (IOException e) {
                Message msg = new Message("G0165E.ERROR_PROCESSING_COLLECTION_RENAME", existingCollectionId);
                throw new ConfigurationManagerException(msg, (Throwable)e);
            }
            crawlerSnapshot.renameCollection(existingCollectionId, newCollectionId);
            crawlerSnapshot.restartCrawlers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanCollectionDirectories() throws IOException, ExtendedException {
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            String pathName = GlobalConfiguration.getConfiguration().getCollectionPath();
            File file = new File(pathName);
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    ExtendedException ee;
                    Message msg;
                    String collectionId = files[i].getName();
                    if (!this.isDirectoryValid(files[i]) || this.isDirectoryInState(files[i], CollectionConfiguration.State.DeletePending)) {
                        Vector<String> filesNotDeleted = FileUtils.removeDirectory(files[i]);
                        if (filesNotDeleted == null || filesNotDeleted.size() <= 0) continue;
                        String fileList = StringUtils.buildFileListString(filesNotDeleted);
                        Message msg2 = new Message("G0083W.FILES_NOT_DELETED_PROCESSING_REMOVE_COLLECTION", collectionId, fileList);
                        System.out.println(msg2.getFormattedTextWithDisplayKey());
                        if (!Loggers.logger.isLoggable(Level.WARNING)) continue;
                        Loggers.logger.log(Level.WARNING, msg2);
                        continue;
                    }
                    if (this.isDirectoryInState(files[i], CollectionConfiguration.State.RenamePending)) {
                        CollectionConfiguration collection;
                        block15: {
                            String newId;
                            collection = (CollectionConfiguration)this.load(collectionId);
                            RestartData restartData = collection.getRestartData();
                            if (restartData != null && (newId = restartData.getNewName()) != null) {
                                try {
                                    this.renameCollectionDirectory(collectionId, newId);
                                    collection.setId(newId);
                                }
                                catch (ConfigurationManagerException e) {
                                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block15;
                                    Loggers.logger.log(Level.SEVERE, e);
                                }
                            }
                        }
                        collection.setRestartData(null);
                        collection.setState(CollectionConfiguration.State.Normal);
                        this.writeCollectionConfiguration(collection);
                        continue;
                    }
                    if (this.isDirectoryInState(files[i], CollectionConfiguration.State.IndexComponentDeletePending)) {
                        try {
                            this.processPendingDeleteOnCollection(collectionId);
                        }
                        catch (Exception e) {
                            msg = new Message("G0073E.ERROR_PROCESSING_PENDING_INDEX_DELETE", collectionId);
                            ee = new ExtendedException(msg, (Throwable)e);
                            System.out.println(msg.getFormattedTextWithDisplayKey());
                            if (!Loggers.logger.isLoggable(Level.SEVERE)) continue;
                            Loggers.logger.log(Level.SEVERE, ee);
                        }
                        continue;
                    }
                    if (!this.isDirectoryInState(files[i], CollectionConfiguration.State.ClearPending)) continue;
                    try {
                        this.clearCollectionImpl(collectionId);
                        continue;
                    }
                    catch (Exception e) {
                        msg = new Message("G0075E.ERROR_PROCESSING_INDEX_CLEAR", collectionId);
                        ee = new ExtendedException(msg, (Throwable)e);
                        System.out.println(msg.getFormattedTextWithDisplayKey());
                        if (!Loggers.logger.isLoggable(Level.SEVERE)) continue;
                        Loggers.logger.log(Level.SEVERE, ee);
                    }
                }
            }
        }
    }

    public void refreshCacheForCollection(String collectionId) {
        this.removeObjectIdFromCache(collectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPendingDeleteOnCollection(String collectionId) throws ExtendedException, IOException {
        Vector<String> filesNotDeleted = null;
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            CollectionConfiguration collection = this.getCollectionForUpdate(collectionId);
            if (collection.getRestartData() != null && collection.getRestartData().getDirectoryPendingDelete() != null) {
                String pathName = collection.getRestartData().getDirectoryPendingDelete();
                filesNotDeleted = FileUtils.removeDirectory(new File(pathName));
            }
            collection.setState(CollectionConfiguration.State.Normal);
            this.persistCollection(collection);
            this.removeFromUpdateableList(collection);
        }
        if (filesNotDeleted != null && filesNotDeleted.size() > 0 && !FileUtils.doesFileListOnlyContainDirectories(filesNotDeleted)) {
            String fileList = StringUtils.buildFileListString(filesNotDeleted);
            Message msg = new Message("G0074E.FILES_NOT_DELETED", fileList);
            ConfigurationManagerException ce = new ConfigurationManagerException(msg);
            throw ce;
        }
    }

    @Override
    public Object load(Object name) throws CacheException {
        CollectionConfiguration collection = null;
        String collectionId = (String)name;
        try {
            collection = CollectionConfiguration.load(collectionId);
        }
        catch (Exception e) {
            Message msg = new Message("G0034E.COLLECTION_LOAD_ERROR", collectionId);
            throw new CacheException(msg, (Throwable)e);
        }
        return collection;
    }

    @Override
    protected String getBaseDirectory() {
        String pathName = GlobalConfiguration.getConfiguration().getCollectionPath();
        return pathName;
    }

    @Override
    protected boolean isDirectoryValid(File collectionDirectory) {
        boolean isValid = false;
        if (collectionDirectory.isDirectory()) {
            FileFilter xmlFilter = new FileFilter(CollectionConfiguration.getCollectionFileName(), null);
            String[] collectionDirectoryList = collectionDirectory.list(xmlFilter);
            isValid = collectionDirectoryList != null && collectionDirectoryList.length > 0;
        }
        return isValid;
    }

    protected boolean isDirectoryInState(File collectionDirectory, CollectionConfiguration.State state) {
        boolean inState = false;
        String collectionId = collectionDirectory.getName();
        try {
            CollectionConfiguration collection = (CollectionConfiguration)this.load(collectionId);
            inState = state.equals((Object)collection.getState());
        }
        catch (ExtendedException e) {
            // empty catch block
        }
        return inState;
    }

    private void removeCollectionImpl(String collectionId) throws ConfigurationManagerException {
        this.drainDocQueueForCollection(collectionId);
        CollectionConfiguration collection = null;
        try {
            collection = this.getCollection(collectionId, CollectionConfiguration.State.DeletePending);
        }
        catch (Throwable t) {
            // empty catch block
        }
        String collectionConfigPath = CollectionConfiguration.buildCollectionPath(collectionId);
        Vector<String> dataFilesCouldNotDelete = new Vector<String>();
        if (collection != null) {
            Vector<IndexDescriptor> indexDescriptors = collection.getIndexDescriptors();
            for (int i = 0; i < indexDescriptors.size(); ++i) {
                String[] dirList;
                IndexDescriptor indexDescriptor = indexDescriptors.get(i);
                String indexPath = indexDescriptor.getAbsolutePath();
                if (indexPath.contains(collectionConfigPath)) continue;
                File indexDirectory = new File(indexDescriptor.getAbsolutePath());
                this.deleteFiles(indexDescriptor.getAbsolutePath(), true, dataFilesCouldNotDelete);
                File parentDirectory = indexDirectory.getParentFile();
                if (parentDirectory == null || (dirList = parentDirectory.list()) != null && dirList.length != 0) continue;
                parentDirectory.delete();
            }
        }
        this.removeObjectIdFromCache(collectionId);
        Vector<String> filesCouldNotDelete = this.removeIdDirectory(collectionId);
        filesCouldNotDelete.addAll(dataFilesCouldNotDelete);
        CollectionCrawlspaceConfigurationManager.getConfigurationManager().notifyDirectoryDeleted(collectionId);
        this.flushInformationForCollection(collectionId);
        if (!FileUtils.doesFileListOnlyContainDirectories(filesCouldNotDelete)) {
            String fileList = StringUtils.buildFileListString(filesCouldNotDelete);
            Message msg = new Message("G0032E.COLLECTION_FILE_DELETE_ERROR", collectionId, fileList);
            ConfigurationManagerException ce = new ConfigurationManagerException(msg);
            throw ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameCollectionImpl(String origId) throws ExtendedException, IOException, InterruptedException {
        DocumentQueueInterface docQueue = GlobalSystem.getSingleInstance().getDocumentQueue();
        IndexManager indexManager = GlobalSystem.getSingleInstance().getIndexManager();
        CollectionConfiguration collection = this.getCollectionForUpdate(origId, CollectionConfiguration.State.RenamePending);
        String newId = collection.getRestartData().getNewName();
        try {
            this.renameCollectionDirectory(origId, newId);
            collection.setId(newId);
            indexManager.deactivateCollection(newId);
            this.removeObjectIdFromCache(origId);
            CollectionCrawlspaceConfigurationManager.getConfigurationManager().removeObjectIdFromCache(origId);
            docQueue.renameCollection(origId, newId);
        }
        finally {
            try {
                collection.setRestartData(null);
                collection.setState(CollectionConfiguration.State.Normal);
                this.persistCollection(collection);
            }
            finally {
                indexManager.activateCollection(collection.getId());
                indexManager.activateCollection(origId);
            }
        }
        this.firePropertyChangeEvent("ConfigurationObjectRenamed", origId, collection.getId());
    }

    private void renameCollectionDirectory(String origId, String newId) throws ConfigurationManagerException {
        String existingCollectionPath = CollectionConfiguration.buildCollectionPath(origId);
        String newCollectionPath = CollectionConfiguration.buildCollectionPath(newId);
        File existingCollectionDirectory = new File(existingCollectionPath);
        File newCollectionDirectory = new File(newCollectionPath);
        boolean renameOk = false;
        try {
            for (int i = 0; i < 10 && !renameOk; ++i) {
                renameOk = existingCollectionDirectory.renameTo(newCollectionDirectory);
                if (renameOk) continue;
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!renameOk) {
            Message msg = new Message("G0166E.RENAME_FAILED", existingCollectionPath, newCollectionPath);
            throw new ConfigurationManagerException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCollectionImpl(String collectionId) throws ExtendedException, IOException {
        IndexManager indexManager = GlobalSystem.getSingleInstance().getIndexManager();
        try {
            this.drainDocQueueForCollection(collectionId);
            Vector<IndexDescriptor.IndexType> indexesToSave = new Vector<IndexDescriptor.IndexType>();
            indexesToSave.add(IndexDescriptor.IndexType.Synonym);
            indexesToSave.add(IndexDescriptor.IndexType.QuickLink);
            CollectionConfiguration collection = null;
            collection = this.getCollectionForUpdate(collectionId, CollectionConfiguration.State.ClearPending);
            Vector<String> filesCouldNotDelete = new Vector<String>();
            Vector<IndexDescriptor> indexDescriptors = collection.getIndexDescriptors();
            for (int i = 0; i < indexDescriptors.size(); ++i) {
                IndexDescriptor indexDescriptor = indexDescriptors.get(i);
                if (indexesToSave.contains((Object)indexDescriptor.getType())) continue;
                this.deleteFiles(indexDescriptor.getAbsolutePath(), false, filesCouldNotDelete);
            }
            String webDbLocation = collection.getCrawlerDataDirectory(Constants.CrawlerType.Web);
            File fCloudscapeDir = new File(webDbLocation);
            boolean hasCloudscapeMetadata = fCloudscapeDir.exists() && fCloudscapeDir.isDirectory() && fCloudscapeDir.list().length > 0;
            this.deleteFiles(webDbLocation, false, filesCouldNotDelete);
            this.createIndexFiles(collection, hasCloudscapeMetadata);
            collection.setState(CollectionConfiguration.State.Normal);
            collection.setRebuildState(CollectionConfiguration.RebuildState.None);
            this.persistCollection(collection);
            this.flushInformationForCollection(collectionId);
            if (!FileUtils.doesFileListOnlyContainDirectories(filesCouldNotDelete)) {
                String fileList = StringUtils.buildFileListString(filesCouldNotDelete);
                Message msg = new Message("G0032E.COLLECTION_FILE_DELETE_ERROR", collectionId, fileList);
                ConfigurationManagerException ce = new ConfigurationManagerException(msg);
                throw ce;
            }
        }
        finally {
            if (indexManager != null) {
                indexManager.activateCollection(collectionId);
            }
        }
    }

    private void flushInformationForCollection(String collectionId) {
        WebCrawler webCrawler;
        IndexerMonitor indexerMonitor = GlobalSystem.getSingleInstance().getIndexerMonitor();
        if (indexerMonitor != null) {
            indexerMonitor.flushStatisticsFor(collectionId);
        }
        if ((webCrawler = GlobalSystem.getSingleInstance().getWebCrawler()) != null) {
            String crawlSpaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, collectionId);
            webCrawler.clearSessionHistory(crawlSpaceId);
        }
    }

    private void deleteFiles(String directoryName, boolean removeDirectory, Vector<String> filesCouldNotDelete) {
        File fDirectory = new File(directoryName);
        Vector<String> tempFilesCouldNotDelete = null;
        tempFilesCouldNotDelete = removeDirectory ? FileUtils.cleanDirectory(fDirectory) : FileUtils.removeDirectory(fDirectory);
        if (tempFilesCouldNotDelete != null && tempFilesCouldNotDelete.size() > 0) {
            filesCouldNotDelete.addAll(tempFilesCouldNotDelete);
        }
    }

    private void persistCollection(CollectionConfiguration collection) throws ExtendedException, IOException {
        this.writeCollectionConfiguration(collection);
        this.configurationCache.replace(collection.getId(), collection, false);
    }

    private void writeCollectionConfiguration(CollectionConfiguration configuration) throws IOException, ExtendedException {
        String collectionDir = CollectionConfiguration.buildCollectionPath(configuration.getId());
        this.createConfigDirctory(configuration.getId());
        configuration.writeTo(collectionDir);
    }

    public void refreshCollectionUsers(String collectionId, boolean waitForRefresh, boolean refreshCrawlers) throws InterruptedException, ConfigurationManagerException {
        GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
        TaskPool taskPool = globalSystem.getTaskPool();
        boolean webCrawlerExists = globalSystem.getWebCrawler() != null;
        boolean newCrawlerFrameworkExists = globalSystem.getGlobalCrawlerManager() != null;
        CountingSemaphore semaphore = null;
        if (waitForRefresh) {
            int numNotifiers = 3;
            if (refreshCrawlers) {
                if (webCrawlerExists) {
                    ++numNotifiers;
                }
                if (newCrawlerFrameworkExists) {
                    ++numNotifiers;
                }
            }
            semaphore = new CountingSemaphore(numNotifiers);
        }
        SearchRefreshTask quiesceSearchRequest = new SearchRefreshTask(collectionId, semaphore);
        taskPool.schedule(quiesceSearchRequest);
        IndexerRefreshTask refreshIndexer = new IndexerRefreshTask(collectionId, semaphore);
        taskPool.schedule(refreshIndexer);
        IndexerMonitorRefreshTask refreshIndexerMonitor = new IndexerMonitorRefreshTask(collectionId, semaphore);
        taskPool.schedule(refreshIndexerMonitor);
        if (refreshCrawlers) {
            if (webCrawlerExists) {
                WebCrawlerRefreshTask refreshWebCrawler = new WebCrawlerRefreshTask(collectionId, semaphore);
                taskPool.schedule(refreshWebCrawler);
            }
            if (newCrawlerFrameworkExists) {
                CrawlerFrameworkRefreshTask refreshCrawlerFramework = new CrawlerFrameworkRefreshTask(collectionId, semaphore);
                taskPool.schedule(refreshCrawlerFramework);
            }
        }
        GlobalSystem.getSingleInstance().getTokenizerManager().refreshCollection(collectionId);
        if (semaphore != null && refreshCrawlers) {
            DocumentPipelineExtensionManager.getInstance().closeExtension(collectionId);
        }
        if (semaphore != null) {
            semaphore.waitForAllNotifiers();
            Vector<Object> errors = semaphore.getNotificationObjects();
            if (errors.size() > 0) {
                Object error = errors.firstElement();
                if (error instanceof ConfigurationManagerException) {
                    throw (ConfigurationManagerException)error;
                }
                if (error instanceof Exception) {
                    throw new ConfigurationManagerException((Exception)error);
                }
            }
        }
    }

    private void drainDocQueueForCollection(String collectionId) {
        DocumentQueueInterface docQueue = GlobalSystem.getSingleInstance().getDocumentQueue();
        if (docQueue != null) {
            LinkedList<QueuedDocument> documentList = new LinkedList<QueuedDocument>();
            docQueue.getDocuments(collectionId, documentList);
            if (documentList.size() > 0) {
                for (int i = 0; i < documentList.size(); ++i) {
                    QueuedDocument queuedDocument = documentList.get(i);
                    BaseDocument doc = queuedDocument.getDocument();
                    if (doc == null || !(doc instanceof StreamedDocument)) continue;
                    StreamedDocument streamedDoc = (StreamedDocument)doc;
                    streamedDoc.dispose();
                }
                docQueue.removeDocuments(collectionId, documentList);
            }
        }
    }

    private void createIndexFiles(CollectionConfiguration config, boolean initializeCrawlerCloudscapeMetadata) throws ExtendedException {
        Indexer.createIndex(config);
        WebCrawler webCrawler = GlobalSystem.getSingleInstance().getWebCrawler();
        if (initializeCrawlerCloudscapeMetadata && webCrawler != null) {
            String webCrawlspaceId = config.getCrawlspaceId(Constants.CrawlerType.Web);
            String webDbLocation = config.getCrawlerDataDirectory(Constants.CrawlerType.Web);
            webCrawler.initializeDB(webCrawlspaceId, webDbLocation);
        }
    }

    private static class IndexerMonitorRefreshTask
    implements Runnable {
        private String collectionId = null;
        private CountingSemaphore semaphore = null;

        private IndexerMonitorRefreshTask(String collectionId, CountingSemaphore sempahore) {
            this.collectionId = collectionId;
            this.semaphore = sempahore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Exception error = null;
            try {
                IndexerMonitor im = GlobalSystem.getSingleInstance().getIndexerMonitor();
                if (im != null) {
                    im.quiesceCollection(this.collectionId);
                }
            }
            catch (Exception e) {
                error = e;
            }
            finally {
                if (this.semaphore != null) {
                    this.semaphore.notifyFinished(error);
                }
            }
        }
    }

    private static class CrawlerFrameworkRefreshTask
    implements Runnable {
        private String collectionId = null;
        private CountingSemaphore semaphore = null;

        private CrawlerFrameworkRefreshTask(String collectionId, CountingSemaphore sempahore) {
            this.collectionId = collectionId;
            this.semaphore = sempahore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Exception error = null;
            try {
                GlobalCrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
                if (crawlerManager != null) {
                    boolean closeCrawlerResources = this.semaphore != null;
                    crawlerManager.refreshCollection(this.collectionId, closeCrawlerResources);
                }
            }
            catch (Exception e) {
                error = e;
            }
            finally {
                if (this.semaphore != null) {
                    this.semaphore.notifyFinished(error);
                }
            }
        }
    }

    private static class WebCrawlerRefreshTask
    implements Runnable {
        private String collectionId = null;
        private CountingSemaphore semaphore = null;

        private WebCrawlerRefreshTask(String collectionId, CountingSemaphore sempahore) {
            this.collectionId = collectionId;
            this.semaphore = sempahore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Exception error = null;
            try {
                CrawlService webCrawlService = CrawlServiceFactory.getInstance().getServiceFor(Constants.CrawlerType.Web);
                if (webCrawlService != null && webCrawlService.getCrawler() != null) {
                    String csId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.collectionId);
                    if (webCrawlService.isCrawling(csId)) {
                        webCrawlService.stopCrawl(csId);
                    }
                    WebCrawler webCrawler = (WebCrawler)webCrawlService.getCrawler();
                    webCrawler.waitForShutdownDB(csId, -1L);
                }
            }
            catch (Exception e) {
                error = e;
            }
            finally {
                if (this.semaphore != null) {
                    this.semaphore.notifyFinished(error);
                }
            }
        }
    }

    private static class SearchRefreshTask
    implements Runnable {
        private String collectionId = null;
        private CountingSemaphore semaphore = null;

        private SearchRefreshTask(String collectionId, CountingSemaphore sempahore) {
            this.collectionId = collectionId;
            this.semaphore = sempahore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Exception error = null;
            try {
                SearchServiceImpl searchService = SearchServiceImpl.getInstance();
                searchService.drop(this.collectionId);
            }
            catch (Exception e) {
                error = e;
            }
            finally {
                if (this.semaphore != null) {
                    this.semaphore.notifyFinished(error);
                }
            }
        }
    }

    private static class IndexerRefreshTask
    implements Runnable {
        private String collectionId = null;
        private CountingSemaphore semaphore = null;

        private IndexerRefreshTask(String collectionId, CountingSemaphore semaphore) {
            this.collectionId = collectionId;
            this.semaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Exception error = null;
            try {
                GlobalSystem.getSingleInstance().getIndexManager().closeCollection(this.collectionId);
            }
            catch (Exception e) {
                error = e;
            }
            finally {
                if (this.semaphore != null) {
                    this.semaphore.notifyFinished(error);
                }
            }
        }
    }

    private class UpdateCollectionRequest
    implements ConfigurationRequest {
        private CollectionConfiguration collection = null;

        private UpdateCollectionRequest(CollectionConfiguration newCollection) {
            this.collection = newCollection;
        }

        public ConfigurationRequest process(String collectionId) throws ExtendedException, IOException {
            String indexPath;
            File f;
            boolean removingCacheIndex;
            if (!ConfigurationManager.this.isUpdateable(this.collection)) {
                String msg = "Error!!  Tried to update a non updatable CollectionConfiguration.  You need to get the collection by getCollectionForUpdate()!!!";
                throw new RuntimeException(msg);
            }
            CollectionConfiguration originalCollection = ConfigurationManager.this.getCollection(collectionId, (CollectionConfiguration.State)null);
            if (this.collection.getUpdateCount() < originalCollection.getUpdateCount()) {
                Message msg = new Message("G0170E.COLLECTION_UPDATE_FAILED_BECAUSE_CONFLICTING_UPDATE", collectionId);
                throw new ConfigurationManagerException(msg);
            }
            ConfigurationLoader.unloadAnalysisScopeConfig(collectionId);
            IndexDescriptor originalCacheIndex = originalCollection.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
            IndexDescriptor newCacheIndex = this.collection.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
            boolean addingNewCacheIndex = originalCacheIndex == null && newCacheIndex != null;
            boolean bl = removingCacheIndex = originalCacheIndex != null && newCacheIndex == null;
            if ((addingNewCacheIndex || removingCacheIndex) && !originalCollection.getState().equals((Object)CollectionConfiguration.State.Normal)) {
                Message msg = new Message("G0156E.COLLECTION_NOT_AVAILABLE_BECAUSE_OF_STATE", collectionId, originalCollection.getState().getText());
                CollectionBadStateException e = new CollectionBadStateException(msg, originalCollection.getState());
                throw e;
            }
            if (addingNewCacheIndex && !(f = new File(indexPath = newCacheIndex.getAbsolutePath())).exists()) {
                boolean success = f.mkdirs();
                if (!success) {
                    Message msg = new Message("G0077E.ERROR_CREATING_INDEX_DIRECTORIES", collectionId, indexPath);
                    throw new ConfigurationManagerException(msg);
                }
                Indexer.createCacheIndex(this.collection);
                if (Loggers.logger.isLoggable(Level.INFO)) {
                    Message msg2 = new Message("G0118I.COLLECTION_CACHE_CREATE_SUCCESSFUL", collectionId);
                    Loggers.logger.log(Level.INFO, msg2);
                }
            }
            RestartData currentRestartData = originalCollection.getRestartData();
            if (removingCacheIndex) {
                if (currentRestartData == null) {
                    currentRestartData = new RestartData();
                }
                currentRestartData.setDirectoryPendingDelete(originalCacheIndex.getAbsolutePath());
            }
            this.collection.setRestartData(currentRestartData);
            this.collection.incrementUpdateCount();
            ConfigurationManager.this.persistCollection(this.collection);
            ConfigurationManager.this.removeFromUpdateableList(this.collection);
            RemoveCacheIndex nextStep = null;
            if (removingCacheIndex) {
                nextStep = new RemoveCacheIndex();
            }
            return nextStep;
        }
    }
}

