/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import java.util.Vector;

public class CollectionUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static synchronized void removeCache(String collectionId) throws ConfigurationManagerException, ConfigurationObjectNotExistsException {
        ConfigurationManager cMgr = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collection = cMgr.getCollectionForUpdate(collectionId);
        IndexDescriptor cacheIndex = collection.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
        if (cacheIndex != null) {
            Vector<IndexDescriptor> indexes = collection.getIndexDescriptors();
            indexes.remove(cacheIndex);
            cMgr.updateCollection(collection);
            collection = cMgr.getCollection(collectionId);
            while (collection.getState().equals((Object)CollectionConfiguration.State.IndexComponentDeletePending)) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                collection = cMgr.getCollection(collectionId);
            }
        }
    }

    public static synchronized void addCache(String collectionId, String dataPath) throws ExtendedException {
        ConfigurationManager cMgr = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collection = cMgr.getCollectionForUpdate(collectionId);
        IndexDescriptor oldCacheIndex = collection.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
        if (oldCacheIndex == null) {
            IndexDescriptor newCacheIndex = IndexDescriptor.buildDescriptorFor(collection, IndexDescriptor.IndexType.Cache);
            if (dataPath != null && dataPath.length() > 0) {
                newCacheIndex.setPath(dataPath);
            }
            Vector<IndexDescriptor> indexes2 = collection.getIndexDescriptors();
            indexes2.add(newCacheIndex);
            cMgr.updateCollection(collection);
        }
    }
}

