/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CollectionFile
implements Serializable {
    protected final String collectionID;
    protected final String path;
    protected long checksum;
    protected long backingStoreLastModified = -1L;
    protected transient File file;
    private int hashCodeCached = 0;
    private static final long serialVersionUID = 1L;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public CollectionFile(String collectionID, String path) throws ExtendedException {
        if (StringUtils.noData(collectionID)) {
            throw new ExtendedException(new Message("G0007E.INVALID_ARGUMENT", collectionID));
        }
        if (StringUtils.noData(path)) {
            throw new ExtendedException(new Message("G0007E.INVALID_ARGUMENT", path));
        }
        this.collectionID = collectionID;
        this.path = path;
    }

    public boolean equals(Object o) {
        if (o instanceof CollectionFile) {
            CollectionFile c = (CollectionFile)o;
            return c.path.equals(this.path) && c.collectionID.equals(this.collectionID);
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (this.hashCodeCached == 0) {
            this.hashCodeCached = (this.collectionID + this.path).hashCode();
        }
        return this.hashCodeCached;
    }

    public void deleteFromCollection() throws ExtendedException {
        this.getFile().delete();
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public long getLastModified() throws ExtendedException {
        return this.getFile().lastModified();
    }

    public long getBackingStoreLastModified() {
        return this.backingStoreLastModified;
    }

    public String getPathInCollection() {
        return this.path;
    }

    public long length() throws ExtendedException {
        return this.getFile().length();
    }

    public InputStream openInputStream() throws IOException, ExtendedException {
        return new FileInputStream(this.getFile());
    }

    public OutputStream openOutputStream() throws IOException, ExtendedException {
        return new FileOutputStream(this.getFile());
    }

    public void setChecksum(long newChecksum) {
        this.checksum = newChecksum;
    }

    public void setBackingStoreLastModified(long newLastModified) {
        this.backingStoreLastModified = newLastModified;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.collectionID);
        sb.append(":").append(this.path).append("]");
        return sb.toString();
    }

    protected File getFile() throws ExtendedException {
        if (this.file == null) {
            File f = new File(this.path);
            if (!f.isAbsolute()) {
                CollectionConfiguration cc = ConfigurationManager.getConfigurationManager().getCollection(this.collectionID);
                if (cc == null) {
                    throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", f.getAbsolutePath()));
                }
                f = new File(cc.getCollectionDirectory(), this.path);
            }
            this.file = f;
        }
        return this.file;
    }
}

