/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationLock;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectCreateException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.configuration.CrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.crawler.CrawlerConfigurationInterface;
import com.ibm.es.nuvo.configuration.crawler.WebCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.crawlspace.HttpAuth;
import com.ibm.es.nuvo.crawlspace.HttpBasicAuth;
import com.ibm.es.nuvo.crawlspace.HttpFormAuth;
import com.ibm.es.nuvo.crawlspace.HttpProxySettings;
import com.ibm.es.nuvo.crawlspace.WebCrawlspace;
import com.ibm.es.nuvo.crawlspace.WebCrawlspaceBranch;
import com.ibm.es.nuvo.documentqueue.DeleteCrawlerDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.ReliableFileInputStream;
import com.ibm.es.nuvo.util.ReliableFileOutputStream;
import com.ibm.es.nuvo.util.StringUtils;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.threadpool.TaskPool;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.web.WebConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionCrawlspaceConfigurationManager
extends CrawlspaceConfigurationManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String WebSeparatorChar = "/";
    private static final String HTTP_Prefix = "http://";
    private static final String HTTPS_Prefix = "https://";

    public CollectionCrawlspaceConfigurationManager() {
        super("collection_crawlspace", "xml");
    }

    public static CollectionCrawlspaceConfigurationManager getConfigurationManager() {
        return GlobalSystem.getSingleInstance().getCollectionCrawlspaceConfigurationManager();
    }

    public CollectionCrawlspace createDefaultCrawlspaceConfig() {
        CollectionCrawlspace cs = null;
        String defaultCrawlerConfigFileName = GlobalConfiguration.getConfiguration().getConfigFileName("defaults", "collection_crawlspace.xml");
        try {
            cs = this.loadCrawlspaceConfigFromFile(defaultCrawlerConfigFileName);
        }
        catch (ExtendedException e) {
            Message msg = new Message("G0096E.COULD_NOT_LOAD_CRAWLSPACE_DEFAULTS", defaultCrawlerConfigFileName);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, ee);
            }
            cs = new CollectionCrawlspace();
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionCrawlspace loadCrawlspaceConfigFromFile(String fileName) throws ExtendedException {
        ReliableFileInputStream configFileStream = null;
        CollectionCrawlspace config = null;
        Object object = this.fileIOLock;
        synchronized (object) {
            try {
                configFileStream = new ReliableFileInputStream(fileName);
                config = (CollectionCrawlspace)this.loadConfiguration(configFileStream, null);
            }
            catch (FileNotFoundException e) {
                Message msg = new Message("G0053E.SYSTEM_MISSING_FILE", fileName);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            finally {
                if (configFileStream != null) {
                    try {
                        configFileStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return config;
    }

    public void createCrawlspace(CollectionCrawlspace config, String collectionId) throws ConfigurationObjectCreateException {
        super.createCrawlspace(config, collectionId);
    }

    public void updateCrawlspace(String collectionId, CollectionCrawlspace crawlspace) throws ConfigurationManagerException, ConfigurationObjectNotExistsException {
        super.updateCrawlspace(collectionId, crawlspace);
    }

    @Override
    public CollectionCrawlspace getCrawlspace(String collectionId) throws ConfigurationManagerException {
        return (CollectionCrawlspace)super.getCrawlspace(collectionId);
    }

    @Override
    public CollectionCrawlspace getCrawlspaceForUpdate(String collectionId) throws ConfigurationManagerException {
        return (CollectionCrawlspace)super.getCrawlspaceForUpdate(collectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String collectionId) throws ExtendedException {
        Object object = ConfigurationLock.getLockObj();
        synchronized (object) {
            CollectionCrawlspace crawlspace = this.getCrawlspace(collectionId);
            WebCrawlspace webCS = crawlspace.getWebCrawlspace();
            this.publishWebCrawlspace(collectionId, webCS);
        }
    }

    @Override
    protected void updateCrawlerForNewConfig(String collectionId, Object aConfig) throws ConfigurationManagerException {
    }

    @Override
    protected void doRemoveCrawler(String collectionId) throws ConfigurationManagerException {
        String collectionDirectory;
        CrawlerConfigurationInterface webCrawlerConfigInterface = WebCrawlerConfiguration.getInstance();
        if (webCrawlerConfigInterface.crawlspaceExists(collectionDirectory = CollectionConfiguration.buildCollectionPath(collectionId))) {
            if (Loggers.tracer.isLoggable(Level.FINE)) {
                Message msg = new Message("G0002I.TRACE_MESSAGE");
                msg.addArgument("Attempting to remove web crawlspace for " + collectionId);
                Loggers.tracer.log(Level.FINE, msg);
            }
            String webCsId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, collectionId);
            try {
                webCrawlerConfigInterface.notifyCrawlerCrawlspaceDeleted(webCsId);
            }
            catch (ExtendedException ignore) {
                // empty catch block
            }
            webCrawlerConfigInterface.deleteCrawlspace(collectionDirectory);
            if (Loggers.tracer.isLoggable(Level.FINE)) {
                Message msg = new Message("G0002I.TRACE_MESSAGE");
                msg.addArgument("Successfully removed web crawlspace for " + collectionId);
                Loggers.tracer.log(Level.FINE, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeConfiguration(Object aCrawlspace, String collectionId) throws IOException, ExtendedException {
        Object object = this.fileIOLock;
        synchronized (object) {
            CollectionCrawlspace crawlspace = (CollectionCrawlspace)aCrawlspace;
            String crawlspaceFileNameBuilt = this.buildFullyQualifiedFileName(collectionId);
            ReliableFileOutputStream os = null;
            try {
                os = new ReliableFileOutputStream(crawlspaceFileNameBuilt);
                XMLTagger tagger = new XMLTagger(true);
                tagger.startPI("xml");
                tagger.writeAttr("version", "1.0");
                tagger.writeAttr("encoding", "UTF-8");
                tagger.endPI();
                crawlspace.writeTo(tagger);
                String xml = tagger.getXML();
                os.write(xml.getBytes("UTF-8"));
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    @Override
    protected Object loadConfiguration(InputStream is, String collectionId) throws ExtendedException {
        return CollectionCrawlspace.loadFrom(is);
    }

    private void publishWebCrawlspace(String collectionId, WebCrawlspace webCS) throws ExtendedException {
        boolean needWebCS;
        CrawlerConfigurationInterface webCSInterface = WebCrawlerConfiguration.getInstance();
        String collectionDirectory = CollectionConfiguration.buildCollectionPath(collectionId);
        boolean bl = needWebCS = webCS != null && webCS.getBranches() != null && webCS.getBranches().size() > 0;
        if (needWebCS) {
            CrawlSpaceConfig csConfig = null;
            csConfig = (CrawlSpaceConfig)webCSInterface.createDefaultCrawlspace(collectionId);
            csConfig.setCollectionId(collectionId);
            csConfig.getPoliteness().setInterval(webCS.getPolitness());
            CollectionCrawlspaceConfigurationManager.addAgentInfoToWebCrawlspace(csConfig, webCS.getCrawlerName(), webCS.getEmailId());
            csConfig.clearStartURLs();
            csConfig.getRule().getRules().clear();
            Vector<WebCrawlspaceBranch> webBranches = webCS.getBranches();
            for (int i = 0; i < webBranches.size(); ++i) {
                WebCrawlspaceBranch branch = webBranches.get(i);
                String userRootURL = branch.getRoot().trim();
                CollectionCrawlspaceConfigurationManager.addDataToWebCrawlspace(csConfig, userRootURL, branch.getAllowRules(), branch.getDenyPatterns());
                HttpAuth auth = branch.getHttpAuth();
                if (auth == null) continue;
                String authStartURL = CollectionCrawlspaceConfigurationManager.generateStartURLForWebCrawlspace(userRootURL);
                authStartURL = CollectionCrawlspaceConfigurationManager.trimURLBackToSeparator(authStartURL);
                AnalysisScopeConfig config = ConfigurationLoader.getAnalysisScopeConfig(csConfig.getCollectionId());
                WebConfig webConfig = config.getWebConfig();
                if (webConfig != null && webConfig.getAuthURLTransformer() != null) {
                    authStartURL = webConfig.getAuthURLTransformer().transform(authStartURL);
                }
                if (auth instanceof HttpBasicAuth) {
                    HttpBasicAuth basicAuth = (HttpBasicAuth)auth;
                    CollectionCrawlspaceConfigurationManager.addBasicAuthToWebCrawlspace(csConfig, basicAuth, authStartURL);
                    continue;
                }
                if (auth instanceof HttpFormAuth) {
                    HttpFormAuth formAuth = (HttpFormAuth)auth;
                    String formAuthURLPattern = authStartURL + "*";
                    System.out.println("Added url pattern of " + formAuthURLPattern);
                    csConfig.getAgent().addFormBaseAuth(formAuthURLPattern, formAuth.getFormName(), formAuth.getFormAction(), formAuth.getHttpMethod().toString());
                    HashMap<String, String> formParms = formAuth.getFormParameters();
                    if (formParms == null || formParms.size() <= 0) continue;
                    for (Map.Entry<String, String> curEntry : formParms.entrySet()) {
                        csConfig.getAgent().addFormBaseAuthParam(curEntry.getKey(), curEntry.getValue(), true);
                    }
                    continue;
                }
                throw new RuntimeException("Error, found unsupported auth type " + auth.getClass().toString());
            }
            HttpProxySettings proxy = webCS.getHttpProxy();
            if (proxy != null) {
                CollectionCrawlspaceConfigurationManager.addProxyToWebCrawlspace(csConfig, proxy);
            }
            csConfig.update();
            webCSInterface.writeCrawlspace(collectionDirectory, csConfig);
            String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, collectionId);
            webCSInterface.notifyCrawlerCrawlspaceUpdated(csConfig, crawlspaceId);
        } else if (webCSInterface.crawlspaceExists(collectionDirectory)) {
            webCSInterface.deleteCrawlspace(collectionDirectory);
            this.clearIndexOfDocuments(collectionId, Constants.CrawlerType.Web);
        }
    }

    protected static void addDataToWebCrawlspace(CrawlSpaceConfig csConfig, String rootURL, List<String> allowRules, List<String> denyPatterns) {
        String pattern;
        int j;
        String startURL = CollectionCrawlspaceConfigurationManager.generateStartURLForWebCrawlspace(rootURL);
        csConfig.addStartURL(startURL);
        if (allowRules != null) {
            for (j = 0; j < allowRules.size(); ++j) {
                pattern = allowRules.get(j);
                csConfig.getRule().addRule("PREFIX", pattern, true);
            }
        }
        if (denyPatterns != null) {
            for (j = 0; j < denyPatterns.size(); ++j) {
                pattern = denyPatterns.get(j);
                csConfig.getRule().addRule("PREFIX", pattern, false);
            }
        }
        csConfig.getRule().addRule("PREFIX", "*", false);
    }

    protected static void addProxyToWebCrawlspace(CrawlSpaceConfig csConfig, HttpProxySettings proxy) {
        if (proxy != null) {
            String strPort = Integer.toString(proxy.getPort());
            csConfig.getAgent().addProxy(proxy.getDomainName(), proxy.getHostName(), strPort, proxy.getUserId(), proxy.getPassword(), false);
        }
    }

    protected static void addBasicAuthToWebCrawlspace(CrawlSpaceConfig csConfig, HttpBasicAuth basicAuth, String url) {
        if (basicAuth != null) {
            csConfig.getAgent().addBasicAuth(url, basicAuth.getUserId(), basicAuth.getPassword(), null, null);
        }
    }

    protected static void addAgentInfoToWebCrawlspace(CrawlSpaceConfig csConfig, String agentName, String contactEmail) {
        csConfig.getAgent().setEmail(contactEmail);
        csConfig.getAgent().setName(agentName);
    }

    public static String generateStartURLForWebCrawlspace(String rootURL) {
        int index;
        String startURL = rootURL.trim();
        if (!StringUtils.startsWithIgnoreCase(startURL, HTTP_Prefix) && !StringUtils.startsWithIgnoreCase(startURL, HTTPS_Prefix)) {
            startURL = HTTP_Prefix + startURL;
        }
        if ((index = startURL.lastIndexOf(WebSeparatorChar)) < HTTPS_Prefix.length()) {
            startURL = startURL + WebSeparatorChar;
        }
        return startURL;
    }

    protected static String trimURLBackToSeparator(String url) {
        String returnURL = null;
        int index = url.lastIndexOf(WebSeparatorChar);
        returnURL = index >= HTTPS_Prefix.length() ? (index < url.length() - 1 ? url.substring(0, index + 1) : url) : url;
        return returnURL;
    }

    private void clearIndexOfDocuments(String collectionId, Constants.CrawlerType crawlerType) {
        TaskPool taskPool = GlobalSystem.getSingleInstance().getTaskPool();
        String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(crawlerType, collectionId);
        DeleteDocumentsRunnable deleteDocuments = new DeleteDocumentsRunnable(collectionId, crawlspaceId);
        taskPool.schedule(deleteDocuments);
    }

    private static class DeleteDocumentsRunnable
    implements Runnable {
        private String crawlspaceId = null;
        private String collectionId = null;

        private DeleteDocumentsRunnable(String collectionId, String crawlspaceId) {
            this.collectionId = collectionId;
            this.crawlspaceId = crawlspaceId;
        }

        public void run() {
            block2: {
                DocumentQueueInterface docQueue = GlobalSystem.getSingleInstance().getDocumentQueue();
                DeleteCrawlerDocument deleteDocument = new DeleteCrawlerDocument(this.crawlspaceId);
                try {
                    docQueue.addDocument(this.collectionId, deleteDocument);
                }
                catch (DocumentQueueInsertException e) {
                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block2;
                    Loggers.logger.log(Level.SEVERE, e);
                }
            }
        }
    }
}

