/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionFile;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.configuration.FieldMappingManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.configuration.RestartData;
import com.ibm.es.nuvo.configuration.ScoringWeights;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import com.ibm.es.nuvo.parser.config.ParserServiceConfigFactory;
import com.ibm.es.nuvo.parser.config.ParserServiceConfigLoader;
import com.ibm.es.nuvo.parser.config.ParserServiceConfigPublisher;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.ReliableFileInputStream;
import com.ibm.es.nuvo.util.ReliableFileOutputStream;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionConfiguration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String ConfigElement = "config";
    private static final String CollectionElement = "collection";
    private static final String DescriptionElement = "description";
    private static final String KnownLanguageElement = "knownLanguage";
    private static final String TokenizerToUseElement = "tokenizerToUse";
    private static final String EnabledForSearchElement = "enabledForSearch";
    private static final String SecureSearchElement = "secureSearch";
    private static final String SecureSearchPreFilterElement = "secureSearchPreFilter";
    private static final String SecureSearchPostFilterElement = "secureSearchPostFilter";
    private static final String NormalizeDocumentACLsElement = "normalizeDocumentACLs";
    private static final String StateElement = "state";
    private static final String ForceNgramForCJKElement = "forceNgramForCJK";
    private static final String IndexAllLemmasElement = "indexAllLemmas";
    private static final String SearchElement = "search";
    private static final String ProximityScoringElement = "proximityScoring";
    private static final String RemoveDuplicatesElement = "removeDuplicates";
    private static final String DynamicSummaryElement = "dynamicSummary";
    private static final String EnabledForSpellCorrectionElement = "enabledForSpellCorrection";
    private static final String IndexesElement = "indexes";
    private static final String IndexThrottleElement = "throttle";
    private static final String IndexThrottleMultiplierElement = "multiplier";
    private static final String QueryTimeoutElement = "queryTimeout";
    private static final String RebuildStateElement = "rebuildState";
    private static final String UpdateCountElement = "updateCount";
    private static final String ParserFileName = "parser_config.xml";
    private static final String CollectionFileName = "collection.xml";
    private static final String BackupFileName = "backup.dat";
    public static final String BackupGenFileName = "backupgen.dat";
    private static final Object fileIOLock = new Object();
    private String id;
    private String description = null;
    private String knownLanguage;
    private String tokenizerToUse;
    private boolean enabledForSearch = true;
    private boolean enabledForSpellCorrection = true;
    private DupElimination removeDuplicates = DupElimination.Exact;
    private boolean proximityScoring = true;
    private boolean provideDynamicSummary = true;
    private Vector<IndexDescriptor> indexDescriptors = null;
    private RestartData restartData = null;
    private State state = State.Normal;
    private int updateCount = 0;
    private RebuildState rebuildState = RebuildState.None;
    private boolean forceNgramForCJK = false;
    private boolean indexAllLemmas = false;
    private ScoringWeights scoringWeights = new ScoringWeights();
    private int indexThrottleMultiplier = 0;
    private boolean secureSearch = false;
    private boolean secureSearchPreFilter = false;
    private boolean secureSearchPostFilter = false;
    private boolean normalizeDocumentACLs = true;
    private int queryTimeout = 3000;
    private ParserServiceConfig parserServiceConfig = null;
    private FieldDefinitions fieldDefinitions = null;
    private FieldMappingManager fieldMappingManager = null;
    private long backupGeneration = -1L;

    private CollectionConfiguration() {
    }

    public static String getDefaultCollectionFileName() {
        String defaultConfigFileName = GlobalConfiguration.getConfiguration().getConfigFileName("defaults", CollectionFileName);
        return defaultConfigFileName;
    }

    private static String getDefaultParserFileName() {
        String defaultConfigFileName = GlobalConfiguration.getConfiguration().getConfigFileName("defaults", ParserFileName);
        return defaultConfigFileName;
    }

    public static CollectionConfiguration createDefault() throws ExtendedException {
        CollectionConfiguration collection = null;
        String defaultCollectionFileName = CollectionConfiguration.getDefaultCollectionFileName();
        String defaultParserFileName = CollectionConfiguration.getDefaultParserFileName();
        ReliableFileInputStream cis = null;
        InputStream pis = null;
        try {
            cis = new ReliableFileInputStream(defaultCollectionFileName);
            pis = new ReliableFileInputStream(defaultParserFileName);
            collection = CollectionConfiguration.loadFrom(cis, pis);
        }
        catch (FileNotFoundException e) {
            throw new ExtendedException(e);
        }
        finally {
            if (cis != null) {
                try {
                    ((InputStream)cis).close();
                }
                catch (IOException e) {}
            }
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (IOException e) {}
            }
        }
        collection.setId(ConfigurationManager.getDefaultCollectionName());
        collection.setForceNgramForCJK(!GlobalSystem.getSingleInstance().isLocaleCJK());
        if (collection.indexDescriptors != null) {
            collection.adjustIndexDescriptorsDirectories();
        }
        return collection;
    }

    public String getId() {
        return this.id;
    }

    public String getKnownLanguage() {
        return this.knownLanguage;
    }

    public String getTokenizerToUse() {
        return this.tokenizerToUse;
    }

    public DupElimination getRemoveDuplicates() {
        return this.removeDuplicates;
    }

    public boolean getProvideDynamicSummary() {
        return this.provideDynamicSummary;
    }

    public boolean getProximityScoring() {
        return this.proximityScoring;
    }

    public String getIndexPath(IndexDescriptor.IndexType indexType) {
        String path = null;
        IndexDescriptor indexDescriptor = this.getIndexDescriptorFor(indexType);
        if (indexDescriptor != null) {
            path = indexDescriptor.getAbsolutePath();
        }
        return path;
    }

    public FieldMappingManager getFieldMappingManager() {
        if (this.fieldMappingManager == null) {
            this.fieldMappingManager = new FieldMappingManager();
        }
        this.fieldMappingManager.setCollectionConfiguration(this);
        return this.fieldMappingManager;
    }

    public void setFieldMappingManager(FieldMappingManager fieldMappingManager) {
        this.fieldMappingManager = fieldMappingManager;
    }

    public void setProvideDynamicSummaryStr(String string) {
        this.setProvideDynamicSummary(string != null && string.equalsIgnoreCase("true"));
    }

    public void setProximityScoringStr(String string) {
        this.setEnableProximityScoring(string != null && string.equalsIgnoreCase("true"));
    }

    public void setProvideDynamicSummary(boolean provideDynamicSummary) {
        this.provideDynamicSummary = provideDynamicSummary;
    }

    public void setEnableProximityScoring(boolean enableProximityScoring) {
        this.proximityScoring = enableProximityScoring;
    }

    public void setParentIndexDirectory(String directory) {
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        Vector<IndexDescriptor> indexDescriptors1 = this.getIndexDescriptors();
        for (int i = 0; i < indexDescriptors1.size(); ++i) {
            IndexDescriptor indexDescriptor = indexDescriptors1.get(i);
            IndexDescriptor.IndexType indexType = indexDescriptor.getType();
            indexDescriptor.setPath(directory + IndexDescriptor.getDefaultDirectoryName(indexType));
        }
        this.setIndexDescriptors(indexDescriptors1);
    }

    public Vector<IndexDescriptor> getIndexDescriptors() {
        return this.indexDescriptors;
    }

    public IndexDescriptor getIndexDescriptorFor(IndexDescriptor.IndexType indexType) {
        IndexDescriptor foundIndexDescriptor = null;
        Vector<IndexDescriptor> descriptors = this.getIndexDescriptors();
        if (indexType != null && descriptors != null) {
            for (int i = 0; i < descriptors.size() && foundIndexDescriptor == null; ++i) {
                IndexDescriptor indexDescriptor = descriptors.get(i);
                if (!indexDescriptor.getType().equals((Object)indexType)) continue;
                foundIndexDescriptor = indexDescriptor;
            }
        }
        return foundIndexDescriptor;
    }

    public boolean isIndexDescriptorDefined(IndexDescriptor.IndexType indexType) {
        IndexDescriptor indexDescriptor = this.getIndexDescriptorFor(indexType);
        return indexDescriptor != null;
    }

    public String getCollectionDirectory() {
        return CollectionConfiguration.buildCollectionPath(this.id);
    }

    public String getCrawlerDataDirectory(Constants.CrawlerType crawlerType) {
        return CollectionConfiguration.getCrawlerDataDirectory(crawlerType, this.id);
    }

    public State getState() {
        return this.state;
    }

    public boolean isInState(State[] validStates) {
        boolean valid = false;
        if (validStates != null && validStates.length > 0) {
            for (int i = 0; i < validStates.length && !valid; ++i) {
                valid = this.state.equals((Object)validStates[i]);
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public String getCrawlspaceId(Constants.CrawlerType crawlerType) {
        return CollectionConfiguration.collectionIdToCrawlspaceId(crawlerType, this.id);
    }

    public boolean isEnabledForSpellCorrection() {
        return this.enabledForSpellCorrection;
    }

    public boolean isEnabledForSearch() {
        return this.enabledForSearch;
    }

    public ScoringWeights getScoringWeights() {
        return this.scoringWeights;
    }

    public String getDescription() {
        return this.description;
    }

    public FieldDefinitions getFieldDefinitions() {
        if (this.fieldDefinitions != null) {
            this.fieldDefinitions.setCollectionConfiguration(this);
        }
        return this.fieldDefinitions;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public boolean isRebuilding() {
        return this.rebuildState != null && this.rebuildState.equals((Object)RebuildState.InProgress);
    }

    public RebuildState getRebuildState() {
        return this.rebuildState;
    }

    public void setRebuildState(RebuildState state) {
        this.rebuildState = state;
    }

    protected int getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    protected synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    protected RestartData getRestartData() {
        return this.restartData;
    }

    public void setRestartData(RestartData restartData) {
        this.restartData = restartData;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public void setFieldDefinitions(FieldDefinitions fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScoringWeights(ScoringWeights scoringWeights) {
        this.scoringWeights = scoringWeights;
    }

    public void setEnabledForSearch(boolean enabledForSearch) {
        this.enabledForSearch = enabledForSearch;
    }

    public void setEnabledForSpellCorrection(boolean enabledForSpellCorrection) {
        this.enabledForSpellCorrection = enabledForSpellCorrection;
    }

    public void setIndexDescriptors(Vector<IndexDescriptor> indexDescriptions) {
        this.indexDescriptors = indexDescriptions;
    }

    public ParserServiceConfig getParserServiceConfig() {
        if (this.parserServiceConfig != null) {
            this.parserServiceConfig.setCollectionConfiguration(this);
        }
        return this.parserServiceConfig;
    }

    public void setParserServiceConfig(ParserServiceConfig parserServiceConfig) {
        this.parserServiceConfig = parserServiceConfig;
    }

    public void setId(String id) {
        String systemDefaultDataDirectory;
        String oldId = this.id;
        this.id = id;
        if (this.id != null && !this.id.equals(oldId) && this.indexDescriptors != null && (systemDefaultDataDirectory = GlobalConfiguration.getConfiguration().getDefaultDataDirectory()) != null && systemDefaultDataDirectory.length() > 0) {
            this.adjustIndexDescriptorsDirectories();
        }
    }

    private void setId_skipDescriptors(String collectionId) {
        this.id = collectionId;
    }

    public void setKnownLanguage(String knownLanguage) {
        this.knownLanguage = knownLanguage;
    }

    public void setTokenizerToUse(String tokenizerToUse) {
        this.tokenizerToUse = tokenizerToUse;
    }

    public String getDefaultDataDirectoryFor(IndexDescriptor.IndexType indexType) {
        String dataDirectory = this.getDefaultDataDirectory() + File.separator + IndexDescriptor.getDefaultDirectoryName(indexType);
        return dataDirectory;
    }

    public void setForceNgramForCJK(boolean forceNgramForCJK) {
        this.forceNgramForCJK = forceNgramForCJK;
    }

    public void setForceNgramForCJKStr(String forceNgramForCJK) {
        this.forceNgramForCJK = "true".equalsIgnoreCase(forceNgramForCJK);
    }

    public boolean isForceNgramForCJK() {
        return this.forceNgramForCJK;
    }

    public void setIndexAllLemmasStr(String all) {
        this.indexAllLemmas = "true".equalsIgnoreCase(all);
    }

    public boolean isIndexAllLemmas() {
        return this.indexAllLemmas;
    }

    public void setIndexThrottleMultiplier(int multiplier) {
        this.indexThrottleMultiplier = multiplier;
    }

    public boolean isSecureSearch() {
        return this.secureSearch;
    }

    public void setSecureSearch(boolean secureSearch) {
        this.secureSearch = secureSearch;
    }

    public boolean isSecureSearchPreFilter() {
        return this.secureSearchPreFilter;
    }

    public boolean isSecureSearchPostFilter() {
        return this.secureSearchPostFilter;
    }

    public boolean isNormalizeDocumentACLs() {
        return this.normalizeDocumentACLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionConfiguration load(String collectionId) throws IOException, ExtendedException {
        CollectionConfiguration collection = null;
        Object object = fileIOLock;
        synchronized (object) {
            String pathName = CollectionConfiguration.buildCollectionPath(collectionId);
            String collectionFilePath = CollectionConfiguration.buildCollectionComponentFileName(pathName);
            String parserFilePath = CollectionConfiguration.buildParserComponentFileName(pathName);
            ReliableFileInputStream cis = null;
            InputStream pis = null;
            try {
                cis = new ReliableFileInputStream(collectionFilePath);
                pis = new ReliableFileInputStream(parserFilePath);
                collection = CollectionConfiguration.loadFrom(cis, pis);
            }
            finally {
                if (cis != null) {
                    ((InputStream)cis).close();
                }
                if (pis != null) {
                    pis.close();
                }
            }
            collection.setId_skipDescriptors(collectionId);
        }
        return collection;
    }

    public static CollectionConfiguration loadFrom(InputStream collectionStream, InputStream parserStream) throws ExtendedException {
        CollectionConfiguration collection = CollectionConfiguration.loadBaseComponentFrom(collectionStream);
        if (parserStream != null) {
            ParserServiceConfigLoader loader = ParserServiceConfigFactory.getLoader();
            ParserServiceConfig config = loader.load(parserStream);
            collection.setParserServiceConfig(config);
        }
        return collection;
    }

    private static CollectionConfiguration loadBaseComponentFrom(InputStream is) throws ExtendedException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String collectionKey = "/config/collection/";
        tree.addPath(collectionKey + DescriptionElement, "setDescription");
        tree.addPath(collectionKey + KnownLanguageElement, "setKnownLanguage");
        tree.addPath(collectionKey + TokenizerToUseElement, "setTokenizerToUse");
        tree.addPath(collectionKey + EnabledForSearchElement, "setEnabledForSearchStr");
        tree.addPath(collectionKey + RebuildStateElement, "setRebuildStateStr");
        tree.addPath(collectionKey + StateElement, "setStateStr");
        tree.addPath(collectionKey + ForceNgramForCJKElement, "setForceNgramForCJKStr");
        tree.addPath(collectionKey + IndexAllLemmasElement, "setIndexAllLemmasStr");
        tree.addPath(collectionKey + SearchElement + "/" + ProximityScoringElement, "setProximityScoringStr");
        tree.addPath(collectionKey + SearchElement + "/" + RemoveDuplicatesElement, "setDupEliminationStr");
        tree.addPath(collectionKey + SearchElement + "/" + DynamicSummaryElement, "setProvideDynamicSummaryStr");
        tree.addPath(collectionKey + SearchElement + "/" + EnabledForSpellCorrectionElement, "setEnabledForSpellCorrectionStr");
        tree.addPath(collectionKey + SearchElement + "/" + SecureSearchElement, "setEnabledForSecureSearchStr");
        tree.addPath(collectionKey + SearchElement + "/" + SecureSearchPreFilterElement, "setEnabledForSecureSearchPreFilterStr");
        tree.addPath(collectionKey + SearchElement + "/" + SecureSearchPostFilterElement, "setEnabledForSecureSearchPostFilterStr");
        tree.addPath(collectionKey + SearchElement + "/" + NormalizeDocumentACLsElement, "setNormalizeDocumentACLsStr");
        tree.addPath(collectionKey + SearchElement + "/" + QueryTimeoutElement, "setQueryTimeoutStr");
        tree.addPath(collectionKey + IndexThrottleElement + "/" + IndexThrottleMultiplierElement, "setIndexThrottleMultiplier", Integer.TYPE);
        tree.addPath(collectionKey + UpdateCountElement, "setUpdateCount", Integer.TYPE);
        tree.addSetSubcomponent(collectionKey + "scoring", "buildScoringWeights");
        ScoringWeights.prepareParseTree(collectionKey, tree);
        tree.addSetSubcomponent(collectionKey + IndexesElement + "/" + "index", "buildIndexDescriptor");
        IndexDescriptor.prepareParseTree(collectionKey + IndexesElement, tree);
        tree.addSetSubcomponent(collectionKey + "fields", "buildFieldDefinitions");
        FieldDefinitions.prepareParseTree(collectionKey, tree);
        tree.addSetSubcomponent(collectionKey + "mappings", "buildFieldMappingManager");
        FieldMappingManager.prepareParseTree(collectionKey, tree);
        tree.addSetSubcomponent(collectionKey + "restart_data", "buildRestartData");
        RestartData.prepareParseTree(collectionKey, tree);
        CollectionConfiguration configuration = new CollectionConfiguration();
        parser.parse(is, tree, configuration);
        if (configuration.getFieldDefinitions() == null) {
            configuration.setFieldDefinitions(FieldDefinitions.createDefault());
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(String collectionDirectory) throws IOException, ExtendedException {
        Object object = fileIOLock;
        synchronized (object) {
            ReliableFileOutputStream pos = null;
            String parserFile = CollectionConfiguration.buildParserComponentFileName(collectionDirectory);
            ParserServiceConfig parserConfig = this.getParserServiceConfig();
            if (parserConfig == null) {
                boolean deleted;
                File fParser = new File(parserFile);
                if (fParser.exists() && !(deleted = fParser.delete())) {
                    Message msg = new Message("G0119E.FILE_DELETE_ERROR", parserFile);
                    ConfigurationManagerException e = new ConfigurationManagerException(msg);
                    throw e;
                }
            } else {
                try {
                    pos = new ReliableFileOutputStream(parserFile);
                    ParserServiceConfigPublisher publisher = ParserServiceConfigFactory.getPublisher();
                    publisher.publish(pos, parserConfig);
                }
                finally {
                    if (pos != null) {
                        pos.close();
                    }
                }
            }
            ReliableFileOutputStream fos = null;
            String collectionFile = CollectionConfiguration.buildCollectionComponentFileName(collectionDirectory);
            try {
                fos = new ReliableFileOutputStream(collectionFile);
                this.writeCollectionComponentTo(fos);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public void writeTo(XMLTagger xmlTagger, String collectionDataElement, String parserDataElement) throws ExtendedException {
        xmlTagger.startElement(collectionDataElement);
        this.writeCollectionComponentTo(xmlTagger);
        xmlTagger.endElement(collectionDataElement);
        ParserServiceConfig parserConfig = this.getParserServiceConfig();
        if (parserConfig != null) {
            ParserServiceConfigPublisher publisher = ParserServiceConfigFactory.getPublisher();
            xmlTagger.startElement(parserDataElement);
            publisher.publish(xmlTagger, parserConfig);
            xmlTagger.endElement(parserDataElement);
        }
    }

    public void writeCollectionComponentTo(OutputStream os) throws IOException {
        XMLTagger xmlTagger = new XMLTagger(true);
        xmlTagger.startPI("xml");
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.writeAttr("encoding", "UTF-8");
        xmlTagger.endPI();
        this.writeCollectionComponentTo(xmlTagger);
        String xmlDoc = xmlTagger.getXML();
        try {
            os.write(xmlDoc.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            os.write(xmlDoc.getBytes());
        }
    }

    private void writeCollectionComponentTo(XMLTagger xmlTagger) {
        ScoringWeights localScoringWeights;
        xmlTagger.openStartElement(ConfigElement);
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.closeTag();
        xmlTagger.startElement(CollectionElement);
        if (!this.state.equals((Object)State.Normal)) {
            xmlTagger.startElement(StateElement);
            xmlTagger.writeText(this.state.toString());
            xmlTagger.endElement(StateElement);
        }
        if (this.restartData != null) {
            this.restartData.writeTo(xmlTagger);
        }
        xmlTagger.startElement(UpdateCountElement);
        xmlTagger.writeText(String.valueOf(this.updateCount));
        xmlTagger.endElement(UpdateCountElement);
        xmlTagger.startElement(EnabledForSearchElement);
        xmlTagger.writeText(String.valueOf(this.isEnabledForSearch()));
        xmlTagger.endElement(EnabledForSearchElement);
        if (this.rebuildState != null) {
            xmlTagger.startElement(RebuildStateElement);
            xmlTagger.writeText(this.rebuildState.toString());
            xmlTagger.endElement(RebuildStateElement);
        }
        xmlTagger.startElement(SearchElement);
        xmlTagger.startElement(RemoveDuplicatesElement);
        switch (this.removeDuplicates) {
            case Exact: {
                xmlTagger.writeText("Exact");
                break;
            }
            case None: {
                xmlTagger.writeText("None");
                break;
            }
            case NearAndExact: {
                xmlTagger.writeText("NearAndExact");
                break;
            }
            default: {
                xmlTagger.writeText("None");
            }
        }
        xmlTagger.endElement(RemoveDuplicatesElement);
        xmlTagger.startElement(DynamicSummaryElement);
        xmlTagger.writeText(Boolean.toString(this.getProvideDynamicSummary()));
        xmlTagger.endElement(DynamicSummaryElement);
        xmlTagger.startElement(EnabledForSpellCorrectionElement);
        xmlTagger.writeText(Boolean.toString(this.isEnabledForSpellCorrection()));
        xmlTagger.endElement(EnabledForSpellCorrectionElement);
        xmlTagger.startElement(ProximityScoringElement);
        xmlTagger.writeText(Boolean.toString(this.getProximityScoring()));
        xmlTagger.endElement(ProximityScoringElement);
        xmlTagger.startElement(SecureSearchElement);
        xmlTagger.writeText(Boolean.toString(this.secureSearch));
        xmlTagger.endElement(SecureSearchElement);
        xmlTagger.startElement(SecureSearchPreFilterElement);
        xmlTagger.writeText(Boolean.toString(this.secureSearchPreFilter));
        xmlTagger.endElement(SecureSearchPreFilterElement);
        xmlTagger.startElement(SecureSearchPostFilterElement);
        xmlTagger.writeText(Boolean.toString(this.secureSearchPostFilter));
        xmlTagger.endElement(SecureSearchPostFilterElement);
        xmlTagger.startElement(NormalizeDocumentACLsElement);
        xmlTagger.writeText(Boolean.toString(this.normalizeDocumentACLs));
        xmlTagger.endElement(NormalizeDocumentACLsElement);
        xmlTagger.startElement(QueryTimeoutElement);
        xmlTagger.writeText(String.valueOf(this.queryTimeout));
        xmlTagger.endElement(QueryTimeoutElement);
        xmlTagger.endElement(SearchElement);
        if (this.knownLanguage != null) {
            xmlTagger.startElement(KnownLanguageElement);
            xmlTagger.writeText(this.knownLanguage);
            xmlTagger.endElement(KnownLanguageElement);
        }
        if (this.tokenizerToUse != null) {
            xmlTagger.startElement(TokenizerToUseElement);
            xmlTagger.writeText(this.tokenizerToUse);
            xmlTagger.endElement(TokenizerToUseElement);
        }
        if (this.description != null) {
            xmlTagger.startElement(DescriptionElement);
            xmlTagger.writeText(this.description);
            xmlTagger.endElement(DescriptionElement);
        }
        xmlTagger.startElement(ForceNgramForCJKElement);
        xmlTagger.writeText(String.valueOf(this.forceNgramForCJK));
        xmlTagger.endElement(ForceNgramForCJKElement);
        xmlTagger.startElement(IndexAllLemmasElement);
        xmlTagger.writeText(String.valueOf(this.indexAllLemmas));
        xmlTagger.endElement(IndexAllLemmasElement);
        Vector<IndexDescriptor> localIndexDescriptors = this.getIndexDescriptors();
        if (localIndexDescriptors.size() > 0) {
            xmlTagger.startElement(IndexesElement);
            for (int i = 0; i < localIndexDescriptors.size(); ++i) {
                IndexDescriptor indexDescriptor = localIndexDescriptors.get(i);
                indexDescriptor.writeTo(xmlTagger);
            }
            xmlTagger.endElement(IndexesElement);
        }
        if ((localScoringWeights = this.getScoringWeights()) != null) {
            localScoringWeights.writeTo(xmlTagger);
        }
        xmlTagger.startElement(IndexThrottleElement);
        xmlTagger.startElement(IndexThrottleMultiplierElement);
        xmlTagger.writeText(String.valueOf(this.indexThrottleMultiplier));
        xmlTagger.endElement(IndexThrottleMultiplierElement);
        xmlTagger.endElement(IndexThrottleElement);
        if (this.fieldDefinitions != null) {
            this.fieldDefinitions.writeTo(xmlTagger);
        }
        if (this.fieldMappingManager != null) {
            this.fieldMappingManager.writeTo(xmlTagger);
        }
        xmlTagger.endElement(CollectionElement);
        xmlTagger.endElement(ConfigElement);
    }

    protected String getDefaultDataDirectory() {
        String dataDirectory = null;
        String defaultDataDirectory = GlobalConfiguration.getConfiguration().getDefaultDataDirectory();
        if (defaultDataDirectory == null || defaultDataDirectory.length() == 0) {
            dataDirectory = "data";
        } else {
            dataDirectory = defaultDataDirectory;
            if (!dataDirectory.endsWith(File.separator)) {
                dataDirectory = dataDirectory + File.separator;
            }
            dataDirectory = dataDirectory + this.id;
        }
        return dataDirectory;
    }

    public static String buildCollectionPath(String collectionId) {
        String pathName = ConfigurationManager.getConfigurationManager().buildIdDirectoryName(collectionId);
        return pathName;
    }

    protected static String getCollectionFileName() {
        return CollectionFileName;
    }

    public static String buildCollectionComponentFileName(String collectionDirectory) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(collectionDirectory);
        if (!collectionDirectory.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(CollectionConfiguration.getCollectionFileName());
        return sb.toString();
    }

    protected static String buildParserComponentFileName(String collectionDirectory) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(collectionDirectory);
        if (!collectionDirectory.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(ParserFileName);
        return sb.toString();
    }

    protected static String buildCollectionWebCrawlSpaceFileName(String collectionId) {
        StringBuffer sb = new StringBuffer(200);
        if (collectionId != null) {
            sb.append(CollectionConfiguration.buildCollectionPath(collectionId));
            sb.append(File.separator);
            sb.append("web_crawlspace.xml");
        }
        return sb.toString();
    }

    public static String getCrawlerDataDirectory(Constants.CrawlerType crawlerType, String collectionId) {
        StringBuffer path = new StringBuffer(100);
        path.append(CollectionConfiguration.buildCollectionPath(collectionId));
        path.append(File.separator);
        if (crawlerType.equals((Object)Constants.CrawlerType.Web)) {
            path.append("cloudscape_web");
        } else {
            path.append("cloudscape_unknown");
        }
        return path.toString();
    }

    public static String collectionIdToCrawlspaceId(Constants.CrawlerType crawlerType, String collectionId) {
        String crawlspaceId = null;
        if (crawlerType.equals((Object)Constants.CrawlerType.Web)) {
            crawlspaceId = collectionId;
        }
        return crawlspaceId;
    }

    public static String crawlspaceIdToCollectionId(String crawlspaceId) {
        String collectionId = null;
        collectionId = crawlspaceId;
        return collectionId;
    }

    public void setEnabledForSpellCorrectionStr(String enabledForSpellCorrection) {
        this.enabledForSpellCorrection = enabledForSpellCorrection.equalsIgnoreCase("true");
    }

    public void setEnabledForSearchStr(String enabledForSearch) {
        this.enabledForSearch = enabledForSearch.equalsIgnoreCase("true");
    }

    public void setQueryTimeoutStr(String timeout) {
        this.queryTimeout = Integer.parseInt(timeout);
    }

    public void setEnabledForSecureSearchStr(String enabled) {
        this.secureSearch = enabled.equalsIgnoreCase("true");
    }

    public void setEnabledForSecureSearchPreFilterStr(String enabled) {
        this.secureSearchPreFilter = !enabled.equalsIgnoreCase("false");
    }

    public void setEnabledForSecureSearchPostFilterStr(String enabled) {
        this.secureSearchPostFilter = !enabled.equalsIgnoreCase("false");
    }

    public void setNormalizeDocumentACLsStr(String enabled) {
        this.normalizeDocumentACLs = !enabled.equalsIgnoreCase("false");
    }

    public void setRebuildStateStr(String strState) {
        this.rebuildState = RebuildState.valueOf(strState);
    }

    public void setDupEliminationStr(String removeDups) {
        if (removeDups.equalsIgnoreCase("Exact")) {
            this.removeDuplicates = DupElimination.Exact;
        } else if (removeDups.equalsIgnoreCase("None")) {
            this.removeDuplicates = DupElimination.None;
        } else if (removeDups.equalsIgnoreCase("NearAndExact")) {
            this.removeDuplicates = DupElimination.NearAndExact;
        }
    }

    public void setStateStr(String newState) {
        this.state = State.valueOf(newState);
    }

    public int getIndexThrottleMultiplier() {
        return this.indexThrottleMultiplier;
    }

    public void setThrottleMultiplier(int throttleMultiplier) {
        this.indexThrottleMultiplier = throttleMultiplier;
    }

    public void setRemoveDuplicates(DupElimination dupElimination) {
        this.removeDuplicates = dupElimination;
    }

    public ScoringWeights buildScoringWeights() {
        if (this.scoringWeights == null) {
            this.scoringWeights = new ScoringWeights();
        }
        return this.scoringWeights;
    }

    public FieldDefinitions buildFieldDefinitions() {
        if (this.fieldDefinitions == null) {
            this.fieldDefinitions = new FieldDefinitions();
        }
        return this.fieldDefinitions;
    }

    public FieldMappingManager buildFieldMappingManager() {
        if (this.fieldMappingManager == null) {
            this.fieldMappingManager = new FieldMappingManager();
        }
        return this.fieldMappingManager;
    }

    public RestartData buildRestartData() {
        if (this.restartData == null) {
            this.restartData = new RestartData();
        }
        return this.restartData;
    }

    public IndexDescriptor buildIndexDescriptor() {
        if (this.indexDescriptors == null) {
            this.indexDescriptors = new Vector();
        }
        IndexDescriptor indexDescriptor = new IndexDescriptor();
        indexDescriptor.setCollection(this);
        this.indexDescriptors.add(indexDescriptor);
        return indexDescriptor;
    }

    private void adjustIndexDescriptorsDirectories() {
        Vector<IndexDescriptor> indexes = this.getIndexDescriptors();
        String defaultDataDirectory = this.getDefaultDataDirectory() + File.separator;
        for (int i = 0; i < indexes.size(); ++i) {
            IndexDescriptor indexDesc = indexes.elementAt(i);
            String dataDir = defaultDataDirectory + IndexDescriptor.getDefaultDirectoryName(indexDesc.getType());
            indexDesc.setPath(dataDir);
        }
    }

    public Iterator<CollectionFile> getFilesForBackup() {
        return this.getFilesForBackup(null);
    }

    public Iterator<CollectionFile> getFilesForBackup(IndexDescriptor.IndexType[] indexTypesToBackup) {
        int j;
        LinkedList<CollectionFile> filesForBackup = new LinkedList<CollectionFile>();
        File[] collectionDirFiles = new File(this.getCollectionDirectory()).listFiles();
        int numberOfFiles = collectionDirFiles == null ? 0 : collectionDirFiles.length;
        for (j = 0; j < numberOfFiles; ++j) {
            if (collectionDirFiles[j].isDirectory()) continue;
            try {
                filesForBackup.add(new CollectionFile(this.id, collectionDirFiles[j].getName()));
                continue;
            }
            catch (ExtendedException e) {
                // empty catch block
            }
        }
        for (j = 0; j < this.indexDescriptors.size(); ++j) {
            IndexDescriptor indexDescriptor = this.indexDescriptors.get(j);
            if (indexDescriptor == null) continue;
            if (indexTypesToBackup != null) {
                boolean found = false;
                for (int k = 0; k < indexTypesToBackup.length && !found; ++k) {
                    if (!indexTypesToBackup[k].equals((Object)indexDescriptor.getType())) continue;
                    found = true;
                }
                if (!found) continue;
            }
            this.cumulateIndexFilesForBackup(indexDescriptor, filesForBackup);
        }
        return filesForBackup.iterator();
    }

    public File getBackupMetadataFile() {
        return new File(this.getCollectionDirectory(), BackupFileName);
    }

    private void cumulateIndexFilesForBackup(IndexDescriptor indexDescriptor, List<CollectionFile> list) {
        File indexDirectory = new File(indexDescriptor.getPath());
        boolean absolute = indexDirectory.isAbsolute();
        File absoluteIndexDirectory = absolute ? indexDirectory : new File(indexDescriptor.getAbsolutePath());
        int prefixLength = 0;
        if (!absolute) {
            String prefix = new File(this.getCollectionDirectory()).getAbsolutePath();
            if (!prefix.endsWith(File.separator)) {
                prefix = prefix + File.separator;
            }
            prefixLength = prefix.length();
        }
        this.cumulateFilesRecursively(prefixLength, absoluteIndexDirectory, list);
    }

    private void cumulateFilesRecursively(int prefixLength, File file, List<CollectionFile> list) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int j = 0; j < (files == null ? 0 : files.length); ++j) {
                this.cumulateFilesRecursively(prefixLength, files[j], list);
            }
        } else {
            String path = file.getAbsolutePath();
            if (prefixLength > 0) {
                path = path.substring(prefixLength);
            }
            try {
                list.add(new CollectionFile(this.id, path));
            }
            catch (ExtendedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long getBackupGeneration() {
        File backupGenFile;
        if (this.backupGeneration < 0L && (backupGenFile = new File(this.getCollectionDirectory(), BackupGenFileName)).canRead()) {
            DataInputStream dis = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(backupGenFile);
                dis = new DataInputStream(fis);
                this.backupGeneration = dis.readLong();
            }
            catch (Throwable t) {
                BackupUtil.assuredClose(dis);
                BackupUtil.assuredClose(fis);
                catch (Throwable throwable) {
                    BackupUtil.assuredClose(dis);
                    BackupUtil.assuredClose(fis);
                    throw throwable;
                }
            }
            BackupUtil.assuredClose(dis);
            BackupUtil.assuredClose(fis);
        }
        if (this.backupGeneration < 0L) {
            this.backupGeneration = 0L;
            this.saveBackupGeneration();
        }
        return this.backupGeneration;
    }

    public void incrementBackupGeneration() {
        this.backupGeneration = this.getBackupGeneration() + 1L;
        this.saveBackupGeneration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBackupGeneration() {
        FilterOutputStream dos = null;
        FileOutputStream fos = null;
        boolean saved = true;
        long valueToSave = this.backupGeneration;
        try {
            File backupGenFile = new File(this.getCollectionDirectory(), BackupGenFileName);
            fos = new FileOutputStream(backupGenFile);
            dos = new DataOutputStream(fos);
            ((DataOutputStream)dos).writeLong(valueToSave);
        }
        catch (Throwable t) {
            saved = false;
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Throwable t) {
                saved = false;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Throwable t) {
                saved = false;
            }
        }
        this.backupGeneration = saved ? valueToSave : -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RebuildState {
        None,
        InProgress,
        Complete,
        FinishedWithErrors;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DupElimination {
        None,
        Exact,
        NearAndExact;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Normal("G0168I.COLLECTION_STATE_NORMAL"),
        IndexComponentDeletePending("G0168I.COLLECTION_STATE_INDEX_COMPONENT_DELETE_PENDING"),
        DeletePending("G0168I.COLLECTION_STATE_DELETE_PENDING"),
        Restoring("G0168I.COLLECTION_STATE_RESTORING"),
        ClearPending("G0168I.COLLECTION_STATE_CLEAR"),
        RenamePending("G0168I.COLLECTION_STATE_RENAMING");

        String msgKey = null;

        private State(String aMsgKey) {
            this.msgKey = aMsgKey;
        }

        public String getText() {
            Message msg = new Message(this.msgKey);
            return msg.getFormattedText();
        }
    }
}

