/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.cache.CacheLoader;
import com.ibm.es.nuvo.cache.ObjectCache;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConfigurationManager
implements CacheLoader<Object, Object> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String ConfigurationObjectCreated = "ConfigurationObjectCreated";
    public static final String ConfigurationObjectRenamed = "ConfigurationObjectRenamed";
    public static final String ConfigurationObjectRemoved = "ConfigurationObjectRemoved";
    public static final String ConfigurationObjectUpdated = "ConfigurationObjectUpdated";
    private static final int DefaultConfigCacheSize = 100;
    protected ObjectCache<Object, Object> configurationCache;
    private PropertyChangeSupport propertyChangeSupport = null;
    private Vector<WeakReference<Object>> updateableInstances = new Vector();

    protected BaseConfigurationManager() {
        this(100);
    }

    private BaseConfigurationManager(int cacheSize) {
        Properties props = new Properties();
        props.put("cache.size", (Object)cacheSize);
        this.configurationCache = new ObjectCache(props);
        this.configurationCache.setCacheLoader(this);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    protected void firePropertyChangeEvent(String event, String oldObjectId, Object newObjectId) {
        this.propertyChangeSupport.firePropertyChange(event, oldObjectId, newObjectId);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    protected void markAsUpdateable(Object obj) {
        if (obj != null) {
            this.updateableInstances.add(new WeakReference<Object>(obj));
        }
    }

    protected boolean isUpdateable(Object obj) {
        return this.searchUpdateListFor(obj, false);
    }

    protected void removeFromUpdateableList(Object obj) {
        this.searchUpdateListFor(obj, true);
    }

    private boolean searchUpdateListFor(Object obj, boolean removeIfFound) {
        boolean found = false;
        for (int i = this.updateableInstances.size() - 1; i >= 0; --i) {
            WeakReference<Object> wrObject = this.updateableInstances.get(i);
            Object obj2 = wrObject.get();
            if (obj2 == null) {
                this.updateableInstances.remove(i);
                continue;
            }
            if (obj2 != obj) continue;
            found = true;
            if (!removeIfFound) continue;
            this.updateableInstances.remove(i);
        }
        return found;
    }
}

