/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.configuration;

import com.ibm.es.nuvo.api.AdminService;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.documenttracking.DocumentTracker;
import com.ibm.es.nuvo.documenttracking.DocumentTrackingInformation;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.common.ApplicationInfo;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;

public class AdminServiceImpl
implements AdminService {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public void createCollection(ApplicationInfo appInfo, CollectionConfiguration configuration) throws SiapiException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        try {
            configurationManager.createCollection(configuration, true);
        }
        catch (ConfigurationManagerException e) {
            SiapiException siapiException = new SiapiException(1, 24, "Cannot create collection", (Throwable)e);
            throw siapiException;
        }
    }

    public void createCollection(ApplicationInfo appInfo, String collectionId, String collectionLabel, int optimizationMode, String defaultLanguage, Properties configProperties) throws SiapiException {
        CollectionConfiguration config;
        try {
            config = CollectionConfiguration.createDefault();
        }
        catch (Exception e) {
            throw new SiapiException(1, 24, "Cannot create collection", (Throwable)e);
        }
        config.setId(collectionId);
        this.createCollection(appInfo, config);
    }

    public void createImportedReorganizedCollection(ApplicationInfo arg0, String arg1, String arg2, int arg3, String arg4, String arg5, Properties arg6) throws SiapiException {
    }

    public void destroyCollection(ApplicationInfo appInfo, String collectionId) throws SiapiException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        try {
            configurationManager.removeCollection(collectionId);
        }
        catch (ConfigurationManagerException e) {
            SiapiException siapiException = new SiapiException(1, 24, "Cannot remove collection", (Throwable)e);
            throw siapiException;
        }
        catch (ConfigurationObjectNotExistsException e) {
            SiapiException siapiException = new SiapiException(1, 24, "Cannot remove collection", (Throwable)e);
            throw siapiException;
        }
        catch (InterruptedException e) {
            SiapiException siapiException = new SiapiException(1, 24, "Cannot remove collection", (Throwable)e);
            throw siapiException;
        }
    }

    public String[] getSearchableCollectionIDs(ApplicationInfo arg0) throws SiapiException {
        return null;
    }

    public String[] getIndexableCollectionIDs(ApplicationInfo arg0) throws SiapiException {
        return null;
    }

    public boolean isEnabledForSearch(ApplicationInfo arg0, String arg1, Properties arg2) throws SiapiException {
        return false;
    }

    public boolean isEnabledForIndexing(ApplicationInfo arg0, String arg1) throws SiapiException {
        return false;
    }

    public void enableCollectionForSearch(ApplicationInfo arg0, String arg1, Properties arg2) throws SiapiException {
    }

    public void disableCollectionForSearch(ApplicationInfo arg0, String arg1, Properties arg2) throws SiapiException {
    }

    public void enableCollectionForIndexing(ApplicationInfo arg0, String arg1, Properties arg2) throws SiapiException {
    }

    public void disableCollectionForIndexing(ApplicationInfo arg0, String arg1, Properties arg2) throws SiapiException {
    }

    public String performAdminCommand(ApplicationInfo arg0, String arg1, String arg2, Properties arg3) throws SiapiException {
        return null;
    }

    public void createRemoteFederator(ApplicationInfo arg0, String arg1, Properties arg2, String[] arg3) throws SiapiException {
    }

    public void associateApplicationWithCollection(ApplicationInfo arg0, String arg1, String arg2) throws SiapiException {
    }

    public void associateApplicationWithCollection(ApplicationInfo arg0, String arg1, String arg2, int arg3) throws SiapiException {
    }

    public void disassociateApplicationFromCollection(ApplicationInfo arg0, String arg1, String arg2) throws SiapiException {
    }

    public void registerApplication(ApplicationInfo arg0, ApplicationInfo arg1, int arg2) throws SiapiException {
    }

    public void unregisterApplication(ApplicationInfo arg0, String arg1) throws SiapiException {
    }

    public void getDocumentStatus(ApplicationInfo appInfo, String collectionId, String urlPattern, int startOffset, int maxHit, OutputStream os) throws SiapiException {
        DocumentTracker tracker = new DocumentTracker();
        try {
            Vector<DocumentTrackingInformation> allInfo = new Vector<DocumentTrackingInformation>();
            boolean truncated = tracker.getDocumentInformation(collectionId, urlPattern, startOffset, maxHit, allInfo);
            PrintStream ps = new PrintStream(os);
            ps.println("collection:" + collectionId);
            ps.println("urlPattern:" + urlPattern);
            ps.println("maxHit:" + maxHit);
            ps.println("startOffset:" + startOffset);
            ps.println();
            if (truncated) {
                ps.println("more than results " + maxHit + " retrieved, result truncated");
            }
            int count = 1;
            for (DocumentTrackingInformation info : allInfo) {
                ps.println(count++);
                ps.println(info.toString());
                ps.println();
            }
            ps.println();
        }
        catch (ExtendedException e) {
            e.printStackTrace();
        }
    }
}

