/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.admin.beans.FieldBean;
import com.ibm.es.nuvo.common.admin.beans.NameComparator;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.configuration.FieldMappingManager;
import com.ibm.es.nuvo.crawler.admin.FieldType;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataFieldsExplorer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static boolean deleteMetadataFieldIfNotInUse(CollectionConfiguration collectionConfiguration, String newFieldName) {
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> systemFields = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.BuiltIn, FieldDefinitions.FieldType.Hidden, FieldDefinitions.FieldType.Predefined));
        if (!systemFields.containsKey(newFieldName)) {
            Map<String, FieldDefinition> userFields = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.User));
            if (userFields.containsKey(newFieldName)) {
                FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
                List<FieldMappingManager.FieldSource> sources = fieldMappingManager.getFieldSources(newFieldName);
                if (sources.size() == 0) {
                    ParserServiceConfig parserServiceConfig = collectionConfiguration.getParserServiceConfig();
                    Map<String, String> parserMapping = parserServiceConfig.getFieldMappings();
                    if (parserMapping.containsValue(newFieldName)) {
                        return false;
                    }
                    fieldDefinitions.removeFieldDefinition(newFieldName, FieldDefinitions.FieldType.User);
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean shouldUpdateTheFieldDefinition(Map<String, FieldDefinition> fieldDefinitionMap, String mapToName, boolean completeMatch, boolean textSearchable, String metadataType) {
        if (fieldDefinitionMap != null && fieldDefinitionMap.containsKey(mapToName)) {
            FieldDefinition fieldDefinition = fieldDefinitionMap.get(mapToName);
            String fieldDefinitionType = MetadataFieldsExplorer.getMetadataTypeFromFieldDefinition(fieldDefinition);
            if (!fieldDefinitionType.equals(metadataType)) {
                return true;
            }
            boolean fieldDefinitionCompleteMatch = MetadataFieldsExplorer.isCompleteMatch(fieldDefinition);
            if (fieldDefinitionCompleteMatch && !completeMatch || !fieldDefinitionCompleteMatch && completeMatch) {
                return true;
            }
            boolean fieldDefinitionTextSearchable = MetadataFieldsExplorer.isTextSearchable(fieldDefinition);
            if (fieldDefinitionTextSearchable && !textSearchable || !fieldDefinitionTextSearchable && textSearchable) {
                return true;
            }
        }
        return false;
    }

    public static boolean fieldDefinitionExists(String fieldName, Map<String, FieldDefinition> fieldDefinitionMap) {
        boolean containsKey = false;
        if (fieldDefinitionMap != null && !(containsKey = fieldDefinitionMap.containsKey(fieldName))) {
            containsKey = fieldDefinitionMap.containsKey(fieldName.toLowerCase());
        }
        return containsKey;
    }

    public static FieldDefinition createNewFieldDefinition(String fieldName, boolean completeMatch, boolean textSearchable, String metadataType) {
        FieldDefinition newFieldDefinition = new FieldDefinition(fieldName);
        FieldDefinition.FieldSearchAttributes newFieldDefinitionAttributes = new FieldDefinition.FieldSearchAttributes(!completeMatch);
        newFieldDefinition.setFieldSearchAttr(newFieldDefinitionAttributes);
        newFieldDefinition.setFullTextSearchable(textSearchable);
        if (metadataType.equals("text")) {
            newFieldDefinition.setFieldSearchable(true);
            newFieldDefinition.setParametricSearchable(false);
        } else {
            newFieldDefinition.setFieldSearchable(false);
            newFieldDefinition.setParametricSearchable(true);
            FieldDefinition.ParametricSearchAttributes parametricSearchAttributes = newFieldDefinition.getParametricSearchAttr();
            if (metadataType.equals("decimal")) {
                parametricSearchAttributes.setType(FieldDefinition.ParametricType.Decimal);
            } else if (metadataType.equals("date")) {
                parametricSearchAttributes.setType(FieldDefinition.ParametricType.Date);
            }
            newFieldDefinition.setParametricSearchAttr(parametricSearchAttributes);
        }
        newFieldDefinitionAttributes.setSortable(false);
        newFieldDefinitionAttributes.setCaseSensitive(false);
        newFieldDefinition.setCategory(false);
        return newFieldDefinition;
    }

    public static FieldDefinition createNewFieldDefinition(String fieldName, boolean completeMatch, boolean textSearchable, FieldType fieldType) {
        FieldDefinition newFieldDefinition = new FieldDefinition(fieldName);
        FieldDefinition.FieldSearchAttributes newFieldDefinitionAttributes = new FieldDefinition.FieldSearchAttributes(!completeMatch);
        newFieldDefinition.setFieldSearchAttr(newFieldDefinitionAttributes);
        newFieldDefinition.setFullTextSearchable(textSearchable);
        if (fieldType == FieldType.STRING) {
            newFieldDefinition.setFieldSearchable(true);
        } else {
            newFieldDefinition.setFieldSearchable(false);
        }
        newFieldDefinitionAttributes.setSortable(false);
        newFieldDefinitionAttributes.setCaseSensitive(false);
        newFieldDefinition.setCategory(false);
        if (fieldType == FieldType.LONG || fieldType == FieldType.DOUBLE) {
            FieldDefinition.ParametricSearchAttributes parametricSearchAttributes = newFieldDefinition.getParametricSearchAttr();
            parametricSearchAttributes.setType(FieldDefinition.ParametricType.Decimal);
            newFieldDefinition.setParametricSearchAttr(parametricSearchAttributes);
            newFieldDefinition.setParametricSearchable(true);
        } else if (fieldType == FieldType.DATE) {
            FieldDefinition.ParametricSearchAttributes parametricSearchAttributes = newFieldDefinition.getParametricSearchAttr();
            parametricSearchAttributes.setType(FieldDefinition.ParametricType.Date);
            newFieldDefinition.setParametricSearchAttr(parametricSearchAttributes);
            newFieldDefinition.setParametricSearchable(true);
        } else {
            newFieldDefinition.setParametricSearchable(false);
        }
        return newFieldDefinition;
    }

    public static FieldBean getFieldBeanWithName(String name, List<FieldBean> fieldList) {
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                FieldBean fieldBean = fieldList.get(i);
                if (!fieldBean.getName().equals(name)) continue;
                return fieldBean;
            }
        }
        return null;
    }

    public static void validateFieldMappingName(String name, FieldDefinitions fieldDefinitions) throws ExtendedException {
        if (name.equals("")) {
            throw new ExtendedException(new Message("A0180I.general.metadata.name.empty"));
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                throw new ExtendedException(new Message("A0180I.metadataField.invalidStartCharacter", name));
            }
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '(' && c != ')' && c != ':' && c != '^' && c != '@' && c != '[' && c != ']' && c != '\'' && c != '{' && c != '}' && c != '~' && c != '*' && c != '?' && c != '\\' && c != '<' && c != '>' && c != '=' && c != '!') continue;
            throw new ExtendedException(new Message("A0180I.metadataField.invalid", name));
        }
        Map<String, FieldDefinition> predefinedBuiltInHiddenFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.BuiltIn, FieldDefinitions.FieldType.Hidden));
        if (predefinedBuiltInHiddenFieldDefinitionMap.containsKey(name)) {
            throw new ExtendedException(new Message("A1340I.metadataField.reservedFieldName", name));
        }
    }

    public static String calculateMapToName(String externalName, Map<String, FieldDefinition> hiddenFieldDefinitionMap) {
        String calcedExternalName = externalName.toLowerCase();
        if (MetadataFieldsExplorer.fieldDefinitionExists(externalName, hiddenFieldDefinitionMap)) {
            calcedExternalName = calcedExternalName + "_1";
        }
        return calcedExternalName;
    }

    public static void validateMapToFields(List<FieldBean> fieldList, FieldDefinitions fieldDefinitions, Map<String, String> parserFieldMappings, FieldMappingManager fieldMappingManager, String tableID, boolean shouldValidateWithExistingFields) throws ExtendedException {
        Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        Map<String, FieldDefinition> hiddenPredefinedBuiltInFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Hidden, FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.BuiltIn));
        Hashtable<String, FieldBean> ht = new Hashtable<String, FieldBean>();
        for (int i = 0; i < fieldList.size(); ++i) {
            boolean fieldDefinitionTextSearchable;
            FieldBean fieldBean = fieldList.get(i);
            if (!fieldBean.isEnabled()) continue;
            String name = fieldBean.getName();
            String defaultMapToName = fieldBean.getMapToName().toLowerCase();
            if (defaultMapToName.equals("")) {
                defaultMapToName = fieldBean.getName().toLowerCase();
            }
            fieldBean.setMapToName(defaultMapToName);
            for (int j = 0; j < defaultMapToName.length(); ++j) {
                char c = defaultMapToName.charAt(j);
                if (j == 0 && !Character.isLetter(c)) {
                    Message errMsg = new Message("A0180I.displayName.invalidStartCharacter", defaultMapToName, name);
                    fieldBean.setErrorMessage(errMsg);
                    throw new ExtendedException(errMsg);
                }
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '(' && c != ')' && c != ':' && c != '^' && c != '@' && c != '[' && c != ']' && c != '\'' && c != '{' && c != '}' && c != '~' && c != '*' && c != '?' && c != '\\' && c != '<' && c != '>' && c != '=' && c != '!') continue;
                Message errMsg = new Message("A0180I.displayName.invalid", defaultMapToName, name);
                fieldBean.setErrorMessage(errMsg);
                throw new ExtendedException(errMsg);
            }
            if (fieldBean.isTextSearchable() && fieldBean.isCompleteMatch()) {
                Message errMsg = new Message("A0180I.metadataField.cannnotBeBothTextSearchableAndExactMatch", fieldBean.getName(), fieldBean.getMapToName());
                fieldBean.setErrorMessage(errMsg);
                throw new ExtendedException(errMsg);
            }
            if (hiddenPredefinedBuiltInFieldDefinitionMap.containsKey(defaultMapToName) && !defaultMapToName.equals("title")) {
                Message errMsg = new Message("A1340I.metadataField.invalidMapToField.hiddenField", defaultMapToName, name);
                fieldBean.setErrorMessage(errMsg);
                throw new ExtendedException(errMsg);
            }
            if (defaultMapToName.equals("title")) {
                FieldDefinition fieldDefinition = hiddenPredefinedBuiltInFieldDefinitionMap.get(defaultMapToName);
                String fieldDefinitionType = MetadataFieldsExplorer.getMetadataTypeFromFieldDefinition(fieldDefinition);
                if (!fieldDefinitionType.equals(fieldBean.getMetadataType())) {
                    Message m = new Message("A0180I.general.metadata.type." + fieldBean.getMetadataType());
                    String metadataTypeTranslated = m.getFormattedText();
                    Message m2 = new Message("A0180I.general.metadata.type." + fieldDefinitionType);
                    String fieldDefinitionTypeTranslated = m2.getFormattedText();
                    Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentType", defaultMapToName, fieldBean.getName(), metadataTypeTranslated, fieldDefinitionTypeTranslated);
                    fieldBean.setErrorMessage(errMsg);
                    throw new ExtendedException(errMsg);
                }
                boolean fieldDefinitionCompleteMatch = MetadataFieldsExplorer.isCompleteMatch(fieldDefinition);
                if (fieldDefinitionCompleteMatch && !fieldBean.isCompleteMatch() || !fieldDefinitionCompleteMatch && fieldBean.isCompleteMatch()) {
                    Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentCompleteMatch", defaultMapToName, fieldBean.getName());
                    fieldBean.setErrorMessage(errMsg);
                    throw new ExtendedException(errMsg);
                }
                fieldDefinitionTextSearchable = MetadataFieldsExplorer.isTextSearchable(fieldDefinition);
                if ((!fieldDefinitionTextSearchable || fieldBean.isTextSearchable()) && (fieldDefinitionTextSearchable || !fieldBean.isTextSearchable())) continue;
                Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentTextSearchable", defaultMapToName, fieldBean.getName());
                fieldBean.setErrorMessage(errMsg);
                throw new ExtendedException(errMsg);
            }
            if ((tableID != null || shouldValidateWithExistingFields) && predefinedBuiltInUserFieldDefinitionMap.containsKey(defaultMapToName)) {
                FieldDefinition fieldDefinition = predefinedBuiltInUserFieldDefinitionMap.get(defaultMapToName);
                int numFieldsMappedToDisplayName = MetadataFieldsExplorer.getNumberOfOtherFieldsMappedToDisplayName(defaultMapToName, parserFieldMappings, fieldMappingManager, tableID);
                if (numFieldsMappedToDisplayName >= 1) {
                    boolean fieldDefinitionCompleteMatch;
                    String fieldDefinitionType = MetadataFieldsExplorer.getMetadataTypeFromFieldDefinition(fieldDefinition);
                    if (!fieldDefinitionType.equals(fieldBean.getMetadataType())) {
                        Message m = new Message("A0180I.general.metadata.type." + fieldBean.getMetadataType());
                        String metadataTypeTranslated = m.getFormattedText();
                        Message m2 = new Message("A0180I.general.metadata.type." + fieldDefinitionType);
                        String fieldDefinitionTypeTranslated = m2.getFormattedText();
                        Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentType", defaultMapToName, fieldBean.getName(), metadataTypeTranslated, fieldDefinitionTypeTranslated);
                        fieldBean.setErrorMessage(errMsg);
                        throw new ExtendedException(errMsg);
                    }
                    if (fieldBean.getMetadataType().equals("text") && ((fieldDefinitionCompleteMatch = MetadataFieldsExplorer.isCompleteMatch(fieldDefinition)) && !fieldBean.isCompleteMatch() || !fieldDefinitionCompleteMatch && fieldBean.isCompleteMatch())) {
                        Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentCompleteMatch", defaultMapToName, fieldBean.getName());
                        fieldBean.setErrorMessage(errMsg);
                        throw new ExtendedException(errMsg);
                    }
                    fieldDefinitionTextSearchable = MetadataFieldsExplorer.isTextSearchable(fieldDefinition);
                    if (fieldDefinitionTextSearchable && !fieldBean.isTextSearchable() || !fieldDefinitionTextSearchable && fieldBean.isTextSearchable()) {
                        Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentTextSearchable", defaultMapToName, fieldBean.getName());
                        fieldBean.setErrorMessage(errMsg);
                        throw new ExtendedException(errMsg);
                    }
                }
            }
            if (ht.containsKey(fieldBean.getMapToName())) {
                FieldBean prevFieldBean = (FieldBean)ht.get(fieldBean.getMapToName());
                if (!fieldBean.getMetadataType().equals(prevFieldBean.getMetadataType())) {
                    Message m = new Message("A0180I.general.metadata.type." + prevFieldBean.getMetadataType());
                    String prevMetadataTypeTranslated = m.getFormattedText();
                    Message m2 = new Message("A0180I.general.metadata.type." + fieldBean.getMetadataType());
                    String fieldBeanMetadataTypeTranslated = m2.getFormattedText();
                    Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentType", defaultMapToName, fieldBean.getName(), fieldBeanMetadataTypeTranslated, prevMetadataTypeTranslated);
                    fieldBean.setErrorMessage(errMsg);
                    prevFieldBean.setErrorMessage(errMsg);
                    throw new ExtendedException(errMsg);
                }
                if (prevFieldBean.getMetadataType().equals("text") && (fieldBean.isCompleteMatch() && !prevFieldBean.isCompleteMatch() || !fieldBean.isCompleteMatch() && prevFieldBean.isCompleteMatch())) {
                    Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentCompleteMatch", defaultMapToName, fieldBean.getName());
                    fieldBean.setErrorMessage(errMsg);
                    prevFieldBean.setErrorMessage(errMsg);
                    throw new ExtendedException(errMsg);
                }
                if ((!fieldBean.isTextSearchable() || prevFieldBean.isTextSearchable()) && (fieldBean.isTextSearchable() || !prevFieldBean.isTextSearchable())) continue;
                Message errMsg = new Message("A1340I.metadataField.invalidMapToField.differentTextSearchable", defaultMapToName, fieldBean.getName());
                fieldBean.setErrorMessage(errMsg);
                prevFieldBean.setErrorMessage(errMsg);
                throw new ExtendedException(errMsg);
            }
            ht.put(fieldBean.getMapToName(), fieldBean);
        }
    }

    public static String getDefaultMapToName(String name, String metadataType, boolean completeMatch, boolean textSearchable, Map<String, FieldDefinition> hiddenFieldDefinitionMap, Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap) {
        String defaultMapToName = name.toLowerCase();
        if (hiddenFieldDefinitionMap.containsKey(defaultMapToName)) {
            return "";
        }
        boolean containsKey = predefinedBuiltInUserFieldDefinitionMap.containsKey(defaultMapToName);
        if (containsKey) {
            FieldDefinition fieldDefinition = predefinedBuiltInUserFieldDefinitionMap.get(defaultMapToName);
            String fieldDefinitionType = MetadataFieldsExplorer.getMetadataTypeFromFieldDefinition(fieldDefinition);
            if (!fieldDefinitionType.equals(metadataType)) {
                return "";
            }
            if (fieldDefinitionType.equals("text")) {
                boolean fieldDefinitionCompleteMatch = MetadataFieldsExplorer.isCompleteMatch(fieldDefinition);
                if (fieldDefinitionCompleteMatch && !completeMatch || !fieldDefinitionCompleteMatch && completeMatch) {
                    return "";
                }
                boolean fieldDefinitionTextSearchable = MetadataFieldsExplorer.isTextSearchable(fieldDefinition);
                if (fieldDefinitionTextSearchable && !textSearchable || !fieldDefinitionTextSearchable && textSearchable) {
                    return "";
                }
            }
        }
        return defaultMapToName;
    }

    public static boolean isCompleteMatch(FieldDefinition fieldDefinition) {
        return !fieldDefinition.getFieldSearchAttr().isTokenized();
    }

    public static boolean isTextSearchable(FieldDefinition fieldDefinition) {
        return fieldDefinition.isFullTextSearchable();
    }

    public static String getMetadataTypeFromFieldDefinition(FieldDefinition fieldDefinition) {
        FieldDefinition.ParametricSearchAttributes parametricSearchAttributes;
        String type = "text";
        if (fieldDefinition.isParametricSearchable() && (parametricSearchAttributes = fieldDefinition.getParametricSearchAttr()) != null) {
            if (parametricSearchAttributes.getType() == FieldDefinition.ParametricType.Decimal) {
                type = "decimal";
            } else if (parametricSearchAttributes.getType() == FieldDefinition.ParametricType.Date) {
                type = "date";
            }
        }
        return type;
    }

    public static String getMetadataTypeFromFieldType(FieldType fieldType) {
        if (fieldType == FieldType.LONG || fieldType == FieldType.DOUBLE) {
            return "decimal";
        }
        if (fieldType == FieldType.STRING) {
            return "text";
        }
        if (fieldType == FieldType.DATE) {
            return "date";
        }
        return "text";
    }

    public static String getMetadataTypeFromFieldType(String fieldType) {
        if (fieldType.equalsIgnoreCase("LONG") || fieldType.equalsIgnoreCase("DOUBLE")) {
            return "decimal";
        }
        if (fieldType.equalsIgnoreCase("STRING")) {
            return "text";
        }
        if (fieldType.equalsIgnoreCase("DATE")) {
            return "date";
        }
        return "text";
    }

    private static void addFieldsToVector(FieldDefinitions.FieldType fieldType, Map<String, FieldDefinition> fieldMap, Vector<FieldBean> fieldsVector) {
        for (String key : fieldMap.keySet()) {
            FieldDefinition field = fieldMap.get(key);
            FieldBean displayMetadataFieldBean = new FieldBean();
            displayMetadataFieldBean.setName(field.getName());
            displayMetadataFieldBean.setTextSearchable(field.isFullTextSearchable());
            displayMetadataFieldBean.setFieldSearchable(field.isFieldSearchable());
            displayMetadataFieldBean.setReturnable(field.isReturnable());
            displayMetadataFieldBean.setCategory(field.isCategory());
            displayMetadataFieldBean.setDefaultValue(field.getDefaultValue());
            FieldDefinition.FieldSearchAttributes fieldAttributes = field.getFieldSearchAttr();
            displayMetadataFieldBean.setCaseSensitive(fieldAttributes.isCaseSensitive());
            displayMetadataFieldBean.setLemmatized(fieldAttributes.isLemmatized());
            displayMetadataFieldBean.setTokenized(fieldAttributes.isTokenized());
            displayMetadataFieldBean.setParametricSearchable(field.isParametricSearchable());
            FieldDefinition.ParametricSearchAttributes parametricSearchAttributes = field.getParametricSearchAttr();
            displayMetadataFieldBean.setDecimalPercision(Integer.toString(parametricSearchAttributes.getPrecision()));
            displayMetadataFieldBean.setType("decimal");
            if (field.isParametricSearchable() && parametricSearchAttributes != null) {
                if (parametricSearchAttributes.getType() == FieldDefinition.ParametricType.Decimal) {
                    displayMetadataFieldBean.setType("decimal");
                } else if (parametricSearchAttributes.getType() == FieldDefinition.ParametricType.Date) {
                    displayMetadataFieldBean.setType("date");
                }
            }
            if (fieldType == FieldDefinitions.FieldType.Predefined) {
                displayMetadataFieldBean.setCanEdit(true);
                displayMetadataFieldBean.setCanDelete(false);
                displayMetadataFieldBean.setMetadataType("predefined");
            } else if (fieldType == FieldDefinitions.FieldType.BuiltIn) {
                displayMetadataFieldBean.setCanEdit(false);
                displayMetadataFieldBean.setCanDelete(false);
                displayMetadataFieldBean.setMetadataType("builtin");
            } else if (fieldType == FieldDefinitions.FieldType.User) {
                displayMetadataFieldBean.setCanEdit(true);
                displayMetadataFieldBean.setCanDelete(true);
                displayMetadataFieldBean.setMetadataType("user");
            }
            fieldsVector.add(displayMetadataFieldBean);
        }
    }

    private static int getNumberOfOtherFieldsMappedToDisplayName(String displayName, Map<String, String> parserFieldMappings, FieldMappingManager fieldMappingManager, String tableID) {
        List<FieldMappingManager.FieldSource> fieldSources = fieldMappingManager.getFieldSources(displayName);
        int num = 0;
        for (int i = 0; i < fieldSources.size(); ++i) {
            FieldMappingManager.FieldSource fs = fieldSources.get(i);
            if (tableID == null) {
                ++num;
                continue;
            }
            if (fs.getId().equals(tableID)) continue;
            ++num;
        }
        Set<String> keySet = parserFieldMappings.keySet();
        for (String metadataFieldName : keySet) {
            String mapToName = parserFieldMappings.get(metadataFieldName);
            if (!mapToName.equals(displayName)) continue;
            ++num;
        }
        return num;
    }

    private static void validateAddMetadataField(String collectionID, FieldBean fieldBean, FieldDefinitions fieldDefinitions) throws ExtendedException {
        String fieldName;
        if (fieldBean.getName() != null) {
            fieldBean.setName(fieldBean.getName().trim());
        }
        if ((fieldName = fieldBean.getName()).equals("")) {
            throw new ExtendedException(new Message("A0180I.general.metadata.name.empty"));
        }
        Map<String, FieldDefinition> userPredefinedBuiltInHiddenFieldMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.BuiltIn, FieldDefinitions.FieldType.Hidden));
        if (userPredefinedBuiltInHiddenFieldMap.containsKey(fieldName)) {
            throw new ExtendedException(new Message("A1742I.htmlMetadataField.dupName", fieldName, collectionID));
        }
        for (int i = 0; i < fieldBean.getName().length(); ++i) {
            char c = fieldBean.getName().charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                throw new ExtendedException(new Message("A0180I.metadataField.invalidStartCharacter", fieldBean.getName()));
            }
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '(' && c != ')' && c != ':' && c != '^' && c != '@' && c != '[' && c != ']' && c != '\'' && c != '{' && c != '}' && c != '~' && c != '*' && c != '?' && c != '\\' && c != '<' && c != '>' && c != '=' && c != '!') continue;
            throw new ExtendedException(new Message("A0180I.metadataField.invalid", fieldBean.getName()));
        }
        Map<String, FieldDefinition> predefinedBuiltInHiddenFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.BuiltIn, FieldDefinitions.FieldType.Hidden));
        if (predefinedBuiltInHiddenFieldDefinitionMap.containsKey(fieldBean.getName())) {
            throw new ExtendedException(new Message("A1340I.metadataField.reservedFieldName", fieldBean.getName()));
        }
        if (fieldBean.isTextSearchable() && fieldBean.isCompleteMatch()) {
            throw new ExtendedException(new Message("A0180I.metadataField.cannnotBeBothTextSearchableAndExactMatch", fieldBean.getName(), fieldBean.getMapToName()));
        }
    }

    public static FieldBean[] getMetadataFields(String collectionID, Locale locale) throws ConfigurationManagerException {
        Vector<FieldBean> metadataFields = new Vector<FieldBean>();
        CollectionConfiguration collectionConfiguration = ConfigurationManager.getConfigurationManager().getCollection(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> fieldMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.BuiltIn));
        MetadataFieldsExplorer.addFieldsToVector(FieldDefinitions.FieldType.BuiltIn, fieldMap, metadataFields);
        fieldMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined));
        MetadataFieldsExplorer.addFieldsToVector(FieldDefinitions.FieldType.Predefined, fieldMap, metadataFields);
        fieldMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.User));
        MetadataFieldsExplorer.addFieldsToVector(FieldDefinitions.FieldType.User, fieldMap, metadataFields);
        FieldBean[] metadataArray = new FieldBean[metadataFields.size()];
        for (int i = 0; i < metadataArray.length; ++i) {
            metadataArray[i] = metadataFields.elementAt(i);
        }
        if (locale != null) {
            NameComparator inameComparator = new NameComparator(locale);
            Arrays.sort(metadataArray, inameComparator);
        }
        return metadataArray;
    }

    public static String addMetadataField(String collectionID, FieldBean fieldBean) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        MetadataFieldsExplorer.validateAddMetadataField(collectionID, fieldBean, fieldDefinitions);
        FieldDefinition newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(fieldBean.getName(), fieldBean.isCompleteMatch(), fieldBean.isTextSearchable(), fieldBean.getType());
        fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
        configurationManager.updateCollection(collectionConfiguration);
        return fieldBean.getName().toLowerCase();
    }
}

