/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.admin.beans.DatabaseBean;
import com.ibm.es.nuvo.common.admin.beans.DatabaseTableBean;
import com.ibm.es.nuvo.common.admin.beans.FieldBean;
import com.ibm.es.nuvo.common.admin.beans.NameComparator;
import com.ibm.es.nuvo.common.admin.util.DatabaseCrawlSpaceExplorer;
import com.ibm.es.nuvo.common.admin.util.MetadataFieldsExplorer;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.configuration.FieldMappingManager;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLMetadataFieldsExplorer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static FieldBean[] getHTMLMetadataFields(String collectionID, Locale locale) throws ConfigurationManagerException, CrawlerControlException, CrawlerConfigurationException {
        Vector<FieldBean> metadataFields = new Vector<FieldBean>();
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollection(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> userBuiltInPredefinedFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        ParserServiceConfig parserServiceConfig = collectionConfiguration.getParserServiceConfig();
        Map<String, String> fieldMappings = parserServiceConfig.getFieldMappings();
        Set<String> keySet = fieldMappings.keySet();
        for (String metadataFieldName : keySet) {
            String mapToName = fieldMappings.get(metadataFieldName);
            FieldBean fieldBean = new FieldBean();
            fieldBean.setName(metadataFieldName);
            fieldBean.setMapToName(mapToName);
            FieldDefinition fieldDefinition = userBuiltInPredefinedFieldDefinitionMap.get(fieldBean.getMapToName());
            fieldBean.setMetadataType(MetadataFieldsExplorer.getMetadataTypeFromFieldDefinition(fieldDefinition));
            if (fieldBean.getMetadataType().equals("text")) {
                fieldBean.setCompleteMatch(MetadataFieldsExplorer.isCompleteMatch(fieldDefinition));
                fieldBean.setTextSearchable(MetadataFieldsExplorer.isTextSearchable(fieldDefinition));
            }
            metadataFields.add(fieldBean);
        }
        DatabaseBean[] jdbcCrawlSpace = DatabaseCrawlSpaceExplorer.getCrawlSpaceMappings(collectionID, null);
        if (jdbcCrawlSpace != null) {
            for (int i = 0; i < jdbcCrawlSpace.length; ++i) {
                List<DatabaseTableBean> tables;
                DatabaseBean dbBean = jdbcCrawlSpace[i];
                if (dbBean == null || (tables = dbBean.getTables()) == null) continue;
                for (int j = 0; j < tables.size(); ++j) {
                    DatabaseTableBean table = tables.get(j);
                    if (table == null) continue;
                    FieldBean[] columns = table.getColumns();
                    for (int k = 0; k < columns.length; ++k) {
                        metadataFields.add(columns[k]);
                    }
                }
            }
        }
        FieldBean[] metadataArray = new FieldBean[metadataFields.size()];
        for (int i = 0; i < metadataArray.length; ++i) {
            metadataArray[i] = (FieldBean)metadataFields.elementAt(i);
        }
        if (locale != null) {
            NameComparator inameComparator = new NameComparator(locale);
            Arrays.sort(metadataArray, inameComparator);
        }
        for (int i = 0; i < metadataArray.length; ++i) {
            metadataArray[i].setId(Integer.toString(i));
        }
        return metadataArray;
    }

    public static void deleteHTMLMetadataField(String collectionID, String fieldName) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        ParserServiceConfig parserServiceConfig = collectionConfiguration.getParserServiceConfig();
        Map<String, String> fieldMappings = parserServiceConfig.getFieldMappings();
        if (!fieldMappings.containsKey(fieldName)) {
            throw new ExtendedException(new Message("A1742I.htmlMetadataField.cannotFind", fieldName, collectionID));
        }
        String displayName = fieldMappings.get(fieldName);
        parserServiceConfig.removeFieldMapping(fieldName);
        MetadataFieldsExplorer.deleteMetadataFieldIfNotInUse(collectionConfiguration, displayName);
        configurationManager.updateCollection(collectionConfiguration);
    }

    public static void validateAddHTMLMetadataField(String collectionID, FieldBean fieldBean) throws ExtendedException {
        if (fieldBean.getName() != null) {
            fieldBean.setName(fieldBean.getName().trim());
        }
        CollectionConfiguration collectionConfiguration = ConfigurationManager.getConfigurationManager().getCollection(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        String fieldName = fieldBean.getName();
        MetadataFieldsExplorer.validateFieldMappingName(fieldName, fieldDefinitions);
        if (fieldName.equals("")) {
            throw new ExtendedException(new Message("A0180I.general.htmlMetadata.name.empty"));
        }
        if (HTMLMetadataFieldsExplorer.doesMetadataFieldNameExists(collectionID, fieldName)) {
            throw new ExtendedException(new Message("A1742I.htmlMetadataField.dupName", fieldName, collectionID));
        }
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (i == 0) {
                if (Character.isLetter(c)) continue;
                throw new ExtendedException(new Message("A0180I.htmlMetadataField.invalidStartCharacter"));
            }
            if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == ':' || c == '.') continue;
            throw new ExtendedException(new Message("A0180I.htmlMetadataField.invalid"));
        }
        ParserServiceConfig parserServiceConfig = collectionConfiguration.getParserServiceConfig();
        Map<String, String> parserFieldMappings = parserServiceConfig.getFieldMappings();
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        Vector<FieldBean> fieldList = new Vector<FieldBean>();
        fieldList.add(fieldBean);
        MetadataFieldsExplorer.validateMapToFields(fieldList, fieldDefinitions, parserFieldMappings, fieldMappingManager, null, true);
    }

    public static void addHTMLMetadataField(String collectionID, FieldBean fieldBean) throws ExtendedException {
        HTMLMetadataFieldsExplorer.validateAddHTMLMetadataField(collectionID, fieldBean);
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        ParserServiceConfig parserServiceConfig = collectionConfiguration.getParserServiceConfig();
        Map<String, String> parserFieldMappings = parserServiceConfig.getFieldMappings();
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        MetadataFieldsExplorer.validateFieldMappingName(fieldBean.getName(), fieldDefinitions);
        Vector<FieldBean> fieldList = new Vector<FieldBean>();
        fieldList.add(fieldBean);
        MetadataFieldsExplorer.validateMapToFields(fieldList, fieldDefinitions, parserFieldMappings, fieldMappingManager, null, true);
        String mapToName = fieldBean.getMapToName();
        parserServiceConfig.addFieldMapping(fieldBean.getName(), mapToName);
        if (!MetadataFieldsExplorer.fieldDefinitionExists(mapToName, predefinedBuiltInUserFieldDefinitionMap)) {
            FieldDefinition newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(mapToName, fieldBean.isCompleteMatch(), fieldBean.isTextSearchable(), fieldBean.getMetadataType());
            fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
        }
        configurationManager.updateCollection(collectionConfiguration);
    }

    public static void validateSaveHTMLMetadataFields(String collectionID, List<FieldBean> fieldBeans) throws ExtendedException {
        FieldBean fieldBean;
        int i;
        CollectionConfiguration collectionConfiguration = ConfigurationManager.getConfigurationManager().getCollection(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        for (i = 0; i < fieldBeans.size(); ++i) {
            fieldBean = fieldBeans.get(i);
            fieldBean.setErrorMessage(null);
        }
        for (i = 0; i < fieldBeans.size(); ++i) {
            fieldBean = fieldBeans.get(i);
            try {
                MetadataFieldsExplorer.validateFieldMappingName(fieldBean.getName(), fieldDefinitions);
                continue;
            }
            catch (ExtendedException e) {
                fieldBean.setErrorMessage(e.getNonLocalizedMessage());
                e.getMessage();
                throw e;
            }
        }
        HashMap<String, String> emptyParserFieldMappings = new HashMap<String, String>();
        MetadataFieldsExplorer.validateMapToFields(fieldBeans, fieldDefinitions, emptyParserFieldMappings, fieldMappingManager, null, false);
    }

    public static void saveHTMLMetadataFields(String collectionID, List<FieldBean> fieldBeans) throws ExtendedException {
        int i;
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        for (int i2 = 0; i2 < fieldBeans.size(); ++i2) {
            FieldBean fieldBean = fieldBeans.get(i2);
            fieldBean.setErrorMessage(null);
        }
        HashMap<String, String> emptyParserFieldMappings = new HashMap<String, String>();
        MetadataFieldsExplorer.validateMapToFields(fieldBeans, fieldDefinitions, emptyParserFieldMappings, fieldMappingManager, null, false);
        ParserServiceConfig parserServiceConfig = collectionConfiguration.getParserServiceConfig();
        Map<String, String> parserFieldMappings = parserServiceConfig.getFieldMappings();
        Set<String> keySet = parserFieldMappings.keySet();
        Iterator<String> it = keySet.iterator();
        Vector<String> removeList = new Vector<String>();
        Vector<String> originalMapToNameList = new Vector<String>();
        while (it.hasNext()) {
            String metadataFieldName = it.next();
            removeList.add(metadataFieldName);
            originalMapToNameList.add(parserFieldMappings.get(metadataFieldName));
        }
        for (i = 0; i < removeList.size(); ++i) {
            parserServiceConfig.removeFieldMapping((String)removeList.get(i));
        }
        for (i = 0; i < fieldBeans.size(); ++i) {
            FieldDefinition newFieldDefinition;
            FieldBean fieldBean = fieldBeans.get(i);
            try {
                MetadataFieldsExplorer.validateFieldMappingName(fieldBean.getName(), fieldDefinitions);
            }
            catch (ExtendedException e) {
                fieldBean.setErrorMessage(e.getNonLocalizedMessage());
                throw e;
            }
            String mapToName = fieldBean.getMapToName();
            if (fieldBean.getIconDataID() == null || fieldBean.getIconDataID().equals("")) {
                parserServiceConfig.addFieldMapping(fieldBean.getName(), mapToName);
            } else {
                fieldMappingManager.addMapping(fieldBean.getIconDataID(), fieldBean.getName(), fieldBean.getMapToName(), false);
            }
            if (!MetadataFieldsExplorer.fieldDefinitionExists(mapToName, predefinedBuiltInUserFieldDefinitionMap)) {
                newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(mapToName, fieldBean.isCompleteMatch(), fieldBean.isTextSearchable(), fieldBean.getMetadataType());
                fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
                continue;
            }
            if (!MetadataFieldsExplorer.shouldUpdateTheFieldDefinition(predefinedBuiltInUserFieldDefinitionMap, mapToName, fieldBean.isCompleteMatch(), fieldBean.isTextSearchable(), fieldBean.getMetadataType())) continue;
            newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(mapToName, fieldBean.isCompleteMatch(), fieldBean.isTextSearchable(), fieldBean.getMetadataType());
            fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
        }
        for (i = 0; i < originalMapToNameList.size(); ++i) {
            String displayName = (String)originalMapToNameList.get(i);
            MetadataFieldsExplorer.deleteMetadataFieldIfNotInUse(collectionConfiguration, displayName);
        }
        configurationManager.updateCollection(collectionConfiguration);
    }

    private static boolean doesMetadataFieldNameExists(String collectionID, String fieldName) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollection(collectionID);
        ParserServiceConfig parserServiceConfig = collectionConfiguration.getParserServiceConfig();
        Map<String, String> fieldMappings = parserServiceConfig.getFieldMappings();
        Set<String> keySet = fieldMappings.keySet();
        for (String metadataFieldName : keySet) {
            if (!metadataFieldName.equals(fieldName)) continue;
            return true;
        }
        return false;
    }
}

