/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.util;

import com.ibm.es.nuvo.common.admin.beans.FileDirectoryBean;
import java.io.File;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDirectoryExplorer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String currentDirectory;
    private static final String parentDirectory = "[..]";
    private static final String windowsRoot = "\\\\";
    private static final String unixRoot = "/";

    public FileDirectoryExplorer(String currentDirectory) {
        this.currentDirectory = currentDirectory == null || currentDirectory.equals("") ? FileDirectoryExplorer.getVirtualRoot() : currentDirectory;
    }

    public Vector<FileDirectoryBean> getDirectories() {
        Vector<FileDirectoryBean> directories;
        block5: {
            block4: {
                directories = new Vector<FileDirectoryBean>();
                if (!this.currentDirectory.equals(windowsRoot)) break block4;
                Vector<String> roots = FileDirectoryExplorer.getRoots();
                for (int i = 0; i < roots.size(); ++i) {
                    FileDirectoryBean fileDirBean = new FileDirectoryBean();
                    fileDirBean.setName(roots.get(i));
                    fileDirBean.setDirectory(true);
                    directories.add(fileDirBean);
                }
                break block5;
            }
            File file = new File(this.currentDirectory);
            String[] files = file.list();
            if (files == null) break block5;
            if (!this.currentDirectory.equals(unixRoot)) {
                FileDirectoryBean fileDirBean = new FileDirectoryBean();
                fileDirBean.setName(parentDirectory);
                fileDirBean.setDirectory(true);
                directories.add(fileDirBean);
            }
            for (int i = 0; i < files.length; ++i) {
                FileDirectoryBean fileDirBean;
                if (files[i].equals(".") || files[i].equals("..")) continue;
                File f = new File(this.currentDirectory + File.separator + files[i]);
                if (f.isDirectory() && !f.isHidden()) {
                    fileDirBean = new FileDirectoryBean();
                    fileDirBean.setName(files[i] + File.separator);
                    fileDirBean.setDirectory(true);
                    directories.add(fileDirBean);
                    continue;
                }
                if (!f.isFile() || f.isHidden()) continue;
                fileDirBean = new FileDirectoryBean();
                fileDirBean.setName(files[i]);
                fileDirBean.setDirectory(false);
                directories.add(fileDirBean);
            }
        }
        return directories;
    }

    public boolean isValidCurrentDirectory() {
        if (this.currentDirectory == null) {
            return false;
        }
        if (this.currentDirectory.equals(windowsRoot)) {
            return true;
        }
        File file = new File(this.currentDirectory);
        return file.exists() && file.isDirectory();
    }

    public void changeDirectory(String subDirectory) {
        if (subDirectory.equals(parentDirectory)) {
            File f = new File(this.currentDirectory);
            String parent = f.getParent();
            this.currentDirectory = parent != null ? (parent.endsWith(File.separator) ? parent : parent + File.separator) : windowsRoot;
        } else {
            File f = new File(this.currentDirectory);
            this.currentDirectory = this.currentDirectory.equals(unixRoot) ? this.currentDirectory + subDirectory : (this.currentDirectory.equals(windowsRoot) ? subDirectory : (FileDirectoryExplorer.getRoots().contains(this.currentDirectory) ? this.currentDirectory + subDirectory : (this.currentDirectory.endsWith(File.separator) ? this.currentDirectory + subDirectory : this.currentDirectory + File.separator + subDirectory)));
        }
    }

    public String getCurrentDirectory() {
        if (this.currentDirectory.equals(windowsRoot)) {
            return "";
        }
        return this.currentDirectory;
    }

    public LinkedList<String> getHierarchy() {
        LinkedList<String> hierarchy = new LinkedList<String>();
        for (File f = new File(this.currentDirectory).getParentFile(); f != null; f = f.getParentFile()) {
            hierarchy.addFirst(f.getPath());
        }
        return hierarchy;
    }

    public static Vector<String> getRoots() {
        File[] roots = File.listRoots();
        Vector<String> rootStrings = new Vector<String>(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            rootStrings.add(roots[i].getPath());
        }
        return rootStrings;
    }

    public static String getVirtualRoot() {
        if (FileDirectoryExplorer.getRoots().firstElement().equals(unixRoot)) {
            return unixRoot;
        }
        return windowsRoot;
    }
}

