/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.util;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.admin.beans.DatabaseTableBean;
import com.ibm.es.nuvo.common.admin.beans.FieldBean;
import com.ibm.es.nuvo.common.admin.beans.NameComparator;
import com.ibm.es.nuvo.common.admin.util.DatabaseCrawlSpaceExplorer;
import com.ibm.es.nuvo.common.admin.util.MetadataFieldsExplorer;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.FieldType;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseExplorer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final boolean isDemo = false;
    private static final String JDBC_CRAWLER_TYPE = "com.ibm.es.nuvo.crawler.adapter.jdbc";
    private static final String JDBC_CRAWLER_NAME = "jdbc";
    private String collectionID;
    private String dburl;
    private String userid;
    private String password;
    private String driver;
    private String classpath;
    private String schemaName;
    private String tableName;

    public DatabaseExplorer(String collectionID, String dburl, String userid, String password, String driver, String classpath) {
        this.collectionID = collectionID;
        this.dburl = dburl;
        this.userid = userid;
        this.password = password;
        this.driver = driver;
        this.classpath = classpath;
    }

    public Message testConnection() throws ExtendedException {
        this.getTables();
        return new Message("A1745I.database.successConnect");
    }

    public Vector<String> getTables() throws ExtendedException {
        return this.getTablesMinusCurrentTables(new DatabaseTableBean[0]);
    }

    public Vector<String> getTablesMinusCurrentTables(DatabaseTableBean[] currentTables) throws ExtendedException {
        CrawlerType[] crawlerTypeArray;
        Vector<String> tables = new Vector<String>();
        boolean dbHasTables = false;
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(this.collectionID);
        if (crawlerManager != null && (crawlerTypeArray = crawlerManager.getAvailableCrawlerTypes()) != null) {
            for (int i = 0; i < crawlerTypeArray.length; ++i) {
                CrawlerType crawlerType = crawlerTypeArray[i];
                if (!crawlerType.getName().equals(JDBC_CRAWLER_TYPE)) continue;
                List<Configuration> requiredConfigurationList = crawlerType.getRequiredConfigurations();
                for (Configuration config : requiredConfigurationList) {
                    String name = config.getName();
                    if (name.equals("user")) {
                        config.setString(this.userid);
                        continue;
                    }
                    if (name.equals("password")) {
                        config.setString(this.password);
                        continue;
                    }
                    if (name.equals("driver")) {
                        config.setString(this.driver);
                        continue;
                    }
                    if (!name.equals("dburl")) continue;
                    config.setString(this.dburl);
                }
                List<String> classpathList = DatabaseCrawlSpaceExplorer.getClasspathAsList(this.classpath);
                CrawlerConfiguration crawlerConfig = crawlerManager.newCrawlerConfiguration(JDBC_CRAWLER_NAME, crawlerType, requiredConfigurationList, classpathList);
                crawlerConfig.open();
                if (crawlerConfig.hasSubSpaces()) {
                    Iterator<SpaceConfiguration> servers = crawlerConfig.getSubSpaces();
                    while (servers.hasNext()) {
                        SpaceConfiguration server = servers.next();
                        server.open();
                        Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                        while (schemas.hasNext()) {
                            SpaceConfiguration schema = schemas.next();
                            schema.open();
                            Iterator<SpaceConfiguration> tableIterator = schema.getSubSpaces();
                            while (tableIterator.hasNext()) {
                                SpaceConfiguration table = tableIterator.next();
                                String name = schema.getName() + "." + table.getName();
                                dbHasTables = true;
                                if (this.contains(name, currentTables)) continue;
                                tables.add(schema.getName() + "." + table.getName());
                            }
                            schema.close();
                        }
                        server.close();
                    }
                }
                crawlerConfig.close();
            }
        }
        if (tables.size() == 0) {
            if (dbHasTables) {
                throw new ExtendedException(new Message("A1340I.no.discoveredDatabaseTables.alreadyInCrawlSpace", this.dburl));
            }
            throw new ExtendedException(new Message("A1340I.no.discoveredDatabaseTables", this.dburl));
        }
        return tables;
    }

    public FieldBean[] getTableColumns(Locale locale) throws CrawlerConfigurationException, ConfigurationManagerException {
        int i;
        CrawlerType[] crawlerTypeArray;
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollection(this.collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        Map<String, FieldDefinition> hiddenFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Hidden));
        Vector<FieldBean> columns = new Vector<FieldBean>();
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(this.collectionID);
        if (crawlerManager != null && (crawlerTypeArray = crawlerManager.getAvailableCrawlerTypes()) != null) {
            for (i = 0; i < crawlerTypeArray.length; ++i) {
                CrawlerType crawlerType = crawlerTypeArray[i];
                if (!crawlerType.getName().equals(JDBC_CRAWLER_TYPE)) continue;
                List<Configuration> requiredConfigurationList = crawlerType.getRequiredConfigurations();
                for (Configuration config : requiredConfigurationList) {
                    String name = config.getName();
                    if (name.equals("user")) {
                        config.setString(this.userid);
                        continue;
                    }
                    if (name.equals("password")) {
                        config.setString(this.password);
                        continue;
                    }
                    if (name.equals("driver")) {
                        config.setString(this.driver);
                        continue;
                    }
                    if (!name.equals("dburl")) continue;
                    config.setString(this.dburl);
                }
                List<String> classpathList = DatabaseCrawlSpaceExplorer.getClasspathAsList(this.classpath);
                CrawlerConfiguration crawlerConfig = crawlerManager.newCrawlerConfiguration(JDBC_CRAWLER_NAME, crawlerType, requiredConfigurationList, classpathList);
                crawlerConfig.open();
                if (crawlerConfig.hasSubSpaces()) {
                    Iterator<SpaceConfiguration> servers = crawlerConfig.getSubSpaces();
                    while (servers.hasNext()) {
                        SpaceConfiguration server = servers.next();
                        server.open();
                        Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                        while (schemas.hasNext()) {
                            SpaceConfiguration schema = schemas.next();
                            if (!schema.getName().equals(this.schemaName)) continue;
                            schema.open();
                            Iterator<SpaceConfiguration> tableIterator = schema.getSubSpaces();
                            while (tableIterator.hasNext()) {
                                SpaceConfiguration table = tableIterator.next();
                                if (!table.getName().equals(this.tableName)) continue;
                                table.open();
                                table.setAsCrawlSpace(true);
                                Iterator<FieldConfiguration> fieldsItr = table.getFields();
                                while (fieldsItr.hasNext()) {
                                    FieldConfiguration field = fieldsItr.next();
                                    if (field.isSystemField()) continue;
                                    FieldBean fieldBean = new FieldBean();
                                    if (field.getType() == FieldType.STRING) {
                                        fieldBean.setEnabled(true);
                                        fieldBean.setMapToName("");
                                    } else {
                                        fieldBean.setMapToName("");
                                    }
                                    fieldBean.setName(field.getName());
                                    fieldBean.setMetadataType(field.getType().toString());
                                    fieldBean.setType(field.getTypeName());
                                    fieldBean.setUniqueKey(false);
                                    fieldBean.setCompleteMatch(false);
                                    fieldBean.setTextSearchable(false);
                                    columns.add(fieldBean);
                                }
                                Collection<Configuration> crawlSpaceConfig = table.getCrawlSpaceConfigurations().values();
                                for (Configuration config : crawlSpaceConfig) {
                                    FieldBean fieldBean;
                                    int j;
                                    int size;
                                    Set<Configuration.ListItem> items;
                                    if (config.getName().equals("primary_key")) {
                                        items = config.getItems();
                                        block9: for (Configuration.ListItem item : items) {
                                            size = columns.size();
                                            for (j = 0; j < size; ++j) {
                                                fieldBean = (FieldBean)columns.elementAt(j);
                                                if (!fieldBean.getName().equals(item.getValue())) continue;
                                                fieldBean.setCanBeAUniqueKey(true);
                                                fieldBean.setUniqueKey(item.isSelected());
                                                continue block9;
                                            }
                                        }
                                        continue;
                                    }
                                    if (config.getName().equals("content_column")) {
                                        items = config.getItems();
                                        block11: for (Configuration.ListItem item : items) {
                                            size = columns.size();
                                            for (j = 0; j < size; ++j) {
                                                fieldBean = (FieldBean)columns.elementAt(j);
                                                if (!fieldBean.getName().equals(item.getValue())) continue;
                                                fieldBean.setCanBeAContent(true);
                                                continue block11;
                                            }
                                        }
                                        continue;
                                    }
                                    if (config.getName().equals("document_date")) {
                                        items = config.getItems();
                                        block13: for (Configuration.ListItem item : items) {
                                            size = columns.size();
                                            for (j = 0; j < size; ++j) {
                                                fieldBean = (FieldBean)columns.elementAt(j);
                                                if (!fieldBean.getName().equals(item.getValue())) continue;
                                                fieldBean.setCanBeADocumentDate(true);
                                                continue block13;
                                            }
                                        }
                                        continue;
                                    }
                                    if (!config.getName().equals("detect_update")) continue;
                                    items = config.getItems();
                                    block15: for (Configuration.ListItem item : items) {
                                        size = columns.size();
                                        for (j = 0; j < size; ++j) {
                                            fieldBean = (FieldBean)columns.elementAt(j);
                                            if (!fieldBean.getName().equals(item.getValue())) continue;
                                            fieldBean.setCanBeADetectUpdate(true);
                                            continue block15;
                                        }
                                    }
                                }
                                table.close();
                            }
                            schema.close();
                        }
                        server.close();
                    }
                }
                crawlerConfig.close();
            }
        }
        FieldBean[] columnsArray = new FieldBean[columns.size()];
        for (i = 0; i < columnsArray.length; ++i) {
            columnsArray[i] = (FieldBean)columns.elementAt(i);
            if (!columnsArray[i].isUniqueKey() || !columnsArray[i].getMetadataType().equals("STRING")) continue;
            columnsArray[i].setCompleteMatch(true);
        }
        for (i = 0; i < columnsArray.length; ++i) {
            FieldBean field = columnsArray[i];
            field.setMapToName(MetadataFieldsExplorer.getDefaultMapToName(field.getName(), MetadataFieldsExplorer.getMetadataTypeFromFieldType(field.getMetadataType()), field.isCompleteMatch(), field.isTextSearchable(), hiddenFieldDefinitionMap, predefinedBuiltInUserFieldDefinitionMap));
        }
        if (locale != null) {
            NameComparator inameComparator = new NameComparator(locale);
            Arrays.sort(columnsArray, inameComparator);
        }
        return columnsArray;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getDburl() {
        return this.dburl;
    }

    public void setDburl(String dburl) {
        this.dburl = dburl;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    private boolean contains(String name, DatabaseTableBean[] tables) {
        if (tables != null) {
            for (int i = 0; i < tables.length; ++i) {
                DatabaseTableBean table = tables[i];
                if (!table.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }
}

