/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.util;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.common.admin.beans.DatabaseBean;
import com.ibm.es.nuvo.common.admin.beans.DatabaseDriverBean;
import com.ibm.es.nuvo.common.admin.beans.DatabaseTableBean;
import com.ibm.es.nuvo.common.admin.beans.FieldBean;
import com.ibm.es.nuvo.common.admin.beans.NameComparator;
import com.ibm.es.nuvo.common.admin.util.DatabaseExplorer;
import com.ibm.es.nuvo.common.admin.util.MetadataFieldsExplorer;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.configuration.FieldMappingManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceStatus;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseCrawlSpaceExplorer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final boolean isDemo = false;
    private static final String JDBC_CRAWLER_TYPE = "com.ibm.es.nuvo.crawler.adapter.jdbc";
    private static final String JDBC_CRAWLER_NAME = "jdbc";

    public static DatabaseBean[] getCrawlSpace(String collectionID, Locale locale) throws CrawlerControlException, CrawlerConfigurationException {
        Vector<DatabaseBean> databases = new Vector<DatabaseBean>();
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE)) continue;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            Configuration dburlConfig = crawlerConfiguration.getConfigurations().get("dburl");
            Configuration userConfig = crawlerConfiguration.getConfigurations().get("user");
            DatabaseBean dbBean = new DatabaseBean();
            dbBean.setDbURL(dburlConfig.getString());
            dbBean.setUserid(userConfig.getString());
            dbBean.setCrawlerId(crawlerControl.getID());
            databases.add(dbBean);
            if (!crawlerConfiguration.hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    while (tables.hasNext()) {
                        SpaceConfiguration table = tables.next();
                        DatabaseTableBean tableBean = new DatabaseTableBean();
                        dbBean.addTable(tableBean);
                        tableBean.setName(schema.getName() + "." + table.getName());
                        CrawlSpaceControl crawlSpaceControl = crawlerManager.getCrawlSpaceControl(crawlerControl.getID(), table.getID());
                        CrawlSpaceStatus status = crawlSpaceControl.getCrawlSpaceStatus();
                        tableBean.setStatus(status.getStatus().toString());
                        tableBean.setNumberOfCrawledRecords(status.getNumberOfCrawledRecords());
                        tableBean.setNumberOfDeletedRecords(status.getNumberOfDeletedRecords());
                        tableBean.setNumberOfErrorRecords(status.getNumberOfErrorRecords());
                        tableBean.setNumberOfInsertedRecords(status.getNumberOfInsertedRecords());
                        tableBean.setNumberOfUpdatedRecords(status.getNumberOfUpdatedRecords());
                        tableBean.setStartTime(status.getStartTime());
                        tableBean.setEndTime(status.getEndTime());
                        tableBean.setTotalTime(status.getTotalTime());
                        tableBean.setScheduled(false);
                        tableBean.setLastError(status.getLastError());
                    }
                }
            }
        }
        NameComparator inameComparator = null;
        if (locale != null) {
            inameComparator = new NameComparator(locale);
        }
        DatabaseBean[] databaseArray = new DatabaseBean[databases.size()];
        for (int i = 0; i < databaseArray.length; ++i) {
            databaseArray[i] = (DatabaseBean)databases.get(i);
            DatabaseTableBean[] tableArray = databaseArray[i].getTableArray();
            if (locale != null) {
                Arrays.sort(tableArray, inameComparator);
            }
            Vector<DatabaseTableBean> v = new Vector<DatabaseTableBean>();
            for (int j = 0; j < tableArray.length; ++j) {
                v.add(tableArray[j]);
            }
            databaseArray[i].setTables(v);
        }
        if (locale != null) {
            Arrays.sort(databaseArray, inameComparator);
        }
        return databaseArray;
    }

    public static DatabaseBean[] getCrawlSpaceMappings(String collectionID, Locale locale) throws CrawlerControlException, CrawlerConfigurationException, ConfigurationManagerException {
        Vector<DatabaseBean> databases = new Vector<DatabaseBean>();
        CollectionConfiguration collectionConfiguration = ConfigurationManager.getConfigurationManager().getCollection(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        Map<String, FieldDefinition> userPredefinedBuiltInFieldDefinitionMap = collectionConfiguration.getFieldDefinitions().getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.BuiltIn));
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE)) continue;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            Configuration dburlConfig = crawlerConfiguration.getConfigurations().get("dburl");
            Configuration userConfig = crawlerConfiguration.getConfigurations().get("user");
            DatabaseBean dbBean = new DatabaseBean();
            dbBean.setDbURL(dburlConfig.getString());
            dbBean.setUserid(userConfig.getString());
            dbBean.setCrawlerId(crawlerControl.getID());
            databases.add(dbBean);
            if (!crawlerConfiguration.hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    while (tables.hasNext()) {
                        SpaceConfiguration tableSpace = tables.next();
                        DatabaseTableBean tableBean = new DatabaseTableBean();
                        dbBean.addTable(tableBean);
                        tableBean.setName(schema.getName() + "." + tableSpace.getName());
                        Vector<FieldBean> columns = new Vector<FieldBean>();
                        Map<String, FieldMappingManager.FieldMapping> mappings = fieldMappingManager.getFieldMappingMap(tableSpace.getID());
                        Iterator<FieldConfiguration> fields = tableSpace.getFields();
                        while (fields.hasNext()) {
                            FieldConfiguration field = fields.next();
                            if (field.isSystemField() || !field.isEnabled()) continue;
                            FieldBean fieldBean = new FieldBean();
                            fieldBean.setName(field.getName());
                            fieldBean.setType(field.getTypeName());
                            fieldBean.setMetadataType(MetadataFieldsExplorer.getMetadataTypeFromFieldType(field.getType()));
                            fieldBean.setEnabled(field.isEnabled());
                            fieldBean.setIconClass("icon-database-tiny");
                            fieldBean.setIconHoverHelp(dbBean.getName() + " " + tableBean.getName());
                            fieldBean.setIconDataID(tableSpace.getID());
                            FieldMappingManager.FieldMapping mapping = mappings.get(field.getName());
                            if (mapping != null) {
                                fieldBean.setMapToName(mapping.getFieldName());
                            }
                            if (userPredefinedBuiltInFieldDefinitionMap.containsKey(fieldBean.getMapToName())) {
                                FieldDefinition fieldDefinition = userPredefinedBuiltInFieldDefinitionMap.get(fieldBean.getMapToName());
                                fieldBean.setCompleteMatch(MetadataFieldsExplorer.isCompleteMatch(fieldDefinition));
                                fieldBean.setTextSearchable(MetadataFieldsExplorer.isTextSearchable(fieldDefinition));
                            }
                            columns.add(fieldBean);
                        }
                        FieldBean[] columnsArray = new FieldBean[columns.size()];
                        for (int x = 0; x < columnsArray.length; ++x) {
                            columnsArray[x] = (FieldBean)columns.elementAt(x);
                        }
                        if (locale != null) {
                            NameComparator inameComparator = new NameComparator(locale);
                            Arrays.sort(columnsArray, inameComparator);
                        }
                        tableBean.setColumns(columnsArray);
                    }
                }
            }
        }
        NameComparator inameComparator = null;
        if (locale != null) {
            inameComparator = new NameComparator(locale);
        }
        DatabaseBean[] databaseArray = new DatabaseBean[databases.size()];
        for (int i = 0; i < databaseArray.length; ++i) {
            databaseArray[i] = (DatabaseBean)databases.get(i);
            DatabaseTableBean[] tableArray = databaseArray[i].getTableArray();
            if (locale != null) {
                Arrays.sort(tableArray, inameComparator);
            }
            Vector<DatabaseTableBean> v = new Vector<DatabaseTableBean>();
            for (int j = 0; j < tableArray.length; ++j) {
                v.add(tableArray[j]);
            }
            databaseArray[i].setTables(v);
        }
        if (locale != null) {
            Arrays.sort(databaseArray, inameComparator);
        }
        return databaseArray;
    }

    public static void startCrawl(String collectionID, String crawlerId, String dbURL, String schemaName, String tableName, boolean fullRecrawl) throws ExtendedException {
        CrawlMode mode;
        CrawlSpaceControl crawlSpaceControl = DatabaseCrawlSpaceExplorer.getCrawlSpaceControl(collectionID, crawlerId, dbURL, schemaName, tableName);
        CrawlMode crawlMode = mode = fullRecrawl ? CrawlMode.FORCE : CrawlMode.NORMAL;
        if (crawlSpaceControl == null) {
            throw new ExtendedException(new Message("A1742I.table.cannotFind", crawlerId, dbURL, schemaName, tableName, collectionID));
        }
        crawlSpaceControl.startCrawl(mode);
    }

    public static void stopCrawl(String collectionID, String crawlerId, String dbURL, String schemaName, String tableName) throws ExtendedException {
        CrawlSpaceControl crawlSpaceControl = DatabaseCrawlSpaceExplorer.getCrawlSpaceControl(collectionID, crawlerId, dbURL, schemaName, tableName);
        if (crawlSpaceControl == null) {
            throw new ExtendedException(new Message("A1742I.table.cannotFind", crawlerId, dbURL, schemaName, tableName, collectionID));
        }
        crawlSpaceControl.stopCrawl();
    }

    public static void enableSchedule(String collectionID, String crawlerId, String dbURL, String schemaName, String tableName) throws ExtendedException {
        CrawlSpaceControl crawlSpaceControl = DatabaseCrawlSpaceExplorer.getCrawlSpaceControl(collectionID, crawlerId, dbURL, schemaName, tableName);
        if (crawlSpaceControl == null) {
            throw new ExtendedException(new Message("A1742I.table.cannotFind", crawlerId, dbURL, schemaName, tableName, collectionID));
        }
    }

    public static void disableSchedule(String collectionID, String crawlerId, String dbURL, String schemaName, String tableName) throws ExtendedException {
        CrawlSpaceControl crawlSpaceControl = DatabaseCrawlSpaceExplorer.getCrawlSpaceControl(collectionID, crawlerId, dbURL, schemaName, tableName);
        if (crawlSpaceControl == null) {
            throw new ExtendedException(new Message("A1742I.table.cannotFind", crawlerId, dbURL, schemaName, tableName, collectionID));
        }
    }

    public static DatabaseDriverBean[] getDatabaseDrivers(String collectionID, Locale locale) throws CrawlerControlException, CrawlerConfigurationException {
        CrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        Vector<DatabaseDriverBean> drivers = new Vector<DatabaseDriverBean>();
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE)) continue;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            Iterator<Configuration> configurationIterator = crawlerConfiguration.getConfigurations().values().iterator();
            String driverName = "";
            while (configurationIterator.hasNext()) {
                Configuration config = configurationIterator.next();
                if (!config.getName().equals("driver")) continue;
                driverName = config.getString();
            }
            StringBuffer classpathStringBuffer = new StringBuffer();
            for (String classpathEntry : crawlerConfiguration.getClasspathEntries()) {
                if (classpathStringBuffer.length() > 0) {
                    if (GlobalConfiguration.getConfiguration().isWindows()) {
                        classpathStringBuffer.append(";");
                    } else {
                        classpathStringBuffer.append(":");
                    }
                }
                classpathStringBuffer.append(classpathEntry);
            }
            String classpath = classpathStringBuffer.toString();
            DatabaseDriverBean dbDriverBean = null;
            for (int k = 0; k < drivers.size(); ++k) {
                DatabaseDriverBean driver = (DatabaseDriverBean)drivers.elementAt(k);
                if (!driver.getName().equals(driverName) || !driver.getClasspath().equalsIgnoreCase(classpath)) continue;
                dbDriverBean = driver;
                break;
            }
            if (dbDriverBean != null) continue;
            dbDriverBean = new DatabaseDriverBean();
            drivers.add(dbDriverBean);
            dbDriverBean.setClasspath(classpath.toString());
            dbDriverBean.setName(driverName);
        }
        DatabaseDriverBean[] driverArray = new DatabaseDriverBean[drivers.size()];
        for (int i = 0; i < driverArray.length; ++i) {
            driverArray[i] = (DatabaseDriverBean)drivers.elementAt(i);
        }
        if (locale != null) {
            NameComparator inameComparator = new NameComparator(locale);
            Arrays.sort(driverArray, inameComparator);
        }
        return driverArray;
    }

    public static void validateDatabasePassword(String collectionID, String dburl, String driver, String classpath, String userid, String password) throws ExtendedException {
        CrawlerType[] crawlerTypeArray;
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        if (crawlerManager != null && (crawlerTypeArray = crawlerManager.getAvailableCrawlerTypes()) != null) {
            for (int i = 0; i < crawlerTypeArray.length; ++i) {
                CrawlerType crawlerType = crawlerTypeArray[i];
                if (!crawlerType.getName().equals(JDBC_CRAWLER_TYPE)) continue;
                List<Configuration> requiredConfigurationList = crawlerType.getRequiredConfigurations();
                for (Configuration config : requiredConfigurationList) {
                    String name = config.getName();
                    if (name.equals("user")) {
                        config.setString(userid);
                        continue;
                    }
                    if (name.equals("password")) {
                        config.setString(password);
                        continue;
                    }
                    if (name.equals("driver")) {
                        config.setString(driver);
                        continue;
                    }
                    if (!name.equals("dburl")) continue;
                    config.setString(dburl);
                }
                List<String> classpathList = DatabaseCrawlSpaceExplorer.getClasspathAsList(classpath);
                CrawlerConfiguration crawlerConfiguration = crawlerManager.newCrawlerConfiguration(JDBC_CRAWLER_NAME, crawlerType, requiredConfigurationList, classpathList);
                crawlerConfiguration.open();
                continue;
            }
        }
    }

    public static DatabaseBean getDatabaseBean(String collectionID, String crawlerId, String dburl) throws ExtendedException {
        DatabaseBean dbBean = null;
        CrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerControl.getID().equals(crawlerId)) continue;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            Iterator<Configuration> configurationIterator = crawlerConfiguration.getConfigurations().values().iterator();
            dbBean = new DatabaseBean();
            dbBean.setDbURL(dburl);
            dbBean.setCrawlerId(crawlerConfiguration.getID());
            boolean foundIt = false;
            while (configurationIterator.hasNext()) {
                Configuration config = configurationIterator.next();
                if (config.getName().equals("dburl")) {
                    if (!config.getString().equals(dburl)) continue;
                    foundIt = true;
                    dbBean.setDbURL(config.getString());
                    continue;
                }
                if (config.getName().equals("user")) {
                    dbBean.setUserid(config.getString());
                    continue;
                }
                if (config.getName().equals("password")) {
                    dbBean.setPassword(config.getString());
                    continue;
                }
                if (config.getName().equals("driver")) {
                    dbBean.setDrivername(config.getString());
                    continue;
                }
                if (config.getName().equals("es:max_connections")) {
                    dbBean.setMaxConnections(Long.toString(config.getLong()));
                    continue;
                }
                if (config.getName().equals("es:fetch_interval")) {
                    dbBean.setFetchInterval(Long.toString(config.getLong()));
                    continue;
                }
                if (!config.getName().equals("es:max_page_length")) continue;
                dbBean.setMaxPageLength(Long.toString(config.getLong()));
            }
            if (!foundIt) continue;
            StringBuffer classpath = new StringBuffer();
            for (String classpathEntry : crawlerConfiguration.getClasspathEntries()) {
                if (classpath.length() > 0) {
                    if (GlobalConfiguration.getConfiguration().isWindows()) {
                        classpath.append(";");
                    } else {
                        classpath.append(":");
                    }
                }
                classpath.append(classpathEntry);
            }
            dbBean.setClasspath(classpath.toString());
            return dbBean;
        }
        throw new ExtendedException(new Message("A1742I.database.cannotFind", crawlerId, dburl, collectionID));
    }

    public static void updateDatabase(String collectionID, DatabaseBean dbBean) throws ExtendedException {
        DatabaseCrawlSpaceExplorer.validateDatabasePassword(collectionID, dbBean.getDbURL(), dbBean.getDrivername(), dbBean.getClasspath(), dbBean.getUserid(), dbBean.getPassword());
        CrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        boolean foundADBToDelete = false;
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerControl.getID().equals(dbBean.getCrawlerId())) continue;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            Iterator<Configuration> configurationIterator = crawlerConfiguration.getConfigurations().values().iterator();
            boolean foundIt = false;
            while (configurationIterator.hasNext()) {
                Configuration config = configurationIterator.next();
                if (!config.getName().equals("dburl") || !config.getString().equals(dbBean.getDbURL())) continue;
                foundIt = true;
                foundADBToDelete = true;
                break;
            }
            if (!foundIt) continue;
            for (Configuration config : crawlerConfiguration.getConfigurations().values()) {
                if (config.getName().equals("password")) {
                    config.setString(dbBean.getPassword());
                    continue;
                }
                if (config.getName().equals("es:max_connections")) {
                    try {
                        long maxConnections = Long.parseLong(dbBean.getMaxConnections());
                        config.setLong(maxConnections);
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (config.getName().equals("es:fetch_interval")) {
                    try {
                        long fetchInterval = Long.parseLong(dbBean.getFetchInterval());
                        config.setLong(fetchInterval);
                    }
                    catch (Exception e) {
                        System.out.println("dbBean.getFetchInterval()[" + dbBean.getFetchInterval() + "] - e=" + e.toString());
                    }
                    continue;
                }
                if (!config.getName().equals("es:max_page_length")) continue;
                try {
                    long maxPageLength = Long.parseLong(dbBean.getMaxPageLength());
                    config.setLong(maxPageLength);
                }
                catch (Exception e) {
                    System.out.println("DatabaseCrawlSpaceExplorer::updateDatabase - dbBean.getMaxPageLength()[" + dbBean.getMaxPageLength() + "] - e=" + e.toString());
                }
            }
            crawlerManager.submitCrawlerConfiguration(crawlerConfiguration);
        }
        if (!foundADBToDelete) {
            throw new ExtendedException(new Message("A1742I.database.cannotFind", dbBean.getCrawlerId(), dbBean.getDbURL(), collectionID));
        }
    }

    public static void validateTableFields(String collectionID, String crawlerId, String dburl, String schemaName, String tableName, List<FieldBean> fieldList) throws ExtendedException {
        SpaceConfiguration tableSpace = DatabaseCrawlSpaceExplorer.getTable(collectionID, crawlerId, dburl, schemaName, tableName);
        String tableID = null;
        if (tableSpace != null) {
            tableID = tableSpace.getID();
        }
        for (int i = 0; i < fieldList.size(); ++i) {
            FieldBean fieldBean = fieldList.get(i);
            fieldBean.setErrorMessage(null);
        }
        CollectionConfiguration collectionConfiguration = ConfigurationManager.getConfigurationManager().getCollection(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, String> parserFieldMappings = collectionConfiguration.getParserServiceConfig().getFieldMappings();
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        MetadataFieldsExplorer.validateMapToFields(fieldList, fieldDefinitions, parserFieldMappings, fieldMappingManager, tableID, true);
    }

    public static void updateDatabaseTable(String collectionID, String crawlerId, String dburl, String schemaName, String tableName, List<FieldBean> fieldList, Map<String, String> map) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        Map<String, FieldDefinition> hiddenFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Hidden));
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerConfiguration crawlerConfiguration;
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerControl.getID().equals(crawlerId) || !(crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID())).hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                if (!server.getName().equals(dburl)) continue;
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    if (!schema.getName().equals(schemaName)) continue;
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    while (tables.hasNext()) {
                        SpaceConfiguration table = tables.next();
                        if (!table.getName().equals(tableName)) continue;
                        Iterator<FieldConfiguration> fields = table.getFields();
                        while (fields.hasNext()) {
                            FieldConfiguration field = fields.next();
                            if (field.isSystemField()) continue;
                            field.setEnabled(DatabaseCrawlSpaceExplorer.isFieldEnabled(field.getName(), fieldList));
                            if (field.isEnabled()) {
                                FieldDefinition newFieldDefinition;
                                String externalName = DatabaseCrawlSpaceExplorer.getFieldsExternalName(field.getName(), fieldList);
                                externalName = MetadataFieldsExplorer.calculateMapToName(externalName, hiddenFieldDefinitionMap);
                                fieldMappingManager.addMapping(table.getID(), field.getName(), externalName, field.isSystemField());
                                boolean isCompleteMatch = DatabaseCrawlSpaceExplorer.isFieldCompleteMatch(field.getName(), fieldList);
                                boolean isTextSearchable = DatabaseCrawlSpaceExplorer.isFieldTextSearchable(field.getName(), fieldList);
                                if (!MetadataFieldsExplorer.fieldDefinitionExists(externalName, predefinedBuiltInUserFieldDefinitionMap)) {
                                    newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(externalName, isCompleteMatch, isTextSearchable, field.getType());
                                    fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
                                    continue;
                                }
                                if (!MetadataFieldsExplorer.shouldUpdateTheFieldDefinition(predefinedBuiltInUserFieldDefinitionMap, externalName, isCompleteMatch, isTextSearchable, MetadataFieldsExplorer.getMetadataTypeFromFieldType(field.getType()))) continue;
                                newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(externalName, isCompleteMatch, isTextSearchable, field.getType());
                                fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
                                continue;
                            }
                            fieldMappingManager.removeMapping(table.getID(), field.getName(), field.isSystemField());
                        }
                        Metadata meta = fieldMappingManager.getCrawlspaceMetadata(table.getID());
                        if (meta == null) {
                            meta = new Metadata();
                        }
                        if (map.get("language") != null && !map.get("language").equals("")) {
                            if (map.get("languageAutoDefect") != null && map.get("languageAutoDefect").equals("true")) {
                                String language = map.get("language");
                                meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("KnownLanguage");
                                meta.set("Language", language);
                            } else {
                                String knownLanguage = map.get("language");
                                meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("Language");
                                meta.set("KnownLanguage", knownLanguage);
                            }
                        } else {
                            meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("KnownLanguage");
                            meta.set("Language", "");
                        }
                        if (map.get("contentFieldCodePage") != null && !map.get("contentFieldCodePage").equals("")) {
                            if (map.get("contentFieldCodePageAutoDetect") != null && map.get("contentFieldCodePageAutoDetect").equals("true")) {
                                String charset = map.get("contentFieldCodePage");
                                meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("KnownCharset");
                                meta.set("Charset", charset);
                            } else {
                                String knownCharset = map.get("contentFieldCodePage");
                                meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("Charset");
                                meta.set("KnownCharset", knownCharset);
                            }
                        } else {
                            meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("KnownCharset");
                            meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("Charset");
                        }
                        if (map.get("contentFieldMimeType") != null && !map.get("contentFieldMimeType").equals("")) {
                            String mimeType = map.get("contentFieldMimeType");
                            meta.set("KnownContentType", mimeType);
                        } else {
                            meta.getMetadataPart(Metadata.Type.CrawlerMetadata).remove("KnownContentType");
                        }
                        fieldMappingManager.setCrawlspaceMetadata(table.getID(), meta);
                        Collection<Configuration> crawlSpaceConfig = table.getCrawlSpaceConfigurations().values();
                        for (Configuration config : crawlSpaceConfig) {
                            String detectUpdateField;
                            String name;
                            Set<Configuration.ListItem> items;
                            if (config.getName().equals("primary_key")) {
                                Set<Configuration.ListItem> items2 = config.getItems();
                                for (Configuration.ListItem item : items2) {
                                    String name2 = item.getValue();
                                    item.setSelected(DatabaseCrawlSpaceExplorer.isFieldUniqueKey(name2, fieldList));
                                }
                                continue;
                            }
                            if (config.getName().equals("condition")) {
                                if (map.get("theSQLCondition") == null) continue;
                                config.setString(map.get("theSQLCondition"));
                                continue;
                            }
                            if (config.getName().equals("content_column")) {
                                String contentField = map.get("contentField");
                                if (contentField == null) continue;
                                items = config.getItems();
                                for (Configuration.ListItem item : items) {
                                    name = item.getValue();
                                    if (name.equals(contentField)) {
                                        item.setSelected(true);
                                        continue;
                                    }
                                    item.setSelected(false);
                                }
                                continue;
                            }
                            if (config.getName().equals("document_date")) {
                                String dateField = map.get("dateField");
                                if (dateField == null) continue;
                                items = config.getItems();
                                for (Configuration.ListItem item : items) {
                                    name = item.getValue();
                                    if (name.equals(dateField)) {
                                        item.setSelected(true);
                                        continue;
                                    }
                                    item.setSelected(false);
                                }
                                continue;
                            }
                            if (!config.getName().equals("detect_update") || (detectUpdateField = map.get("detectUpdateField")) == null) continue;
                            items = config.getItems();
                            for (Configuration.ListItem item : items) {
                                name = item.getValue();
                                if (name.equals(detectUpdateField)) {
                                    item.setSelected(true);
                                    continue;
                                }
                                item.setSelected(false);
                            }
                        }
                        crawlerManager.submitCrawlerConfiguration(crawlerConfiguration);
                        configurationManager.updateCollection(collectionConfiguration);
                        return;
                    }
                }
            }
        }
        throw new ExtendedException(new Message("A1742I.table.cannotFind", crawlerId, dburl, schemaName, tableName, collectionID));
    }

    public static void updateDatabaseTableMapToField(String collectionID, String crawlerId, String dburl, String schemaName, String tableName, String fieldName, String mapToField) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerConfiguration crawlerConfiguration;
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerControl.getID().equals(crawlerId) || !(crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID())).hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                if (!server.getName().equals(dburl)) continue;
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    if (!schema.getName().equals(schemaName)) continue;
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    while (tables.hasNext()) {
                        SpaceConfiguration table = tables.next();
                        if (!table.getName().equals(tableName)) continue;
                        Iterator<FieldConfiguration> fields = table.getFields();
                        while (fields.hasNext()) {
                            FieldConfiguration field = fields.next();
                            if (field.isSystemField() || !field.getName().equals(fieldName)) continue;
                            fieldMappingManager.addMapping(table.getID(), field.getName(), mapToField, field.isSystemField());
                        }
                        configurationManager.updateCollection(collectionConfiguration);
                        return;
                    }
                }
            }
        }
        throw new ExtendedException(new Message("A1742I.tableField.cannotFind", crawlerId, dburl, schemaName, tableName, fieldName, collectionID));
    }

    public static void updateDatabaseImplicitFieldMapToField(String collectionID, String fieldName, String mapToField) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE)) continue;
            boolean isChanged = false;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            if (crawlerConfiguration.hasSubSpaces()) {
                Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
                while (servers.hasNext()) {
                    SpaceConfiguration server = servers.next();
                    Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                    while (schemas.hasNext()) {
                        SpaceConfiguration schema = schemas.next();
                        Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                        while (tables.hasNext()) {
                            SpaceConfiguration table = tables.next();
                            Iterator<FieldConfiguration> fields = table.getCrawlSpaceFields();
                            while (fields.hasNext()) {
                                FieldConfiguration field = fields.next();
                                if (!field.getName().equals(fieldName)) continue;
                                fieldMappingManager.addMapping(table.getID(), field.getName(), mapToField, field.isSystemField());
                                isChanged = true;
                            }
                        }
                    }
                }
            }
            if (!isChanged) continue;
            configurationManager.updateCollection(collectionConfiguration);
        }
    }

    public static void updateDatabaseImplicitFieldEnabled(String collectionID, List<FieldBean> implicitFieldList) throws ExtendedException {
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE)) continue;
            boolean isChanged = false;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            if (crawlerConfiguration.hasSubSpaces()) {
                Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
                while (servers.hasNext()) {
                    SpaceConfiguration server = servers.next();
                    Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                    while (schemas.hasNext()) {
                        SpaceConfiguration schema = schemas.next();
                        Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                        while (tables.hasNext()) {
                            SpaceConfiguration table = tables.next();
                            Iterator<FieldConfiguration> fields = table.getCrawlSpaceFields();
                            while (fields.hasNext()) {
                                FieldConfiguration field = fields.next();
                                FieldBean implicitFieldFromClient = MetadataFieldsExplorer.getFieldBeanWithName(field.getName(), implicitFieldList);
                                if (implicitFieldFromClient == null) continue;
                                field.setEnabled(implicitFieldFromClient.isEnabled());
                                isChanged = true;
                            }
                        }
                    }
                }
            }
            if (!isChanged) continue;
            crawlerManager.submitCrawlerConfiguration(crawlerConfiguration);
        }
    }

    public static DatabaseTableBean getDatabaseTableBean(String collectionID, String crawlerId, String dburl, String schemaName, String tableName, Locale locale) throws ExtendedException {
        DatabaseTableBean dbTableBean = new DatabaseTableBean();
        dbTableBean.setName(tableName);
        Vector<FieldBean> columns = new Vector<FieldBean>();
        DatabaseBean dbBean = DatabaseCrawlSpaceExplorer.getDatabaseBean(collectionID, crawlerId, dburl);
        DatabaseExplorer explorer = new DatabaseExplorer(collectionID, dbBean.getDbURL(), dbBean.getUserid(), dbBean.getPassword(), dbBean.getDrivername(), dbBean.getClasspath());
        explorer.setSchemaName(schemaName);
        explorer.setTableName(tableName);
        FieldBean[] discoveredColumns = explorer.getTableColumns(null);
        SpaceConfiguration tableSpace = DatabaseCrawlSpaceExplorer.getTable(collectionID, crawlerId, dburl, schemaName, tableName);
        if (tableSpace == null) {
            throw new ExtendedException(new Message("A1742I.table.cannotFind", crawlerId, dburl, schemaName, tableName, collectionID));
        }
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollection(collectionID);
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> fieldMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.BuiltIn));
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        Metadata meta = fieldMappingManager.getCrawlspaceMetadata(tableSpace.getID());
        if (meta != null) {
            if (meta.contains("Language") && meta.get("Language") != null) {
                dbTableBean.setLanguageAutoDetect(true);
                dbTableBean.setLanguage(meta.get("Language"));
            } else if (meta.contains("KnownLanguage") && meta.get("KnownLanguage") != null) {
                dbTableBean.setLanguageAutoDetect(false);
                dbTableBean.setLanguage(meta.get("KnownLanguage"));
            } else {
                dbTableBean.setLanguageAutoDetect(true);
                dbTableBean.setLanguage("");
            }
            if (meta.contains("Charset") && meta.get("Charset") != null) {
                dbTableBean.setContentCodePageAutoDetect(true);
                dbTableBean.setContentCodePage(meta.get("Charset"));
            } else if (meta.contains("KnownCharset") && meta.get("KnownCharset") != null) {
                dbTableBean.setContentCodePageAutoDetect(false);
                dbTableBean.setContentCodePage(meta.get("KnownCharset"));
            } else {
                dbTableBean.setContentCodePageAutoDetect(true);
                dbTableBean.setContentCodePage("");
            }
            if (meta.contains("KnownContentType") && meta.get("KnownContentType") != null) {
                dbTableBean.setContentMimetype(meta.get("KnownContentType"));
            }
        } else {
            dbTableBean.setLanguageAutoDetect(true);
            dbTableBean.setLanguage("");
            dbTableBean.setContentCodePageAutoDetect(true);
            dbTableBean.setContentCodePage("");
            dbTableBean.setContentMimetype("");
        }
        Map<String, FieldMappingManager.FieldMapping> mappings = fieldMappingManager.getFieldMappingMap(tableSpace.getID());
        Iterator<FieldConfiguration> fields = tableSpace.getFields();
        while (fields.hasNext()) {
            FieldConfiguration field = fields.next();
            if (field.isSystemField()) continue;
            FieldBean fieldBean = new FieldBean();
            fieldBean.setName(field.getName());
            fieldBean.setType(field.getTypeName());
            fieldBean.setMetadataType(field.getType().toString());
            fieldBean.setEnabled(field.isEnabled());
            FieldMappingManager.FieldMapping mapping = mappings.get(field.getName());
            if (mapping != null) {
                fieldBean.setMapToName(mapping.getFieldName());
            }
            if (fieldMap.containsKey(fieldBean.getMapToName())) {
                FieldDefinition fieldDefinition = fieldMap.get(fieldBean.getMapToName());
                fieldBean.setCompleteMatch(MetadataFieldsExplorer.isCompleteMatch(fieldDefinition));
                fieldBean.setTextSearchable(MetadataFieldsExplorer.isTextSearchable(fieldDefinition));
            }
            for (int i = 0; i < discoveredColumns.length; ++i) {
                FieldBean discoveredColumn = discoveredColumns[i];
                if (!fieldBean.getName().equals(discoveredColumn.getName())) continue;
                fieldBean.setCanBeAUniqueKey(discoveredColumn.isCanBeAUniqueKey());
                fieldBean.setCanBeAContent(discoveredColumn.isCanBeAContent());
                fieldBean.setCanBeADetectUpdate(discoveredColumn.isCanBeADetectUpdate());
                fieldBean.setCanBeADocumentDate(discoveredColumn.isCanBeADocumentDate());
                break;
            }
            columns.add(fieldBean);
        }
        Collection<Configuration> crawlSpaceConfig = tableSpace.getCrawlSpaceConfigurations().values();
        for (Configuration config : crawlSpaceConfig) {
            Set<Configuration.ListItem> items;
            if (config.getName().equals("primary_key")) {
                items = config.getItems();
                block3: for (Configuration.ListItem item : items) {
                    int size = columns.size();
                    for (int j = 0; j < size; ++j) {
                        FieldBean fieldBean = (FieldBean)columns.elementAt(j);
                        if (!fieldBean.getName().equals(item.getValue())) continue;
                        fieldBean.setUniqueKey(item.isSelected());
                        continue block3;
                    }
                }
                continue;
            }
            if (config.getName().equals("condition")) {
                if (config.getString() != null) {
                    dbTableBean.setCondition(config.getString());
                    continue;
                }
                dbTableBean.setCondition("");
                continue;
            }
            if (config.getName().equals("content_column")) {
                items = config.getItems();
                for (Configuration.ListItem item : items) {
                    if (!item.isSelected()) continue;
                    dbTableBean.setContentFieldName(item.getValue());
                }
                continue;
            }
            if (config.getName().equals("document_date")) {
                items = config.getItems();
                for (Configuration.ListItem item : items) {
                    if (!item.isSelected()) continue;
                    dbTableBean.setDocumentDateFieldName(item.getValue());
                }
                continue;
            }
            if (!config.getName().equals("detect_update")) continue;
            items = config.getItems();
            for (Configuration.ListItem item : items) {
                if (!item.isSelected()) continue;
                dbTableBean.setDetectUpdateFieldName(item.getValue());
            }
        }
        FieldBean[] columnsArray = new FieldBean[columns.size()];
        for (int i = 0; i < columnsArray.length; ++i) {
            columnsArray[i] = (FieldBean)columns.elementAt(i);
        }
        if (locale != null) {
            NameComparator inameComparator = new NameComparator(locale);
            Arrays.sort(columnsArray, inameComparator);
        }
        dbTableBean.setColumns(columnsArray);
        return dbTableBean;
    }

    public static FieldBean[] getDatabaseImplicitFields(String collectionID, Locale locale) throws ExtendedException {
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerConfiguration crawlerConfiguration;
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !(crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID())).hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    if (!tables.hasNext()) continue;
                    SpaceConfiguration tableSpace = tables.next();
                    Vector<FieldBean> columns = new Vector<FieldBean>();
                    Iterator<FieldConfiguration> fields = tableSpace.getCrawlSpaceFields();
                    while (fields.hasNext()) {
                        FieldConfiguration field = fields.next();
                        FieldBean fieldBean = new FieldBean();
                        fieldBean.setName(field.getName());
                        fieldBean.setType(field.getTypeName());
                        fieldBean.setMetadataType(field.getType().toString());
                        fieldBean.setEnabled(field.isEnabled());
                        columns.add(fieldBean);
                    }
                    FieldBean[] columnsArray = new FieldBean[columns.size()];
                    for (int k = 0; k < columnsArray.length; ++k) {
                        columnsArray[k] = (FieldBean)columns.elementAt(k);
                    }
                    if (locale != null) {
                        NameComparator inameComparator = new NameComparator(locale);
                        Arrays.sort(columnsArray, inameComparator);
                    }
                    return columnsArray;
                }
            }
        }
        return new FieldBean[0];
    }

    public static void deleteDatabase(String collectionID, String crawlerId, String dburl) throws ExtendedException {
        int i;
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        CrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        Vector<String> v = new Vector<String>();
        Vector<String> externalNamesVector = new Vector<String>();
        for (i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerControl.getID().equals(crawlerId)) continue;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            Iterator<Configuration> configurationIterator = crawlerConfiguration.getConfigurations().values().iterator();
            String crawlerConfigID = crawlerConfiguration.getID();
            while (configurationIterator.hasNext()) {
                Configuration config = configurationIterator.next();
                if (!config.getName().equals("dburl") || !config.getString().equals(dburl)) continue;
                v.add(crawlerConfigID);
            }
            boolean shouldSubmit = false;
            if (!crawlerConfiguration.hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                if (!server.getName().equals(dburl)) continue;
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    while (tables.hasNext()) {
                        SpaceConfiguration table = tables.next();
                        shouldSubmit = true;
                        Iterator<FieldConfiguration> fields = table.getFields();
                        Map<String, FieldMappingManager.FieldMapping> mappings = fieldMappingManager.getFieldMappingMap(table.getID());
                        while (fields.hasNext()) {
                            FieldMappingManager.FieldMapping mapping;
                            FieldConfiguration field = fields.next();
                            if (field.getName() == null || (mapping = mappings.get(field.getName())) == null) continue;
                            String externalName = mapping.getFieldName();
                            externalNamesVector.add(externalName);
                        }
                        fieldMappingManager.removeCrawlspace(table.getID());
                    }
                }
            }
            if (!shouldSubmit) continue;
            for (int j = 0; j < externalNamesVector.size(); ++j) {
                String externalName = (String)externalNamesVector.get(j);
                MetadataFieldsExplorer.deleteMetadataFieldIfNotInUse(collectionConfiguration, externalName);
            }
            configurationManager.updateCollection(collectionConfiguration);
        }
        if (v.size() == 0) {
            throw new ExtendedException(new Message("A1742I.database.cannotFind", crawlerId, dburl, collectionID));
        }
        for (i = 0; i < v.size(); ++i) {
            String crawlerConfigID = (String)v.get(i);
            crawlerManager.removeCrawler(crawlerConfigID);
        }
    }

    public static void deleteDatabaseTable(String collectionID, String crawlerId, String dburl, String schemaName, String tableName) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        CrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        boolean foundIt = false;
        Vector<String> externalNamesVector = new Vector<String>();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerControl.getID().equals(crawlerId)) continue;
            boolean shouldSubmit = false;
            CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID());
            if (!crawlerConfiguration.hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                if (!server.getName().equals(dburl)) continue;
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    if (!schema.getName().equals(schemaName)) continue;
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    while (tables.hasNext()) {
                        SpaceConfiguration table = tables.next();
                        if (!table.getName().equals(tableName)) continue;
                        foundIt = true;
                        shouldSubmit = true;
                        table.setEnabled(false);
                        Iterator<FieldConfiguration> fields = table.getFields();
                        Map<String, FieldMappingManager.FieldMapping> mappings = fieldMappingManager.getFieldMappingMap(table.getID());
                        while (fields.hasNext()) {
                            FieldMappingManager.FieldMapping mapping;
                            FieldConfiguration field = fields.next();
                            if (field.getName() == null || (mapping = mappings.get(field.getName())) == null) continue;
                            String externalName = mapping.getFieldName();
                            externalNamesVector.add(externalName);
                        }
                        fieldMappingManager.removeCrawlspace(table.getID());
                    }
                }
            }
            if (!shouldSubmit) continue;
            crawlerManager.submitCrawlerConfiguration(crawlerConfiguration);
            for (int j = 0; j < externalNamesVector.size(); ++j) {
                String externalName = (String)externalNamesVector.get(j);
                MetadataFieldsExplorer.deleteMetadataFieldIfNotInUse(collectionConfiguration, externalName);
            }
            configurationManager.updateCollection(collectionConfiguration);
        }
        if (!foundIt) {
            throw new ExtendedException(new Message("A1742I.table.cannotFind", crawlerId, dburl, schemaName, tableName, collectionID));
        }
    }

    public static void addTableToDatabase(String collectionID, String crawlerId, String userid, String password, String driver, String dburl, String classpath, String schemaName, String tableName, List<FieldBean> fieldList, String whereClause) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        Map<String, FieldDefinition> hiddenFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Hidden));
        CrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        CrawlerConfiguration crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerId);
        if (crawlerConfiguration != null && crawlerConfiguration.hasSubSpaces()) {
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                server.open();
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    if (!schema.getName().equals(schemaName)) continue;
                    schema.open();
                    Iterator<SpaceConfiguration> tableIterator = schema.getSubSpaces();
                    while (tableIterator.hasNext()) {
                        SpaceConfiguration table = tableIterator.next();
                        if (!table.getName().equals(tableName)) continue;
                        table.open();
                        table.setAsCrawlSpace(true);
                        Iterator<FieldConfiguration> fieldsItr = table.getFields();
                        while (fieldsItr.hasNext()) {
                            FieldConfiguration field = fieldsItr.next();
                            if (field.isSystemField()) continue;
                            field.setEnabled(DatabaseCrawlSpaceExplorer.isFieldEnabled(field.getName(), fieldList));
                            if (!field.isEnabled()) continue;
                            String externalName = DatabaseCrawlSpaceExplorer.getFieldsExternalName(field.getName(), fieldList);
                            externalName = MetadataFieldsExplorer.calculateMapToName(externalName, hiddenFieldDefinitionMap);
                            fieldMappingManager.addMapping(table.getID(), field.getName(), externalName, field.isSystemField());
                            if (MetadataFieldsExplorer.fieldDefinitionExists(externalName, predefinedBuiltInUserFieldDefinitionMap)) continue;
                            boolean isCompleteMatch = DatabaseCrawlSpaceExplorer.isFieldCompleteMatch(field.getName(), fieldList);
                            boolean isTextSearchable = DatabaseCrawlSpaceExplorer.isFieldTextSearchable(field.getName(), fieldList);
                            FieldDefinition newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(externalName, isCompleteMatch, isTextSearchable, field.getType());
                            fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
                        }
                        Metadata meta = fieldMappingManager.getCrawlspaceMetadata(table.getID());
                        if (meta == null) {
                            meta = new Metadata();
                        }
                        Iterator<FieldConfiguration> csFieldsItr = table.getCrawlSpaceFields();
                        while (csFieldsItr.hasNext()) {
                            FieldConfiguration field = csFieldsItr.next();
                            meta.add(Metadata.Type.CrawlerImplicit, field.getName(), field.getValue());
                            String externalName = MetadataFieldsExplorer.calculateMapToName(field.getName(), hiddenFieldDefinitionMap);
                            fieldMappingManager.addMapping(table.getID(), field.getName(), externalName, true);
                            if (MetadataFieldsExplorer.fieldDefinitionExists(externalName, predefinedBuiltInUserFieldDefinitionMap)) continue;
                            boolean isCompleteMatch = false;
                            boolean isTextSearchable = false;
                            FieldDefinition newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(externalName, isCompleteMatch, isTextSearchable, field.getType());
                            fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
                        }
                        fieldMappingManager.setCrawlspaceMetadata(table.getID(), meta);
                        Collection<Configuration> crawlSpaceConfig = table.getCrawlSpaceConfigurations().values();
                        for (Configuration config : crawlSpaceConfig) {
                            if (config.getName().equals("primary_key")) {
                                Set<Configuration.ListItem> items = config.getItems();
                                for (Configuration.ListItem item : items) {
                                    String name = item.getValue();
                                    item.setSelected(DatabaseCrawlSpaceExplorer.isFieldUniqueKey(name, fieldList));
                                }
                                continue;
                            }
                            if (!config.getName().equals("condition")) continue;
                            config.setString(whereClause);
                        }
                        table.setEnabled(true);
                        schema.setEnabled(true);
                        server.setEnabled(true);
                        crawlerConfiguration.setEnabled(true);
                        crawlerManager.submitCrawlerConfiguration(crawlerConfiguration);
                        configurationManager.updateCollection(collectionConfiguration);
                        table.close();
                    }
                    schema.close();
                }
                server.close();
            }
            crawlerConfiguration.close();
            return;
        }
        throw new ExtendedException(new Message("A1742I.database.cannotFind", crawlerId, dburl, collectionID));
    }

    public static void addDatabaseAndTable(String collectionID, String userid, String password, String driver, String classpath, String dburl, String schemaName, String tableName, List<FieldBean> fieldList, String whereClause) throws ExtendedException {
        CrawlerType[] crawlerTypeArray;
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> predefinedBuiltInUserFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        Map<String, FieldDefinition> hiddenFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Hidden));
        CrawlerManager crawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        if (crawlerManager != null && (crawlerTypeArray = crawlerManager.getAvailableCrawlerTypes()) != null) {
            for (int i = 0; i < crawlerTypeArray.length; ++i) {
                CrawlerType crawlerType = crawlerTypeArray[i];
                if (!crawlerType.getName().equals(JDBC_CRAWLER_TYPE)) continue;
                List<Configuration> requiredConfigurationList = crawlerType.getRequiredConfigurations();
                for (Configuration config : requiredConfigurationList) {
                    String name = config.getName();
                    if (name.equals("user")) {
                        config.setString(userid);
                        continue;
                    }
                    if (name.equals("password")) {
                        config.setString(password);
                        continue;
                    }
                    if (name.equals("driver")) {
                        config.setString(driver);
                        continue;
                    }
                    if (!name.equals("dburl")) continue;
                    config.setString(dburl);
                }
                List<String> classpathList = DatabaseCrawlSpaceExplorer.getClasspathAsList(classpath);
                CrawlerConfiguration crawlerConfiguration = crawlerManager.newCrawlerConfiguration(JDBC_CRAWLER_NAME, crawlerType, requiredConfigurationList, classpathList);
                crawlerConfiguration.open();
                if (!crawlerConfiguration.hasSubSpaces()) continue;
                Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
                while (servers.hasNext()) {
                    SpaceConfiguration server = servers.next();
                    server.open();
                    Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                    while (schemas.hasNext()) {
                        SpaceConfiguration schema = schemas.next();
                        if (!schema.getName().equals(schemaName)) continue;
                        schema.open();
                        Iterator<SpaceConfiguration> tableIterator = schema.getSubSpaces();
                        while (tableIterator.hasNext()) {
                            SpaceConfiguration table = tableIterator.next();
                            if (!table.getName().equals(tableName)) continue;
                            table.open();
                            table.setAsCrawlSpace(true);
                            Iterator<FieldConfiguration> fieldsItr = table.getFields();
                            while (fieldsItr.hasNext()) {
                                FieldConfiguration field = fieldsItr.next();
                                if (field.isSystemField()) continue;
                                field.setEnabled(DatabaseCrawlSpaceExplorer.isFieldEnabled(field.getName(), fieldList));
                                if (!field.isEnabled()) continue;
                                String externalName = DatabaseCrawlSpaceExplorer.getFieldsExternalName(field.getName(), fieldList);
                                externalName = MetadataFieldsExplorer.calculateMapToName(externalName, hiddenFieldDefinitionMap);
                                fieldMappingManager.addMapping(table.getID(), field.getName(), externalName, field.isSystemField());
                                if (MetadataFieldsExplorer.fieldDefinitionExists(externalName, predefinedBuiltInUserFieldDefinitionMap)) continue;
                                boolean isCompleteMatch = DatabaseCrawlSpaceExplorer.isFieldCompleteMatch(field.getName(), fieldList);
                                boolean isTextSearchable = DatabaseCrawlSpaceExplorer.isFieldTextSearchable(field.getName(), fieldList);
                                FieldDefinition newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(externalName, isCompleteMatch, isTextSearchable, field.getType());
                                fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
                            }
                            Metadata meta = fieldMappingManager.getCrawlspaceMetadata(table.getID());
                            if (meta == null) {
                                meta = new Metadata();
                            }
                            Iterator<FieldConfiguration> csFieldsItr = table.getCrawlSpaceFields();
                            while (csFieldsItr.hasNext()) {
                                FieldConfiguration field = csFieldsItr.next();
                                meta.add(Metadata.Type.CrawlerImplicit, field.getName(), field.getValue());
                                String externalName = MetadataFieldsExplorer.calculateMapToName(field.getName(), hiddenFieldDefinitionMap);
                                fieldMappingManager.addMapping(table.getID(), field.getName(), externalName, field.isSystemField());
                                if (MetadataFieldsExplorer.fieldDefinitionExists(externalName, predefinedBuiltInUserFieldDefinitionMap)) continue;
                                boolean isCompleteMatch = false;
                                boolean isTextSearchable = false;
                                FieldDefinition newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(externalName, isCompleteMatch, isTextSearchable, field.getType());
                                fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
                            }
                            fieldMappingManager.setCrawlspaceMetadata(table.getID(), meta);
                            Collection<Configuration> crawlSpaceConfig = table.getCrawlSpaceConfigurations().values();
                            for (Configuration config : crawlSpaceConfig) {
                                if (config.getName().equals("primary_key")) {
                                    Set<Configuration.ListItem> items = config.getItems();
                                    for (Configuration.ListItem item : items) {
                                        String name = item.getValue();
                                        item.setSelected(DatabaseCrawlSpaceExplorer.isFieldUniqueKey(name, fieldList));
                                    }
                                    continue;
                                }
                                if (!config.getName().equals("condition")) continue;
                                config.setString(whereClause);
                            }
                            table.setEnabled(true);
                            schema.setEnabled(true);
                            server.setEnabled(true);
                            crawlerConfiguration.setEnabled(true);
                            crawlerManager.submitCrawlerConfiguration(crawlerConfiguration);
                            configurationManager.updateCollection(collectionConfiguration);
                            table.close();
                        }
                        schema.close();
                    }
                    server.close();
                }
                crawlerConfiguration.close();
            }
        }
    }

    public static List<String> getClasspathAsList(String classpath) {
        ArrayList<String> classpathList = new ArrayList<String>();
        String token = ":";
        if (GlobalConfiguration.getConfiguration().isWindows()) {
            token = ";";
        }
        StringTokenizer st = new StringTokenizer(classpath, token);
        while (st.hasMoreElements()) {
            String classpathElement = (String)st.nextElement();
            classpathList.add(classpathElement);
        }
        return classpathList;
    }

    private static SpaceConfiguration getTable(String collectionID, String crawlerId, String dburl, String schemaName, String tableName) throws CrawlerControlException, CrawlerConfigurationException {
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlArray.length; ++i) {
            CrawlerConfiguration crawlerConfiguration;
            CrawlerControl crawlerControl = crawlerControlArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerControl.getID().equals(crawlerId) || !(crawlerConfiguration = crawlerManager.getCrawlerConfiguration(crawlerControl.getID())).hasSubSpaces()) continue;
            Iterator<SpaceConfiguration> servers = crawlerConfiguration.getSubSpaces();
            while (servers.hasNext()) {
                SpaceConfiguration server = servers.next();
                if (!server.getName().equals(dburl)) continue;
                Iterator<SpaceConfiguration> schemas = server.getSubSpaces();
                while (schemas.hasNext()) {
                    SpaceConfiguration schema = schemas.next();
                    if (!schema.getName().equals(schemaName)) continue;
                    Iterator<SpaceConfiguration> tables = schema.getSubSpaces();
                    while (tables.hasNext()) {
                        SpaceConfiguration table = tables.next();
                        if (!table.getName().equals(tableName)) continue;
                        return table;
                    }
                }
            }
        }
        return null;
    }

    private static CrawlSpaceControl getCrawlSpaceControl(String collectionID, String crawlerId, String inDburl, String inSchemaName, String inTableName) throws CrawlerControlException {
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager crawlerManager = globalCrawlerManager.getCrawlerManager(collectionID);
        CrawlerControl[] crawlerControlerArray = crawlerManager.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControlerArray.length; ++i) {
            CrawlerControl crawlerControl = crawlerControlerArray[i];
            if (!crawlerControl.getType().equals(JDBC_CRAWLER_TYPE) || !crawlerId.equals(crawlerControl.getID())) continue;
            CrawlSpaceControl[] crawlSpaceControlerArray = crawlerManager.getAvailableCrawlSpaceControls(crawlerControl.getID());
            for (int j = 0; j < crawlSpaceControlerArray.length; ++j) {
                CrawlSpaceControl crawlspaceControl = crawlSpaceControlerArray[j];
                String[] path = crawlspaceControl.getPath();
                String dbURL = path[1];
                String schemaName = path[2];
                String tableName = path[3];
                if (!(inDburl.equals(dbURL) & inSchemaName.equals(schemaName)) || !inTableName.equals(tableName)) continue;
                return crawlspaceControl;
            }
        }
        return null;
    }

    private static boolean isFieldEnabled(String fieldName, List<FieldBean> fieldList) {
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                FieldBean fieldBean = fieldList.get(i);
                if (!fieldBean.getName().equals(fieldName)) continue;
                return fieldBean.isEnabled();
            }
        }
        return false;
    }

    private static boolean isFieldUniqueKey(String fieldName, List<FieldBean> fieldList) {
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                FieldBean fieldBean = fieldList.get(i);
                if (!fieldBean.getName().equals(fieldName)) continue;
                return fieldBean.isUniqueKey();
            }
        }
        System.out.println("** isFieldUniqueKey - could not find field with name=" + fieldName + "!!!!!!");
        return false;
    }

    private static String getFieldsExternalName(String fieldName, List<FieldBean> fieldList) {
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                FieldBean fieldBean = fieldList.get(i);
                if (!fieldBean.getName().equals(fieldName)) continue;
                String mapToName = fieldBean.getMapToName().trim().toLowerCase();
                if (mapToName.equals("")) {
                    mapToName = fieldName.toLowerCase();
                }
                return mapToName;
            }
        }
        System.out.println("** getFieldsExternalName - could not find field with name=" + fieldName + "!!!!!!");
        return fieldName.toLowerCase();
    }

    private static boolean isFieldCompleteMatch(String fieldName, List<FieldBean> fieldList) {
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                FieldBean fieldBean = fieldList.get(i);
                if (!fieldBean.getName().equals(fieldName)) continue;
                return fieldBean.isCompleteMatch();
            }
        }
        return false;
    }

    private static boolean isFieldTextSearchable(String fieldName, List<FieldBean> fieldList) {
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                FieldBean fieldBean = fieldList.get(i);
                if (!fieldBean.getName().equals(fieldName)) continue;
                return fieldBean.isTextSearchable();
            }
        }
        return false;
    }
}

